# This an autogenerated file
# 
# Generated with ScriptingPreference
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.scriptingpreference import ScriptingPreferenceBlueprint
from numpy import ndarray,asarray
from sima.sima.scriptablevalue import ScriptableValue
from sima.sima.simapreference import SIMAPreference

class ScriptingPreference(SIMAPreference):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    showScripts : bool
         (default False)
    javaScriptLocations : ndarray
    pythonHome : str
         Override python home folder(default "")
    pythonPaths : ndarray
    """

    def __init__(self , _id="", showScripts=False, pythonHome="", **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.showScripts = showScripts
        self.javaScriptLocations = ndarray(1)
        self.pythonHome = pythonHome
        self.pythonPaths = ndarray(1)
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ScriptingPreferenceBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def showScripts(self) -> bool:
        """"""
        return self.__showScripts

    @showScripts.setter
    def showScripts(self, value: bool):
        """Set showScripts"""
        self.__showScripts = bool(value)

    @property
    def javaScriptLocations(self) -> ndarray:
        """"""
        return self.__javaScriptLocations

    @javaScriptLocations.setter
    def javaScriptLocations(self, value: ndarray):
        """Set javaScriptLocations"""
        self.__javaScriptLocations = asarray(value)

    @property
    def pythonHome(self) -> str:
        """Override python home folder"""
        return self.__pythonHome

    @pythonHome.setter
    def pythonHome(self, value: str):
        """Set pythonHome"""
        self.__pythonHome = str(value)

    @property
    def pythonPaths(self) -> ndarray:
        """"""
        return self.__pythonPaths

    @pythonPaths.setter
    def pythonPaths(self, value: ndarray):
        """Set pythonPaths"""
        self.__pythonPaths = asarray(value)
