# This an autogenerated file
# 
# Generated with TurbineBladeResponseStorage
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.turbinebladeresponsestorage import TurbineBladeResponseStorageBlueprint
from typing import Dict
from sima.riflex.elementreference import ElementReference
from sima.riflex.responseamount import ResponseAmount
from sima.riflex.storagetype import StorageType
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class TurbineBladeResponseStorage(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    store : bool
         (default False)
    responseAmount : ResponseAmount
    timeInterval : float
         Desired time interval for storage. A value of 0 gives storage at each time step.(default 0.0)
    fileFormat : StorageType
    elements : List[ElementReference]
         Specification of elements for turbine blade response storage
    """

    def __init__(self , _id="", store=False, responseAmount=ResponseAmount.MIN, timeInterval=0.0, fileFormat=StorageType.BINARY, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.store = store
        self.responseAmount = responseAmount
        self.timeInterval = timeInterval
        self.fileFormat = fileFormat
        self.elements = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return TurbineBladeResponseStorageBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def store(self) -> bool:
        """"""
        return self.__store

    @store.setter
    def store(self, value: bool):
        """Set store"""
        self.__store = bool(value)

    @property
    def responseAmount(self) -> ResponseAmount:
        """"""
        return self.__responseAmount

    @responseAmount.setter
    def responseAmount(self, value: ResponseAmount):
        """Set responseAmount"""
        self.__responseAmount = value

    @property
    def timeInterval(self) -> float:
        """Desired time interval for storage. A value of 0 gives storage at each time step."""
        return self.__timeInterval

    @timeInterval.setter
    def timeInterval(self, value: float):
        """Set timeInterval"""
        self.__timeInterval = float(value)

    @property
    def fileFormat(self) -> StorageType:
        """"""
        return self.__fileFormat

    @fileFormat.setter
    def fileFormat(self, value: StorageType):
        """Set fileFormat"""
        self.__fileFormat = value

    @property
    def elements(self) -> List[ElementReference]:
        """Specification of elements for turbine blade response storage"""
        return self.__elements

    @elements.setter
    def elements(self, value: List[ElementReference]):
        """Set elements"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__elements = value
