# This an autogenerated file
# 
# Generated with SeafloorContactLineSpecification
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.seafloorcontactlinespecification import SeafloorContactLineSpecificationBlueprint
from typing import Dict
from sima.riflex.segmentreference import SegmentReference
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.arline import ARLine
    from sima.riflex.seafloorcontact import SeafloorContact

class SeafloorContactLineSpecification(SegmentReference):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Line
    segment : int
         Segment on given line(default 1)
    allSegments : bool
         All segments(default False)
    allLines : bool
         Apply specified contact to all lines(default False)
    contact : SeafloorContact
    """

    def __init__(self , _id="", segment=1, allSegments=False, allLines=False, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.line = None
        self.segment = segment
        self.allSegments = allSegments
        self.allLines = allLines
        self.contact = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SeafloorContactLineSpecificationBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Line"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def segment(self) -> int:
        """Segment on given line"""
        return self.__segment

    @segment.setter
    def segment(self, value: int):
        """Set segment"""
        self.__segment = int(value)

    @property
    def allSegments(self) -> bool:
        """All segments"""
        return self.__allSegments

    @allSegments.setter
    def allSegments(self, value: bool):
        """Set allSegments"""
        self.__allSegments = bool(value)

    @property
    def allLines(self) -> bool:
        """Apply specified contact to all lines"""
        return self.__allLines

    @allLines.setter
    def allLines(self, value: bool):
        """Set allLines"""
        self.__allLines = bool(value)

    @property
    def contact(self) -> SeafloorContact:
        """"""
        return self.__contact

    @contact.setter
    def contact(self, value: SeafloorContact):
        """Set contact"""
        self.__contact = value
