# This an autogenerated file
# 
# Generated with ParameterVariation
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.parametervariation import ParameterVariationBlueprint
from typing import Dict
from sima.riflex.boundarychangegroup import BoundaryChangeGroup
from sima.riflex.convergencenorm import ConvergenceNorm
from sima.riflex.currentvariationitem import CurrentVariationItem
from sima.riflex.offsetvariationitem import OffsetVariationItem
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class ParameterVariation(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    numVariations : int
         Number of variations(default 0)
    maxIterations : int
         Maximum number of iterations for each variation(default 1)
    convergenceNorm : ConvergenceNorm
    accuracy : float
         Required accuracy measured by displacement norm(default 0.0001)
    energyAccuracy : float
         Required accuracy measured by energy norm. This value is relevant only if Convergence Norm is 'Both'.(default 0.0001)
    offset : bool
         (default False)
    current : bool
         (default False)
    specifiedForce : bool
         (default False)
    offsetVariation : OffsetVariationItem
    currentVariation : CurrentVariationItem
    boundaryChangeGroup : BoundaryChangeGroup
    fricActivation : bool
         Activate bottom friction forces(default False)
    springActivation : bool
         Activate global springs(default False)
    memoActivation : bool
         Activate material memory formulation (isotropic / kinematic hardening)(default False)
    """

    def __init__(self , _id="", numVariations=0, maxIterations=1, convergenceNorm=ConvergenceNorm.DISP, accuracy=0.0001, energyAccuracy=0.0001, offset=False, current=False, specifiedForce=False, fricActivation=False, springActivation=False, memoActivation=False, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.numVariations = numVariations
        self.maxIterations = maxIterations
        self.convergenceNorm = convergenceNorm
        self.accuracy = accuracy
        self.energyAccuracy = energyAccuracy
        self.offset = offset
        self.current = current
        self.specifiedForce = specifiedForce
        self.offsetVariation = None
        self.currentVariation = None
        self.boundaryChangeGroup = None
        self.fricActivation = fricActivation
        self.springActivation = springActivation
        self.memoActivation = memoActivation
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ParameterVariationBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def numVariations(self) -> int:
        """Number of variations"""
        return self.__numVariations

    @numVariations.setter
    def numVariations(self, value: int):
        """Set numVariations"""
        self.__numVariations = int(value)

    @property
    def maxIterations(self) -> int:
        """Maximum number of iterations for each variation"""
        return self.__maxIterations

    @maxIterations.setter
    def maxIterations(self, value: int):
        """Set maxIterations"""
        self.__maxIterations = int(value)

    @property
    def convergenceNorm(self) -> ConvergenceNorm:
        """"""
        return self.__convergenceNorm

    @convergenceNorm.setter
    def convergenceNorm(self, value: ConvergenceNorm):
        """Set convergenceNorm"""
        self.__convergenceNorm = value

    @property
    def accuracy(self) -> float:
        """Required accuracy measured by displacement norm"""
        return self.__accuracy

    @accuracy.setter
    def accuracy(self, value: float):
        """Set accuracy"""
        self.__accuracy = float(value)

    @property
    def energyAccuracy(self) -> float:
        """Required accuracy measured by energy norm. This value is relevant only if Convergence Norm is 'Both'."""
        return self.__energyAccuracy

    @energyAccuracy.setter
    def energyAccuracy(self, value: float):
        """Set energyAccuracy"""
        self.__energyAccuracy = float(value)

    @property
    def offset(self) -> bool:
        """"""
        return self.__offset

    @offset.setter
    def offset(self, value: bool):
        """Set offset"""
        self.__offset = bool(value)

    @property
    def current(self) -> bool:
        """"""
        return self.__current

    @current.setter
    def current(self, value: bool):
        """Set current"""
        self.__current = bool(value)

    @property
    def specifiedForce(self) -> bool:
        """"""
        return self.__specifiedForce

    @specifiedForce.setter
    def specifiedForce(self, value: bool):
        """Set specifiedForce"""
        self.__specifiedForce = bool(value)

    @property
    def offsetVariation(self) -> OffsetVariationItem:
        """"""
        return self.__offsetVariation

    @offsetVariation.setter
    def offsetVariation(self, value: OffsetVariationItem):
        """Set offsetVariation"""
        self.__offsetVariation = value

    @property
    def currentVariation(self) -> CurrentVariationItem:
        """"""
        return self.__currentVariation

    @currentVariation.setter
    def currentVariation(self, value: CurrentVariationItem):
        """Set currentVariation"""
        self.__currentVariation = value

    @property
    def boundaryChangeGroup(self) -> BoundaryChangeGroup:
        """"""
        return self.__boundaryChangeGroup

    @boundaryChangeGroup.setter
    def boundaryChangeGroup(self, value: BoundaryChangeGroup):
        """Set boundaryChangeGroup"""
        self.__boundaryChangeGroup = value

    @property
    def fricActivation(self) -> bool:
        """Activate bottom friction forces"""
        return self.__fricActivation

    @fricActivation.setter
    def fricActivation(self, value: bool):
        """Set fricActivation"""
        self.__fricActivation = bool(value)

    @property
    def springActivation(self) -> bool:
        """Activate global springs"""
        return self.__springActivation

    @springActivation.setter
    def springActivation(self, value: bool):
        """Set springActivation"""
        self.__springActivation = bool(value)

    @property
    def memoActivation(self) -> bool:
        """Activate material memory formulation (isotropic / kinematic hardening)"""
        return self.__memoActivation

    @memoActivation.setter
    def memoActivation(self, value: bool):
        """Set memoActivation"""
        self.__memoActivation = bool(value)
