# This an autogenerated file
# 
# Generated with HydrodynamicLoadStorage
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.hydrodynamicloadstorage import HydrodynamicLoadStorageBlueprint
from typing import Dict
from sima.riflex.hydrodynamicloadelementstorage import HydrodynamicLoadElementStorage
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class HydrodynamicLoadStorage(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    store : bool
         Store hydrodynamic loads(default False)
    storageStep : int
         Storage for every <storage step> given.(default 1)
    elements : List[HydrodynamicLoadElementStorage]
         Specification of nodes for displacement storage
    """

    def __init__(self , _id="", store=False, storageStep=1, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.store = store
        self.storageStep = storageStep
        self.elements = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return HydrodynamicLoadStorageBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def store(self) -> bool:
        """Store hydrodynamic loads"""
        return self.__store

    @store.setter
    def store(self, value: bool):
        """Set store"""
        self.__store = bool(value)

    @property
    def storageStep(self) -> int:
        """Storage for every <storage step> given."""
        return self.__storageStep

    @storageStep.setter
    def storageStep(self, value: int):
        """Set storageStep"""
        self.__storageStep = int(value)

    @property
    def elements(self) -> List[HydrodynamicLoadElementStorage]:
        """Specification of nodes for displacement storage"""
        return self.__elements

    @elements.setter
    def elements(self, value: List[HydrodynamicLoadElementStorage]):
        """Set elements"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__elements = value
