# This an autogenerated file
# 
# Generated with ElementStressStorage
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.elementstressstorage import ElementStressStorageBlueprint
from typing import Dict
from sima.riflex.elementreference import ElementReference
from sima.riflex.end import End
from sima.riflex.stresstype import StressType
from sima.riflex.wallpoint import WallPoint
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.arline import ARLine

class ElementStressStorage(ElementReference):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Line
    segment : int
         Segment on given line(default 1)
    allSegments : bool
         All segments(default False)
    elementNumber : int
         Local element number on actual segment(default 1)
    allElements : bool
         All elements(default False)
    allEnds : bool
         All ends(default False)
    elementEnd : End
         End number 1 or 2
    _type : StressType
    outerDiameter : float
         (default 0.0)
    thickness : float
         (default 0.0)
    internalPressure : float
         (default 0.0)
    externalPressure : float
         (default 0.0)
    numberOfPoints : int
         (default 8)
    position : WallPoint
    """

    def __init__(self , _id="", segment=1, allSegments=False, elementNumber=1, allElements=False, allEnds=False, elementEnd=End.ONE, _type=StressType.AXIAL_BENDING, outerDiameter=0.0, thickness=0.0, internalPressure=0.0, externalPressure=0.0, numberOfPoints=8, position=WallPoint.OUTER_WALL, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.line = None
        self.segment = segment
        self.allSegments = allSegments
        self.elementNumber = elementNumber
        self.allElements = allElements
        self.allEnds = allEnds
        self.elementEnd = elementEnd
        self._type = _type
        self.outerDiameter = outerDiameter
        self.thickness = thickness
        self.internalPressure = internalPressure
        self.externalPressure = externalPressure
        self.numberOfPoints = numberOfPoints
        self.position = position
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ElementStressStorageBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Line"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def segment(self) -> int:
        """Segment on given line"""
        return self.__segment

    @segment.setter
    def segment(self, value: int):
        """Set segment"""
        self.__segment = int(value)

    @property
    def allSegments(self) -> bool:
        """All segments"""
        return self.__allSegments

    @allSegments.setter
    def allSegments(self, value: bool):
        """Set allSegments"""
        self.__allSegments = bool(value)

    @property
    def elementNumber(self) -> int:
        """Local element number on actual segment"""
        return self.__elementNumber

    @elementNumber.setter
    def elementNumber(self, value: int):
        """Set elementNumber"""
        self.__elementNumber = int(value)

    @property
    def allElements(self) -> bool:
        """All elements"""
        return self.__allElements

    @allElements.setter
    def allElements(self, value: bool):
        """Set allElements"""
        self.__allElements = bool(value)

    @property
    def allEnds(self) -> bool:
        """All ends"""
        return self.__allEnds

    @allEnds.setter
    def allEnds(self, value: bool):
        """Set allEnds"""
        self.__allEnds = bool(value)

    @property
    def elementEnd(self) -> End:
        """End number 1 or 2"""
        return self.__elementEnd

    @elementEnd.setter
    def elementEnd(self, value: End):
        """Set elementEnd"""
        self.__elementEnd = value

    @property
    def _type(self) -> StressType:
        """"""
        return self.___type

    @_type.setter
    def _type(self, value: StressType):
        """Set _type"""
        self.___type = value

    @property
    def outerDiameter(self) -> float:
        """"""
        return self.__outerDiameter

    @outerDiameter.setter
    def outerDiameter(self, value: float):
        """Set outerDiameter"""
        self.__outerDiameter = float(value)

    @property
    def thickness(self) -> float:
        """"""
        return self.__thickness

    @thickness.setter
    def thickness(self, value: float):
        """Set thickness"""
        self.__thickness = float(value)

    @property
    def internalPressure(self) -> float:
        """"""
        return self.__internalPressure

    @internalPressure.setter
    def internalPressure(self, value: float):
        """Set internalPressure"""
        self.__internalPressure = float(value)

    @property
    def externalPressure(self) -> float:
        """"""
        return self.__externalPressure

    @externalPressure.setter
    def externalPressure(self, value: float):
        """Set externalPressure"""
        self.__externalPressure = float(value)

    @property
    def numberOfPoints(self) -> int:
        """"""
        return self.__numberOfPoints

    @numberOfPoints.setter
    def numberOfPoints(self, value: int):
        """Set numberOfPoints"""
        self.__numberOfPoints = int(value)

    @property
    def position(self) -> WallPoint:
        """"""
        return self.__position

    @position.setter
    def position(self, value: WallPoint):
        """Set position"""
        self.__position = value
