# This an autogenerated file
# 
# Generated with ContactSurfaceLine
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.contactsurfaceline import ContactSurfaceLineBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.arline import ARLine

class ContactSurfaceLine(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Reference to line to be checked for contact with the contact surface.
    firstSegmentContact : int
         First segment to be checked for contact(default 1)
    firstElementContact : int
         First element within first contact segment to be chekced for contact(default 1)
    lastSegmentContact : int
         Last segment to be checked for contact(default 0)
    lastElementContact : int
         Last element within last contact segment to be checked for contact(default 0)
    """

    def __init__(self , _id="", firstSegmentContact=1, firstElementContact=1, lastSegmentContact=0, lastElementContact=0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.line = None
        self.firstSegmentContact = firstSegmentContact
        self.firstElementContact = firstElementContact
        self.lastSegmentContact = lastSegmentContact
        self.lastElementContact = lastElementContact
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ContactSurfaceLineBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Reference to line to be checked for contact with the contact surface."""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def firstSegmentContact(self) -> int:
        """First segment to be checked for contact"""
        return self.__firstSegmentContact

    @firstSegmentContact.setter
    def firstSegmentContact(self, value: int):
        """Set firstSegmentContact"""
        self.__firstSegmentContact = int(value)

    @property
    def firstElementContact(self) -> int:
        """First element within first contact segment to be chekced for contact"""
        return self.__firstElementContact

    @firstElementContact.setter
    def firstElementContact(self, value: int):
        """Set firstElementContact"""
        self.__firstElementContact = int(value)

    @property
    def lastSegmentContact(self) -> int:
        """Last segment to be checked for contact"""
        return self.__lastSegmentContact

    @lastSegmentContact.setter
    def lastSegmentContact(self, value: int):
        """Set lastSegmentContact"""
        self.__lastSegmentContact = int(value)

    @property
    def lastElementContact(self) -> int:
        """Last element within last contact segment to be checked for contact"""
        return self.__lastElementContact

    @lastElementContact.setter
    def lastElementContact(self, value: int):
        """Set lastElementContact"""
        self.__lastElementContact = int(value)
