# This an autogenerated file
# 
# Generated with AxisymmetricCrossSection
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.axisymmetriccrosssection import AxisymmetricCrossSectionBlueprint
from typing import Dict
from sima.riflex.aerodynamicinputcode import AerodynamicInputCode
from sima.riflex.axialstiffness import AxialStiffness
from sima.riflex.axialstiffnessitem import AxialStiffnessItem
from sima.riflex.axisymmetriccrosssectionmassvolume import AxisymmetricCrossSectionMassVolume
from sima.riflex.barbeam import BarBeam
from sima.riflex.bendingstiffness import BendingStiffness
from sima.riflex.bendingstiffnessy_item import BendingStiffnessY_Item
from sima.riflex.crosssection import CrossSection
from sima.riflex.crsaxialdamping import CRSAxialDamping
from sima.riflex.crsaxialfrictionmodel import CRSAxialFrictionModel
from sima.riflex.crsmassdamping import CRSMassDamping
from sima.riflex.crsstiffnessdamping import CRSStiffnessDamping
from sima.riflex.hydrodynamicinputcode import HydrodynamicInputCode
from sima.riflex.hysteresis import Hysteresis
from sima.riflex.loadformulation import LoadFormulation
from sima.riflex.tangentialfroudekrylovscaling import TangentialFroudeKrylovScaling
from sima.riflex.timedomainvivloadcoefficients import TimeDomainVIVLoadCoefficients
from sima.riflex.torsionstiffness import TorsionStiffness
from sima.riflex.torsionstiffnessitem import TorsionStiffnessItem
from sima.riflex.vivloadformulation import VIVLoadFormulation
from sima.sima.scriptablevalue import ScriptableValue

class AxisymmetricCrossSection(CrossSection,CRSAxialFrictionModel,TimeDomainVIVLoadCoefficients):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default "")
    staticFriction : float
         Static friction force corresponding to elongation(default 0.0)
    staticElongation : float
         Relative elongation(default 0.0)
    dynamicFriction : float
         Dynamic friction force corresponding to elongation(default 0.0)
    dynamicElongation : float
         Relative elongation(default 0.0)
    axialFriction : bool
         Local axial friction model(default False)
    vivLoadFormulation : VIVLoadFormulation
    cv : float
         Vortex shedding load coefficient for cross-flow excitation (nondimensional)(default 0.0)
    fnull : float
         Natural cross-flow vortex shedding frequency (nondimensional)(default 0.0)
    fmin : float
         Minimum cross-flow vortex shedding frequency (nondimensional)(default 0.0)
    fmax : float
         Maximum cross-flow vortex shedding frequency (nondimensional)(default 0.0)
    nmem : int
         Number of time steps used in calculation of standard deviation(default 500)
    cvil : float
         Load coefficient for in-line excitation(default 0.0)
    alphil : float
         Nondimensional parameter giving freedom to in-line excitation frequency(default 0.0)
    chh : float
         Higher harmonic load coefficient (nondimensional)(default 0.0)
    fnullil : float
         Natural in-line vortex shedding frequency (nondimensional)(default 0.0)
    fminil : float
         Minimum in-line vortex shedding frequency (nondimensional)(default 0.0)
    fmaxil : float
         Maximum in-line vortex shedding frequency (nondimensional)(default 0.0)
    scfkSpecification : bool
         Scaling of Froude-Krylov term in Morison’s equation in normal direction(default True)
    loadFormulation : LoadFormulation
    hydrodynamicDiameter : float
         Hydrodynamic diameter(default 0.0)
    addedMassTanDir : float
         Added mass in tangential direction(default 0.0)
    addedMassNormDir : float
         Added mass in normal direction(default 0.0)
    dampingNormDir : float
         Damping coefficients in normal direction(default 0.0)
    cdt : float
         Quadratic drag coefficient in tangential direction.(default 0.0)
    cdn : float
         Quadratic drag coefficient in normal direction.(default 0.0)
    cmt : float
         Added mass per unit length in tangential direction.(default 0.0)
    cmn : float
         Added mass per unit length in normal direction.(default 0.0)
    cdtl : float
         Linear drag force coefficient in tangential direction.(default 0.0)
    cdnl : float
         Linear drag force coefficient in normal direction.(default 0.0)
    cdx : float
         Quadratic drag coefficient in tangential direction.(default 0.0)
    cdy : float
         Quadratic drag coefficient in normal direction.(default 0.0)
    amx : float
         Added mass per unit length in tangential direction.(default 0.0)
    amy : float
         Added mass per unit length in normal direction.(default 0.0)
    cdlx : float
         Linear drag force coefficient in tangential direction.(default 0.0)
    cdly : float
         Linear drag force coefficient in normal direction.(default 0.0)
    hydrodynamicInputCode : HydrodynamicInputCode
         Hydrodynamic input code
    scfk : float
         Scaling factor for Froude-Krylov term in Morison’s equation in normal direction(default 1.0)
    scfkt : TangentialFroudeKrylovScaling
         Scale for Froude-Krylov term in Morison’s equation in tangential direction
    massDampingSpecification : bool
         Mass proportional Rayleigh damping(default False)
    stiffnessDampingSpecification : bool
         Stiffness proportional Rayleigh damping(default False)
    axialDampingSpecification : bool
         Local axial damping model(default False)
    temperature : float
         Temperature at which the specification applies(default 0.0)
    alpha : float
         Thermal expansion coefficient(default 0.0)
    beta : float
         Pressure expansion coefficient(default 0.0)
    massDamping : CRSMassDamping
    stiffnessDamping : CRSStiffnessDamping
    axialDamping : CRSAxialDamping
    defaultExpansion : bool
         Use default thermal and pressure expansion settings(default True)
    cdax : float
         Quadratic aerodynamic drag force coefficient per unit length in tangential direction(default 0.0)
    cday : float
         Quadratic aerodynamic drag force coefficient per unit length in normal direction(default 0.0)
    cdaz : float
         Quadratic aerodynamic drag force coefficient per unit length in z direction(default 0.0)
    aerodynamicInputCode : AerodynamicInputCode
         Aerodynamic input code
    aerodynamicDiameter : float
         Aerodynamic diameter(default 0.0)
    massVolume : AxisymmetricCrossSectionMassVolume
    axialStiffnessInput : AxialStiffness
         Axial stiffness input specification
    bendingStiffnessInput : BendingStiffness
         Bending stiffness input specification
    torsionStiffnessInput : TorsionStiffness
         Torsion stiffness input specification
    pressureDependency : int
         Pressure dependency parameter related to bending moment(default 0)
    hysteresisOption : Hysteresis
         Hysteresis option in bending moment / curvature relation
    hardeningParameter : float
         Hardening parameter(default 0.0)
    axialStiffness : float
         Axial stiffness(default 0.0)
    axialStiffnessCharacteristics : List[AxialStiffnessItem]
    bendingStiffness : float
         Bending stiffness around y-axis(default 0.0)
    intFrictionMoment : float
         Internal friction moment.(default 0.0)
    shearStiffness : float
         Shear stiffness(default 0.0)
    bendingStiffnessCharacteristics : List[BendingStiffnessY_Item]
    negativeTorsionStiffness : float
         Torsion stiffness for negative twist.(default 0.0)
    positiveTorsionStiffness : float
         Torsion stiffness for positive twist.(default 0.0)
    torsionStiffnessCharacteristics : List[TorsionStiffnessItem]
    tensionCapacity : float
         Tension capacity(default 0.0)
    maxCurvature : float
         Maximum curvature(default 0.0)
    barBeam : BarBeam
         Cross section type
    stiffnessFactor : float
         Initial stiffness factor for internal friction moment(default 10.0)
    submerged : bool
         Use formulation for partly submerged cross-section(default False)
    coupledBendingTorsion : bool
         Geometric stiffness coupling between bending and torsion(default False)
    hydrodynamicRadiationInputCode : HydrodynamicInputCode
         Code for input of simplified radiation force coefficients
    solidityRatio : float
         Solidity ratio.(default 0.0)
    netWidthEnd1 : float
         Net width at segment end 1(default 0.0)
    netWidthEnd2 : float
         Net width at segment end 2(default 0.0)
    currentVelocityScaling : float
         Ratio between reduced current speed and ambient current speed due to upstream net shadowing effects(default 1.0)
    """

    def __init__(self , _id="", name="", staticFriction=0.0, staticElongation=0.0, dynamicFriction=0.0, dynamicElongation=0.0, axialFriction=False, vivLoadFormulation=VIVLoadFormulation.CROSSFLOW_VIV_ONLY, cv=0.0, fnull=0.0, fmin=0.0, fmax=0.0, nmem=500, cvil=0.0, alphil=0.0, chh=0.0, fnullil=0.0, fminil=0.0, fmaxil=0.0, scfkSpecification=True, loadFormulation=LoadFormulation.MORISON, hydrodynamicDiameter=0.0, addedMassTanDir=0.0, addedMassNormDir=0.0, dampingNormDir=0.0, cdt=0.0, cdn=0.0, cmt=0.0, cmn=0.0, cdtl=0.0, cdnl=0.0, cdx=0.0, cdy=0.0, amx=0.0, amy=0.0, cdlx=0.0, cdly=0.0, hydrodynamicInputCode=HydrodynamicInputCode.DIMENSIONAL, scfk=1.0, scfkt=TangentialFroudeKrylovScaling.ON, massDampingSpecification=False, stiffnessDampingSpecification=False, axialDampingSpecification=False, temperature=0.0, alpha=0.0, beta=0.0, defaultExpansion=True, cdax=0.0, cday=0.0, cdaz=0.0, aerodynamicInputCode=AerodynamicInputCode.NONE, aerodynamicDiameter=0.0, axialStiffnessInput=AxialStiffness.CONSTANT, bendingStiffnessInput=BendingStiffness.CONSTANT, torsionStiffnessInput=TorsionStiffness.CONSTANT, pressureDependency=0, hysteresisOption=Hysteresis.NO_HYSTERESIS, hardeningParameter=0.0, axialStiffness=0.0, bendingStiffness=0.0, intFrictionMoment=0.0, shearStiffness=0.0, negativeTorsionStiffness=0.0, positiveTorsionStiffness=0.0, tensionCapacity=0.0, maxCurvature=0.0, barBeam=BarBeam.BAR, stiffnessFactor=10.0, submerged=False, coupledBendingTorsion=False, hydrodynamicRadiationInputCode=HydrodynamicInputCode.DIMENSIONAL, solidityRatio=0.0, netWidthEnd1=0.0, netWidthEnd2=0.0, currentVelocityScaling=1.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.name = name
        self.staticFriction = staticFriction
        self.staticElongation = staticElongation
        self.dynamicFriction = dynamicFriction
        self.dynamicElongation = dynamicElongation
        self.axialFriction = axialFriction
        self.vivLoadFormulation = vivLoadFormulation
        self.cv = cv
        self.fnull = fnull
        self.fmin = fmin
        self.fmax = fmax
        self.nmem = nmem
        self.cvil = cvil
        self.alphil = alphil
        self.chh = chh
        self.fnullil = fnullil
        self.fminil = fminil
        self.fmaxil = fmaxil
        self.scfkSpecification = scfkSpecification
        self.loadFormulation = loadFormulation
        self.hydrodynamicDiameter = hydrodynamicDiameter
        self.addedMassTanDir = addedMassTanDir
        self.addedMassNormDir = addedMassNormDir
        self.dampingNormDir = dampingNormDir
        self.cdt = cdt
        self.cdn = cdn
        self.cmt = cmt
        self.cmn = cmn
        self.cdtl = cdtl
        self.cdnl = cdnl
        self.cdx = cdx
        self.cdy = cdy
        self.amx = amx
        self.amy = amy
        self.cdlx = cdlx
        self.cdly = cdly
        self.hydrodynamicInputCode = hydrodynamicInputCode
        self.scfk = scfk
        self.scfkt = scfkt
        self.massDampingSpecification = massDampingSpecification
        self.stiffnessDampingSpecification = stiffnessDampingSpecification
        self.axialDampingSpecification = axialDampingSpecification
        self.temperature = temperature
        self.alpha = alpha
        self.beta = beta
        self.massDamping = None
        self.stiffnessDamping = None
        self.axialDamping = None
        self.defaultExpansion = defaultExpansion
        self.cdax = cdax
        self.cday = cday
        self.cdaz = cdaz
        self.aerodynamicInputCode = aerodynamicInputCode
        self.aerodynamicDiameter = aerodynamicDiameter
        self.massVolume = None
        self.axialStiffnessInput = axialStiffnessInput
        self.bendingStiffnessInput = bendingStiffnessInput
        self.torsionStiffnessInput = torsionStiffnessInput
        self.pressureDependency = pressureDependency
        self.hysteresisOption = hysteresisOption
        self.hardeningParameter = hardeningParameter
        self.axialStiffness = axialStiffness
        self.axialStiffnessCharacteristics = list()
        self.bendingStiffness = bendingStiffness
        self.intFrictionMoment = intFrictionMoment
        self.shearStiffness = shearStiffness
        self.bendingStiffnessCharacteristics = list()
        self.negativeTorsionStiffness = negativeTorsionStiffness
        self.positiveTorsionStiffness = positiveTorsionStiffness
        self.torsionStiffnessCharacteristics = list()
        self.tensionCapacity = tensionCapacity
        self.maxCurvature = maxCurvature
        self.barBeam = barBeam
        self.stiffnessFactor = stiffnessFactor
        self.submerged = submerged
        self.coupledBendingTorsion = coupledBendingTorsion
        self.hydrodynamicRadiationInputCode = hydrodynamicRadiationInputCode
        self.solidityRatio = solidityRatio
        self.netWidthEnd1 = netWidthEnd1
        self.netWidthEnd2 = netWidthEnd2
        self.currentVelocityScaling = currentVelocityScaling
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return AxisymmetricCrossSectionBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def staticFriction(self) -> float:
        """Static friction force corresponding to elongation"""
        return self.__staticFriction

    @staticFriction.setter
    def staticFriction(self, value: float):
        """Set staticFriction"""
        self.__staticFriction = float(value)

    @property
    def staticElongation(self) -> float:
        """Relative elongation"""
        return self.__staticElongation

    @staticElongation.setter
    def staticElongation(self, value: float):
        """Set staticElongation"""
        self.__staticElongation = float(value)

    @property
    def dynamicFriction(self) -> float:
        """Dynamic friction force corresponding to elongation"""
        return self.__dynamicFriction

    @dynamicFriction.setter
    def dynamicFriction(self, value: float):
        """Set dynamicFriction"""
        self.__dynamicFriction = float(value)

    @property
    def dynamicElongation(self) -> float:
        """Relative elongation"""
        return self.__dynamicElongation

    @dynamicElongation.setter
    def dynamicElongation(self, value: float):
        """Set dynamicElongation"""
        self.__dynamicElongation = float(value)

    @property
    def axialFriction(self) -> bool:
        """Local axial friction model"""
        return self.__axialFriction

    @axialFriction.setter
    def axialFriction(self, value: bool):
        """Set axialFriction"""
        self.__axialFriction = bool(value)

    @property
    def vivLoadFormulation(self) -> VIVLoadFormulation:
        """"""
        return self.__vivLoadFormulation

    @vivLoadFormulation.setter
    def vivLoadFormulation(self, value: VIVLoadFormulation):
        """Set vivLoadFormulation"""
        self.__vivLoadFormulation = value

    @property
    def cv(self) -> float:
        """Vortex shedding load coefficient for cross-flow excitation (nondimensional)"""
        return self.__cv

    @cv.setter
    def cv(self, value: float):
        """Set cv"""
        self.__cv = float(value)

    @property
    def fnull(self) -> float:
        """Natural cross-flow vortex shedding frequency (nondimensional)"""
        return self.__fnull

    @fnull.setter
    def fnull(self, value: float):
        """Set fnull"""
        self.__fnull = float(value)

    @property
    def fmin(self) -> float:
        """Minimum cross-flow vortex shedding frequency (nondimensional)"""
        return self.__fmin

    @fmin.setter
    def fmin(self, value: float):
        """Set fmin"""
        self.__fmin = float(value)

    @property
    def fmax(self) -> float:
        """Maximum cross-flow vortex shedding frequency (nondimensional)"""
        return self.__fmax

    @fmax.setter
    def fmax(self, value: float):
        """Set fmax"""
        self.__fmax = float(value)

    @property
    def nmem(self) -> int:
        """Number of time steps used in calculation of standard deviation"""
        return self.__nmem

    @nmem.setter
    def nmem(self, value: int):
        """Set nmem"""
        self.__nmem = int(value)

    @property
    def cvil(self) -> float:
        """Load coefficient for in-line excitation"""
        return self.__cvil

    @cvil.setter
    def cvil(self, value: float):
        """Set cvil"""
        self.__cvil = float(value)

    @property
    def alphil(self) -> float:
        """Nondimensional parameter giving freedom to in-line excitation frequency"""
        return self.__alphil

    @alphil.setter
    def alphil(self, value: float):
        """Set alphil"""
        self.__alphil = float(value)

    @property
    def chh(self) -> float:
        """Higher harmonic load coefficient (nondimensional)"""
        return self.__chh

    @chh.setter
    def chh(self, value: float):
        """Set chh"""
        self.__chh = float(value)

    @property
    def fnullil(self) -> float:
        """Natural in-line vortex shedding frequency (nondimensional)"""
        return self.__fnullil

    @fnullil.setter
    def fnullil(self, value: float):
        """Set fnullil"""
        self.__fnullil = float(value)

    @property
    def fminil(self) -> float:
        """Minimum in-line vortex shedding frequency (nondimensional)"""
        return self.__fminil

    @fminil.setter
    def fminil(self, value: float):
        """Set fminil"""
        self.__fminil = float(value)

    @property
    def fmaxil(self) -> float:
        """Maximum in-line vortex shedding frequency (nondimensional)"""
        return self.__fmaxil

    @fmaxil.setter
    def fmaxil(self, value: float):
        """Set fmaxil"""
        self.__fmaxil = float(value)

    @property
    def scfkSpecification(self) -> bool:
        """Scaling of Froude-Krylov term in Morison’s equation in normal direction"""
        return self.__scfkSpecification

    @scfkSpecification.setter
    def scfkSpecification(self, value: bool):
        """Set scfkSpecification"""
        self.__scfkSpecification = bool(value)

    @property
    def loadFormulation(self) -> LoadFormulation:
        """"""
        return self.__loadFormulation

    @loadFormulation.setter
    def loadFormulation(self, value: LoadFormulation):
        """Set loadFormulation"""
        self.__loadFormulation = value

    @property
    def hydrodynamicDiameter(self) -> float:
        """Hydrodynamic diameter"""
        return self.__hydrodynamicDiameter

    @hydrodynamicDiameter.setter
    def hydrodynamicDiameter(self, value: float):
        """Set hydrodynamicDiameter"""
        self.__hydrodynamicDiameter = float(value)

    @property
    def addedMassTanDir(self) -> float:
        """Added mass in tangential direction"""
        return self.__addedMassTanDir

    @addedMassTanDir.setter
    def addedMassTanDir(self, value: float):
        """Set addedMassTanDir"""
        self.__addedMassTanDir = float(value)

    @property
    def addedMassNormDir(self) -> float:
        """Added mass in normal direction"""
        return self.__addedMassNormDir

    @addedMassNormDir.setter
    def addedMassNormDir(self, value: float):
        """Set addedMassNormDir"""
        self.__addedMassNormDir = float(value)

    @property
    def dampingNormDir(self) -> float:
        """Damping coefficients in normal direction"""
        return self.__dampingNormDir

    @dampingNormDir.setter
    def dampingNormDir(self, value: float):
        """Set dampingNormDir"""
        self.__dampingNormDir = float(value)

    @property
    def cdt(self) -> float:
        """Quadratic drag coefficient in tangential direction."""
        return self.__cdt

    @cdt.setter
    def cdt(self, value: float):
        """Set cdt"""
        self.__cdt = float(value)

    @property
    def cdn(self) -> float:
        """Quadratic drag coefficient in normal direction."""
        return self.__cdn

    @cdn.setter
    def cdn(self, value: float):
        """Set cdn"""
        self.__cdn = float(value)

    @property
    def cmt(self) -> float:
        """Added mass per unit length in tangential direction."""
        return self.__cmt

    @cmt.setter
    def cmt(self, value: float):
        """Set cmt"""
        self.__cmt = float(value)

    @property
    def cmn(self) -> float:
        """Added mass per unit length in normal direction."""
        return self.__cmn

    @cmn.setter
    def cmn(self, value: float):
        """Set cmn"""
        self.__cmn = float(value)

    @property
    def cdtl(self) -> float:
        """Linear drag force coefficient in tangential direction."""
        return self.__cdtl

    @cdtl.setter
    def cdtl(self, value: float):
        """Set cdtl"""
        self.__cdtl = float(value)

    @property
    def cdnl(self) -> float:
        """Linear drag force coefficient in normal direction."""
        return self.__cdnl

    @cdnl.setter
    def cdnl(self, value: float):
        """Set cdnl"""
        self.__cdnl = float(value)

    @property
    def cdx(self) -> float:
        """Quadratic drag coefficient in tangential direction."""
        return self.__cdx

    @cdx.setter
    def cdx(self, value: float):
        """Set cdx"""
        self.__cdx = float(value)

    @property
    def cdy(self) -> float:
        """Quadratic drag coefficient in normal direction."""
        return self.__cdy

    @cdy.setter
    def cdy(self, value: float):
        """Set cdy"""
        self.__cdy = float(value)

    @property
    def amx(self) -> float:
        """Added mass per unit length in tangential direction."""
        return self.__amx

    @amx.setter
    def amx(self, value: float):
        """Set amx"""
        self.__amx = float(value)

    @property
    def amy(self) -> float:
        """Added mass per unit length in normal direction."""
        return self.__amy

    @amy.setter
    def amy(self, value: float):
        """Set amy"""
        self.__amy = float(value)

    @property
    def cdlx(self) -> float:
        """Linear drag force coefficient in tangential direction."""
        return self.__cdlx

    @cdlx.setter
    def cdlx(self, value: float):
        """Set cdlx"""
        self.__cdlx = float(value)

    @property
    def cdly(self) -> float:
        """Linear drag force coefficient in normal direction."""
        return self.__cdly

    @cdly.setter
    def cdly(self, value: float):
        """Set cdly"""
        self.__cdly = float(value)

    @property
    def hydrodynamicInputCode(self) -> HydrodynamicInputCode:
        """Hydrodynamic input code"""
        return self.__hydrodynamicInputCode

    @hydrodynamicInputCode.setter
    def hydrodynamicInputCode(self, value: HydrodynamicInputCode):
        """Set hydrodynamicInputCode"""
        self.__hydrodynamicInputCode = value

    @property
    def scfk(self) -> float:
        """Scaling factor for Froude-Krylov term in Morison’s equation in normal direction"""
        return self.__scfk

    @scfk.setter
    def scfk(self, value: float):
        """Set scfk"""
        self.__scfk = float(value)

    @property
    def scfkt(self) -> TangentialFroudeKrylovScaling:
        """Scale for Froude-Krylov term in Morison’s equation in tangential direction"""
        return self.__scfkt

    @scfkt.setter
    def scfkt(self, value: TangentialFroudeKrylovScaling):
        """Set scfkt"""
        self.__scfkt = value

    @property
    def massDampingSpecification(self) -> bool:
        """Mass proportional Rayleigh damping"""
        return self.__massDampingSpecification

    @massDampingSpecification.setter
    def massDampingSpecification(self, value: bool):
        """Set massDampingSpecification"""
        self.__massDampingSpecification = bool(value)

    @property
    def stiffnessDampingSpecification(self) -> bool:
        """Stiffness proportional Rayleigh damping"""
        return self.__stiffnessDampingSpecification

    @stiffnessDampingSpecification.setter
    def stiffnessDampingSpecification(self, value: bool):
        """Set stiffnessDampingSpecification"""
        self.__stiffnessDampingSpecification = bool(value)

    @property
    def axialDampingSpecification(self) -> bool:
        """Local axial damping model"""
        return self.__axialDampingSpecification

    @axialDampingSpecification.setter
    def axialDampingSpecification(self, value: bool):
        """Set axialDampingSpecification"""
        self.__axialDampingSpecification = bool(value)

    @property
    def temperature(self) -> float:
        """Temperature at which the specification applies"""
        return self.__temperature

    @temperature.setter
    def temperature(self, value: float):
        """Set temperature"""
        self.__temperature = float(value)

    @property
    def alpha(self) -> float:
        """Thermal expansion coefficient"""
        return self.__alpha

    @alpha.setter
    def alpha(self, value: float):
        """Set alpha"""
        self.__alpha = float(value)

    @property
    def beta(self) -> float:
        """Pressure expansion coefficient"""
        return self.__beta

    @beta.setter
    def beta(self, value: float):
        """Set beta"""
        self.__beta = float(value)

    @property
    def massDamping(self) -> CRSMassDamping:
        """"""
        return self.__massDamping

    @massDamping.setter
    def massDamping(self, value: CRSMassDamping):
        """Set massDamping"""
        self.__massDamping = value

    @property
    def stiffnessDamping(self) -> CRSStiffnessDamping:
        """"""
        return self.__stiffnessDamping

    @stiffnessDamping.setter
    def stiffnessDamping(self, value: CRSStiffnessDamping):
        """Set stiffnessDamping"""
        self.__stiffnessDamping = value

    @property
    def axialDamping(self) -> CRSAxialDamping:
        """"""
        return self.__axialDamping

    @axialDamping.setter
    def axialDamping(self, value: CRSAxialDamping):
        """Set axialDamping"""
        self.__axialDamping = value

    @property
    def defaultExpansion(self) -> bool:
        """Use default thermal and pressure expansion settings"""
        return self.__defaultExpansion

    @defaultExpansion.setter
    def defaultExpansion(self, value: bool):
        """Set defaultExpansion"""
        self.__defaultExpansion = bool(value)

    @property
    def cdax(self) -> float:
        """Quadratic aerodynamic drag force coefficient per unit length in tangential direction"""
        return self.__cdax

    @cdax.setter
    def cdax(self, value: float):
        """Set cdax"""
        self.__cdax = float(value)

    @property
    def cday(self) -> float:
        """Quadratic aerodynamic drag force coefficient per unit length in normal direction"""
        return self.__cday

    @cday.setter
    def cday(self, value: float):
        """Set cday"""
        self.__cday = float(value)

    @property
    def cdaz(self) -> float:
        """Quadratic aerodynamic drag force coefficient per unit length in z direction"""
        return self.__cdaz

    @cdaz.setter
    def cdaz(self, value: float):
        """Set cdaz"""
        self.__cdaz = float(value)

    @property
    def aerodynamicInputCode(self) -> AerodynamicInputCode:
        """Aerodynamic input code"""
        return self.__aerodynamicInputCode

    @aerodynamicInputCode.setter
    def aerodynamicInputCode(self, value: AerodynamicInputCode):
        """Set aerodynamicInputCode"""
        self.__aerodynamicInputCode = value

    @property
    def aerodynamicDiameter(self) -> float:
        """Aerodynamic diameter"""
        return self.__aerodynamicDiameter

    @aerodynamicDiameter.setter
    def aerodynamicDiameter(self, value: float):
        """Set aerodynamicDiameter"""
        self.__aerodynamicDiameter = float(value)

    @property
    def massVolume(self) -> AxisymmetricCrossSectionMassVolume:
        """"""
        return self.__massVolume

    @massVolume.setter
    def massVolume(self, value: AxisymmetricCrossSectionMassVolume):
        """Set massVolume"""
        self.__massVolume = value

    @property
    def axialStiffnessInput(self) -> AxialStiffness:
        """Axial stiffness input specification"""
        return self.__axialStiffnessInput

    @axialStiffnessInput.setter
    def axialStiffnessInput(self, value: AxialStiffness):
        """Set axialStiffnessInput"""
        self.__axialStiffnessInput = value

    @property
    def bendingStiffnessInput(self) -> BendingStiffness:
        """Bending stiffness input specification"""
        return self.__bendingStiffnessInput

    @bendingStiffnessInput.setter
    def bendingStiffnessInput(self, value: BendingStiffness):
        """Set bendingStiffnessInput"""
        self.__bendingStiffnessInput = value

    @property
    def torsionStiffnessInput(self) -> TorsionStiffness:
        """Torsion stiffness input specification"""
        return self.__torsionStiffnessInput

    @torsionStiffnessInput.setter
    def torsionStiffnessInput(self, value: TorsionStiffness):
        """Set torsionStiffnessInput"""
        self.__torsionStiffnessInput = value

    @property
    def pressureDependency(self) -> int:
        """Pressure dependency parameter related to bending moment"""
        return self.__pressureDependency

    @pressureDependency.setter
    def pressureDependency(self, value: int):
        """Set pressureDependency"""
        self.__pressureDependency = int(value)

    @property
    def hysteresisOption(self) -> Hysteresis:
        """Hysteresis option in bending moment / curvature relation"""
        return self.__hysteresisOption

    @hysteresisOption.setter
    def hysteresisOption(self, value: Hysteresis):
        """Set hysteresisOption"""
        self.__hysteresisOption = value

    @property
    def hardeningParameter(self) -> float:
        """Hardening parameter"""
        return self.__hardeningParameter

    @hardeningParameter.setter
    def hardeningParameter(self, value: float):
        """Set hardeningParameter"""
        self.__hardeningParameter = float(value)

    @property
    def axialStiffness(self) -> float:
        """Axial stiffness"""
        return self.__axialStiffness

    @axialStiffness.setter
    def axialStiffness(self, value: float):
        """Set axialStiffness"""
        self.__axialStiffness = float(value)

    @property
    def axialStiffnessCharacteristics(self) -> List[AxialStiffnessItem]:
        """"""
        return self.__axialStiffnessCharacteristics

    @axialStiffnessCharacteristics.setter
    def axialStiffnessCharacteristics(self, value: List[AxialStiffnessItem]):
        """Set axialStiffnessCharacteristics"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__axialStiffnessCharacteristics = value

    @property
    def bendingStiffness(self) -> float:
        """Bending stiffness around y-axis"""
        return self.__bendingStiffness

    @bendingStiffness.setter
    def bendingStiffness(self, value: float):
        """Set bendingStiffness"""
        self.__bendingStiffness = float(value)

    @property
    def intFrictionMoment(self) -> float:
        """Internal friction moment."""
        return self.__intFrictionMoment

    @intFrictionMoment.setter
    def intFrictionMoment(self, value: float):
        """Set intFrictionMoment"""
        self.__intFrictionMoment = float(value)

    @property
    def shearStiffness(self) -> float:
        """Shear stiffness"""
        return self.__shearStiffness

    @shearStiffness.setter
    def shearStiffness(self, value: float):
        """Set shearStiffness"""
        self.__shearStiffness = float(value)

    @property
    def bendingStiffnessCharacteristics(self) -> List[BendingStiffnessY_Item]:
        """"""
        return self.__bendingStiffnessCharacteristics

    @bendingStiffnessCharacteristics.setter
    def bendingStiffnessCharacteristics(self, value: List[BendingStiffnessY_Item]):
        """Set bendingStiffnessCharacteristics"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__bendingStiffnessCharacteristics = value

    @property
    def negativeTorsionStiffness(self) -> float:
        """Torsion stiffness for negative twist."""
        return self.__negativeTorsionStiffness

    @negativeTorsionStiffness.setter
    def negativeTorsionStiffness(self, value: float):
        """Set negativeTorsionStiffness"""
        self.__negativeTorsionStiffness = float(value)

    @property
    def positiveTorsionStiffness(self) -> float:
        """Torsion stiffness for positive twist."""
        return self.__positiveTorsionStiffness

    @positiveTorsionStiffness.setter
    def positiveTorsionStiffness(self, value: float):
        """Set positiveTorsionStiffness"""
        self.__positiveTorsionStiffness = float(value)

    @property
    def torsionStiffnessCharacteristics(self) -> List[TorsionStiffnessItem]:
        """"""
        return self.__torsionStiffnessCharacteristics

    @torsionStiffnessCharacteristics.setter
    def torsionStiffnessCharacteristics(self, value: List[TorsionStiffnessItem]):
        """Set torsionStiffnessCharacteristics"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__torsionStiffnessCharacteristics = value

    @property
    def tensionCapacity(self) -> float:
        """Tension capacity"""
        return self.__tensionCapacity

    @tensionCapacity.setter
    def tensionCapacity(self, value: float):
        """Set tensionCapacity"""
        self.__tensionCapacity = float(value)

    @property
    def maxCurvature(self) -> float:
        """Maximum curvature"""
        return self.__maxCurvature

    @maxCurvature.setter
    def maxCurvature(self, value: float):
        """Set maxCurvature"""
        self.__maxCurvature = float(value)

    @property
    def barBeam(self) -> BarBeam:
        """Cross section type"""
        return self.__barBeam

    @barBeam.setter
    def barBeam(self, value: BarBeam):
        """Set barBeam"""
        self.__barBeam = value

    @property
    def stiffnessFactor(self) -> float:
        """Initial stiffness factor for internal friction moment"""
        return self.__stiffnessFactor

    @stiffnessFactor.setter
    def stiffnessFactor(self, value: float):
        """Set stiffnessFactor"""
        self.__stiffnessFactor = float(value)

    @property
    def submerged(self) -> bool:
        """Use formulation for partly submerged cross-section"""
        return self.__submerged

    @submerged.setter
    def submerged(self, value: bool):
        """Set submerged"""
        self.__submerged = bool(value)

    @property
    def coupledBendingTorsion(self) -> bool:
        """Geometric stiffness coupling between bending and torsion"""
        return self.__coupledBendingTorsion

    @coupledBendingTorsion.setter
    def coupledBendingTorsion(self, value: bool):
        """Set coupledBendingTorsion"""
        self.__coupledBendingTorsion = bool(value)

    @property
    def hydrodynamicRadiationInputCode(self) -> HydrodynamicInputCode:
        """Code for input of simplified radiation force coefficients"""
        return self.__hydrodynamicRadiationInputCode

    @hydrodynamicRadiationInputCode.setter
    def hydrodynamicRadiationInputCode(self, value: HydrodynamicInputCode):
        """Set hydrodynamicRadiationInputCode"""
        self.__hydrodynamicRadiationInputCode = value

    @property
    def solidityRatio(self) -> float:
        """Solidity ratio."""
        return self.__solidityRatio

    @solidityRatio.setter
    def solidityRatio(self, value: float):
        """Set solidityRatio"""
        self.__solidityRatio = float(value)

    @property
    def netWidthEnd1(self) -> float:
        """Net width at segment end 1"""
        return self.__netWidthEnd1

    @netWidthEnd1.setter
    def netWidthEnd1(self, value: float):
        """Set netWidthEnd1"""
        self.__netWidthEnd1 = float(value)

    @property
    def netWidthEnd2(self) -> float:
        """Net width at segment end 2"""
        return self.__netWidthEnd2

    @netWidthEnd2.setter
    def netWidthEnd2(self, value: float):
        """Set netWidthEnd2"""
        self.__netWidthEnd2 = float(value)

    @property
    def currentVelocityScaling(self) -> float:
        """Ratio between reduced current speed and ambient current speed due to upstream net shadowing effects"""
        return self.__currentVelocityScaling

    @currentVelocityScaling.setter
    def currentVelocityScaling(self, value: float):
        """Set currentVelocityScaling"""
        self.__currentVelocityScaling = float(value)
