# This an autogenerated file
# 
# Generated with EquidistantSignal
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.equidistantsignal import EquidistantSignalBlueprint
from numpy import ndarray,asarray
from sima.post.generatorsignal import GeneratorSignal
from sima.post.signalproperties import SignalProperties
from sima.sima.scriptablevalue import ScriptableValue

class EquidistantSignal(GeneratorSignal):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    properties : List[SignalProperties]
    name : str
         (default "")
    directInput : bool
         (default True)
    values : ndarray
    xunit : str
         Defines the unit of the x axis(default 's')
    yunit : str
         Defines the unit of the y axis(default '-')
    offset : float
         The offset of the x axis.(default 0.0)
    increment : float
         The sample increment of the x axis(default 1.0)
    size : int
         (default 0)
    function : str
         Apply the given function to each element of the input(default "")
    """

    def __init__(self , _id="", name="", directInput=True, xunit='s', yunit='-', offset=0.0, increment=1.0, size=0, function="", **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.properties = list()
        self.name = name
        self.directInput = directInput
        self.values = ndarray(1)
        self.xunit = xunit
        self.yunit = yunit
        self.offset = offset
        self.increment = increment
        self.size = size
        self.function = function
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return EquidistantSignalBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def properties(self) -> List[SignalProperties]:
        """"""
        return self.__properties

    @properties.setter
    def properties(self, value: List[SignalProperties]):
        """Set properties"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__properties = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def directInput(self) -> bool:
        """"""
        return self.__directInput

    @directInput.setter
    def directInput(self, value: bool):
        """Set directInput"""
        self.__directInput = bool(value)

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        self.__values = asarray(value)

    @property
    def xunit(self) -> str:
        """Defines the unit of the x axis"""
        return self.__xunit

    @xunit.setter
    def xunit(self, value: str):
        """Set xunit"""
        self.__xunit = str(value)

    @property
    def yunit(self) -> str:
        """Defines the unit of the y axis"""
        return self.__yunit

    @yunit.setter
    def yunit(self, value: str):
        """Set yunit"""
        self.__yunit = str(value)

    @property
    def offset(self) -> float:
        """The offset of the x axis."""
        return self.__offset

    @offset.setter
    def offset(self, value: float):
        """Set offset"""
        self.__offset = float(value)

    @property
    def increment(self) -> float:
        """The sample increment of the x axis"""
        return self.__increment

    @increment.setter
    def increment(self, value: float):
        """Set increment"""
        self.__increment = float(value)

    @property
    def size(self) -> int:
        """"""
        return self.__size

    @size.setter
    def size(self, value: int):
        """Set size"""
        self.__size = int(value)

    @property
    def function(self) -> str:
        """Apply the given function to each element of the input"""
        return self.__function

    @function.setter
    def function(self, value: str):
        """Set function"""
        self.__function = str(value)
