# This an autogenerated file
# 
# Generated with ColumnConfiguration
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.columnconfiguration import ColumnConfigurationBlueprint
from typing import Dict
from sima.post.pathspecification import PathSpecification
from sima.sima.scriptablevalue import ScriptableValue

class ColumnConfiguration(PathSpecification):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    path : str
         (default "")
    header : str
         Column header. The default value is the header,legend or name attribute of the signal(default "")
    label : str
         Column label. The default value is the unit of the y axis, or the label attribute, or ylabel + unit if specified(default "")
    format : str
         Column number format. Please refer to https://docs.oracle.com/javase/tutorial/i18n/format/decimalFormat.html for a description(default '0.####E0')
    fontSize : int
         Column font size. Will be used when renderin the table in a report,etc.(default 0)
    """

    def __init__(self , _id="", path="", header="", label="", format='0.####E0', fontSize=0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.path = path
        self.header = header
        self.label = label
        self.format = format
        self.fontSize = fontSize
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ColumnConfigurationBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def path(self) -> str:
        """"""
        return self.__path

    @path.setter
    def path(self, value: str):
        """Set path"""
        self.__path = str(value)

    @property
    def header(self) -> str:
        """Column header. The default value is the header,legend or name attribute of the signal"""
        return self.__header

    @header.setter
    def header(self, value: str):
        """Set header"""
        self.__header = str(value)

    @property
    def label(self) -> str:
        """Column label. The default value is the unit of the y axis, or the label attribute, or ylabel + unit if specified"""
        return self.__label

    @label.setter
    def label(self, value: str):
        """Set label"""
        self.__label = str(value)

    @property
    def format(self) -> str:
        """Column number format. Please refer to https://docs.oracle.com/javase/tutorial/i18n/format/decimalFormat.html for a description"""
        return self.__format

    @format.setter
    def format(self, value: str):
        """Set format"""
        self.__format = str(value)

    @property
    def fontSize(self) -> int:
        """Column font size. Will be used when renderin the table in a report,etc."""
        return self.__fontSize

    @fontSize.setter
    def fontSize(self, value: int):
        """Set fontSize"""
        self.__fontSize = int(value)
