# This an autogenerated file
# 
# Generated with ScatterDiagram
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.scatterdiagram import ScatterDiagramBlueprint
from numpy import ndarray,asarray
from sima.metocean.scatterdimension import ScatterDimension
from sima.sima.named import Named
from sima.sima.scriptablevalue import ScriptableValue

class ScatterDiagram(Named):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default "")
    hsUpperLimits : ScatterDimension
    tpUpperLimits : ScatterDimension
    values : ndarray
    unit : str
         (default "")
    """

    def __init__(self , _id="", name="", unit="", **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.name = name
        self.hsUpperLimits = None
        self.tpUpperLimits = None
        self.values = ndarray(1)
        self.unit = unit
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ScatterDiagramBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def hsUpperLimits(self) -> ScatterDimension:
        """"""
        return self.__hsUpperLimits

    @hsUpperLimits.setter
    def hsUpperLimits(self, value: ScatterDimension):
        """Set hsUpperLimits"""
        self.__hsUpperLimits = value

    @property
    def tpUpperLimits(self) -> ScatterDimension:
        """"""
        return self.__tpUpperLimits

    @tpUpperLimits.setter
    def tpUpperLimits(self, value: ScatterDimension):
        """Set tpUpperLimits"""
        self.__tpUpperLimits = value

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        self.__values = asarray(value)

    @property
    def unit(self) -> str:
        """"""
        return self.__unit

    @unit.setter
    def unit(self, value: str):
        """Set unit"""
        self.__unit = str(value)
