# This an autogenerated file
# 
# Generated with FirstOrderMotionTransferFunction
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.firstordermotiontransferfunction import FirstOrderMotionTransferFunctionBlueprint
from numpy import ndarray,asarray
from sima.hydro.directiondependentcomplexvalues import DirectionDependentComplexValues
from sima.hydro.directionsymmetry import DirectionSymmetry
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class FirstOrderMotionTransferFunction(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray
    frequencies : ndarray
    symmetry : DirectionSymmetry
    hfReference : float
         Transfer function reference position(default 0.0)
    surge : DirectionDependentComplexValues
    sway : DirectionDependentComplexValues
    heave : DirectionDependentComplexValues
    roll : DirectionDependentComplexValues
    pitch : DirectionDependentComplexValues
    yaw : DirectionDependentComplexValues
    """

    def __init__(self , _id="", symmetry=DirectionSymmetry.NO_SYMMETRY, hfReference=0.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.directions = ndarray(1)
        self.frequencies = ndarray(1)
        self.symmetry = symmetry
        self.hfReference = hfReference
        self.surge = None
        self.sway = None
        self.heave = None
        self.roll = None
        self.pitch = None
        self.yaw = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return FirstOrderMotionTransferFunctionBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        self.__directions = asarray(value)

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        self.__frequencies = asarray(value)

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def hfReference(self) -> float:
        """Transfer function reference position"""
        return self.__hfReference

    @hfReference.setter
    def hfReference(self, value: float):
        """Set hfReference"""
        self.__hfReference = float(value)

    @property
    def surge(self) -> DirectionDependentComplexValues:
        """"""
        return self.__surge

    @surge.setter
    def surge(self, value: DirectionDependentComplexValues):
        """Set surge"""
        self.__surge = value

    @property
    def sway(self) -> DirectionDependentComplexValues:
        """"""
        return self.__sway

    @sway.setter
    def sway(self, value: DirectionDependentComplexValues):
        """Set sway"""
        self.__sway = value

    @property
    def heave(self) -> DirectionDependentComplexValues:
        """"""
        return self.__heave

    @heave.setter
    def heave(self, value: DirectionDependentComplexValues):
        """Set heave"""
        self.__heave = value

    @property
    def roll(self) -> DirectionDependentComplexValues:
        """"""
        return self.__roll

    @roll.setter
    def roll(self, value: DirectionDependentComplexValues):
        """Set roll"""
        self.__roll = value

    @property
    def pitch(self) -> DirectionDependentComplexValues:
        """"""
        return self.__pitch

    @pitch.setter
    def pitch(self, value: DirectionDependentComplexValues):
        """Set pitch"""
        self.__pitch = value

    @property
    def yaw(self) -> DirectionDependentComplexValues:
        """"""
        return self.__yaw

    @yaw.setter
    def yaw(self, value: DirectionDependentComplexValues):
        """Set yaw"""
        self.__yaw = value
