# This an autogenerated file
# 
# Generated with ComplexValues
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.complexvalues import ComplexValuesBlueprint
from numpy import ndarray,asarray
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class ComplexValues(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    realValues : ndarray
    imagValues : ndarray
    """

    def __init__(self , _id="", **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.realValues = ndarray(1)
        self.imagValues = ndarray(1)
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ComplexValuesBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def realValues(self) -> ndarray:
        """"""
        return self.__realValues

    @realValues.setter
    def realValues(self, value: ndarray):
        """Set realValues"""
        self.__realValues = asarray(value)

    @property
    def imagValues(self) -> ndarray:
        """"""
        return self.__imagValues

    @imagValues.setter
    def imagValues(self, value: ndarray):
        """Set imagValues"""
        self.__imagValues = asarray(value)
