# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['templaer']

package_data = \
{'': ['*']}

install_requires = \
['jinja2>=3.1.2,<4.0.0']

setup_kwargs = {
    'name': 'templaer',
    'version': '0.1.6.1',
    'description': '',
    'long_description': '# Templaer\n\n`Templaer` - универсальный CLI шаблонизатор конфигурационных файлов, основанный на `Jinja2`.\n\n- GitHub - <https://github.com/denisxab/templaer>\n- Pip - <https://pypi.org/project/templaer/>\n- Habr - <https://habr.com/ru/post/717996/>\n\n![](./templaer/main.png)\n![](main.png)\n\n## Аналоги\n\nСуществует множество инструментов, основанных на `Jinja2`, которые можно использовать для шаблонизации конфигурационных файлов через `CLI`. Вот несколько примеров:\n\n- `j2cli`: это инструмент командной строки, который позволяет использовать Jinja2 для создания конфигурационных файлов. Он может принимать данные из файлов или стандартного ввода и применять их к шаблонам, включая конфигурационные файлы.\n- `cookiecutter`: это инструмент командной строки, который использует Jinja2 для генерации проектных шаблонов. Он также может использоваться для создания конфигурационных файлов. cookiecutter может быть установлен через pip.\n- `ansible`: это инструмент автоматизации, который использует Jinja2 для шаблонизации конфигурационных файлов и других файлов, используемых в автоматизации. ansible может быть установлен через pip.\n- `SaltStack`: это инструмент автоматизации, который использует Jinja2 для шаблонизации конфигурационных файлов и других файлов, используемых в автоматизации. SaltStack также может быть установлен через pip.\n- `mustpl` : <https://habr.com/ru/post/684898/>\n\nЯ создал `Templaer` потому что им удобнее пользоваться, и так как он на `Python`, его можно гибко кастомизировать. Если вам нравиться использовать другие шаблонизаторы конфигураций, то используйте их.\n\n## Установка\n\n1. Установить `templaer`\n\n    ```bash\n    pip install templaer\n    ```\n\n2. Получить подсказку по `CLI`\n\n    ```bash\n    python -m templaer\n    ```\n\n> Можете создать алиас в `.bashrc`/`.zshrc` для этой команды\n>\n> ```bash\n> alias templaer="python -m templaer"\n> ```\n\n## Примеры CLI\n\n### Шаблонные файлы\n\nВ файле `context.jsonc` хранятся данные для шаблонов, в нем можно использовать комментарии `//`.\n\nВ простом варианте это может быть словарь. Ключ - это имя переменной, значение ключа - это значение переменной.\n\n```jsonc\n{\n    // Режим разработчика\n    "DEBUG": false,\n    // Порт для дебага\n    "PORT_D": 8080,\n    // Порт для релиза\n    "PORT_R": 80\n}\n```\n\nПример шаблонного файла. Предлагаю для них указывать расширение `.tpl`. В данном случае этот файл называется `nginx.conf.tpl`. Новый собранный файл не будет иметь расширение `.tpl`, и будет называться `nginx.conf`.\n\n```nginx\nserver {\n    listen {{ PORT_R }};\n    server_name "localhost";\n\n    location / {\n        default_type text/html;\n        return 200 \'ok\';\n    }\n}\n```\n\n- Собрать указанные файлы (можно указывать несколько файлов).\n\n    ```bash\n    python -m templaer -c context.jsonc -f Файл0.conf.tpl Файл1.tpl\n    ```\n\n- Поиск в указанной директории всех файлов, которые оканчиваются на .tpl, и сборка этих файлов (можно указывать несколько директорий).\n\n    ```bash\n    python -m templaer -c context.jsonc -d Папка  \n    ```\n\n- Часто бывает нужно чтобы данные хранились в `.env` файле, например это нужно для `Docker`. И чтобы не держать две копии данных в `context.jsonc` и `.env` файлах. Можно указать флаг `-e_` - тогда он создаст `.env` файл на основе `context.jsonc` и поместит его в туже папку где и `context.jsonc`.\n\n    ```bash\n    python -m templaer -c context.jsonc -f Файл.conf.tpl -e_\n    ```\n\n### Шаблонные проекты\n\nЧасто бывает нужно создать проект по какому-то шаблону. В таких шаблонах обычно есть папки, есть файлы с шаблонным текстом, который может быть изменен, в зависимости от контекста, и какие-то бинарные файлы.\n\nДля того чтобы использовать шаблонный проект - его нужно создать.\n\nПример шаблонного проекта, создаем папку `ШаблонПроекта` со следующем содержанием:\n\n```markdown\n- ШаблонПроекта/\n  - manage.py.tpl\n  - Dockerfile.tpl\n  - requirements.txt\n  - api/\n    - urls.py\n    - views.py\n  - conf/\n    - settings.py.tpl\n    - asgi.py\n    - urls.py\n```\n\nДля того чтобы собрать проект по шаблону, нужно использовать команду:\n\n```bash\npython -m templaer -c context.jsonc -ti ШаблонПроекта -to ПапкаКудаСобрать \n```\n\nВ итоге создастся новый проект, в папке `ПапкаКудаСобрать`. В него копируются все файлы и папки из `ШаблонПроекта`, и в нем же будут собраны шаблонные файлы, на основе `context.jsonc`.\n\n```markdown\n- ПапкаКудаСобрать/\n  - manage.py.tpl\n  - manage.py\n  - Dockerfile.tpl\n  - Dockerfile\n  - requirements.txt\n  - api/\n    - urls.py\n    - views.py\n  - conf/\n    - settings.py.tpl\n    - settings.py\n    - asgi.py\n    - urls.py\n```\n\nЕсли вы попробуете заново собрать проект в туже папку, то тогда программа в интерактивном режиме будут запрашивать подтверждение на перезапись файлов, которые отличаются от шаблона. Если вы хотите заранее ответить на все вопросы `Yes`, то укажите флаг `-y_`\n\n```bash\npython -m templaer -c context.jsonc -ti ШаблонПроекта -to ПапкаКудаСобрать -y_\n```\n\n> .\n> **[Список всех готовых шаблонов](#готовые-шаблоны-проектов)**\n> .\n>\n## Основы шаблонов на Jinja2\n\n### Тернарный условный оператор\n\nВ этом примере показано как в зависимости от переменной `DEBUG`, будет поставлено значение из переменной `PORT_D` или `PORT_R`.\n\n1. Содержание файла `context.jsonc`:\n\n    ```json\n    {\n        "DEBUG": false,\n        "PORT_D": 8080,\n        "PORT_R": 80\n    }\n    ```\n\n2. Содержание файла `ЛюбойФайл.conf.tpl`:\n\n    ```nginx\n    server {\n        listen {{ PORT_D if DEBUG else PORT_R }};\n        server_name "localhost";\n\n        location / {\n            default_type text/html;\n            return 200 \'ok\';\n        }\n    }\n    ```\n\n3. Соберем файл используя команду:\n\n    ```bash\n    python -m templaer -c context.jsonc -f ЛюбойФайл.conf.tpl\n    ```\n\n4. В итоге создастся(или перезапишитесь) новый файл `ЛюбойФайл.conf`, с содержанием:\n\n    ```nginx\n    server {\n        listen 80;\n        server_name "localhost";\n\n        location / {\n            default_type text/html;\n            return 200 \'ok\';\n        }\n    }\n    ```\n\n# Готовые шаблоны проектов\n\n`Templaer` удобно использовать для кастомной шаблонизации проектов. В этой главе собраны инструкции как создать, и запустить проект, из шаблона.\n\n## Django REST + PostgreSQL + Nginx + Docker\n\n1. Собрать проект для `Django`:\n\n    ```bash\n    templaer -e_                                     \\\n        -c  ./st/django_project/пример_context.jsonc \\\n        -ti ./st/django_project                      \\\n        -to ПапкаКудаСобрать                  \n    ```\n\n2. Собрать и запустить контейнеры, через `docker-compose`:\n\n    ```bash\n    docker-compose build && docker-compose up\n    ```\n\n3. Создать и применить миграции в БД, и собрать статические файлы в Django:\n\n    ```bash\n    make docker_init_django\n    ```\n\n---\n\n1. Собрать приложение для `Django`:\n\n    ```bash\n    templaer                    \\\n        -ti ./st/django_app     \\\n        -to ПапкаКудаСобрать                  \n    ```\n',
    'author': 'Denis',
    'author_email': 'pro-progerkustov@yandex.ru',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
