"""Fluent solver TUI commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        super().__init__(path, service)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            super().__init__(path, service)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

    class solve(TUIMenu):
        """
        Enter the solve menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
            self.report_files = self.__class__.report_files(path + ["report_files"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            super().__init__(path, service)
        def multistage_time_iterate(self, *args, **kwargs):
            """
            Perform unsteady iterations.
            """
            return PyMenu(self.service, "/solve/multistage_time_iterate").execute(*args, **kwargs)
        def dpm_update(self, *args, **kwargs):
            """
            Updates discrete phase source terms.
            """
            return PyMenu(self.service, "/solve/dpm_update").execute(*args, **kwargs)
        def convergence_conditions(self, *args, **kwargs):
            """
            Enters the convergence conditions menu.
            """
            return PyMenu(self.service, "/solve/convergence_conditions").execute(*args, **kwargs)
        def mesh_motion(self, *args, **kwargs):
            """
            Performs mesh motion.
            """
            return PyMenu(self.service, "/solve/mesh_motion").execute(*args, **kwargs)
        def dual_time_iterate(self, *args, **kwargs):
            """
            Performs unsteady iterations for a specified number of time steps.
            """
            return PyMenu(self.service, "/solve/dual_time_iterate").execute(*args, **kwargs)
        def iterate(self, *args, **kwargs):
            """
            Performs a specified number of iterations.  This option is still available during transient simulations, since it can be used to add more iterations to the same time step after interrupting iterations within a time step.
            """
            return PyMenu(self.service, "/solve/iterate").execute(*args, **kwargs)
        def update_physical_time(self, *args, **kwargs):
            """
            Advances the unsteady solution to the next physical time level. Using this command in conjunction with theiterate command allows you to manually advance the solution in time (rather than doing it automatically with the dual-time-iterate command).
            """
            return PyMenu(self.service, "/solve/update_physical_time").execute(*args, **kwargs)
        def patch(self, *args, **kwargs):
            """
            Patches a value for a flow variable in the domain. You can either provide a numerical value, which you can enter directly, or you can enter an expression, which must be entered within quotation marks.
            """
            return PyMenu(self.service, "/solve/patch").execute(*args, **kwargs)
        def iterate_steady_2way_fsi(self, *args, **kwargs):
            """
            Perform a specified number of steps.
            """
            return PyMenu(self.service, "/solve/iterate_steady_2way_fsi").execute(*args, **kwargs)

        class cell_register_operations(TUIMenu):
            """
            Enters the cell register operations menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists the currently defined cell register operations.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/delete").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enters the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                super().__init__(path, service)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initializes using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solve/initialize/hyb_initialization").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initializes unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/init_flow_statistics").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Sets default initial values.
                """
                return PyMenu(self.service, "/solve/initialize/set_defaults").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specifies the number of timesteps for ramping of sound sources and re-initializes the acoustics wave equation solution. For the initialized acoustics solution, Fluent reports the current state of the sound sources ramping.
                """
                return PyMenu(self.service, "/solve/initialize/init_acoustics_options").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Resets discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solve/initialize/dpm_reset").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/levelset_auto_init").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Displays the number of iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Deletes wall film particles and initializes wall film variables to zero. This option is available only with the wall-film DPM boundary condition.
                """
                return PyMenu(self.service, "/solve/initialize/lwf_initialization").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solve/initialize/repair_wall_distance").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enters the set full-multigrid for initialization menu. Initial values for each variable can be set within this menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solve/initialize/patch").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initializes using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solve/initialize/fmg_initialization").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Opens channel automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enters the hybrid initialization menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                Lists default values.
                """
                return PyMenu(self.service, "/solve/initialize/list_defaults").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initializes the flow field with the current default values.
                """
                return PyMenu(self.service, "/solve/initialize/initialize_flow").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initializes instantaneous velocity field out of steady state RANS results, for use before enabling a scale resolving simulation such as LES.
                """
                return PyMenu(self.service, "/solve/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Displays the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_time_sampled").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Sets reference frame to absolute or relative.
                """
                return PyMenu(self.service, "/solve/initialize/reference_frame").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enters the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)
                def set_options(self, *args, **kwargs):
                    """
                    Sets options for patching and smoothing volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enters the compute default values menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initializes the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Enters the menu for localized turbulent flow initialization.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Sets values for the turbulent intensity and turbulent viscosity ratio for localized initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables localized initialization of turbulent flow variables.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Enters the report definitions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/compute").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report definitions.
                """
                return PyMenu(self.service, "/solve/report_definitions/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/edit").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report definition objects.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete_all").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Creates a copy of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/copy").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Renames a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/rename").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/report_definitions/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/list_properties").execute(*args, **kwargs)

        class report_plots(TUIMenu):
            """
            Enters the report plots menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/clear_data").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plots the specified report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/plot").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report plot objects.
                """
                return PyMenu(self.service, "/solve/report_plots/delete_all").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Defines the axes for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/axes").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/edit").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Defines the curves for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/curves").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report plots.
                """
                return PyMenu(self.service, "/solve/report_plots/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/list_properties").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report plot object.
                """
                return PyMenu(self.service, "/solve/report_plots/delete").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set solution parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.enhanced_les_numerics = self.__class__.enhanced_les_numerics(path + ["enhanced_les_numerics"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                super().__init__(path, service)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Sets the solution methods to the default settings.
                """
                return PyMenu(self.service, "/solve/set/set_solution_methods_to_default").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solve/set/material_property_warnings").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enables solution steering for the density-based solver.
                """
                return PyMenu(self.service, "/solve/set/solution_steering").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Sets solver limits for various solution variables, in order to improve the stability of the solution.
                """
                return PyMenu(self.service, "/solve/set/limits").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enters the max-corrections menu.
                """
                return PyMenu(self.service, "/solve/set/max_corrections").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enters the residual tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/residual_tolerance").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Sets pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solve/set/bc_pressure_extrapolations").execute(*args, **kwargs)
            def multi_grid_controls(self, *args, **kwargs):
                """
                Sets multigrid parameters and termination criteria.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_controls").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Sets the implicit residual smoothing parameters. This command is available only for the explicit coupled solver.
                """
                return PyMenu(self.service, "/solve/set/residual_smoothing").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when reversed flow occurs at inlets and outlets, and when mass-flow inlets develop supersonic regions. By default, flow warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/flow_warnings").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Sets all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solve/set/set_all_species_together").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Selects the equations to be solved.
                """
                return PyMenu(self.service, "/solve/set/equations").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Sets the number of iterations for which convergence monitors are reported. The default is 1 (after every iteration).
                """
                return PyMenu(self.service, "/solve/set/reporting_interval").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solve/set/time_step").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def reactions(self, *args, **kwargs):
                """
                Enables the species reaction sources and sets relaxation factor.
                """
                return PyMenu(self.service, "/solve/set/reactions").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Sets controls to default values.
                """
                return PyMenu(self.service, "/solve/set/set_controls_to_default").execute(*args, **kwargs)
            def enable_output_dp_dt(self, *args, **kwargs):
                """
                Controls whether the output field variabledp-dt will be available for transient simulation postprocessing. If you select no, pressure fields at the previous time steps will not be stored in memory which reduces memory usage.
                """
                return PyMenu(self.service, "/solve/set/enable_output_dp_dt").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Switches between the modified treatment of node-based gradients at boundary cells and the legacy treatment (R14.5.7 and earlier). If using the density-based solver, you can also specify the extended treatment. For details, see .
                """
                return PyMenu(self.service, "/solve/set/nb_gradient_boundary_option").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enters the under-relaxation menu, which allows you to set the under-relaxation factor for each equation that is being solved in a segregated manner.
                """
                return PyMenu(self.service, "/solve/set/under_relaxation").execute(*args, **kwargs)
            def moving_mesh_numerics(self, *args, **kwargs):
                """
                Transient options for sliding, moving, and/or dynamic mesh.
                """
                return PyMenu(self.service, "/solve/set/moving_mesh_numerics").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Sets anisotropic drag parameters for the Eulerian multiphase model.
                """
                return PyMenu(self.service, "/solve/set/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def multi_grid_fas(self, *args, **kwargs):
                """
                Sets the parameters that control the FAS multigrid solver. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_fas").execute(*args, **kwargs)
            def multi_grid_amg(self, *args, **kwargs):
                """
                Sets the parameters that govern the algebraic multigrid procedure.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_amg").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Sets VOF numeric options.
                """
                return PyMenu(self.service, "/solve/set/vof_numerics").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension_expert").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Sets the sub time step calculation method for VOF calculations.
                """
                return PyMenu(self.service, "/solve/set/vof_explicit_controls").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Specifies whether you want to lock (or “freeze”) the temperature values for all the cells in solid zones (including those to which you have a hooked an energy source through a UDF) and in walls that have shell conduction enabled, so that the values do not change during further solver iterations.
                """
                return PyMenu(self.service, "/solve/set/lock_solid_temperature").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enables a modified NITA scheme and other setting changes that can speed up the simulation. This option is only available with the Large Eddy Simulation (LES) turbulence model, and is intended for unreacting flow simulations that use a constant-density fluid.
                """
                return PyMenu(self.service, "/solve/set/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def correction_tolerance(self, *args, **kwargs):
                """
                Enters the correction tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/correction_tolerance").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enters the discretization scheme menu. This allows you to select the discretization scheme for the convection terms in the solution equations. The following text commands can make a selection from a subset of the models in the following table:.
                """
                return PyMenu(self.service, "/solve/set/discretization_scheme").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Selects which pressure-velocity coupling scheme is to be used. Five schemes are available:.
                """
                return PyMenu(self.service, "/solve/set/p_v_coupling").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Sets gradient options.
                """
                return PyMenu(self.service, "/solve/set/gradient_scheme").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Sets the heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/solve/set/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                For flows that do not transition from sub-critical to super-critical, or vice-versa, you can speed-up the solution calculation by updating the frequency of Froude number during run time.
                """
                return PyMenu(self.service, "/solve/set/open_channel_controls").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Sets phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solve/set/phase_based_vof_discretization").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/adaptive_time_stepping").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Sets the reference density method for the Eulerian multiphase model. The following options are available:
                0 (default): Averaged density of the phase
                1: Cell density of the phase
                1: Constant value of 1
                1: Cell density of the phase
                See  for more information.
                """
                return PyMenu(self.service, "/solve/set/mp_reference_density").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solve/set/flux_type").execute(*args, **kwargs)
            def slope_limiter_set(self, *args, **kwargs):
                """
                Selects a new Fluent solver slope limiter.
                """
                return PyMenu(self.service, "/solve/set/slope_limiter_set").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/variable_time_stepping").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Sets the order in which the model equations are solved, which can affect the convergence speed when you are using the pressure-based solver. The standard method is enabled by default and corresponds to the ordering shown in  and  in the Theory Guide; alternatively, you can select theoptimized-for-volumetric-expansion method, which is recommended for flows in which the density is strongly dependent on thermal effects, chemical composition, and so on (such as combustion simulations). This text command is not available for steady simulations and/or when a multiphase model is enabled.
                """
                return PyMenu(self.service, "/solve/set/equation_ordering").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Sets surface-tension calculation options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension").execute(*args, **kwargs)
            def multi_stage(self, *args, **kwargs):
                """
                Sets the multi-stage coefficients and the dissipation and viscous evaluation stages. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_stage").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Sets the number of iterations for a steady-state simulation without starting the calculation.
                """
                return PyMenu(self.service, "/solve/set/number_of_iterations").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Completely disables reconstruction, resulting in totally first-order accuracy.
                """
                return PyMenu(self.service, "/solve/set/disable_reconstruction").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Enables / disables the variable time step size formulation for second-order implicit transient formulations. If you disable the variable time step size formulation, note that any change in the time step size will introduce an error proportional to the change in the time step size ratio.
                """
                return PyMenu(self.service, "/solve/set/second_order_time_options").execute(*args, **kwargs)
            def expert(self, *args, **kwargs):
                """
                Sets expert options.
                """
                return PyMenu(self.service, "/solve/set/expert").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Sets solver options for stiff chemistry solutions.
                """
                return PyMenu(self.service, "/solve/set/stiff_chemistry").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Sets the fine-grid Courant number (time step factor). This command is available only for the coupled solvers.
                """
                return PyMenu(self.service, "/solve/set/courant_number").execute(*args, **kwargs)
            def numerics(self, *args, **kwargs):
                """
                Sets numerics options.
                """
                return PyMenu(self.service, "/solve/set/numerics").execute(*args, **kwargs)
            def relaxation_method(self, *args, **kwargs):
                """
                Sets the solver relaxation method.
                """
                return PyMenu(self.service, "/solve/set/relaxation_method").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enters the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solve/set/relaxation_factor").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when quantities are being limited. By default, limiter warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/limiter_warnings").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enables convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solve/set/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Sets pressure-velocity controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Sets the amount of residual information to be printed. A value of 0 (the default) prints residuals at the end of each fine grid iteration. A value of 1 prints residuals after every stage of the fine grid iteration. A value of 2 prints residuals after every stage on every grid level.
                """
                return PyMenu(self.service, "/solve/set/residual_verbosity").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Sets damping function in flow direction. This command appears only when the VOF model is enabled. Select the damping function to be used:
                Index
                Damping Function
                0
                Linear
                1
                Quadratic
                2
                Cubic
                3
                Cosine.
                """
                return PyMenu(self.service, "/solve/set/numerical_beach_controls").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Enables data sampling for steady or unsteady flow statistics.
                """
                return PyMenu(self.service, "/solve/set/data_sampling").execute(*args, **kwargs)
            def p_v_controls_advanced(self, *args, **kwargs):
                """
                Set advanced pressure-velocity coupling controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls_advanced").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Sets solution steering parameters.
                """
                return PyMenu(self.service, "/solve/set/set_solution_steering").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Sets multiphase numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    super().__init__(path, service)

                class boiling_parameters(TUIMenu):
                    """
                    Enters the menu for the multiphase boiling model parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        When enabled, considers liquid volume fraction effects by multiplying the heat transfer coefficients by the local liquid volume fraction.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)
                    def thin_film(self, *args, **kwargs):
                        """
                        When enabled, includes multiphase boiling thin film effects using .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Enters the menu for the multiphase heat mass transfer parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Enables the alternative treatment of the energy sources. For more  information, see .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Enters the menu for the advanced boiling options for the  semi-mechanistic boiling model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes the expert options for the semi-mechanistic boiling model. For more information about these options, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Enables/disables the two-resistance boiling framework to improve the robustness and accuracy of the solution of cases with multiple boiling mechanisms. For more information about this item, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Sets the under-relaxation factor for boiling heat flux. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Enters the cavitation heat mass transfer menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Sets the condensation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 0.2.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the vapor pressure after the turbulence and thermal correction. The default value is five times the vapor pressure, with consideration of turbulent and thermal effects for each cell and phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Sets the minimum vapor pressure limit for the cavitation mass-transfer model. The default value is 1 Pa.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Sets the evaporation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 1.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enables/disables the turbulent diffusion treatment for a cavitating turbulent flow. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Enters the menu for the area density.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Sets the minimum volume fraction for the area density and cavitation. This may be useful, for example, in cases when a species mass transfer model (such as the Symmetric model or Particle model) do not consider evaporation or condensation if the volume fraction of one of the phases is zero. The seeding allows for a phase change to occur in the fluid flow. The default value is 1e-6.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Enables/disables the interfacial area density Gradient-Symmetric model. For more information about this model, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    Enters the solution-stabilization numerics menu. This item is available only for the VOF model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        super().__init__(path, service)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        When enabled, modifies solver settings for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        When enabled, uses additional controls for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Enters the menu for additional advanced stability controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Enables/disables the blended compressive discretization scheme.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Enters the menu for the velocity-limiting-treatment.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enables/disables the velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Specifies the maximum velocity magnitude.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            When enabled, the solver prints the number of velocity limited cells at each iteration.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Enters the menu for the stability controls for multiphase flows. For more information about the below option, see  and .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        super().__init__(path, service)

                    class hybrid_nita(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Sets the number of outer iterations.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Allows you to change the number of initial time-steps and the number of initial outer iterations to control solution stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Enters the menu for the instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Sets the number of outer iterations for an unstable  event.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Sets the Courant number limit for detecting unstable  events. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enables/disables the instability detector to deal with  possible instability problems. Once this option is enabled,  additional instability detection options become  available.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Selects the CFL number type for detection of an unstable  event. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Sets the velocity limit for detecting unstable events.  This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            When enabled, solves the flow equation at the end of the iteration. This improves the behavior at the start of new time-step if the solution does not converge properly.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Enters the menu for the pressure-velocity coupling controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            super().__init__(path, service)

                        class skewness_correction(TUIMenu):
                            """
                            Enters the skewness correction menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Enables/disables the limited pressure correction  gradient in skewness terms for the PISO, SIMPLEC, or  fractional step pressure-coupling schemes.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Enters the stability controls menu for the Rhie-Chow interpolation.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Enables/disables the low-order velocity interpolation in  the flux calculation.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Enters the stability control menu for VOF cases that involve the Coupled pressure-velocity coupling scheme.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Allows you to use the linearized buoyancy force and the  blended treatment for the buoyancy force.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Enters the anti-diffusion menu. This item is available for VOF cases  with the Interfacial Anti-Diffusion option  enabled.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Sets the cosine exponent in the dynamic strength treatment in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Sets the maximum value of dynamic anti-diffusion strength in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enables dynamic strength to reduce compression in the direction tangential to the interface.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Enters the porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Allows you to fix the saturation (volume fraction) of the phase at  its user-specified residual saturation value.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Enters the compressible multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Enables an alternative formulation for compressible phases at an  inlet boundary. This formulation calculates static temperature and  pressure using an iterative method based on fundamental thermodynamic  relations.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Enables an enhanced numerical treatment that provides better  stability at startup and during calculation of compressible  flows.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Enters the default controls menu. This menu is available only for multiphase flows.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Applies the multiphase defaults (version 2020 R1) to the loaded case  file.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Enters the viscous multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Forces harmonic averaging of cell viscosities to calculate face  viscosity used in momentum equation. This can improve convergence for  highly viscous flow applications (the VOF model only).
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enters the warped-face gradient correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables gradient enhancement computations and specifies whether Fluent uses fast or memory saving mode.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class amg_options(TUIMenu):
                """
                Enters the AMG options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def laplace_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables Laplace coarsening for scalar and/or coupled equations.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/laplace_coarsening").execute(*args, **kwargs)
                def conservative_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of conservative coarsening techniques for scalar and/or coupled equations that can improve parallel performance and/or convergence for some difficult cases.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                def amg_gpgpu_options(self, *args, **kwargs):
                    """
                    Set GPGPU AMG solver options.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                def aggressive_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of a version of the AMG solver that is optimized for high coarsening rates. This option is recommended if the AMG solver diverges with the default settings.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enters the divergence prevention menu. This menu is only available for the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables a divergence prevention option so that Fluent applies under-relaxation to the variables in select cells where the temperature and/or pressure values are approaching the minimum and/or maximum limits.
                    """
                    return PyMenu(self.service, "/solve/set/divergence_prevention/enable").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Makes available the Pressure Discontinuity Sensor which is a binary identifier equal to 1 if a cell is in proximity of a pressure discontinuity.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Sets the level of stabilization used to achieve fast convergence. Enter a number 0-5 corresponding to the Mach number range that best characterizes the flow.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/expert").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Speed Numerics.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/enable").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Sets buffer layer height, verbosity, and open channel wave theory formulation.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Specifies which open channel wave theory formulation Fluent uses.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Sets the buffer layer height.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Sets the open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solve/set/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets the relaxation factor.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Selects the variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Enters the advanced settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                    self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                    self.turbomachinery_specific_numerics = self.__class__.turbomachinery_specific_numerics(path + ["turbomachinery_specific_numerics"], service)
                    super().__init__(path, service)
                def explicit_under_relaxation_value(self, *args, **kwargs):
                    """
                    Explicit under-relaxation value.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/explicit_under_relaxation_value").execute(*args, **kwargs)
                def retain_temporary_solver_mem(self, *args, **kwargs):
                    """
                    Enables/disables the retention of temporary solver memory, which retains gradient data and makes some advanced options available for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_temporary_solver_mem").execute(*args, **kwargs)
                def linearized_mass_transfer_udf(self, *args, **kwargs):
                    """
                    Enables/disables the use of a linearized mass transfer user-defined function (that is, the DEFINE_LINEARIZED_MASS_TRANSFER macro), as opposed to a mass transfer user-defined function (that is, the DEFINE_MASS_TRANSFER macro).
                    """
                    return PyMenu(self.service, "/solve/set/advanced/linearized_mass_transfer_udf").execute(*args, **kwargs)
                def skewness_correction_enhanced(self, *args, **kwargs):
                    """
                    Enable enhanced skewness correction scheme.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/skewness_correction_enhanced").execute(*args, **kwargs)
                def energy_numerical_noise_filter(self, *args, **kwargs):
                    """
                    Enables/disables a filter to eliminate non-physical numerical noise in the energy field. Numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present. Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive. This text command is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_numerical_noise_filter").execute(*args, **kwargs)
                def singhal_et_al_cavitation_model(self, *args, **kwargs):
                    """
                    Enables/disables the availability of the Singhal et al. cavitation model option, which can then be enabled in the Multiphase Model dialog box or by using the following text command: define/phases/set-domain-properties/interaction-domain/heat-mass-reaction/cavitation/cavitation?.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/singhal_et_al_cavitation_model").execute(*args, **kwargs)
                def correction_form(self, *args, **kwargs):
                    """
                    S.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/correction_form").execute(*args, **kwargs)
                def retain_cell_residuals(self, *args, **kwargs):
                    """
                    Enables/disables the retention of cell residuals for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_cell_residuals").execute(*args, **kwargs)
                def alternate_wall_temp_formulation(self, *args, **kwargs):
                    """
                    Enables/disables an alternate formulation for wall temperatures.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/alternate_wall_temp_formulation").execute(*args, **kwargs)
                def show_all_discretization_schemes(self, *args, **kwargs):
                    """
                    Enables/disables the availability of all applicable discretization schemes.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/show_all_discretization_schemes").execute(*args, **kwargs)
                def bcd_boundedness(self, *args, **kwargs):
                    """
                    Specifies the BCD scheme parameter, which controls the boundedness strength of the BCD scheme in the pressure-based solver, as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_boundedness").execute(*args, **kwargs)
                def anisotropic_solid_heat_transfer(self, *args, **kwargs):
                    """
                    Set up the heat transfer for anisotropic solid zones.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/anisotropic_solid_heat_transfer").execute(*args, **kwargs)
                def energy_reconstruction_gradient_limiting(self, *args, **kwargs):
                    """
                    Enable limiting of reconstruction gradient for the energy equation.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_reconstruction_gradient_limiting").execute(*args, **kwargs)
                def bcd_weights_freeze(self, *args, **kwargs):
                    """
                    Enables/disables freezing of weighting coefficients of the central differencing and the upwind components of the BCD scheme. This dialog command requires the iteration number, after which the BCD scheme weights are to be frozen at each timestep. Freezing the BCD weighting coefficients may help to improve convergence of the timestep iterations as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_weights_freeze").execute(*args, **kwargs)

                class secondary_gradient_limiting(TUIMenu):
                    """
                    Enters the secondary gradient limiting menu. This menu is only available when the define/models/solver/pressure-based text command is enabled.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mesh_quality_limits(self, *args, **kwargs):
                        """
                        Defines the mesh quality limits used when applying secondary  gradient limiting to faces on coupled two-sided walls. Shifting this  range closer to 1 will decrease the risk of divergence, but at the cost  of accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                    def energy(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the energy  calculations on coupled two-sided walls. This limiting can help prevent  divergence when the cells on such walls have poor orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                    def uds(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the user-defined  scalar (UDS) calculations on coupled two-sided walls. This limiting can  help prevent divergence when the cells on such walls have poor  orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/uds").execute(*args, **kwargs)

                class non_reflecting_boundary_treatment(TUIMenu):
                    """
                    Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)

                class turbomachinery_specific_numerics(TUIMenu):
                    """
                    Enter turbomachinery specific numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def settings(self, *args, **kwargs):
                        """
                        Adjust settings for turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/settings").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Activate/deactivate turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/enable").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Enter the menu for specifying quantities and zones for steady and unsteady flow statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    Lists the combinations of zones and quantities that are defined for sampling steady and unsteady flow statistics.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Specify zone and quantity combinations for sampling Fourier coefficients of unsteady flows.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)

            class enhanced_les_numerics(TUIMenu):
                """
                Enter enhanced LES options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def optimized_cd(self, *args, **kwargs):
                    """
                    Use optimized central difference discretization.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_cd").execute(*args, **kwargs)
                def optimized_algorithm(self, *args, **kwargs):
                    """
                    Use solver algorithm optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_algorithm").execute(*args, **kwargs)
                def optimized_advection(self, *args, **kwargs):
                    """
                    Use advection scheme optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_advection").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enters the menu to specify parameters of the acoustics wave equation solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the menu to specify the expert parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the explicit relaxation factor. Should be used only with  bad meshes, when iterations do not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the implicit under-relaxation factor. Should be used only  with bad meshes, when the AMG linear solver does not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Provides text commands that allow you to undo enhancements to the default solver behavior.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2021 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R3 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2021 R2 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2022 R1 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enters the transient controls menu, which allows you to define settings related to time advancement for transient flow calculations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def time_step_size(self, *args, **kwargs):
                    """
                    Sets the magnitude of the (physical) time step . This text command is only available when the solve/set/transient-controls/fixed-user-specified text command is set toyes.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    When enabled, if the truncation error within a time step exceeds the specified tolerance Fluent will automatically undo the current calculation and make another attempt with the time step reduced by 1/2. This will be attempted up to 5 times after which Fluent will accept the result and proceed to the next time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/undo_timestep").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size used for solid zones is independent from that used for fluid zones. This text command is only available when both a solid zone exists and energy is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the specified truncation error tolerance.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Sets the method by which you will specify the duration of the calculation. The duration can be defined by the total time, the total number of time steps, the incremental time, or the number of incremental time steps. In this context, "total" indicates that Fluent will consider the amount of time / steps that have already been solved and stop appropriately, whereas "incremental" indicates that the solution will proceed for a specified amount of time / steps regardless of what has previously been calculated. This text command is only available when the time stepping is adaptive or based on a user-defined function.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial conditions at time step n+1. The predictor algorithm is a computation that sets a better initial condition for the time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the total number of time steps that the simulation will run (which includes any time steps that have already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to1.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size is defined by a user-defined function (UDF) that uses theDEFINE_DELTAT macro.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent as the calculation proceeds such that the Courant–Friedrichs–Lewy (CFL) condition is satisfied, using the specified Courant number.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Sets the amount of incremental (that is, additional) time to run the simulation, regardless of how much time has already been run in previous calculations. This text command is only available when the solve/set/transient-controls/duration-specification-method is set to3.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/incremental_time").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which a specified period or frequency is the basis for determining the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation.  This option is available when automatic initialization and case modification is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Allows you to open theSimulation Status dialog box, which reports details about the simulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solution_status").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enters the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Sets the maximum flow time.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_flow_time").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which you directly specify the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing the next time step. The predictor algorithm is a computation that sets a better initial condition for the time step. It uses the rate of change between the prediction and the correction as an indicator for whether the next time step should be larger, smaller, or the same as the current one.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/predict_next_time").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Specifies the time interval for acoustic data sampling. This text command is only available when both the Ffowcs Williams and Hawkings model is selected and the density-based solver is used with the explicit formulation and explicit transient formulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Sets the total amount of time that the simulation will be run (which includes any time that has already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to2.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_time").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the convective time scale (global Courant number): the time-step-size calculation depends on the mesh density and velocity in interfacial cells. This method is available for all multiphase models using the implicit or explicit volume fraction formulation, except for the wet steam model.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Enables / disables an option that allows for better prediction of the flow field in rotating fluid zones at every time step, in order to speed up the calculation. This text command is only available for transient simulations.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Specifies whether to define the transient advancement either directly by entering a time step size / period / frequency (using the text commands available in thesolve/set/transient-controls menu) or indirectly by entering a Courant number value (using the solve/set/courant-number text command). This text command is only available for the density-based solver when both the explicit formulation and explicit transient formulation are used.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/specified_time_step").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation without starting the calculation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/number_of_time_steps").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Enters the menu for setting multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Enables/disables the physics-driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        When enabled, various time scales (depending on the selection) are  printed to the console window at every time step. This text command is  available with the moving mesh CFL constraint and with the physics-based  constraint.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Enters the menu for choosing the time-scale options. This menu  becomes available after you enable the physics-driven time-step  constraints using the solve/set/transient-controls/multiphase-specific-time-constraints/physics-based-constraint?  text command.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the acoustic time scale. This option is available only for compressible flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the viscous time scale. This option is disabled by default. This command is not available with inviscid flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the gravitational time scale. This option is available only if gravity is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the surface-tension-driven time scale. This option is available only if the surface tension force modeling is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enters the pseudo time method menu. This menu is only available for cases that use a pressure-based segregated solver (SIMPLE, SIMPLEC, or PISO) or for steady-state cases that use the pressure-based coupled solver or the density-based implicit solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enters the advanced options menu, which allows you to enable / disable the pseudo time method for individual equations and define their pseudo time scale factors or under-relaxation factors, respectively. These settings only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time Courant number when the local time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time settings for the calculation when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enters the relaxation factors menu, where you can set the pseudo time explicit relaxation factors for individual equations. These factors only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the messages related to the pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Enables and sets the pseudo time step size formulation or disables the pseudo time method option.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/formulation").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/verbosity").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)

            class fast_transient_settings(TUIMenu):
                """
                Enters the fast transient settings menu. This menu is only available for transient cases that use the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rk2(self, *args, **kwargs):
                    """
                    Allows you to enable the use of a two-stage Runge-Kutta scheme for time integration, or revert to the default multi-stage Runge-Kutta scheme. This text command is only available for transient cases that use the density-based explicit formulation.
                    """
                    return PyMenu(self.service, "/solve/set/fast_transient_settings/rk2").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enters the NITA expert control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Enables and sets hybrid NITA options. For more details, see .
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Enables/disables coupling of the neighbor and skewness corrections.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Setting this to 1, enables the verbosity for NITA diagnostics. The default value of 0 disables verbosity output for NITA diagnostics.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/set_verbosity").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enters the poor mesh numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells (those with an orthogonal quality of 0, as well as those identified by other enabled criteria), and defines whether the local solution correction is 0th, 1st, or 2nd order.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the cell gradient quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command. This criterion is only available with the pressure-based solver, and is not supported for cases that have periodic boundaries.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells with an orthogonal quality that is equal to or less than the threshold defined by the solve/set/poor-mesh-numerics/set-quality-threshold text command (which by default is set to 0.05).
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Includes a register for the poor mesh numerics or not.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Sets the orthogonal quality threshold used for applying poor mesh numerics when the solve/set/poor-mesh-numerics/cell-quality-based? text command is enabled. By default, cells with an orthogonal quality of 0.05 or lower are corrected.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the solution and cell quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command, and at a specified frequency (of iterations or time steps). This criterion is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Enables/disables the relocation of select cell centroids, to improve the orthogonality metrics and solution stability. It is applied to cells when the criterion value is equal to or less than a threshold value defined as part of the text command. Note that the enhanced metrics are only apparent when reporting the quality in the solution mode of Fluent, and not in the meshing mode.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Prints out a listing of the poor cells for each criterion: default, cell quality, and user-defined, and (if enabled) cell gradient quality and solution and cell quality.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Resets the list of poor cells included by the default, cell quality, user-defined, cell gradient quality, and solution and cell quality criteria.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Specifies overset meshing solver options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Selects the interpolation method for overset interfaces. Note that the least squares method is recommended for sliding mesh cases.
                    """
                    return PyMenu(self.service, "/solve/set/overset/interpolation_method").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enables/disables a numerical treatment that attempts to assign reasonable data values to orphan cells.
                    """
                    return PyMenu(self.service, "/solve/set/overset/orphan_cell_treatment").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    Uses the pressure gradient of the donor cell in the interpolation of pressure for its receptor cell.
                    """
                    return PyMenu(self.service, "/solve/set/overset/high_order_pressure").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)

        class execute_commands(TUIMenu):
            """
            Enters the execute commands menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/delete").execute(*args, **kwargs)
            def add_edit(self, *args, **kwargs):
                """
                Adds or edits execute commands.
                """
                return PyMenu(self.service, "/solve/execute_commands/add_edit").execute(*args, **kwargs)
            def export(self, *args, **kwargs):
                """
                Export execute-commands to a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/export").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/copy").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/disable").execute(*args, **kwargs)
            def import_(self, *args, **kwargs):
                """
                Import execute-commands from a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/import").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/enable").execute(*args, **kwargs)

        class report_files(TUIMenu):
            """
            Enters the report files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a report file object.
                """
                return PyMenu(self.service, "/solve/report_files/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report file.
                """
                return PyMenu(self.service, "/solve/report_files/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report file.
                """
                return PyMenu(self.service, "/solve/report_files/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report files.
                """
                return PyMenu(self.service, "/solve/report_files/list").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report file.
                """
                return PyMenu(self.service, "/solve/report_files/clear_data").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report file objects.
                """
                return PyMenu(self.service, "/solve/report_files/delete_all").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report file.
                """
                return PyMenu(self.service, "/solve/report_files/edit").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enters the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.playback = self.__class__.playback(path + ["playback"], service)
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.define = self.__class__.define(path + ["define"], service)
                self.pulse = self.__class__.pulse(path + ["pulse"], service)
                super().__init__(path, service)

            class playback(TUIMenu):
                """
                Enters the animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def play(self, *args, **kwargs):
                    """
                    Plays the selected animation.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/play").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Reads new animation from file or already defined animations.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/read").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Plays the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/stored_view").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Specify a custom start frame, increment, and end frame for video export.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Writes animation sequence to the file.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/write").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes animation sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/delete").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enters the video menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def name(self, *args, **kwargs):
                        """
                        Sets the name of the saved video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/name").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Controls whether the resolution of the saved video file matches that  of the images used to create it.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/height").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Specifies what format the video file will be written in (MP4 | AVI |  FLV | MOV | MPEG).
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/format").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/quality").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/width").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Expands or collapses the resolution based on this scaling  factor.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/scale").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Sets the target frames per second (FPS) for the saved video  file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/fps").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enters the object manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def copy(self, *args, **kwargs):
                    """
                    Copies solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/copy").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates new solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/create").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/edit").execute(*args, **kwargs)
                def clear_history(self, *args, **kwargs):
                    """
                    Clears solution animation object history.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/clear_history").execute(*args, **kwargs)

            class define(TUIMenu):
                """
                Enters the animation definition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit_monitor(self, *args, **kwargs):
                    """
                    Changes animation monitor attributes.
                    """
                    return PyMenu(self.service, "/solve/animate/define/edit_monitor").execute(*args, **kwargs)
                def define_monitor(self, *args, **kwargs):
                    """
                    Defines new animation.
                    """
                    return PyMenu(self.service, "/solve/animate/define/define_monitor").execute(*args, **kwargs)

            class pulse(TUIMenu):
                """
                Enter the pulse animation menu (only available when one or more particle track or pathline graphics objects are defined).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    self.hardcopy = self.__class__.hardcopy(path + ["hardcopy"], service)
                    super().__init__(path, service)
                def pulse_mode(self, *args, **kwargs):
                    """
                    Set whether the pulse is a single pulse or continuous.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/pulse_mode").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Select a pathline or particle track graphics object, specify whether you want to write a video file or picture files, and enter the destination directory for the files. Continuous pulse animations result in a 5 second video. Single pulse animations run for a full cycle.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/write").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/quality").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/fps").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/width").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/name").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/height").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/use_original_resolution").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/set_standard_resolution").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/scale").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/format").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/compression_method").execute(*args, **kwargs)

                class hardcopy(TUIMenu):
                    """
                    Hardcopy options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.driver = self.__class__.driver(path + ["driver"], service)
                        self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                        super().__init__(path, service)
                    def use_window_resolution(self, *args, **kwargs):
                        """
                        Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/use_window_resolution").execute(*args, **kwargs)
                    def invert_background(self, *args, **kwargs):
                        """
                        Use a white background when the picture is saved.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/invert_background").execute(*args, **kwargs)
                    def jpeg_hardcopy_quality(self, *args, **kwargs):
                        """
                        To set jpeg hardcopy quality.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/jpeg_hardcopy_quality").execute(*args, **kwargs)
                    def landscape(self, *args, **kwargs):
                        """
                        Plot hardcopies in landscape or portrait orientation.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/landscape").execute(*args, **kwargs)
                    def x_resolution(self, *args, **kwargs):
                        """
                        Set the width of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/x_resolution").execute(*args, **kwargs)
                    def dpi(self, *args, **kwargs):
                        """
                        Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/dpi").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/set_standard_resolution").execute(*args, **kwargs)
                    def y_resolution(self, *args, **kwargs):
                        """
                        Set the height of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/y_resolution").execute(*args, **kwargs)
                    def preview(self, *args, **kwargs):
                        """
                        Display a preview image of a hardcopy.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/preview").execute(*args, **kwargs)

                    class driver(TUIMenu):
                        """
                        Enter the set hardcopy driver menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.post_format = self.__class__.post_format(path + ["post_format"], service)
                            super().__init__(path, service)
                        def jpeg(self, *args, **kwargs):
                            """
                            Produce JPEG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/jpeg").execute(*args, **kwargs)
                        def tiff(self, *args, **kwargs):
                            """
                            Use TIFF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/tiff").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Set the hardcopy options. Available options are:
                            "no gamma correction", disables gamma correction of colors,
                            "physical size = (width,height)", where width and height
                            are the actual measurements of the printable area of the page
                            in centimeters.
                            "subscreen = (left,right,bottom,top)", where left,right,
                            bottom, and top are numbers in [-1,1] describing a subwindow on
                            the page in which to place the hardcopy.
                            The options may be combined by separating them with commas.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/options").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List the current hardcopy driver.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/list").execute(*args, **kwargs)
                        def avz(self, *args, **kwargs):
                            """
                            Use AVZ output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/avz").execute(*args, **kwargs)
                        def eps(self, *args, **kwargs):
                            """
                            Produce encapsulated PostScript (EPS) output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/eps").execute(*args, **kwargs)
                        def hsf(self, *args, **kwargs):
                            """
                            Use HSF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/hsf").execute(*args, **kwargs)
                        def glb(self, *args, **kwargs):
                            """
                            Use GLB output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/glb").execute(*args, **kwargs)
                        def vrml(self, *args, **kwargs):
                            """
                            Use VRML output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/vrml").execute(*args, **kwargs)
                        def post_script(self, *args, **kwargs):
                            """
                            Produce PostScript output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_script").execute(*args, **kwargs)
                        def png(self, *args, **kwargs):
                            """
                            Use PNG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/png").execute(*args, **kwargs)
                        def dump_window(self, *args, **kwargs):
                            """
                            Set the command used to dump the graphics window to a file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/dump_window").execute(*args, **kwargs)
                        def ppm(self, *args, **kwargs):
                            """
                            Produce PPM output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/ppm").execute(*args, **kwargs)

                        class post_format(TUIMenu):
                            """
                            Enter the PostScript driver format menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vector(self, *args, **kwargs):
                                """
                                Use vector format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/vector").execute(*args, **kwargs)
                            def raster(self, *args, **kwargs):
                                """
                                Use the original raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/raster").execute(*args, **kwargs)
                            def fast_raster(self, *args, **kwargs):
                                """
                                Use the new raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/fast_raster").execute(*args, **kwargs)
                            def rle_raster(self, *args, **kwargs):
                                """
                                Use the run-length encoded raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/rle_raster").execute(*args, **kwargs)

                    class color_mode(TUIMenu):
                        """
                        Enter the hardcopy color mode menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def color(self, *args, **kwargs):
                            """
                            Plot hardcopies in color.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/color").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Display the current hardcopy color mode.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/list").execute(*args, **kwargs)
                        def gray_scale(self, *args, **kwargs):
                            """
                            Convert color to grayscale for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/gray_scale").execute(*args, **kwargs)
                        def mono_chrome(self, *args, **kwargs):
                            """
                            Convert color to monochrome (black and white) for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/mono_chrome").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Sets solution monitors.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                super().__init__(path, service)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solve/monitors/set_average_over").execute(*args, **kwargs)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solve/monitors/convergence_conditions").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/add").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/plot").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/curves").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/axes").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enters the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Sets relative convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Chooses which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/monitor").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Sets convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Chooses which currently monitored residuals should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/check_convergence").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Re-normalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/re_normalize").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Sets the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_display").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Chooses whether to delete the residual history and reset iteration counter to 1.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/reset").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Chooses whether to scale residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Chooses whether to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalize").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Sets number of residuals to be saved with data. History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_save").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced formulation for the local scaling of the continuity residuals with the pressure-based solver, so that the absolute mass flow rate at each cell is used. This text command is only available when the computing of the local scale is enabled through the solve/monitors/residual/scale-by-coefficient? text command.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Sets convergence criterion type.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/criterion_type").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/print").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Sets normalization factors for currently monitored residuals (if normalize? is set to yes).
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Sets the number of iterations through which normalization factors will be maximized.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/plot").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete_all").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/clear_data").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Enters the cell registers menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/coarsen").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined cell registers.
                """
                return PyMenu(self.service, "/solve/cell_registers/list").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/display").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Applies poor mesh numerics to the mesh of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/refine").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solve/cell_registers/adapt").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solve/cell_registers/edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/cell_registers/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/delete").execute(*args, **kwargs)

    class icing(TUIMenu):
        """
        FENSAP-ICE options.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def flow(self, *args, **kwargs):
            """
            Flow solver menu.
            """
            return PyMenu(self.service, "/icing/flow").execute(*args, **kwargs)
        def settings(self, *args, **kwargs):
            """
            Global settings menu.
            """
            return PyMenu(self.service, "/icing/settings").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            File menu.
            """
            return PyMenu(self.service, "/icing/file").execute(*args, **kwargs)
        def multishot(self, *args, **kwargs):
            """
            Multi-shot accretion menu.
            """
            return PyMenu(self.service, "/icing/multishot").execute(*args, **kwargs)
        def ice(self, *args, **kwargs):
            """
            Ice accretion menu.
            """
            return PyMenu(self.service, "/icing/ice").execute(*args, **kwargs)
        def drop(self, *args, **kwargs):
            """
            Droplet impingement menu.
            """
            return PyMenu(self.service, "/icing/drop").execute(*args, **kwargs)

    class parametric_study(TUIMenu):
        """
        Enter the parametric study menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.study = self.__class__.study(path + ["study"], service)
            self.update = self.__class__.update(path + ["update"], service)
            self.design_points = self.__class__.design_points(path + ["design_points"], service)
            super().__init__(path, service)
        def delete_study(self, *args, **kwargs):
            """
            Delete Study.
            """
            return PyMenu(self.service, "/parametric_study/delete_study").execute(*args, **kwargs)
        def list_studies(self, *args, **kwargs):
            """
            List Studies.
            """
            return PyMenu(self.service, "/parametric_study/list_studies").execute(*args, **kwargs)
        def initialize(self, *args, **kwargs):
            """
            Start Parametric Study.
            """
            return PyMenu(self.service, "/parametric_study/initialize").execute(*args, **kwargs)
        def rename_study(self, *args, **kwargs):
            """
            Rename Study.
            """
            return PyMenu(self.service, "/parametric_study/rename_study").execute(*args, **kwargs)
        def use_base_data(self, *args, **kwargs):
            """
            Use Base Data.
            """
            return PyMenu(self.service, "/parametric_study/use_base_data").execute(*args, **kwargs)
        def case_settings_changed(self, *args, **kwargs):
            """
            Check if case settings are changed.
            """
            return PyMenu(self.service, "/parametric_study/case_settings_changed").execute(*args, **kwargs)
        def import_design_table(self, *args, **kwargs):
            """
            Import Design Point Table.
            """
            return PyMenu(self.service, "/parametric_study/import_design_table").execute(*args, **kwargs)
        def set_as_current_study(self, *args, **kwargs):
            """
            Set As Current Study.
            """
            return PyMenu(self.service, "/parametric_study/set_as_current_study").execute(*args, **kwargs)
        def duplicate_study(self, *args, **kwargs):
            """
            Duplicate Parametric Study.
            """
            return PyMenu(self.service, "/parametric_study/duplicate_study").execute(*args, **kwargs)
        def export_design_table(self, *args, **kwargs):
            """
            Export Design Point Table.
            """
            return PyMenu(self.service, "/parametric_study/export_design_table").execute(*args, **kwargs)

        class study(TUIMenu):
            """
            Enter the study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def use_base_data(self, *args, **kwargs):
                """
                Use Base Data for Current Study.
                """
                return PyMenu(self.service, "/parametric_study/study/use_base_data").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List Studies.
                """
                return PyMenu(self.service, "/parametric_study/study/list").execute(*args, **kwargs)
            def set_as_current(self, *args, **kwargs):
                """
                Set As Current Study.
                """
                return PyMenu(self.service, "/parametric_study/study/set_as_current").execute(*args, **kwargs)
            def duplicate(self, *args, **kwargs):
                """
                Duplicate Parametric Study.
                """
                return PyMenu(self.service, "/parametric_study/study/duplicate").execute(*args, **kwargs)
            def initialize(self, *args, **kwargs):
                """
                Start Parametric Study.
                """
                return PyMenu(self.service, "/parametric_study/study/initialize").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Study.
                """
                return PyMenu(self.service, "/parametric_study/study/delete").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename Study.
                """
                return PyMenu(self.service, "/parametric_study/study/rename").execute(*args, **kwargs)

        class update(TUIMenu):
            """
            Enter the update menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.concurrent = self.__class__.concurrent(path + ["concurrent"], service)
                super().__init__(path, service)
            def update_current(self, *args, **kwargs):
                """
                Update Current Design Point.
                """
                return PyMenu(self.service, "/parametric_study/update/update_current").execute(*args, **kwargs)
            def print_update_method(self, *args, **kwargs):
                """
                Print update method.
                """
                return PyMenu(self.service, "/parametric_study/update/print_update_method").execute(*args, **kwargs)
            def set_update_method(self, *args, **kwargs):
                """
                Set update method.
                """
                return PyMenu(self.service, "/parametric_study/update/set_update_method").execute(*args, **kwargs)
            def update_all(self, *args, **kwargs):
                """
                Update All Design Points.
                """
                return PyMenu(self.service, "/parametric_study/update/update_all").execute(*args, **kwargs)
            def update_selected_design_points(self, *args, **kwargs):
                """
                Update Selected Design Points.
                """
                return PyMenu(self.service, "/parametric_study/update/update_selected_design_points").execute(*args, **kwargs)

            class concurrent(TUIMenu):
                """
                Enter Concurrent Update menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.licensing = self.__class__.licensing(path + ["licensing"], service)
                    self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def register_new_endpoint(self, *args, **kwargs):
                    """
                    Register a new endpoint.
                    """
                    return PyMenu(self.service, "/parametric_study/update/concurrent/register_new_endpoint").execute(*args, **kwargs)
                def delete_endpoint(self, *args, **kwargs):
                    """
                    Delete endpoint.
                    """
                    return PyMenu(self.service, "/parametric_study/update/concurrent/delete_endpoint").execute(*args, **kwargs)

                class licensing(TUIMenu):
                    """
                    Enter Concurrent Licensing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)

                    class print_to_console(TUIMenu):
                        """
                        Print Concurrent Licensing Settings.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def optislang_license_type(self, *args, **kwargs):
                            """
                            OptiSLang License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/optislang_license_type").execute(*args, **kwargs)
                        def license_type(self, *args, **kwargs):
                            """
                            License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/license_type").execute(*args, **kwargs)
                        def optislang_license_count(self, *args, **kwargs):
                            """
                            OptiSLang License Count.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/optislang_license_count").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enter Concurrent Licensing Menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def optislang_license_type(self, *args, **kwargs):
                            """
                            OptiSLang License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/optislang_license_type").execute(*args, **kwargs)
                        def optislang_license_count(self, *args, **kwargs):
                            """
                            OptiSLang License Count.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/optislang_license_count").execute(*args, **kwargs)
                        def license_type(self, *args, **kwargs):
                            """
                            License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/license_type").execute(*args, **kwargs)

                class print_to_console(TUIMenu):
                    """
                    Print to console concurrent options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def number_of_concurrent_dps(self, *args, **kwargs):
                        """
                        Print Number of Concurrent Design Points.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/number_of_concurrent_dps").execute(*args, **kwargs)
                    def number_of_cores_per_dp(self, *args, **kwargs):
                        """
                        Get Number of Cores per Design Point.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/number_of_cores_per_dp").execute(*args, **kwargs)
                    def registered_endpoints(self, *args, **kwargs):
                        """
                        List registered endpoints.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/registered_endpoints").execute(*args, **kwargs)
                    def current_queue(self, *args, **kwargs):
                        """
                        Get the current queue.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/current_queue").execute(*args, **kwargs)
                    def current_endpoint(self, *args, **kwargs):
                        """
                        Get the current endpoint.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/current_endpoint").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Set concurrent update options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def number_of_cores_per_dp(self, *args, **kwargs):
                        """
                        Set Number of Cores per Design Point.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/number_of_cores_per_dp").execute(*args, **kwargs)
                    def current_endpoint(self, *args, **kwargs):
                        """
                        Set the current endpoint.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/current_endpoint").execute(*args, **kwargs)
                    def number_of_concurrent_dps(self, *args, **kwargs):
                        """
                        Set Number of Concurrent Design Points.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/number_of_concurrent_dps").execute(*args, **kwargs)
                    def current_queue(self, *args, **kwargs):
                        """
                        Set the current queue.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/current_queue").execute(*args, **kwargs)

        class design_points(TUIMenu):
            """
            Enter the design points menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                self.concurrent = self.__class__.concurrent(path + ["concurrent"], service)
                self.auto_create = self.__class__.auto_create(path + ["auto_create"], service)
                self.table = self.__class__.table(path + ["table"], service)
                super().__init__(path, service)
            def clear_data_and_edit_values(self, *args, **kwargs):
                """
                Clear Generated Data.
                """
                return PyMenu(self.service, "/parametric_study/design_points/clear_data_and_edit_values").execute(*args, **kwargs)
            def duplicate(self, *args, **kwargs):
                """
                Duplicate Design Point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/duplicate").execute(*args, **kwargs)
            def load_case_data_for_current_dp(self, *args, **kwargs):
                """
                Loads relevant case/data file for current design point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/load_case_data_for_current_dp").execute(*args, **kwargs)
            def save_journals(self, *args, **kwargs):
                """
                Save Journals.
                """
                return PyMenu(self.service, "/parametric_study/design_points/save_journals").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add new design point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Design Point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/delete").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the design points Set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def capture_simulation_report_data(self, *args, **kwargs):
                    """
                    Set Capture Simulation Report Data option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/capture_simulation_report_data").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    Set WriteData option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/write_data").execute(*args, **kwargs)
                def current_dp(self, *args, **kwargs):
                    """
                    Set current design point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/current_dp").execute(*args, **kwargs)
                def input_parameters_of_dp(self, *args, **kwargs):
                    """
                    Set Input Parameter Values of Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/input_parameters_of_dp").execute(*args, **kwargs)

            class print_to_console(TUIMenu):
                """
                Enter the design points print menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def current_dp(self, *args, **kwargs):
                    """
                    Print Name of Current Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/current_dp").execute(*args, **kwargs)
                def status_of_dp(self, *args, **kwargs):
                    """
                    Print Status of given DP.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/status_of_dp").execute(*args, **kwargs)
                def input_parameters_of_dp(self, *args, **kwargs):
                    """
                    Print Input Parameter Values of Current Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/input_parameters_of_dp").execute(*args, **kwargs)
                def status_of_all_dps(self, *args, **kwargs):
                    """
                    Print Statuses of all Design Points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/status_of_all_dps").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    Print WriteData option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/write_data").execute(*args, **kwargs)
                def output_parameters_of_dp(self, *args, **kwargs):
                    """
                    Print Output Parameter Values of Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/output_parameters_of_dp").execute(*args, **kwargs)
                def capture_simulation_report_data(self, *args, **kwargs):
                    """
                    Print Capture Simulation Report Data option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/capture_simulation_report_data").execute(*args, **kwargs)

            class concurrent(TUIMenu):
                """
                Enter the concurrent design points menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def abort_design_point(self, *args, **kwargs):
                    """
                    Interrupt Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/abort_design_point").execute(*args, **kwargs)
                def refresh_status(self, *args, **kwargs):
                    """
                    Refresh Status.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/refresh_status").execute(*args, **kwargs)
                def abort_all_design_points(self, *args, **kwargs):
                    """
                    Interrupt All Design Points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/abort_all_design_points").execute(*args, **kwargs)

            class auto_create(TUIMenu):
                """
                Enter the auto-crate design points menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_design_points(self, *args, **kwargs):
                    """
                    Create design points automatically.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/create_design_points").execute(*args, **kwargs)
                def go_to_optislang(self, *args, **kwargs):
                    """
                    Open the optiSLang project.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/go_to_optislang").execute(*args, **kwargs)
                def export_designs(self, *args, **kwargs):
                    """
                    Export designs by writing a JSON file.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/export_designs").execute(*args, **kwargs)
                def list_current_settings(self, *args, **kwargs):
                    """
                    List current settings for auto-create design points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/list_current_settings").execute(*args, **kwargs)
                def open_designs_in_optislang_postprocessor(self, *args, **kwargs):
                    """
                    Export designs into JSON and open this JSON into optiSLang Postprocessor.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/open_designs_in_optislang_postprocessor").execute(*args, **kwargs)

            class table(TUIMenu):
                """
                Enter the design point table menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_design_table(self, *args, **kwargs):
                    """
                    Export Design Points Table.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/table/export_design_table").execute(*args, **kwargs)
                def import_design_table(self, *args, **kwargs):
                    """
                    Import Design Points Table.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/table/import_design_table").execute(*args, **kwargs)

    class solution(TUIMenu):
        """
        Enter solution menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.run_calculation = self.__class__.run_calculation(path + ["run_calculation"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.calculation_activities = self.__class__.calculation_activities(path + ["calculation_activities"], service)
            self.controls = self.__class__.controls(path + ["controls"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.methods = self.__class__.methods(path + ["methods"], service)
            super().__init__(path, service)

        class initialize(TUIMenu):
            """
            Enter the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                super().__init__(path, service)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initialize statistics.
                """
                return PyMenu(self.service, "/solution/initialize/init_flow_statistics").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Open channel automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enter the settings for hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initialize using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/hyb_initialization").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Correct wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solution/initialize/repair_wall_distance").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Enter the set defaults menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_defaults").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specify number of timesteps for ramping of sources
                and initialize acoustics model variables.
                During ramping the sound sources are multiplied by a factor smoothly growing from 0 to 1.
                """
                return PyMenu(self.service, "/solution/initialize/init_acoustics_options").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/levelset_auto_init").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                List default values.
                """
                return PyMenu(self.service, "/solution/initialize/list_defaults").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enter the set full-multigrid for initialization menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Set reference frame absolute or relative.
                """
                return PyMenu(self.service, "/solution/initialize/reference_frame").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initialize turbulent velocity fluctuations.
                """
                return PyMenu(self.service, "/solution/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initialize using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solution/initialize/fmg_initialization").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initialize the flow field with the current default values.
                """
                return PyMenu(self.service, "/solution/initialize/initialize_flow").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solution/initialize/patch").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Delete wall film particles and initialize wall film variables to zero.
                """
                return PyMenu(self.service, "/solution/initialize/lwf_initialization").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_time_sampled").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Reset discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solution/initialize/dpm_reset").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enter the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)
                def set_options(self, *args, **kwargs):
                    """
                    Patch and smoothing options for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Turbulent flow parameters for localized initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enter the compute defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initialize the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/shadow").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)

        class run_calculation(TUIMenu):
            """
            Enter run calculation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                super().__init__(path, service)
            def solution_steering(self, *args, **kwargs):
                """
                Enable solution steering for density-based solver.
                """
                return PyMenu(self.service, "/solution/run_calculation/solution_steering").execute(*args, **kwargs)
            def iterate(self, *args, **kwargs):
                """
                Perform a specified number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/iterate").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Set number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/number_of_iterations").execute(*args, **kwargs)
            def mesh_motion(self, *args, **kwargs):
                """
                Perform mesh motion.
                """
                return PyMenu(self.service, "/solution/run_calculation/mesh_motion").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/variable_time_stepping").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Set Solution Steering Parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/set_solution_steering").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/solution/run_calculation/summary").execute(*args, **kwargs)
            def dual_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/dual_time_iterate").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/adaptive_time_stepping").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Set iteration options.
                """
                return PyMenu(self.service, "/solution/run_calculation/data_sampling").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enter the residual tolerance menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_tolerance").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Set the residual report verbosity.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_verbosity").execute(*args, **kwargs)
            def multistage_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/multistage_time_iterate").execute(*args, **kwargs)
            def update_physical_time(self, *args, **kwargs):
                """
                Update the solution to the next physical time level.
                """
                return PyMenu(self.service, "/solution/run_calculation/update_physical_time").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Set options for second-order time formulation.
                """
                return PyMenu(self.service, "/solution/run_calculation/second_order_time_options").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enter the max-corrections menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/max_corrections").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Set number of solver iterations before returning to scheme.
                """
                return PyMenu(self.service, "/solution/run_calculation/reporting_interval").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solution/run_calculation/time_step").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enter into the transient controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def solution_status(self, *args, **kwargs):
                    """
                    Activate the simulation status panel.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solution_status").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Set the physical time step size.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Enable user-specified fixed time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Set total number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Set Duration Specification Method: [0] Incremental Time Steps, [1] Total Time Steps, [2] Total Time, [3] Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    Undo the previous time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/undo_timestep").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enter the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Set Max Iterations/Time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Set the time-stepping parameters for user-defined time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Specify a different time step size for solid zones.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Set Multiphase-specific adaptive time stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/predict_next_time").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Set Total Simulation Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_time").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Set Error-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Set Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/incremental_time").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Set period- or frequency-based fixed time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Set number of time step size for acoustic export.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Use specified time step or courant number.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/specified_time_step").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Improve prediction of flow field at time step n+1 for rotating mesh.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Set maximum flow time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_flow_time").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Set inceremtal number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/number_of_time_steps").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Set Multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Include physics driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity to print multiphase specific time scales.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Set physics based time scale options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Include acoustic time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Include gravity based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Include viscous time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Include surface tension based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Data sampling options for statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    List dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_datasets").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Manage report definitions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/list_properties").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/rename").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all report definition objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete_all").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/list").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solution/report_definitions/compute").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Makes a copy of selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/copy").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/report_definitions/add").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Manage Cell Registers.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/cell_registers/add").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/coarsen").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/list_properties").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/adapt").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/refine").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/delete").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Apply poor mesh numerics to cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/display").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert options for solution.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                super().__init__(path, service)
            def explicit_under_relaxation_value(self, *args, **kwargs):
                """
                Explicit under-relaxation value.
                """
                return PyMenu(self.service, "/solution/expert/explicit_under_relaxation_value").execute(*args, **kwargs)
            def energy_numerical_noise_filter(self, *args, **kwargs):
                """
                The energy equation numerical noise filter can be enabled to eliminate non-physical numerical noise in the energy field.
                The numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present.
                Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive.
                """
                return PyMenu(self.service, "/solution/expert/energy_numerical_noise_filter").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Setting pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solution/expert/bc_pressure_extrapolations").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Enable/Disable reconstruction. When disabled, accuracy will be first-order.
                """
                return PyMenu(self.service, "/solution/expert/disable_reconstruction").execute(*args, **kwargs)
            def retain_cell_residuals(self, *args, **kwargs):
                """
                Retain cell residuals for postprocessing?.
                """
                return PyMenu(self.service, "/solution/expert/retain_cell_residuals").execute(*args, **kwargs)
            def retain_temporary_solver_mem(self, *args, **kwargs):
                """
                Retain temporary solver memory?.
                """
                return PyMenu(self.service, "/solution/expert/retain_temporary_solver_mem").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                Set additional open channel controls.
                """
                return PyMenu(self.service, "/solution/expert/open_channel_controls").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Set anisotropic drag parameters for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Set surface-tension calculation options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension").execute(*args, **kwargs)
            def bcd_weights_freeze(self, *args, **kwargs):
                """
                At each timestep, freeze BCD scheme weights after specified iteration
                in order to improve timestep convergence.
                """
                return PyMenu(self.service, "/solution/expert/bcd_weights_freeze").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Set the equation order.
                """
                return PyMenu(self.service, "/solution/expert/equation_ordering").execute(*args, **kwargs)
            def singhal_et_al_cavitation_model(self, *args, **kwargs):
                """
                Use Singhal-et-al cavitation model?.
                """
                return PyMenu(self.service, "/solution/expert/singhal_et_al_cavitation_model").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Set damping function in flow direction.
                """
                return PyMenu(self.service, "/solution/expert/numerical_beach_controls").execute(*args, **kwargs)
            def correction_form(self, *args, **kwargs):
                """
                Discretize momentum equations in correction form for the pressure-based solver.
                """
                return PyMenu(self.service, "/solution/expert/correction_form").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension_expert").execute(*args, **kwargs)
            def show_all_discretization_schemes(self, *args, **kwargs):
                """
                Allow selection of all applicable discretization schemes?.
                """
                return PyMenu(self.service, "/solution/expert/show_all_discretization_schemes").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Set all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solution/expert/set_all_species_together").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Set Explicit VOF controls.
                """
                return PyMenu(self.service, "/solution/expert/vof_explicit_controls").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Set reference density option for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_reference_density").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Lock the temperature for all solid and shell cell zones in the domain.
                """
                return PyMenu(self.service, "/solution/expert/lock_solid_temperature").execute(*args, **kwargs)
            def alternate_wall_temp_formulation(self, *args, **kwargs):
                """
                Alternate formulation for wall temperatures?.
                """
                return PyMenu(self.service, "/solution/expert/alternate_wall_temp_formulation").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Control the display of warning diagnostics for boundaries with reversed flow, etc.
                """
                return PyMenu(self.service, "/solution/expert/flow_warnings").execute(*args, **kwargs)
            def linearized_mass_transfer_udf(self, *args, **kwargs):
                """
                Use linearized mass transfer UDFs?.
                """
                return PyMenu(self.service, "/solution/expert/linearized_mass_transfer_udf").execute(*args, **kwargs)
            def bcd_boundedness(self, *args, **kwargs):
                """
                BCD scheme boundedness strength, constant or expression (0 to 1).
                """
                return PyMenu(self.service, "/solution/expert/bcd_boundedness").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Control the display of limiter warning diagnostics.
                """
                return PyMenu(self.service, "/solution/expert/limiter_warnings").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solution/expert/material_property_warnings").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Enter previous defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R3.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2022R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R2.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/enable").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Expert high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/expert").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Enable/disable pressure-discontinuity-sensor visualization.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Enter the open-channel-wave-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Set stokes wave theory variants.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Set bufer layer height between phases for segregated velocity inputs.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enter the divergence prevention menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable divergence prevention.
                    """
                    return PyMenu(self.service, "/solution/expert/divergence_prevention/enable").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enter Poor Mesh Numerics Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Reset marking of poor cell elements.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on cell gradient quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Print poor cells count.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics on cells with low quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Include cells in register in poor mesh numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Set quality threshold.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Relocate select cell centroids, to improve orthogonality metrics and solution stability.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on solution and cell quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Solution correction on meshes of poor quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enable").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)

            class non_reflecting_boundary_treatment(TUIMenu):
                """
                Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)

            class secondary_gradient_limiting(TUIMenu):
                """
                Enter the Secondary Gradient Limiting Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh_quality_limits(self, *args, **kwargs):
                    """
                    Specify minimum and maximum mesh quality limits.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                def energy(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for energy equation.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                def uds(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for user-defined scalars.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/uds").execute(*args, **kwargs)

        class calculation_activities(TUIMenu):
            """
            Enter calculation activities menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
                self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
                self.animate = self.__class__.animate(path + ["animate"], service)
                self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
                self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
                super().__init__(path, service)

            class execute_commands(TUIMenu):
                """
                Enter the execute-monitor-commands menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/enable").execute(*args, **kwargs)
                def import_(self, *args, **kwargs):
                    """
                    Import execute-commands from a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/import").execute(*args, **kwargs)
                def export(self, *args, **kwargs):
                    """
                    Export execute-commands to a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/export").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/disable").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/delete").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/copy").execute(*args, **kwargs)
                def add_edit(self, *args, **kwargs):
                    """
                    Add or edit execute-commands.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/add_edit").execute(*args, **kwargs)

            class solution_strategy(TUIMenu):
                """
                Enter the automatic initialization and case modification strategy menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                    super().__init__(path, service)
                def import_modifications(self, *args, **kwargs):
                    """
                    Import a list of case modifications from a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/import_modifications").execute(*args, **kwargs)
                def copy_modification(self, *args, **kwargs):
                    """
                    Copy a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/copy_modification").execute(*args, **kwargs)
                def delete_modification(self, *args, **kwargs):
                    """
                    Delete a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/delete_modification").execute(*args, **kwargs)
                def execute_strategy(self, *args, **kwargs):
                    """
                    Execute the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/execute_strategy").execute(*args, **kwargs)
                def automatic_initialization(self, *args, **kwargs):
                    """
                    Define how the case is to be initialized automatically.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_initialization").execute(*args, **kwargs)
                def add_edit_modification(self, *args, **kwargs):
                    """
                    Define a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/add_edit_modification").execute(*args, **kwargs)
                def disable_modification(self, *args, **kwargs):
                    """
                    Disable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/disable_modification").execute(*args, **kwargs)
                def export_modifications(self, *args, **kwargs):
                    """
                    Export all case modifications to a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/export_modifications").execute(*args, **kwargs)
                def enable_modification(self, *args, **kwargs):
                    """
                    Enable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_modification").execute(*args, **kwargs)
                def continue_strategy_execution(self, *args, **kwargs):
                    """
                    Continue execution of the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)
                def enable_strategy(self, *args, **kwargs):
                    """
                    Specify whether automatic initialization and case modification should be enabled.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_strategy").execute(*args, **kwargs)

                class automatic_case_modification(TUIMenu):
                    """
                    Define how the case is to be modified as the solution progresses.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def before_init_modification(self, *args, **kwargs):
                        """
                        Specify modification to be performed before initialization.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)
                    def modifications(self, *args, **kwargs):
                        """
                        Specify modifications to be performed during solution.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)
                    def original_settings(self, *args, **kwargs):
                        """
                        Specify modification to be performed after initialization to restore to original settings.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)

            class animate(TUIMenu):
                """
                Enter the animation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.objects = self.__class__.objects(path + ["objects"], service)
                    self.define = self.__class__.define(path + ["define"], service)
                    super().__init__(path, service)

                class objects(TUIMenu):
                    """
                    Enter to define, edit, delete solution animation objects.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def create(self, *args, **kwargs):
                        """
                        Create new graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/create").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/delete").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        Copy graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/copy").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/edit").execute(*args, **kwargs)
                    def clear_history(self, *args, **kwargs):
                        """
                        Clear object history.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/clear_history").execute(*args, **kwargs)

                class define(TUIMenu):
                    """
                    Enter the animation definition menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def edit_monitor(self, *args, **kwargs):
                        """
                        Change animation monitor attributes.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/edit_monitor").execute(*args, **kwargs)
                    def define_monitor(self, *args, **kwargs):
                        """
                        Define new animation.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/define_monitor").execute(*args, **kwargs)

            class cell_register_operations(TUIMenu):
                """
                Manage Cell Register Operations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/delete").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/edit").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list").execute(*args, **kwargs)

            class auto_save(TUIMenu):
                """
                Enter the auto save menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def root_name(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/root_name").execute(*args, **kwargs)
                def case_frequency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/case_frequency").execute(*args, **kwargs)
                def max_files(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/max_files").execute(*args, **kwargs)
                def save_data_file_every(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/save_data_file_every").execute(*args, **kwargs)
                def data_frequency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/data_frequency").execute(*args, **kwargs)
                def retain_most_recent_files(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/retain_most_recent_files").execute(*args, **kwargs)
                def append_file_name_with(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/append_file_name_with").execute(*args, **kwargs)

        class controls(TUIMenu):
            """
            Enter the controls menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                super().__init__(path, service)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enter the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solution/controls/relaxation_factor").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Set solver limits for the values of various solution variables.
                """
                return PyMenu(self.service, "/solution/controls/limits").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Set P-V-Controls.
                """
                return PyMenu(self.service, "/solution/controls/p_v_controls").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Set the fine mesh Courant number (time step factor).
                """
                return PyMenu(self.service, "/solution/controls/courant_number").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enter the under-relaxation menu.
                """
                return PyMenu(self.service, "/solution/controls/under_relaxation").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Enter the equations menu.
                """
                return PyMenu(self.service, "/solution/controls/equations").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Set controls to default values.
                """
                return PyMenu(self.service, "/solution/controls/set_controls_to_default").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter controls query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                    self.advanced = self.__class__.advanced(path + ["advanced"], service)
                    super().__init__(path, service)
                def p_v_controls(self, *args, **kwargs):
                    """
                    Get P-V-Controls.
                    """
                    return PyMenu(self.service, "/solution/controls/query/p_v_controls").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Enter under relaxation menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/under_relaxation").execute(*args, **kwargs)
                def courant_number(self, *args, **kwargs):
                    """
                    Get the fine mesh Courant number (time step factor).
                    """
                    return PyMenu(self.service, "/solution/controls/query/courant_number").execute(*args, **kwargs)
                def limits(self, *args, **kwargs):
                    """
                    Get solver limits for the values of various solution variables.
                    """
                    return PyMenu(self.service, "/solution/controls/query/limits").execute(*args, **kwargs)
                def relaxation_factor(self, *args, **kwargs):
                    """
                    Enter the relaxation-factor menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/relaxation_factor").execute(*args, **kwargs)
                def equations(self, *args, **kwargs):
                    """
                    Enter the equations menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/equations").execute(*args, **kwargs)

                class acoustics_wave_equation_controls(TUIMenu):
                    """
                    Enter menu for acoustics wave equation solver controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def relative_convergence_criterion(self, *args, **kwargs):
                        """
                        Specify convergence tolerance for the timestep iterations
                        as the target residual reduction factor.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)
                    def max_iterations_per_timestep(self, *args, **kwargs):
                        """
                        Specify maximum number of iterations per timestep.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter menu for expert controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def under_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify under-relaxation factor to be used in
                            the diagonal matrix elements of implicit solver.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                        def explicit_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify explicit relaxation factor to be applied to
                            the solution correction when updating solution in the timestep iterations.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

                class advanced(TUIMenu):
                    """
                    Controls advanced options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                        super().__init__(path, service)
                    def correction_tolerance(self, *args, **kwargs):
                        """
                        Enter the correction tolerance menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/correction_tolerance").execute(*args, **kwargs)
                    def multi_grid_controls(self, *args, **kwargs):
                        """
                        Enter the multi-grid-controls menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_controls").execute(*args, **kwargs)
                    def relaxation_method(self, *args, **kwargs):
                        """
                        Set the solver relaxation method.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/relaxation_method").execute(*args, **kwargs)
                    def multi_grid_fas(self, *args, **kwargs):
                        """
                        Get the coefficients that govern the FAS multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_fas").execute(*args, **kwargs)
                    def multi_grid_amg(self, *args, **kwargs):
                        """
                        Get the parameters that govern the algebraic multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_amg").execute(*args, **kwargs)
                    def multi_stage(self, *args, **kwargs):
                        """
                        Set the multiple-stage time stepping scheme coefficients.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_stage").execute(*args, **kwargs)

                    class amg_options(TUIMenu):
                        """
                        Enter AMG options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def conservative_amg_coarsening(self, *args, **kwargs):
                            """
                            Use conservative AMG coarsening?.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                        def laplace_coarsening(self, *args, **kwargs):
                            """
                            Get AMG laplace coarsening options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                        def amg_gpgpu_options(self, *args, **kwargs):
                            """
                            Amg gpu options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                        def aggressive_amg_coarsening(self, *args, **kwargs):
                            """
                            Use aggressive AMG coarsening.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/verbosity").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enter menu for acoustics wave equation solver controls.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter menu for expert controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify explicit relaxation factor to be applied to
                        the solution correction when updating solution in the timestep iterations.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify under-relaxation factor to be used in
                        the diagonal matrix elements of implicit solver.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Controls advanced options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                    self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                    super().__init__(path, service)
                def slope_limiter_set(self, *args, **kwargs):
                    """
                    Enter the slope limiter set menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/slope_limiter_set").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Set the solver relaxation method.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/relaxation_method").execute(*args, **kwargs)
                def multi_grid_fas(self, *args, **kwargs):
                    """
                    Set the coefficients that govern the FAS multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_fas").execute(*args, **kwargs)
                def multi_grid_amg(self, *args, **kwargs):
                    """
                    Set the parameters that govern the algebraic multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_amg").execute(*args, **kwargs)
                def correction_tolerance(self, *args, **kwargs):
                    """
                    Enter the correction tolerance menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/correction_tolerance").execute(*args, **kwargs)
                def multi_grid_controls(self, *args, **kwargs):
                    """
                    Enter the multi-grid-controls menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_controls").execute(*args, **kwargs)
                def multi_stage(self, *args, **kwargs):
                    """
                    Set the multiple-stage time stepping scheme coefficients.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_stage").execute(*args, **kwargs)

                class fast_transient_settings(TUIMenu):
                    """
                    Enter the fast transient settings menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rk2(self, *args, **kwargs):
                        """
                        Enable the use of a two-stage Runge-Kutta scheme for time integration.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/fast_transient_settings/rk2").execute(*args, **kwargs)

                class amg_options(TUIMenu):
                    """
                    Enter AMG options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def laplace_coarsening(self, *args, **kwargs):
                        """
                        Set AMG laplace coarsening options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                    def aggressive_amg_coarsening(self, *args, **kwargs):
                        """
                        Use aggressive AMG coarsening.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                    def conservative_amg_coarsening(self, *args, **kwargs):
                        """
                        Use conservative AMG coarsening?.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                    def amg_gpgpu_options(self, *args, **kwargs):
                        """
                        Set GPGPU AMG solver options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Enter the monitors menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                super().__init__(path, service)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solution/monitors/convergence_conditions").execute(*args, **kwargs)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solution/monitors/set_average_over").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/edit").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/add").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/curves").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/axes").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/plot").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/clear_data").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/edit").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/add").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list_properties").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete_all").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enter the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Set the number of iterations through which normalization
                    factors will be maximized.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Set relative convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Set number of residuals to be saved with data.
                    History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_save").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Choose which currently-monitored residuals
                    should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/check_convergence").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Set convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/plot").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Renormalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/re_normalize").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/print").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Enable/disable scaling of residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Delete the residual history and reset iteration counter to unity.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/reset").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Set convergence criterion type.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/criterion_type").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Choose which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/monitor").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Set normalization factors for currently-monitored residuals.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Choose whether or not to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalize").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Set the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_display").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Scale the continuity residuals locally based on the enhanced formulation.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)

        class methods(TUIMenu):
            """
            Enter the methods menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                super().__init__(path, service)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Select the pressure velocity coupling scheme.
                """
                return PyMenu(self.service, "/solution/methods/p_v_coupling").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solution/methods/flux_type").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Set gradient options.
                """
                return PyMenu(self.service, "/solution/methods/gradient_scheme").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_1st_order").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_global_time").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enable convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solution/methods/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/solution/methods/noniterative_time_advance").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/solution/methods/frozen_flux").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Set phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solution/methods/phase_based_vof_discretization").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Set VOF numeric options.
                """
                return PyMenu(self.service, "/solution/methods/vof_numerics").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enter the discretization-scheme menu.
                """
                return PyMenu(self.service, "/solution/methods/discretization_scheme").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Set residual smoothing factor and number of iterations.
                """
                return PyMenu(self.service, "/solution/methods/residual_smoothing").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Set solution methods to default values.
                """
                return PyMenu(self.service, "/solution/methods/set_solution_methods_to_default").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enable/disable accelerated non-iterative time marching.
                """
                return PyMenu(self.service, "/solution/methods/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Set ggnb options.
                """
                return PyMenu(self.service, "/solution/methods/nb_gradient_boundary_option").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order_bounded").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter methods query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def p_v_coupling(self, *args, **kwargs):
                    """
                    Get the pressure velocity coupling scheme.
                    """
                    return PyMenu(self.service, "/solution/methods/query/p_v_coupling").execute(*args, **kwargs)
                def discretization_scheme(self, *args, **kwargs):
                    """
                    Enter the discretization-scheme menu.
                    """
                    return PyMenu(self.service, "/solution/methods/query/discretization_scheme").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def numerics(self, *args, **kwargs):
                    """
                    Set numeric options.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/numerics").execute(*args, **kwargs)
                def reactions(self, *args, **kwargs):
                    """
                    Enable/disable the species reaction sources and set relaxation factor.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/reactions").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/Disable High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets relaxation factor.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/expert").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Select Variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enter the pseudo time method menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enter the relaxation factors menu to set the pseudo time explicit relaxation factors for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Select the pseudo time step size formulation for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/formulation").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enter the advanced options menu to define pseudo time settings for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the local time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the global time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Enter overset solver options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    High order pressure extrapolation at overset interface.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/high_order_pressure").execute(*args, **kwargs)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the interpolation method for overset interface(s).
                    """
                    return PyMenu(self.service, "/solution/methods/overset/interpolation_method").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enable solver to run with orphans present.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/orphan_cell_treatment").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Enter the multiphase numerics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    super().__init__(path, service)

                class compressible_flow(TUIMenu):
                    """
                    Multiphase compressible numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Multiphase compressible flow BC alternate method.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Multiphase enhanced compressible flow numerics options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Multiphase miscellaneous porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Multiphase relative permeability fix option.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Multiphase viscous flow numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Multiphase options for viscosity averaging.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    VOF solution stabilization menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        super().__init__(path, service)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        Execute advanced stabilization for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        Execute additional stability controls for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Additional advanced stability controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Blended Compressive discretization scheme for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Velocity limiting related stabiity controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Enter max velocity magnitude.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enable velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enable verbosity to print number of velocity limited cells during iterations.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Multiphase default controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Activate multiphase defaults for loaded case.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Multiphase boiling parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def thin_film(self, *args, **kwargs):
                        """
                        Multiphase boiling thin film effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        Multiphase boiling liquid volume fraction effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Stability controls for multiphase flow.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        super().__init__(path, service)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Anti Diffusion Menu for VOF/Multi-Fluid VOF Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Set cosine exponent in dynamic strength treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Set maximum value of dynamic anti-diffusion strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enable dynamic strength to reduce compression in the tangential direction to the interface.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Pressure velocity coupling controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            super().__init__(path, service)

                        class coupled_vof(TUIMenu):
                            """
                            Set Coupled VOF stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Set buoynacy force linerization options in coupled vof.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Set Rhie-Chow related stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Use low order velocity interpolation in flux calculation.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class skewness_correction(TUIMenu):
                            """
                            Skewness correction related stabiity controls for multiphase flow.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Use limited pressure correction gradient in skewness corrections for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Equation Order Menu for Homogeneous Multiphase Flow Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            Solve flow equation at the end of iteration as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                    class hybrid_nita(TUIMenu):
                        """
                        Hybrid NITA stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Set number of outer iterations in hybrid nita.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Set hybrid nita start-up controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Set Hybrid NITA instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Set Courant Number type for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Set velocity limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Set Courant Number limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Set number of outer iterations for unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enable instability detector for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Multiphase interphase heat and mass transfer numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Alternative treatment of latent heat source due to mass transfer.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Cavitation numerics options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Minimum vapor pressure limit for cavitation model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enable/disable turbulent diffusion treatment between phases participating in cavitation.
                            This treatment is generally recommended for better solution stability.
                            However, in case of numerical difficulties, it can be disabled.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Evaporation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Maximum limit on vapor pressure after turbulence and thermal correction.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Condensation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Boiling advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Allow generalized two-resistance framework for boiling model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes expert options of min/max superheat along with wetting fraction controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Under-relaxation factor for boiling heat flux.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Interfacial area density menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Minimum vof seeding for non-zero area density in heat and mass transfer.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Interfacial area density gradient-symmetric mechanism.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enter warped-face-gradient-correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable Warped-Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/enable").execute(*args, **kwargs)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enter the nita expert controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Select a hybrid NITA settings option for faster performance and better robustness.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Set skewness neighbor coupling for nita.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set nita verbosity option.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/set_verbosity").execute(*args, **kwargs)

    class setup(TUIMenu):
        """
        Enter setup menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            super().__init__(path, service)

        class materials(TUIMenu):
            """
            Enter the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                List the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/setup/materials/list_properties").execute(*args, **kwargs)
            def list_materials(self, *args, **kwargs):
                """
                List all locally-stored materials.
                """
                return PyMenu(self.service, "/setup/materials/list_materials").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a material from local storage.
                """
                return PyMenu(self.service, "/setup/materials/delete").execute(*args, **kwargs)
            def change_create(self, *args, **kwargs):
                """
                Change the properties of a locally-stored material or create a new material.
                """
                return PyMenu(self.service, "/setup/materials/change_create").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy a material from the database.
                """
                return PyMenu(self.service, "/setup/materials/copy").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copy a material from the database by formula.
                """
                return PyMenu(self.service, "/setup/materials/copy_by_formula").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enter the database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_materials(self, *args, **kwargs):
                    """
                    List all materials in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_materials").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit a material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/edit").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Define a new material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/new").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Save user-defined database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/save").execute(*args, **kwargs)
                def database_type(self, *args, **kwargs):
                    """
                    Set the database type.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/database_type").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert setup menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.spectral = self.__class__.spectral(path + ["spectral"], service)
                super().__init__(path, service)
            def enable_mesh_morpher_optimizer(self, *args, **kwargs):
                """
                Enable use of mesh morpher/optimizer.
                """
                return PyMenu(self.service, "/setup/expert/enable_mesh_morpher_optimizer").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Set heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/setup/expert/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def beta_feature_access(self, *args, **kwargs):
                """
                Enable access to beta features in the interface.
                """
                return PyMenu(self.service, "/setup/expert/beta_feature_access").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Set solver options for stiff-chemistry solutions.
                """
                return PyMenu(self.service, "/setup/expert/stiff_chemistry").execute(*args, **kwargs)

            class spectral(TUIMenu):
                """
                Enter the Spectral menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_harmonic_exports(self, *args, **kwargs):
                    """
                    Deletes Harmonic Export data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/delete_harmonic_exports").execute(*args, **kwargs)
                def calculate_fourier_coefficients(self, *args, **kwargs):
                    """
                    Calculates Fourier coefficient data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/calculate_fourier_coefficients").execute(*args, **kwargs)
                def calculate_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates Harmonic Export data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/calculate_harmonic_exports").execute(*args, **kwargs)
                def delete_fourier_coefficients(self, *args, **kwargs):
                    """
                    Deletes Fourier coefficient data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/delete_fourier_coefficients").execute(*args, **kwargs)

        class named_expressions(TUIMenu):
            """
            Manage named expressions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/named_expressions/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/named_expressions/add").execute(*args, **kwargs)
            def export_to_tsv(self, *args, **kwargs):
                """
                Export expressions.
                """
                return PyMenu(self.service, "/setup/named_expressions/export_to_tsv").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/list_properties").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Compute expression.
                """
                return PyMenu(self.service, "/setup/named_expressions/compute").execute(*args, **kwargs)
            def import_from_tsv(self, *args, **kwargs):
                """
                Export expressions.
                """
                return PyMenu(self.service, "/setup/named_expressions/import_from_tsv").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/edit").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy expression.
                """
                return PyMenu(self.service, "/setup/named_expressions/copy").execute(*args, **kwargs)

        class mesh_interfaces(TUIMenu):
            """
            Enter the mesh-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mapped_interface_options = self.__class__.mapped_interface_options(path + ["mapped_interface_options"], service)
                self.non_conformal_interface_numerics = self.__class__.non_conformal_interface_numerics(path + ["non_conformal_interface_numerics"], service)
                self.auto_options = self.__class__.auto_options(path + ["auto_options"], service)
                super().__init__(path, service)
            def verbosity(self, *args, **kwargs):
                """
                Set mesh interface verbosity.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/verbosity").execute(*args, **kwargs)
            def one_to_one_pairing(self, *args, **kwargs):
                """
                Use the default one-to-one interface creation method?.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/one_to_one_pairing").execute(*args, **kwargs)
            def transfer_motion_across_interfaces(self, *args, **kwargs):
                """
                Transfer motion from one side of the interface to the other when only one side undergoes user-defined or system-coupling motion.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/transfer_motion_across_interfaces").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_periodic").execute(*args, **kwargs)
            def enforce_coupled_wall_between_solids(self, *args, **kwargs):
                """
                Create coupled wall interface between solids.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_coupled_wall_between_solids").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display specified mesh interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/display").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Get non-overlapping zone name from the associated interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/non_overlapping_zone_name").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/create").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improve mesh interface quality.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/improve_quality").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/turbo_create").execute(*args, **kwargs)
            def enable_si_with_nodes(self, *args, **kwargs):
                """
                Enable sliding interfaces with nodes.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_si_with_nodes").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete_all").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Make interface zones periodic.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_periodic").execute(*args, **kwargs)
            def remove_left_handed_interface_faces(self, *args, **kwargs):
                """
                Remove left-handed faces during mesh interface creation.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/remove_left_handed_interface_faces").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/edit").execute(*args, **kwargs)
            def enable_visualization_of_interfaces(self, *args, **kwargs):
                """
                Display facets on mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_visualization_of_interfaces").execute(*args, **kwargs)
            def enforce_continuity_after_bc(self, *args, **kwargs):
                """
                Across the interface, enforces continuity over boundary condition.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_continuity_after_bc").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all mesh-interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/list").execute(*args, **kwargs)
            def auto_pairing(self, *args, **kwargs):
                """
                Automatically pair and create mesh interfaces for some or all interface zones.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/auto_pairing").execute(*args, **kwargs)

            class mapped_interface_options(TUIMenu):
                """
                Enter the mapped-interface-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def solution_controls(self, *args, **kwargs):
                    """
                    Specification of mapped frequency and under-relaxation factor for mapped interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/solution_controls").execute(*args, **kwargs)
                def convert_to_mapped_interface(self, *args, **kwargs):
                    """
                    Convert non-conformal mesh interface to mapped mesh interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/convert_to_mapped_interface").execute(*args, **kwargs)
                def tolerance(self, *args, **kwargs):
                    """
                    Specification of mapped interface tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/tolerance").execute(*args, **kwargs)

            class non_conformal_interface_numerics(TUIMenu):
                """
                Setting non-conformal numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_numerics(self, *args, **kwargs):
                    """
                    Enable modified non-conformal interface numerics.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/non_conformal_interface_numerics/change_numerics").execute(*args, **kwargs)

            class auto_options(TUIMenu):
                """
                Enter auto-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_default_name_prefix(self, *args, **kwargs):
                    """
                    Specification of auto pairing default name prefix.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_default_name_prefix").execute(*args, **kwargs)
                def set_one_to_one_pairing_tolerance(self, *args, **kwargs):
                    """
                    Enable/disable one-to-one auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_one_to_one_pairing_tolerance").execute(*args, **kwargs)
                def proximity_tolerance(self, *args, **kwargs):
                    """
                    Specification of auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/proximity_tolerance").execute(*args, **kwargs)
                def keep_empty_interface(self, *args, **kwargs):
                    """
                    Keep empty interfaces during one-to-one mesh interface creation.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/keep_empty_interface").execute(*args, **kwargs)
                def naming_option(self, *args, **kwargs):
                    """
                    Specify whether or not to include an informative suffix to the mesh interface name.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/naming_option").execute(*args, **kwargs)
                def pairing_between_interface_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_interface_zones_only").execute(*args, **kwargs)
                def pairing_between_different_cell_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones from different cell zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_different_cell_zones_only").execute(*args, **kwargs)

        class dynamic_mesh(TUIMenu):
            """
            Enter the dynamic mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.actions = self.__class__.actions(path + ["actions"], service)
                self.zones = self.__class__.zones(path + ["zones"], service)
                self.transient_settings = self.__class__.transient_settings(path + ["transient_settings"], service)
                self.events = self.__class__.events(path + ["events"], service)
                self.controls = self.__class__.controls(path + ["controls"], service)
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Enable/disable the dynamic mesh solver and options.
                """
                return PyMenu(self.service, "/setup/dynamic_mesh/dynamic_mesh").execute(*args, **kwargs)

            class actions(TUIMenu):
                """
                Enter the dynamic mesh actions menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remesh_cell_zone(self, *args, **kwargs):
                    """
                    Manually remesh cell zone with option to remesh adjacent dynamic face zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/actions/remesh_cell_zone").execute(*args, **kwargs)

            class zones(TUIMenu):
                """
                Enter the dynamic mesh zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    List dynamic zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/list").execute(*args, **kwargs)
                def remove_boundary_layer(self, *args, **kwargs):
                    """
                    Remove cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/remove_boundary_layer").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete dynamic zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/delete").execute(*args, **kwargs)
                def insert_interior_layer(self, *args, **kwargs):
                    """
                    Insert new layer cell zone at specified location.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/insert_interior_layer").execute(*args, **kwargs)
                def remove_interior_layer(self, *args, **kwargs):
                    """
                    Remove interior layer cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/remove_interior_layer").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create dynamic zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/create").execute(*args, **kwargs)
                def insert_boundary_layer(self, *args, **kwargs):
                    """
                    Insert new cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/insert_boundary_layer").execute(*args, **kwargs)

            class transient_settings(TUIMenu):
                """
                Enter the dynamic mesh transient settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Enable/disable transient scheme verbosity for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/transient_settings/verbosity").execute(*args, **kwargs)
                def allow_second_order(self, *args, **kwargs):
                    """
                    Enable/disable 2nd order transient scheme for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/transient_settings/allow_second_order").execute(*args, **kwargs)

            class events(TUIMenu):
                """
                Enter the dynamic mesh events menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_event_file(self, *args, **kwargs):
                    """
                    Export dynamic mesh events to file.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/events/export_event_file").execute(*args, **kwargs)
                def import_event_file(self, *args, **kwargs):
                    """
                    Import dynamic mesh event file.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/events/import_event_file").execute(*args, **kwargs)

            class controls(TUIMenu):
                """
                Enter the dynamic mesh control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.periodic_displacement_parameters = self.__class__.periodic_displacement_parameters(path + ["periodic_displacement_parameters"], service)
                    self.layering_parameters = self.__class__.layering_parameters(path + ["layering_parameters"], service)
                    self.six_dof_parameters = self.__class__.six_dof_parameters(path + ["six_dof_parameters"], service)
                    self.smoothing_parameters = self.__class__.smoothing_parameters(path + ["smoothing_parameters"], service)
                    self.contact_parameters = self.__class__.contact_parameters(path + ["contact_parameters"], service)
                    self.in_cylinder_parameters = self.__class__.in_cylinder_parameters(path + ["in_cylinder_parameters"], service)
                    self.implicit_update_parameters = self.__class__.implicit_update_parameters(path + ["implicit_update_parameters"], service)
                    self.remeshing_parameters = self.__class__.remeshing_parameters(path + ["remeshing_parameters"], service)
                    super().__init__(path, service)
                def in_cylinder_output(self, *args, **kwargs):
                    """
                    Enable/disable in-cylinder output.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_output").execute(*args, **kwargs)
                def remeshing(self, *args, **kwargs):
                    """
                    Enable/disable local remeshing in tri/tet and mixed cell zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Enable/disable dynamic-layering in quad/hex cell zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering").execute(*args, **kwargs)
                def smoothing(self, *args, **kwargs):
                    """
                    Enable/disable dynamic mesh smoothing.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing").execute(*args, **kwargs)
                def steady_pseudo_time_control(self, *args, **kwargs):
                    """
                    Enable/disable pseudo time step control in user interface.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/steady_pseudo_time_control").execute(*args, **kwargs)

                class periodic_displacement_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh periodic displacement menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def set_active_displacement(self, *args, **kwargs):
                        """
                        Set Active Periodic Displacement in Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/set_active_displacement").execute(*args, **kwargs)
                    def delete_displacement(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_displacement").execute(*args, **kwargs)
                    def list_displacements(self, *args, **kwargs):
                        """
                        List Periodic Displacements.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/list_displacements").execute(*args, **kwargs)
                    def copy_displacement(self, *args, **kwargs):
                        """
                        Copy Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/copy_displacement").execute(*args, **kwargs)
                    def delete_all_displacements(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacements.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_displacements").execute(*args, **kwargs)
                    def list_groups(self, *args, **kwargs):
                        """
                        List Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/list_groups").execute(*args, **kwargs)
                    def edit_group(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/edit_group").execute(*args, **kwargs)
                    def create_displacement(self, *args, **kwargs):
                        """
                        Create Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/create_displacement").execute(*args, **kwargs)
                    def create_group(self, *args, **kwargs):
                        """
                        Create Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/create_group").execute(*args, **kwargs)
                    def delete_group(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_group").execute(*args, **kwargs)
                    def edit_displacement(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/edit_displacement").execute(*args, **kwargs)
                    def delete_all_groups(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_groups").execute(*args, **kwargs)

                class layering_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh layering menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def constant_height(self, *args, **kwargs):
                        """
                        Enable/disable layering based on constant height, else layering based on constant ratio.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/constant_height").execute(*args, **kwargs)
                    def collapse_factor(self, *args, **kwargs):
                        """
                        Set the factor determining when to collapse dynamic layers.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/collapse_factor").execute(*args, **kwargs)
                    def split_factor(self, *args, **kwargs):
                        """
                        Set the factor determining when to split dynamic layers.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/split_factor").execute(*args, **kwargs)

                class six_dof_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh six-dof menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def z_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify z-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/z_component_of_gravity").execute(*args, **kwargs)
                    def second_order(self, *args, **kwargs):
                        """
                        Enable/disable second order six DOF solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/second_order").execute(*args, **kwargs)
                    def y_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify y-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/y_component_of_gravity").execute(*args, **kwargs)
                    def motion_history_file_name(self, *args, **kwargs):
                        """
                        Location of six DOF motion history file.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/motion_history_file_name").execute(*args, **kwargs)
                    def x_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify x-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/x_component_of_gravity").execute(*args, **kwargs)
                    def create_properties(self, *args, **kwargs):
                        """
                        Create a set of Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/create_properties").execute(*args, **kwargs)
                    def motion_history(self, *args, **kwargs):
                        """
                        Enable/disable writing position/orientation of six DOF zones to file.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/motion_history").execute(*args, **kwargs)
                    def delete_properties(self, *args, **kwargs):
                        """
                        Delete a set of Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/delete_properties").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/list_properties").execute(*args, **kwargs)

                class smoothing_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh smoothing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def smoothing_method(self, *args, **kwargs):
                        """
                        Specify the smoothing method used by the dynamic mesh model.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/smoothing_method").execute(*args, **kwargs)
                    def diffusion_fvm(self, *args, **kwargs):
                        """
                        Set the numerical method used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_fvm").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for spring-based solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/max_iter").execute(*args, **kwargs)
                    def skew_smooth_face_skew_max(self, *args, **kwargs):
                        """
                        Set the face skewness threshold above which deforming boundary faces
                        will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_face_skew_max").execute(*args, **kwargs)
                    def relative_convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the relative residual convergence tolerance for diffusion-based (FVM) smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/relative_convergence_tolerance").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for spring smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/verbosity").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the convergence tolerance for spring-based solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/convergence_tolerance").execute(*args, **kwargs)
                    def skew_smooth_all_deforming_boundaries(self, *args, **kwargs):
                        """
                        Enable/disable skewness smoothing for all deforming
                        dynamic boundary zones. If disabled, only the deforming dynamic boundary zones are
                        smoothed which have smoothing explicitly enabled or use local face remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_all_deforming_boundaries").execute(*args, **kwargs)
                    def bnd_node_relaxation(self, *args, **kwargs):
                        """
                        Set the spring boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/bnd_node_relaxation").execute(*args, **kwargs)
                    def boundary_distance_method(self, *args, **kwargs):
                        """
                        Set the method used to evaluate the boundary distance for the
                        diffusion coefficient calculation.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/boundary_distance_method").execute(*args, **kwargs)
                    def bnd_stiffness_factor(self, *args, **kwargs):
                        """
                        Set the stiffness factor for springs connected to boundary nodes.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/bnd_stiffness_factor").execute(*args, **kwargs)
                    def skew_smooth_niter(self, *args, **kwargs):
                        """
                        Set the number of skewness-based smoothing cycles.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_niter").execute(*args, **kwargs)
                    def constant_factor(self, *args, **kwargs):
                        """
                        Set the spring constant relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/constant_factor").execute(*args, **kwargs)
                    def skew_smooth_cell_skew_max(self, *args, **kwargs):
                        """
                        Set the cell skewness threshold above which cells will be smoothed
                        using the skewness method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_cell_skew_max").execute(*args, **kwargs)
                    def spring_on_all_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for all cell shapes.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/spring_on_all_elements").execute(*args, **kwargs)
                    def laplace_node_relaxation(self, *args, **kwargs):
                        """
                        Set the Laplace boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/laplace_node_relaxation").execute(*args, **kwargs)
                    def poisson_ratio(self, *args, **kwargs):
                        """
                        Set the Poisson's ratio used by the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/poisson_ratio").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for mesh smoothing (FEM).
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/amg_stabilization").execute(*args, **kwargs)
                    def spring_on_simplex_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for tri/tet elements in mixed element zones.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/spring_on_simplex_elements").execute(*args, **kwargs)
                    def diffusion_coeff_parameter(self, *args, **kwargs):
                        """
                        Set the diffusion coefficient parameter used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_parameter").execute(*args, **kwargs)
                    def smooth_from_reference_position(self, *args, **kwargs):
                        """
                        Enable smoothing from reference position.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/smooth_from_reference_position").execute(*args, **kwargs)
                    def diffusion_coeff_function(self, *args, **kwargs):
                        """
                        Specify whether the diffusion coefficient is based on the
                        boundary distance or the cell volume.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_function").execute(*args, **kwargs)

                class contact_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh contact detection menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.flow_control_parameters = self.__class__.flow_control_parameters(path + ["flow_control_parameters"], service)
                        super().__init__(path, service)
                    def contact_threshold(self, *args, **kwargs):
                        """
                        Specify threshold distance for contact detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_threshold").execute(*args, **kwargs)
                    def contact_method(self, *args, **kwargs):
                        """
                        Select the method used for flow control in the contact region.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_method").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for contact-detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/verbosity").execute(*args, **kwargs)
                    def update_contact_marks(self, *args, **kwargs):
                        """
                        Update which cells are marked in order to block flow in the contact region.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/update_contact_marks").execute(*args, **kwargs)
                    def flow_control(self, *args, **kwargs):
                        """
                        Enable/disable flow control.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control").execute(*args, **kwargs)
                    def contact_face_zones(self, *args, **kwargs):
                        """
                        Select face zones involved in contact detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_face_zones").execute(*args, **kwargs)
                    def render_contact_cells(self, *args, **kwargs):
                        """
                        Set the option to include contact-cells in post-processing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/render_contact_cells").execute(*args, **kwargs)
                    def contact_udf(self, *args, **kwargs):
                        """
                        Select UDF to be invoked when contact is detected.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_udf").execute(*args, **kwargs)

                    class flow_control_parameters(TUIMenu):
                        """
                        Enter the flow control menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solution_stabilization(self, *args, **kwargs):
                            """
                            Enable/disable the performance of additional iterations per time step and
                            the application of solution controls to improve the stability of the solver.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/solution_stabilization").execute(*args, **kwargs)
                        def create_flow_control_zone(self, *args, **kwargs):
                            """
                            Create a flow control zone.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/create_flow_control_zone").execute(*args, **kwargs)
                        def delete_flow_control_zone(self, *args, **kwargs):
                            """
                            Delete a flow control zone.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/delete_flow_control_zone").execute(*args, **kwargs)

                class in_cylinder_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh in-cylinder menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def starting_crank_angle(self, *args, **kwargs):
                        """
                        Specify the starting crank angle.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/starting_crank_angle").execute(*args, **kwargs)
                    def position_starting_mesh(self, *args, **kwargs):
                        """
                        Move mesh from top dead center to starting crank angle.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/position_starting_mesh").execute(*args, **kwargs)
                    def modify_lift(self, *args, **kwargs):
                        """
                        Modify the lift curve (shift or scale).
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/modify_lift").execute(*args, **kwargs)
                    def piston_data(self, *args, **kwargs):
                        """
                        Specify the crank radius, connecting rod length, and piston pin offset.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/piston_data").execute(*args, **kwargs)
                    def print_plot_lift(self, *args, **kwargs):
                        """
                        Print or plot valve lift curve.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/print_plot_lift").execute(*args, **kwargs)
                    def crank_angle_step(self, *args, **kwargs):
                        """
                        Specify the crank angle step size.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/crank_angle_step").execute(*args, **kwargs)
                    def crank_period(self, *args, **kwargs):
                        """
                        Specify the crank period.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/crank_period").execute(*args, **kwargs)
                    def minimum_lift(self, *args, **kwargs):
                        """
                        Specify the minimum lift for in-cylinder valves.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/minimum_lift").execute(*args, **kwargs)
                    def piston_stroke_cutoff(self, *args, **kwargs):
                        """
                        Specify the cut off point for in-cylinder piston.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/piston_stroke_cutoff").execute(*args, **kwargs)
                    def max_crank_angle_step(self, *args, **kwargs):
                        """
                        Specify the maximum crank angle step size.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/max_crank_angle_step").execute(*args, **kwargs)

                class implicit_update_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh implicit update menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def motion_relaxation(self, *args, **kwargs):
                        """
                        Specify motion relaxation of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/motion_relaxation").execute(*args, **kwargs)
                    def residual_criteria(self, *args, **kwargs):
                        """
                        Specify residual criteria of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/residual_criteria").execute(*args, **kwargs)
                    def update_interval(self, *args, **kwargs):
                        """
                        Specify update interval of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/update_interval").execute(*args, **kwargs)

                class remeshing_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh remeshing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.prism_layer_parameters = self.__class__.prism_layer_parameters(path + ["prism_layer_parameters"], service)
                        self.prism_controls = self.__class__.prism_controls(path + ["prism_controls"], service)
                        self.sizing_controls = self.__class__.sizing_controls(path + ["sizing_controls"], service)
                        super().__init__(path, service)
                    def unified_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable unified remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/unified_remeshing").execute(*args, **kwargs)
                    def zone_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable cell zone remeshing method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/zone_remeshing").execute(*args, **kwargs)
                    def sizing_funct_variation(self, *args, **kwargs):
                        """
                        Set the maximum sizing function increase/decrease in the interior.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_variation").execute(*args, **kwargs)
                    def size_remesh_interval(self, *args, **kwargs):
                        """
                        Set the interval (in time steps) when remeshing based on size is done.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/size_remesh_interval").execute(*args, **kwargs)
                    def retain_size_distribution(self, *args, **kwargs):
                        """
                        Enable/disable retaining of size distribution.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/retain_size_distribution").execute(*args, **kwargs)
                    def sizing_funct_defaults(self, *args, **kwargs):
                        """
                        Set sizing function defaults.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_defaults").execute(*args, **kwargs)
                    def cell_skew_max(self, *args, **kwargs):
                        """
                        Set the cell skewness threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/cell_skew_max").execute(*args, **kwargs)
                    def remeshing_methods(self, *args, **kwargs):
                        """
                        Enable/disable remeshing methods.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/remeshing_methods").execute(*args, **kwargs)
                    def sizing_funct_resolution(self, *args, **kwargs):
                        """
                        Set the sizing function resolution with respect to shortest boundary.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_resolution").execute(*args, **kwargs)
                    def poly_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable poly remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/poly_remeshing").execute(*args, **kwargs)
                    def sizing_funct_rate(self, *args, **kwargs):
                        """
                        Determine how far from the boundary the increase/decrease happens.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_rate").execute(*args, **kwargs)
                    def sizing_function(self, *args, **kwargs):
                        """
                        Enable/disable sizing function to control size based remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_function").execute(*args, **kwargs)
                    def length_max(self, *args, **kwargs):
                        """
                        Set the length threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/length_max").execute(*args, **kwargs)
                    def remeshing_after_moving(self, *args, **kwargs):
                        """
                        Enable/disable optional remeshing after mesh motion to meet skewness threshold.
                        Steady state dynamic mesh only.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/remeshing_after_moving").execute(*args, **kwargs)
                    def parallel_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable parallel remeshing for zone remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/parallel_remeshing").execute(*args, **kwargs)
                    def length_min(self, *args, **kwargs):
                        """
                        Set the length threshold below which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/length_min").execute(*args, **kwargs)
                    def face_skew_max(self, *args, **kwargs):
                        """
                        Set the face skewness threshold above which faces will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/face_skew_max").execute(*args, **kwargs)

                    class prism_layer_parameters(TUIMenu):
                        """
                        Enter the dynamic mesh prism remeshing menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def first_height(self, *args, **kwargs):
                            """
                            Set first cell height in the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/first_height").execute(*args, **kwargs)
                        def growth_rate(self, *args, **kwargs):
                            """
                            Set the geometric growth rate of the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/growth_rate").execute(*args, **kwargs)
                        def number_of_layers(self, *args, **kwargs):
                            """
                            Set the number of elements in the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/number_of_layers").execute(*args, **kwargs)

                    class prism_controls(TUIMenu):
                        """
                        Specify optional prism controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def edit(self, *args, **kwargs):
                            """
                            Edit an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/edit").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List objects.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/list").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/delete").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            List properties of an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/list_properties").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Add a new object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/add").execute(*args, **kwargs)

                    class sizing_controls(TUIMenu):
                        """
                        Specify optional sizing controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            List objects.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/delete").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Add a new object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/add").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edit an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/edit").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            List properties of an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list_properties").execute(*args, **kwargs)

        class operating_conditions(TUIMenu):
            """
            Enter the define operating conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def operating_density(self, *args, **kwargs):
                """
                Multiphase flow Operating Density menu.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_density").execute(*args, **kwargs)
            def gravity(self, *args, **kwargs):
                """
                Set gravitational acceleration.
                """
                return PyMenu(self.service, "/setup/operating_conditions/gravity").execute(*args, **kwargs)
            def reference_pressure_method(self, *args, **kwargs):
                """
                Choosing reference pressure type.
                """
                return PyMenu(self.service, "/setup/operating_conditions/reference_pressure_method").execute(*args, **kwargs)
            def operating_pressure(self, *args, **kwargs):
                """
                Set the operating pressure.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_pressure").execute(*args, **kwargs)
            def gravity_mrf_behavior(self, *args, **kwargs):
                """
                Enable/disable the fix of gravity vector in a stationary reference frame.
                """
                return PyMenu(self.service, "/setup/operating_conditions/gravity_mrf_behavior").execute(*args, **kwargs)
            def used_ref_pressure_location(self, *args, **kwargs):
                """
                See the actual coordinates of reference pressure used.
                """
                return PyMenu(self.service, "/setup/operating_conditions/used_ref_pressure_location").execute(*args, **kwargs)
            def reference_pressure_location(self, *args, **kwargs):
                """
                Set coordinates of reference pressure.
                """
                return PyMenu(self.service, "/setup/operating_conditions/reference_pressure_location").execute(*args, **kwargs)
            def use_inlet_temperature_for_operating_density(self, *args, **kwargs):
                """
                Use Inlet Temperature to calculate Opearating Density.
                """
                return PyMenu(self.service, "/setup/operating_conditions/use_inlet_temperature_for_operating_density").execute(*args, **kwargs)
            def set_state(self, *args, **kwargs):
                """
                Select state for real gas EOS subcritical condition.
                """
                return PyMenu(self.service, "/setup/operating_conditions/set_state").execute(*args, **kwargs)
            def operating_temperature(self, *args, **kwargs):
                """
                Set the operating temperature for Boussinesq.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_temperature").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Manage reference frames.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/edit").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/display").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/reference_frames/add").execute(*args, **kwargs)
            def hide(self, *args, **kwargs):
                """
                Hide Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/hide").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/list_properties").execute(*args, **kwargs)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/setup/reference_frames/display_edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/reference_frames/list").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enter the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                super().__init__(path, service)
            def addon_module(self, *args, **kwargs):
                """
                Load addon module.
                """
                return PyMenu(self.service, "/setup/models/addon_module").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_1st_order").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/setup/models/virtual_blade_model").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/setup/models/noniterative_time_advance").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enable/disable the steady solution model.
                """
                return PyMenu(self.service, "/setup/models/steady").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enable/disable the NOx model.
                """
                return PyMenu(self.service, "/setup/models/nox").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Enable/disable Backward Euler unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_euler").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Enable/disable the axisymmetric model.
                """
                return PyMenu(self.service, "/setup/models/axisymmetric").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enter battery model menu.
                """
                return PyMenu(self.service, "/setup/models/battery_model").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/setup/models/frozen_flux").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/setup/models/vbm").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enable/disable the solidification and melting model.
                """
                return PyMenu(self.service, "/setup/models/solidification_melting").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_global_time").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enable/disable ablation model.
                """
                return PyMenu(self.service, "/setup/models/ablation").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enable/disable the electric-potential model.
                """
                return PyMenu(self.service, "/setup/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enable/disable the crevice model.
                """
                return PyMenu(self.service, "/setup/models/crevice_model").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enter the crevice model controls menu.
                """
                return PyMenu(self.service, "/setup/models/crevice_model_controls").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enable/disable axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/setup/models/swirl").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/setup/models/energy").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Enable/disable Newmark unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enable/disable the soot model.
                """
                return PyMenu(self.service, "/setup/models/soot").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enter the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/setup/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enable/disable the coupled-implicit solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/density_based_implicit").execute(*args, **kwargs)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enable/disable the segregated solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/pressure_based").execute(*args, **kwargs)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enable/disable the coupled-explicit solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/density_based_explicit").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Define two-temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def weak_ionization(self, *args, **kwargs):
                    """
                    Apply weak ionization in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/weak_ionization").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set two-temperature model verbosity option.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/set_verbosity").execute(*args, **kwargs)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/enable").execute(*args, **kwargs)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Apply robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enter the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    super().__init__(path, service)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model solution options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enable Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initialize Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activate Eulerian wall film equations.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Set film material and properties.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enter Eulerian wall film coupled solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film curvature smoothing.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film coupled solution.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enter the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    super().__init__(path, service)
                def user_defined(self, *args, **kwargs):
                    """
                    Set DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/user_defined").execute(*args, **kwargs)
                def spray_model(self, *args, **kwargs):
                    """
                    Enter the spray model menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/spray_model").execute(*args, **kwargs)
                def injections(self, *args, **kwargs):
                    """
                    Enter the injections menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/injections").execute(*args, **kwargs)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Remove/keep all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enable/disable unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/unsteady_tracking").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enter the options menu to set optional DPM models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Spatially stagger non-atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Provide a stagger radius for non atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Dump multicomponent particle mass if the saturation temperature cannot be determined.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enable/disable correction for Vaporization heat transfer.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enable/disable erosion/accretion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Set ensemble average cloud properties.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/ensemble_average").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enable/disable pressure gradient force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Stagger transient parcels for their first time step?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enable/disable calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enable/disable Saffman lift force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        Write the current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enable/disable particle radiation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/particle_radiation").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Set Vaporization options.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Options to activate and configure the SCR urea deposition risk analysis.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Set significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Maximum number of species that can interact with particles in the DPM UDFs.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Remove the wall film temperature limiter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enable contour and vector plots of particle data.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Skip the pressure dependent boiling point calculation to allow supercritical pressure conditions for vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enable/disable tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enable/disable virtual mass force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Enable/disable using Absolute Pressure for Vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Spatially stagger atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Set the thermolysis limit.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        Set the staggering factor between 0 and 1 to control the amount of staggering.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        A uniform mass distribution will be enabled for all solid cone and atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enable/disable Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enable/disable thermophoretic force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initialize erosion/accretion rates with Zero.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enter the erosion-dynamic mesh interactions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        super().__init__(path, service)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enable mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Perform coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh setup menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Perform dynamic mesh related setup.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specify all participating walls.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Set erosion modelling specific settings.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh run menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Set total time of erosion.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Set number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Set the iteration increment to save data files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Set the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Set the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Enter the interaction menu to set parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        Recalculate the mixture fraction source terms as function of the primary mixture fraction?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enable/disable the linear growth of DPM source terms every DPM iteration.
                        .
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Set the number of continuous phase iterations per DPM iteration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Set the under-relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of all DPM source terms to increase numerical robustness.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enable/disable the update of DPM source terms every flow iteration.
                        (if not, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Enable/disable coupling of continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enable/disable flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of mixture fraction source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enter the splash options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Select splash pdf limiting method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Select splash fraction method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enter the stripping options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping mass coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping diameter coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enter the parallel menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to hybrid.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to message passing.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to shared memory.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Print particle workpile statistics.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/report").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Set the number of processors to use for DPM.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Use DPM domain to simulate particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Enable/disable the particle workpile algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the menu to set expert DPM parallel options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Set DPM Domain partition method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enter the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Set the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enable/disable the DEM collision model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supply settings for collisions to a pair of collision partners.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manage collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)
                        def copy(self, *args, **kwargs):
                            """
                            Copy a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Rename a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)
                        def create(self, *args, **kwargs):
                            """
                            Create a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enter the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def granular_stress_tensor(self, *args, **kwargs):
                        """
                        Enable granular stress tensor to be considered with solid pressure gradient as collision force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/granular_stress_tensor").execute(*args, **kwargs)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Set Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        Evaporate droplet completely when the remaining mass is below this fraction of initial mass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Set parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Average DDPM specific variables like volume fractions and velocities on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enable/disable coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Set a factor for the gaussian kernel for node-based averaging.~%Large values give small size, small values give large size of kernel.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Do the averaging after each integration step for higher accuracy at a higher cost.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def predictor_corrector(self, *args, **kwargs):
                        """
                        Enable predictor/corrector approach to track particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/predictor_corrector").execute(*args, **kwargs)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enable/disable the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Average DPM source terms on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Set the adapt integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Control the format of the one-line tracking statistics printed after every DPM tracking pass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Define underrelaxation factor for film height.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Set the drag law.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specify a tracking scheme.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specify a kernel for the averaging.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def dynamic_interaction(self, *args, **kwargs):
                        """
                        Enable/disable dynamic interaction range.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/dynamic_interaction").execute(*args, **kwargs)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enable node based averaging of DPM variables.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enter the high resolution tracking menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            super().__init__(path, service)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets if the case contains periodic boundaries.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Use adaptive time stepping based upon the particle velocity.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Project existing particles to film to track using high resolution tracking?.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Use the particle timestep for the axisymmetric subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            Use barycentric coordinates when sampling at planes.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enable high resolution tracking.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enable automatic scaling of subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Set the tolerance for subtet intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Move the particle a fraction of the distance to the subtet center when crossing a sliding interface.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Use barycentric coordinates for intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            Test for inverted subtets due to warped cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Adjust the particle timestep to account for high aspect ratio cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enable interpolation of flow viscosity to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                Enable interpolation of flow solution gradients.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                Precompute cell values of PDF species mass fractions prior to particle tracking.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enable interpolation of flow density to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enable interpolation of temperature to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                Set the nodal velocity on all walls to zero.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                Enable interpolation of wallfilm properties to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enable interpolation of flow specific heat to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enter the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set NOx-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Select NOx chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Select additional nox equations.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_expert").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enter the acoustics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    super().__init__(path, service)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enable/disable the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Read acoustic source data files and compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Set acoustic receivers.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/receivers").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enable/disable convective effects option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/convective_effects").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Set acoustic sources.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/sources").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enable/disable the wave equation model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/wave_equation").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Export acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/modal_analysis").execute(*args, **kwargs)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enable/disable the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enable/disable moving receiver option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable the acoustics model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/off").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def compute_write(self, *args, **kwargs):
                    """
                    Compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/compute_write").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Write on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enable/disable the export data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Write centroid info.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enable/disable auto prune of the receiver signal(s) during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/auto_prune").execute(*args, **kwargs)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enable/disable the broadband noise model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enable export acoustic source data in ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zones.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_active(self, *args, **kwargs):
                        """
                        List the names of the active sponge layer definitions.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list_active").execute(*args, **kwargs)
                    def activate(self, *args, **kwargs):
                        """
                        Activate a sponge object.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/activate").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/edit").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the names of the sponge layer definitions.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/delete").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list_properties").execute(*args, **kwargs)
                    def deactivate(self, *args, **kwargs):
                        """
                        Deactivate a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/deactivate").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a new sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/add").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enter the acoustic sources FFT menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        Clean up storage area.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Compute FFT fields.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Read ASD files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Write CGNS files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enter the FFT surface variables menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Create octave bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Create third bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Remove variables.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Create constant-width bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Create set of modes.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enter the far field parameters menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specify far field speed of sound.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specify far field density.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)

                class wave_equation_options(TUIMenu):
                    """
                    Enter the options menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.basic_shapes = self.__class__.basic_shapes(path + ["basic_shapes"], service)
                        self.remote_receivers_options = self.__class__.remote_receivers_options(path + ["remote_receivers_options"], service)
                        super().__init__(path, service)
                    def sponge_layer_factor(self, *args, **kwargs):
                        """
                        Specify artificial viscosity factor for sponge layer.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_factor").execute(*args, **kwargs)
                    def sponge_layer_base_level(self, *args, **kwargs):
                        """
                        Specify artificial viscosity base level applied everywhere.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_base_level").execute(*args, **kwargs)
                    def remote_receivers(self, *args, **kwargs):
                        """
                        Activate the Kirchhoff's integral method for remote receivers.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers").execute(*args, **kwargs)
                    def sponge_layer_udf(self, *args, **kwargs):
                        """
                        Select user-defined function for sponge layer.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_udf").execute(*args, **kwargs)
                    def time_filter_source(self, *args, **kwargs):
                        """
                        Activate time-filtering of sound sources.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/time_filter_source").execute(*args, **kwargs)
                    def source_mask_udf(self, *args, **kwargs):
                        """
                        Select user-defined function for sound source masking.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/source_mask_udf").execute(*args, **kwargs)

                    class basic_shapes(TUIMenu):
                        """
                        Enter the basic shapes menu to build source mask and sponge layer
                        geometry shapes using cell registers.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def add_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Add a region register for the sponge layer.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/add_sponge_layer_shape").execute(*args, **kwargs)
                        def remove_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Remove a region register from the sponge layer.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/remove_sponge_layer_shape").execute(*args, **kwargs)
                        def remove_source_mask_shape(self, *args, **kwargs):
                            """
                            Remove a region register from the source mask.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/remove_source_mask_shape").execute(*args, **kwargs)
                        def list_region_registers(self, *args, **kwargs):
                            """
                            List all available region registers (hex/cylinder/sphere).
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_region_registers").execute(*args, **kwargs)
                        def list_sponge_layer_shapes(self, *args, **kwargs):
                            """
                            List all active sponge layer registers.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_sponge_layer_shapes").execute(*args, **kwargs)
                        def add_source_mask_shape(self, *args, **kwargs):
                            """
                            Add a region register for the source mask.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/add_source_mask_shape").execute(*args, **kwargs)
                        def list_source_mask_shapes(self, *args, **kwargs):
                            """
                            List all active source mask registers.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_source_mask_shapes").execute(*args, **kwargs)

                    class remote_receivers_options(TUIMenu):
                        """
                        Enter the menu to set up the Kirchhoff's integral method and output its results.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def write_signals(self, *args, **kwargs):
                            """
                            Write signals calculated at receiver locations.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers_options/write_signals").execute(*args, **kwargs)
                        def integration_surface(self, *args, **kwargs):
                            """
                            Select Kirchhoff's integration surface.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers_options/integration_surface").execute(*args, **kwargs)

            class viscous(TUIMenu):
                """
                Enter the viscous model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_turbulence = self.__class__.multiphase_turbulence(path + ["multiphase_turbulence"], service)
                    self.near_wall_treatment = self.__class__.near_wall_treatment(path + ["near_wall_treatment"], service)
                    self.turbulence_expert = self.__class__.turbulence_expert(path + ["turbulence_expert"], service)
                    self.transition_model_options = self.__class__.transition_model_options(path + ["transition_model_options"], service)
                    self.geko_options = self.__class__.geko_options(path + ["geko_options"], service)
                    super().__init__(path, service)
                def mixing_length(self, *args, **kwargs):
                    """
                    Enable/disable the mixing-length (algebraic) turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/mixing_length").execute(*args, **kwargs)
                def sa_alternate_prod(self, *args, **kwargs):
                    """
                    Enable/disable strain/vorticity production in Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_alternate_prod").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Select user-defined functions to define the turbulent viscosity and the turbulent Prandtl and Schmidt numbers.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined").execute(*args, **kwargs)
                def sa_enhanced_wall_treatment(self, *args, **kwargs):
                    """
                    Enable/disable the enhanced wall treatment for the Spalart-Allmaras model.
                    If disabled, no smooth blending between the viscous sublayer and the
                    log-law formulation is employed, as was done in versions previous to Fluent14.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_enhanced_wall_treatment").execute(*args, **kwargs)
                def detached_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable detached eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/detached_eddy_simulation").execute(*args, **kwargs)
                def rsm_ssg_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the quadratic pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_ssg_pressure_strain").execute(*args, **kwargs)
                def sa_damping(self, *args, **kwargs):
                    """
                    Enable/disable the full low-Reynolds number form of Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_damping").execute(*args, **kwargs)
                def v2f(self, *args, **kwargs):
                    """
                    Enable/disable the V2F turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/v2f").execute(*args, **kwargs)
                def les_subgrid_wale(self, *args, **kwargs):
                    """
                    Enable/disable the WALE subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wale").execute(*args, **kwargs)
                def rsm_or_earsm_geko_option(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO option for RSM or EARSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_or_earsm_geko_option").execute(*args, **kwargs)
                def spalart_allmaras(self, *args, **kwargs):
                    """
                    Enable/disable the Spalart-Allmaras turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/spalart_allmaras").execute(*args, **kwargs)
                def ke_realizable(self, *args, **kwargs):
                    """
                    Enable/disable the realizable k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_realizable").execute(*args, **kwargs)
                def kw_sst(self, *args, **kwargs):
                    """
                    Enable/disable the SST k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_sst").execute(*args, **kwargs)
                def sas(self, *args, **kwargs):
                    """
                    Enable/disable the SAS turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sas").execute(*args, **kwargs)
                def turb_compressibility(self, *args, **kwargs):
                    """
                    Enable/disable the compressibility correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_compressibility").execute(*args, **kwargs)
                def turb_buoyancy_effects(self, *args, **kwargs):
                    """
                    Select buoyancy effects on turbulence.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_buoyancy_effects").execute(*args, **kwargs)
                def k_kl_w(self, *args, **kwargs):
                    """
                    Enable/disable the k-kl-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/k_kl_w").execute(*args, **kwargs)
                def zero_equation_hvac(self, *args, **kwargs):
                    """
                    Enable/disable the zero-equation HVAC turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/zero_equation_hvac").execute(*args, **kwargs)
                def kw_geko(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_geko").execute(*args, **kwargs)
                def ke_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_easm").execute(*args, **kwargs)
                def kw_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_easm").execute(*args, **kwargs)
                def low_pressure_boundary_slip(self, *args, **kwargs):
                    """
                    Enable/disable the slip boundary formulation for low-pressure gas systems.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/low_pressure_boundary_slip").execute(*args, **kwargs)
                def transition_sst(self, *args, **kwargs):
                    """
                    Enable/disable the transition SST turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/transition_sst").execute(*args, **kwargs)
                def curvature_correction(self, *args, **kwargs):
                    """
                    Enable/disable the curvature correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction").execute(*args, **kwargs)
                def rsm_bsl_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-BSL model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_bsl_based").execute(*args, **kwargs)
                def laminar(self, *args, **kwargs):
                    """
                    Enable/disable the laminar flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/laminar").execute(*args, **kwargs)
                def corner_flow_correction_ccorner(self, *args, **kwargs):
                    """
                    Set the corner flow correction coefficient CCORNER.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction_ccorner").execute(*args, **kwargs)
                def corner_flow_correction(self, *args, **kwargs):
                    """
                    Enable/disable the corner flow correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction").execute(*args, **kwargs)
                def kw_shear_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega shear-flow correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_shear_correction").execute(*args, **kwargs)
                def kw_bsl(self, *args, **kwargs):
                    """
                    Enable/disable the BSL k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_bsl").execute(*args, **kwargs)
                def les_dynamic_energy_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Prandtl Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_energy_flux").execute(*args, **kwargs)
                def rsm_omega_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-omega model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_omega_based").execute(*args, **kwargs)
                def inviscid(self, *args, **kwargs):
                    """
                    Enable/disable the inviscid flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/inviscid").execute(*args, **kwargs)
                def ke_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_rng").execute(*args, **kwargs)
                def add_transition_model(self, *args, **kwargs):
                    """
                    Enable/disable a transition model to account for transitional effects.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/add_transition_model").execute(*args, **kwargs)
                def rng_swirl_model(self, *args, **kwargs):
                    """
                    Enable/disable swirl corrections for rng-model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_swirl_model").execute(*args, **kwargs)
                def large_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable large eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/large_eddy_simulation").execute(*args, **kwargs)
                def rsm_solve_tke(self, *args, **kwargs):
                    """
                    Enable/disable the solution of T.K.E. in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_solve_tke").execute(*args, **kwargs)
                def kw_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_standard").execute(*args, **kwargs)
                def rng_differential_visc(self, *args, **kwargs):
                    """
                    Enable/disable the differential-viscosity model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_differential_visc").execute(*args, **kwargs)
                def les_subgrid_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_rng").execute(*args, **kwargs)
                def trans_sst_roughness_correlation(self, *args, **kwargs):
                    """
                    Enable/disable the Transition-SST roughness correlation option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/trans_sst_roughness_correlation").execute(*args, **kwargs)
                def les_subgrid_dynamic_fvar(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                def ke1e(self, *args, **kwargs):
                    """
                    Enable/disable the KE1E turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke1e").execute(*args, **kwargs)
                def les_subgrid_tke(self, *args, **kwargs):
                    """
                    Enable/disable the kinetic energy transport subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_tke").execute(*args, **kwargs)
                def reynolds_stress_model(self, *args, **kwargs):
                    """
                    Enable/disable the RSM turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/reynolds_stress_model").execute(*args, **kwargs)
                def ke_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_standard").execute(*args, **kwargs)
                def les_subgrid_wmles(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles").execute(*args, **kwargs)
                def rsm_linear_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the linear pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_linear_pressure_strain").execute(*args, **kwargs)
                def rsm_wall_echo(self, *args, **kwargs):
                    """
                    Enable/disable wall-echo effects in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_wall_echo").execute(*args, **kwargs)
                def kw_wj_bsl_earsm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_wj_bsl_earsm").execute(*args, **kwargs)
                def curvature_correction_ccurv(self, *args, **kwargs):
                    """
                    Set the curvature correction coefficient CCURV.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction_ccurv").execute(*args, **kwargs)
                def les_subgrid_smagorinsky(self, *args, **kwargs):
                    """
                    Enable/disable the Smagorinsky-Lilly subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_smagorinsky").execute(*args, **kwargs)
                def kw_low_re_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega low Re option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_low_re_correction").execute(*args, **kwargs)
                def les_dynamic_scalar_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Schmidt Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_scalar_flux").execute(*args, **kwargs)
                def user_defined_transition(self, *args, **kwargs):
                    """
                    Set user-defined transition correlations.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined_transition").execute(*args, **kwargs)
                def des_limiter_option(self, *args, **kwargs):
                    """
                    Select DES limiter option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/des_limiter_option").execute(*args, **kwargs)
                def les_subgrid_wmles_s_minus_omega(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES S-Omega subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles_s_minus_omega").execute(*args, **kwargs)

                class multiphase_turbulence(TUIMenu):
                    """
                    Enter the multiphase turbulence menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_multiphase_models(self, *args, **kwargs):
                        """
                        Select the k-epsilon multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/turbulence_multiphase_models").execute(*args, **kwargs)
                    def subgrid_turbulence_contribution_aiad(self, *args, **kwargs):
                        """
                        Enable/disable the Subgrid Turbulence Contribution for the AIAD model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/subgrid_turbulence_contribution_aiad").execute(*args, **kwargs)
                    def rsm_multiphase_models(self, *args, **kwargs):
                        """
                        Enable/disable the Reynolds Stress multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/rsm_multiphase_models").execute(*args, **kwargs)
                    def multiphase_options(self, *args, **kwargs):
                        """
                        Enable/disable multiphase options.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/multiphase_options").execute(*args, **kwargs)

                class near_wall_treatment(TUIMenu):
                    """
                    Enter the near wall treatment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_wall_treatment(self, *args, **kwargs):
                        """
                        Enable/disable enhanced wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/enhanced_wall_treatment").execute(*args, **kwargs)
                    def non_equilibrium_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable non-equilibrium wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/non_equilibrium_wall_fn").execute(*args, **kwargs)
                    def werner_wengle_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable Werner-Wengle wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/werner_wengle_wall_fn").execute(*args, **kwargs)
                    def wall_omega_treatment(self, *args, **kwargs):
                        """
                        Set wall omega treatment.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wall_omega_treatment").execute(*args, **kwargs)
                    def wf_thermal_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function thermal effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_thermal_effects").execute(*args, **kwargs)
                    def scalable_wall_functions(self, *args, **kwargs):
                        """
                        Enable/disable scalable wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/scalable_wall_functions").execute(*args, **kwargs)
                    def menter_lechner(self, *args, **kwargs):
                        """
                        Enable/disable near wall treatment Menter-Lechner.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/menter_lechner").execute(*args, **kwargs)
                    def user_defined_wall_functions(self, *args, **kwargs):
                        """
                        Enable user defined wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/user_defined_wall_functions").execute(*args, **kwargs)
                    def wf_pressure_gradient_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function pressure-gradient effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_pressure_gradient_effects").execute(*args, **kwargs)

                class turbulence_expert(TUIMenu):
                    """
                    Enter the turbulence expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_damping(self, *args, **kwargs):
                        """
                        Enable/disable turbulence damping and set turbulence damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turbulence_damping").execute(*args, **kwargs)
                    def production_limiter(self, *args, **kwargs):
                        """
                        Enable/disable the Production Limiter.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/production_limiter").execute(*args, **kwargs)
                    def non_newtonian_modification(self, *args, **kwargs):
                        """
                        Enable/disable non-Newtonian modification for Lam-Bremhorst model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/non_newtonian_modification").execute(*args, **kwargs)
                    def sbes_update_interval_k_omega(self, *args, **kwargs):
                        """
                        Set an integer value how often the k and omega equations are updated in a transient SBES run.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_update_interval_k_omega").execute(*args, **kwargs)
                    def turb_non_newtonian(self, *args, **kwargs):
                        """
                        Enable/disable turbulence for non-Newtonian fluids.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_non_newtonian").execute(*args, **kwargs)
                    def kw_add_sas(self, *args, **kwargs):
                        """
                        Enable/disable the SAS-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_sas").execute(*args, **kwargs)
                    def sbes_sdes_hybrid_model(self, *args, **kwargs):
                        """
                        Select the SBES / SDES hybrid model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sdes_hybrid_model").execute(*args, **kwargs)
                    def low_re_ke(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke").execute(*args, **kwargs)
                    def kw_vorticity_based_production(self, *args, **kwargs):
                        """
                        Enable/disable vorticity based production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_vorticity_based_production").execute(*args, **kwargs)
                    def sbes_les_subgrid_dynamic_fvar(self, *args, **kwargs):
                        """
                        Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                    def thermal_p_function(self, *args, **kwargs):
                        """
                        Enable/disable the Jayatilleke P function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/thermal_p_function").execute(*args, **kwargs)
                    def kato_launder_model(self, *args, **kwargs):
                        """
                        Enable/disable Kato-Launder modification for production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kato_launder_model").execute(*args, **kwargs)
                    def rke_cmu_rotation_term(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of omega in the Cmu definition.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/rke_cmu_rotation_term").execute(*args, **kwargs)
                    def restore_sst_v61(self, *args, **kwargs):
                        """
                        Enable/disable SST formulation of v6.1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/restore_sst_v61").execute(*args, **kwargs)
                    def turb_pk_compressible(self, *args, **kwargs):
                        """
                        Enable/disable turbulent production due to compressible divergence.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_pk_compressible").execute(*args, **kwargs)
                    def sbes_sgs_option(self, *args, **kwargs):
                        """
                        Select SBES subgrid-scale model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sgs_option").execute(*args, **kwargs)
                    def low_re_ke_index(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon model version.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke_index").execute(*args, **kwargs)
                    def kw_add_des(self, *args, **kwargs):
                        """
                        Enable/disable DES-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_des").execute(*args, **kwargs)
                    def turb_add_sbes_sdes(self, *args, **kwargs):
                        """
                        Enable/disable SBES / SDES with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_add_sbes_sdes").execute(*args, **kwargs)

                class transition_model_options(TUIMenu):
                    """
                    Enter the transition model options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ctu_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_lowtu").execute(*args, **kwargs)
                    def cfpg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_lowtu").execute(*args, **kwargs)
                    def rv1_switch(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient RV1_SWITCH.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rv1_switch").execute(*args, **kwargs)
                    def rec_max(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_MAX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_max").execute(*args, **kwargs)
                    def critical_reynolds_number_correlation(self, *args, **kwargs):
                        """
                        Set the critical Reynolds number correlation.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/critical_reynolds_number_correlation").execute(*args, **kwargs)
                    def cbubble_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c1").execute(*args, **kwargs)
                    def cbubble_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c2").execute(*args, **kwargs)
                    def crossflow_transition(self, *args, **kwargs):
                        """
                        Enable/disable crossflow transition for the intermittency transition model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/crossflow_transition").execute(*args, **kwargs)
                    def rec_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c1").execute(*args, **kwargs)
                    def ctu_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_hightu").execute(*args, **kwargs)
                    def capg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_hightu").execute(*args, **kwargs)
                    def cfpg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_hightu").execute(*args, **kwargs)
                    def capg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_lowtu").execute(*args, **kwargs)
                    def clambda_scale(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CLAMBDA_SCALE.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/clambda_scale").execute(*args, **kwargs)
                    def rec_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c2").execute(*args, **kwargs)

                class geko_options(TUIMenu):
                    """
                    Enter the GEKO options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cnw(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw").execute(*args, **kwargs)
                    def wall_distance_free(self, *args, **kwargs):
                        """
                        Enable/disable wall-distance-free version of GEKO model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/wall_distance_free").execute(*args, **kwargs)
                    def geko_defaults(self, *args, **kwargs):
                        """
                        Set GEKO options to default.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/geko_defaults").execute(*args, **kwargs)
                    def cjet_aux(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET_AUX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet_aux").execute(*args, **kwargs)
                    def cbf_lam(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_LAM.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_lam").execute(*args, **kwargs)
                    def blending_function(self, *args, **kwargs):
                        """
                        Set the GEKO model blending function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/blending_function").execute(*args, **kwargs)
                    def cmix(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CMIX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cmix").execute(*args, **kwargs)
                    def cbf_tur(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_TUR.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_tur").execute(*args, **kwargs)
                    def csep(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CSEP.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/csep").execute(*args, **kwargs)
                    def cjet(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet").execute(*args, **kwargs)
                    def cnw_sub(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW_SUB.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw_sub").execute(*args, **kwargs)
                    def creal(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CREAL.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/creal").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enter the system coupling model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Enable/disable face based data transfer.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        super().__init__(path, service)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enter the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/setup/models/structure/thermal_effects").execute(*args, **kwargs)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enable the linear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/linear_elasticity").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/nonlinear_elasticity").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disable the structural model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/structure_off").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enter the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Set structure damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/amg_stabilization").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enable explicit fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of operating p into fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of viscous fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enter the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Change Turbulent Schmidt Number for Soot/Nuclei Equations.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set Soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Set soot process parameters.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enable/disable the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Enter the soot model parameters menu.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)

            class shell_conduction(TUIMenu):
                """
                Enter the shell conduction model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def save_shell_zones(self, *args, **kwargs):
                    """
                    Enable/Disable saving shell zones to case file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/save_shell_zones").execute(*args, **kwargs)
                def settings(self, *args, **kwargs):
                    """
                    Enter Multi-layer Shell Conduction data.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/settings").execute(*args, **kwargs)
                def enhanced_encapsulation(self, *args, **kwargs):
                    """
                    Enable/disable enhanced encapsulation for shell conduction and S2S models. This is not applicable if coupled sliding interface walls exists.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/enhanced_encapsulation").execute(*args, **kwargs)
                def multi_layer_shell(self, *args, **kwargs):
                    """
                    Enable/disable multi layer shell conduction model.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/multi_layer_shell").execute(*args, **kwargs)
                def write_csv(self, *args, **kwargs):
                    """
                    Write shell conduction settings to a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/write_csv").execute(*args, **kwargs)
                def read_csv(self, *args, **kwargs):
                    """
                    Read shell conduction settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/read_csv").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enter the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enable/disable reaction diffusion balance at reacting surface for surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Set/Change partially premixed mixture properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enable/disable PDF transport expert user.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enable/disable the inert transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_model").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Set species transport expert options.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport_expert").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/thickened_flame_model").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Set premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_model").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enable/disable the ignition model.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Set ISAT parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/integration_parameters").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Set PDF transport mixing model.
                    """
                    return PyMenu(self.service, "/setup/models/species/mixing_model").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_combustion").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Set ignition model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model_controls").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enable/disable storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/setup/models/species/save_gradients").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enable/disable EPDF energy  option.
                    """
                    return PyMenu(self.service, "/setup/models/species/epdf_energy").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable stiff chemistry option.
                    """
                    return PyMenu(self.service, "/setup/models/species/stiff_chemistry").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable wall surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Set premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Set combustion expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_expert").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable heat of surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Set the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Set flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/flamelet_expert").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Set Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Enable/disable ion species migration in electric field.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_migration").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Import Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/setup/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/relax_to_equil").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enable/disable CHEMKIN-CFD.
                    """
                    return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clear the ISAT table.
                    """
                    return PyMenu(self.service, "/setup/models/species/clear_isat_table").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enable/disable diffusion energy source.
                    """
                    return PyMenu(self.service, "/setup/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Set user specified grid parameters for PDF and flamelet.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enable/Disable the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enable/disable liquid micro mixing option.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Set Eddy-Dissipation Concept model constants.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Set spark model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/spark_model").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable thermal diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/thermal_diffusion").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/species/inlet_diffusion").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Set inert transport model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_controls").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable particle surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enable/disable the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable solution of species models.
                    """
                    return PyMenu(self.service, "/setup/models/species/off").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enable/disable mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/mass_deposition_source").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Set up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/setup/models/species/coal_calculator").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Set combustion numerics options.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_numerics").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enable/disable the species transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enable/disable the Reactor Network model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reactor_network_model").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initialize Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/setup/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enable/disable building of a full 2 mixture fraction table.
                    """
                    return PyMenu(self.service, "/setup/models/species/full_tabulation").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enable/disable volumetric reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/volumetric_reactions").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Set the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enter the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        List cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Delete cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Add a monitor cell for debug output.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Set advanced parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def basic_options(self, *args, **kwargs):
                        """
                        Set basic parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Define multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specify the number of phases.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Coupled level set.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Interface Modeling Options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specify multiphase model.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/model").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Regime-transition-modeling-options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    VOF sub-models.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Body force formulation.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Mixture parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/mixture_parameters").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enter the population balance model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        super().__init__(path, service)
                    def model(self, *args, **kwargs):
                        """
                        Select the population balance model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/model").execute(*args, **kwargs)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Calculate fluid particle diameters using different methods.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enter the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Control vof cut-off for breakage and aggregation.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def nucleation(self, *args, **kwargs):
                            """
                            Set the nucleantion rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Set the aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def growth(self, *args, **kwargs):
                            """
                            Set the growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        super().__init__(path, service)

                    class iac_expert(TUIMenu):
                        """
                        Enter the IAC expert setting menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def yao_morel_model(self, *args, **kwargs):
                            """
                            Set ym model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)
                        def ishii_kim_model(self, *args, **kwargs):
                            """
                            Set ik model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                        def iac_pseudo_time_step(self, *args, **kwargs):
                            """
                            Set iac pseudo-time.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                        def hibiki_ishii_model(self, *args, **kwargs):
                            """
                            Set hi model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                super().__init__(path, service)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    super().__init__(path, service)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)

                            class numerics(TUIMenu):
                                """
                                Enter the menu to set numerics models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    super().__init__(path, service)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    super().__init__(path, service)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)

                            class forces(TUIMenu):
                                """
                                Enter the menu to set interfacial forces related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    super().__init__(path, service)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects o