#!/usr/bin/env python3
# Generated by "pythonizer FindBin.pm" v1.009 run by JO2742 on Mon Oct 31 17:58:41 2022
# Implied pythonizer options: -a
__author__ = """Joe Cool"""
__email__ = "snoopyjc@gmail.com"
__version__ = "1.009"
# FindBin.pm
#
# Copyright (c) 1995 Graham Barr & Nick Ing-Simmons. All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
# pragma pythonizer -a

"""
=head1 NAME

FindBin - Locate directory of original perl script

=head1 SYNOPSIS

 use FindBin;
 use lib "$FindBin::Bin/../lib";

 or

 use FindBin qw($Bin);
 use lib "$Bin/../lib";


=head1 DESCRIPTION

Locates the full path to the script bin directory to allow the use
of paths relative to the bin directory.

This allows a user to setup a directory tree for some software with
directories C<< <root>/bin >> and C<< <root>/lib >>, and then the above
example will allow the use of modules in the lib directory without knowing
where the software tree is installed.

If perl is invoked using the B<-e> option or the perl script is read from
C<STDIN> then FindBin sets both C<$Bin> and C<$RealBin> to the current
directory.

=head1 EXPORTABLE VARIABLES

 $Bin         - path to bin directory from where script was invoked
 $Script      - basename of script from which perl was invoked
 $RealBin     - $Bin with all links resolved
 $RealScript  - $Script with all links resolved


=head1 KNOWN ISSUES

If there are two modules using C<FindBin> from different directories
under the same interpreter, this won't work. Since C<FindBin> uses a
C<BEGIN> block, it'll be executed only once, and only the first caller
will get it right. This is a problem under mod_perl and other persistent
Perl environments, where you shouldn't use this module. Which also means
that you should avoid using C<FindBin> in modules that you plan to put
on CPAN. To make sure that C<FindBin> will work is to call the C<again>
function:

  use FindBin;
  FindBin::again(); # or FindBin->again;


In former versions of FindBin there was no C<again> function. The
workaround was to force the C<BEGIN> block to be executed again:

  delete $INC{'FindBin.pm'};
  require FindBin;


=head1 AUTHORS

FindBin is supported as part of the core perl distribution.  Please submit bug
reports at L<https://github.com/Perl/perl5/issues>.

Graham Barr E<lt>F<gbarr@pobox.com>E<gt>
Nick Ing-Simmons E<lt>F<nik@tiuk.ti.com>E<gt>

=head1 COPYRIGHT

Copyright (c) 1995 Graham Barr & Nick Ing-Simmons. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
"""
import builtins, os, perllib, re, sys

_str = lambda s: "" if s is None else str(s)
perllib.init_package("main")
perllib.init_package("FindBin")


def cwd2(*_args):
    cwd = os.getcwd()
    # getcwd might fail if it hasn't access to the current directory.
    # try harder.
    if cwd is None:
        cwd = os.getcwd()

    return cwd


FindBin.cwd2 = cwd2


def init(*_args):
    global _d

    BinOld = None
    linktext = None
    script = None
    FindBin.Dir = (
        FindBin.Bin_v
    )  # SNOOPYJC: These lines can't translate properly so we fix them later
    FindBin.RealDir = FindBin.RealBin_v

    if sys.argv[0] == "-e" or sys.argv[0] == "-":
        # perl invoked with -e or script is on C<STDIN>
        FindBin.Script_v = FindBin.RealScript_v = sys.argv[0]
        FindBin.Bin_v = FindBin.RealBin_v = cwd2()
        if perllib.os_name() == "VMS":
            FindBin.Bin_v = VMS.Filespec.unixify(FindBin.Bin_v)

        FindBin.Dir_v = FindBin.RealDir_v = FindBin.Bin_v  # SNOOPYJC
        return FindBin.Dir_v
    else:
        script = sys.argv[0]

        if perllib.os_name() == "VMS":
            [FindBin.Bin_v, FindBin.Script_v] = perllib.list_of_n(
                (
                    _m := re.search(
                        re.compile(r"(.*[\]>/]+)(.*)", re.S),
                        _str(VMS.Filespec.rmsexpand(sys.argv[0])),
                    ),
                    _m.groups() if _m else [],
                )[1],
                2,
            )
            # C<use disk:[dev]/lib> isn't going to work, so unixify first
            perllib.assign_global(
                "FindBin",
                "Bin_v",
                re.sub(r"/\Z", r"", _str(VMS.Filespec.unixify(FindBin.Bin_v)), count=1),
            )
            [FindBin.RealBin_v, FindBin.RealScript_v] = (FindBin.Bin_v, FindBin.Script_v)
            FindBin.Dir_v = FindBin.Bin_v  # SNOOPYJC
            return FindBin.Dir_v
        else:
            if not perllib.is_file(script):
                perllib.croak(f"Cannot find current script '{sys.argv[0]}'")

            # Ensure $script contains the complete path in case we C<chdir>

            if not (os.path.isabs(_str(script))):
                script = os.path.join(cwd2(), script)

            [FindBin.Script_v, FindBin.Bin_v] = perllib.list_of_n(
                perllib.fileparse(_str(script)), 2
            )

            # Resolve $script if it is a link
            while True:
                linktext = perllib.readlink(_str(script))

                [FindBin.RealScript_v, FindBin.RealBin_v] = perllib.list_of_n(
                    perllib.fileparse(_str(script)), 2
                )
                if linktext is None:
                    break

                script = (
                    linktext
                    if (os.path.isabs(_str(linktext)))
                    else File.Spec.catfile(FindBin.RealBin_v, linktext)
                )

            # Get absolute paths to directories

            if FindBin.Bin_v:
                BinOld = FindBin.Bin_v
                FindBin.Bin_v = perllib.abspath(_str(FindBin.Bin_v))
                if FindBin.Bin_v is None:
                    FindBin.Bin_v = File.Spec.canonpath(BinOld)

            if FindBin.RealBin_v:
                FindBin.RealBin_v = perllib.abspath(_str(FindBin.RealBin_v))

            FindBin.Dir_v = FindBin.Bin_v  # SNOOPYJC
            FindBin.RealDir_v = FindBin.RealBin_v  # SNOOPYJC
            return FindBin.RealDir_v


FindBin.init = init

FindBin.Bin_v = perllib.init_global("FindBin", "Bin_v", None)
FindBin.Dir_v = perllib.init_global("FindBin", "Dir_v", None)
FindBin.RealBin_v = perllib.init_global("FindBin", "RealBin_v", None)
FindBin.RealDir_v = perllib.init_global("FindBin", "RealDir_v", None)
FindBin.RealScript_v = perllib.init_global("FindBin", "RealScript_v", None)
FindBin.Script_v = perllib.init_global("FindBin", "Script_v", None)
_d = ""

builtins.__PACKAGE__ = "FindBin"
# SKIPPED: use strict;
perllib.WARNING = 1

# SKIPPED: use Carp;
# SKIPPED: require Exporter;
# SKIPPED: use Cwd qw(getcwd cwd abs_path);
# SKIPPED: use File::Basename;
# SKIPPED: use File::Spec;

FindBin.EXPORT_OK_a = "$Bin $Script $RealBin $RealScript $Dir $RealDir".split()
FindBin.EXPORT_TAGS_h = perllib.Hash(
    {"ALL": "$Bin $Script $RealBin $RealScript $Dir $RealDir".split()}
)
FindBin.ISA_a = "Exporter".split()

FindBin.VERSION_v = "1.53"

# needed for VMS-specific filename translation
if perllib.os_name() == "VMS":
    import VMS.Filespec as _VMS_Filespec

    VMS.Filespec.import_()

for _ in range(1):  # BEGIN:
    init()


FindBin.again = init
again = init
