import surfex
import unittest
import experiment
import scheduler
import os
from datetime import datetime


class TestSubmit(unittest.TestCase):

    @staticmethod
    def _create_exp(wd):
        os.makedirs(wd, exist_ok=True)
        argv = [
            "setup",
            "--wd", wd,
            "-surfex", surfex.__path__[0],
            "-scheduler", scheduler.__path__[0],
            "-rev", os.getcwd(),
            "-host", "unittest",
            "--debug",
            "--domain_file", "test/settings/conf_proj_test.json"
        ]
        kwargs = experiment.parse_surfex_script(argv)
        experiment.surfex_script(**kwargs)

    def test_submission(self):

        exp = "test_submission"
        hm_wd = "/tmp/host0/hm_wd/" + exp
        self._create_exp(hm_wd)

        # Set progress
        dtg = datetime(2020, 6, 9, 9)
        progress = {"DTG": dtg.strftime("%Y%m%d%H")}
        progress_pp = {"DTGPP": dtg.strftime("%Y%m%d%H")}
        progress = experiment.Progress(progress, progress_pp)

        sfx_exp = experiment.ExpFromFiles(exp, hm_wd, progress=progress)

        ecf_name = "/" + exp + "/Forecasting/Forecast"
        ecf_tryno = 1
        ecf_pass = "dummy_password"

        task = scheduler.EcflowTask(ecf_name, ecf_tryno, ecf_pass, ecf_rid=int(os.getpid()),
                                    submission_id=None)
        os.makedirs("/tmp/host1/job/" + exp + "/Forecasting/", exist_ok=True)
        fh = open("/tmp/host1/job/" + exp + "/Forecasting/Forecast.job1", "w")
        fh.write("My job generated by ecflow")
        fh.close()

        exceptions = {
            "complete": {
                "task": {
                    "Forecast": "is_coldstart"
                },
                "family": {
                    "Forecasting": "is_coldstart"
                }
            }
        }

        env_file = "/tmp/host1/job/" + exp + "/Forecasting/Env"
        fh = open(env_file, "w")
        fh.write("print(\"Oh my environment\n\")")
        fh.close()

        hosts = sfx_exp.system.hosts
        joboutdir = {}
        for host in range(0, len(hosts)):
            joboutdir.update({str(host): sfx_exp.system.get_var("JOBOUTDIR", str(host))})
        submit = scheduler.EcflowSubmitTask(task, sfx_exp.env_submit, sfx_exp.server, joboutdir,
                                            submit_exceptions=exceptions, env_file=env_file)
        submit.write_job()

