# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.model_route_spec import ModelRouteSpec  # noqa: F401,E501
from odahuflow.sdk.models.model_route_status import ModelRouteStatus  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelRoute(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, spec: ModelRouteSpec=None, status: ModelRouteStatus=None):  # noqa: E501
        """ModelRoute - a model defined in Swagger

        :param id: The id of this ModelRoute.  # noqa: E501
        :type id: str
        :param spec: The spec of this ModelRoute.  # noqa: E501
        :type spec: ModelRouteSpec
        :param status: The status of this ModelRoute.  # noqa: E501
        :type status: ModelRouteStatus
        """
        self.swagger_types = {
            'id': str,
            'spec': ModelRouteSpec,
            'status': ModelRouteStatus
        }

        self.attribute_map = {
            'id': 'id',
            'spec': 'spec',
            'status': 'status'
        }

        self._id = id
        self._spec = spec
        self._status = status

    @classmethod
    def from_dict(cls, dikt) -> 'ModelRoute':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelRoute of this ModelRoute.  # noqa: E501
        :rtype: ModelRoute
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this ModelRoute.

        Model route id  # noqa: E501

        :return: The id of this ModelRoute.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this ModelRoute.

        Model route id  # noqa: E501

        :param id: The id of this ModelRoute.
        :type id: str
        """

        self._id = id

    @property
    def spec(self) -> ModelRouteSpec:
        """Gets the spec of this ModelRoute.

        Model route specification  # noqa: E501

        :return: The spec of this ModelRoute.
        :rtype: ModelRouteSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec: ModelRouteSpec):
        """Sets the spec of this ModelRoute.

        Model route specification  # noqa: E501

        :param spec: The spec of this ModelRoute.
        :type spec: ModelRouteSpec
        """

        self._spec = spec

    @property
    def status(self) -> ModelRouteStatus:
        """Gets the status of this ModelRoute.

        Model route status  # noqa: E501

        :return: The status of this ModelRoute.
        :rtype: ModelRouteStatus
        """
        return self._status

    @status.setter
    def status(self, status: ModelRouteStatus):
        """Sets the status of this ModelRoute.

        Model route status  # noqa: E501

        :param status: The status of this ModelRoute.
        :type status: ModelRouteStatus
        """

        self._status = status
