
# define useful function
def null(df,df_name):
    if df.isnull().values.any() ==False:
        print(f'STATUS: There is NO ANY null value in {df_name}')
    else:
        print('STATUS: There is null value in dataframe')
        columns = df.columns[df.isna().any()].tolist()
        temp = {}
        for column in columns:
            count = (len(df)) - (df[column].count())
            temp[column] = f"{count} ({round((count/len(df)), 4)*100}%)"
        print(f'STATUS: Nulls of {df_name} = {temp} of total {len(df)}')

def duplicate(df, column):
    if len(df[df[column].duplicated()]) ==0:
        print(f'STATUS: There is NO ANY duplicate value in the column of "{column}"')
    else:
        print(f'STATUS: There are {len(df[df[column].duplicated()])} duplicate values in the column of "{column}"')

def shape(df,df_name):
    print(f'STATUS: Dimension of "{df_name}" = {df.shape}')

def vc(df, column, r=False):
    from IPython.display import display
    vc_df = df.reset_index().groupby([column]).size().to_frame('count')
    vc_df['percentage (%)'] = vc_df['count'].div(sum(vc_df['count'])).mul(100)
    vc_df = vc_df.sort_values(by=['percentage (%)'], ascending=False)
    print(f'STATUS: Value counts of "{column}"...')
    display(vc_df)
    if r:
        return vc_df

def drop(df, column):
    df2 = df.drop(column, axis=1)
    print(f"STATUS: Columns of {column} were dropped")
    return df2

def dtype(df, column):
    print(f"STATUS: Data type of {column} = {df[column].dtypes}")

def unique(df, column, r =False):
    num = len(df[column].unique())
    print(f"STATUS: Unique value for {column} = {num}")
    if r:
        return num





#################################



# CHECK POINT 1 CODING BLOCKS
# C1: Stratify Split
def stratify_split(df, index_col, random_state_value, proposed_test_size):
    from sklearn.model_selection import train_test_split
    unique_num = unique(df, index_col, True)
    proportion_min  = unique_num/len(df)
    proportion_added = proportion_min + (0.10 * proportion_min)
    if proportion_added <= proposed_test_size:
        test_size_value = proposed_test_size
        print(f"STATUS: The proportion of the stratified splitting is {test_size_value}")
    else:
        test_size_value = round(proportion_added, 4)
        print(f"STATUS: The proportion of the stratified splitting is {test_size_value} to be able to perform stratify split")
    
    # to make sure there is no unique index_col
    df = df.groupby(index_col).filter(lambda x : len(x)>=2)
    
    X_train, X_test = train_test_split(df, stratify=df[index_col], \
                                                    test_size=test_size_value, random_state=random_state_value)
    print(f"STATUS: The dataframe is splitted with test size of {test_size_value}")
    shape(X_train,'X_train') ; shape(X_test,'X_test')
    return X_train, X_test

# C1: Pivot
def pivot(X_train, X_test, index_col, columns_col, values_col):
    from IPython.display import display
    matrix_train = X_train.pivot_table(index = index_col, columns=columns_col,values=values_col)
    print(f"STATUS: Pivoted for matrix training set")
    shape(matrix_train,f'train matrix')
    matrix_test = X_test.pivot_table(index = index_col, columns=columns_col,values=values_col)
    print(f"STATUS: Pivoted for matrix testing set")
    shape(matrix_test,f'test matrix')
    print(f"STATUS: Matrix train first 5 rows")
    display(matrix_train.head())
    return matrix_train, matrix_test

# C1: Normalisation
def normalisation(matrix_train):
    from IPython.display import display
    # normalisation
    matrix_train_norm = matrix_train.subtract(matrix_train.mean(axis=1), axis='rows')
    print(f"STATUS: Normalised for matrix training set")
    # replace NaN with 0, means average rating
    matrix_train_norm =matrix_train_norm.fillna(0)
    print(f"STATUS: Replaced Null with 0 for matrix training set")
    shape(matrix_train_norm,'matrix_train_norm')
    print("STATUS: After dropping all rows with only 0 values...")
    matrix_train_norm = matrix_train_norm.loc[~(matrix_train_norm==0).all(axis=1)]
    shape(matrix_train_norm,'matrix_train_norm')
    print(f"STATUS: Normalised matrix train first 5 rows")
    display(matrix_train_norm.head())
    return matrix_train_norm

# C1: User similarity matrix using Pearson correlation
def pearson_similarity(df):
    from IPython.display import display
    print("STATUS: Computing Pearson Correlation ...")
    df = df.T.corr(method ='pearson')
    print("STATUS: Computing Pearson Correlation Done")
    shape(df, 'Pearson Correlation Matrix')
    print('first 5 rows ...'); display(df.head())
    return df

# CHECKPOINT 1 - COMBINED
def recommender_pre_processing(df2, index_col, columns_col, values_col, \
                               random_state_value =42, proposed_test_size=0.2):
    X_train, X_test = stratify_split(df2, index_col, random_state_value =random_state_value, \
                                     proposed_test_size=proposed_test_size)
    matrix_train, matrix_test = pivot(X_train, X_test, index_col, columns_col, values_col)
    matrix_train_norm = normalisation(matrix_train)
    matrix_train_norm_treated_pearson = pearson_similarity(matrix_train_norm)
    return X_train, X_test, matrix_train_norm, matrix_train_norm_treated_pearson, matrix_test

# CHECK POINT 2 CODING BLOCKS
# C2: Get similarity thereshold
def get_thereshold(matrix_train_norm_treated_pearson, thereshold_N):
    import numpy as np
    print(f"STATUS: Computing similarity thereshold at {thereshold_N} percentile")
    thereshold = np.percentile(matrix_train_norm_treated_pearson.values, thereshold_N)
    print(f"STATUS: Thereshold similarity = {thereshold}")
    return thereshold, thereshold_N

# C2: Extract N Similar User or Item
def extract_n_similar(df, col_Id, thereshold, n_rows=100, show_text=False):
    from IPython.display import display
    df2 = df.drop(index=col_Id)
    if thereshold:
        top_n_similar_users = (df2[df2[col_Id]>=thereshold][[col_Id]]).sort_values(by=col_Id, \
                                                                                   ascending=False).head(n_rows)
        if show_text:
            print(f"STATUS: The thereshold of similarity pearson correlation is {thereshold}")
            print(f"STATUS: Sorted values in descending and filter the value more than or equal to {thereshold}")
            shape(top_n_similar_users,f'top_n_similar_users to {col_Id}')
            display(top_n_similar_users.head())
    else:
        top_n_similar_users = (df2[[col_Id]]).sort_values(by=col_Id, ascending=False).head(n_rows)
        if show_text:
            shape(top_n_similar_users,f'top_n_similar_users to {col_Id}')
            display(top_n_similar_users.head())
    return top_n_similar_users

# C2: Get Target Interacted Element
def get_target_interacted(df, col_Id,  show_text=True):
    from IPython.display import display
    target_data = df[df.index==col_Id]
    # remove columns only zero value
    target_rated = target_data.loc[:, (target_data != 0).any(axis=0)]
    if show_text==True:
        print(f"STATUS: Target interacted: {target_rated.columns.tolist()} ")
        shape(target_rated,'target_rated')
        display(target_rated.head())
    return target_rated

# C2: Get Target Neighnors Interacted Element
def get_target_most_similar_interacted(df, similar_users, show_text=True):
    from IPython.display import display
    target_similar_data = (df[df.index.isin(similar_users.index)])
    # remove columns only zero value
    target_similar_rated = target_similar_data.loc[:, (target_similar_data != 0).any(axis=0)]
    if show_text==True:
        print(f"STATUS: Target similar interacted: {target_similar_rated.columns.tolist()} ")
        shape(target_similar_rated,'target_similar_rated')
        display(target_similar_rated.head())
    return target_similar_rated

# C2: Get Recommended Element
def recommended_movies_(matrix_train_norm_treated_pearson, matrix_train_norm, thereshold, col_Id, \
                        n_rows,show_text=False):
    similar_users = extract_n_similar(matrix_train_norm_treated_pearson,col_Id, thereshold, \
                                        n_rows=n_rows, show_text=show_text)
    most_similar_user_rated =get_target_most_similar_interacted(matrix_train_norm, \
                                                                similar_users, show_text=show_text)
    a = most_similar_user_rated.columns.tolist()
    b = (get_target_interacted(matrix_train_norm, col_Id, show_text=show_text)).columns.tolist()
    recommended_movies_unwatch_picked_user = list(set(a) - set(b))
    recommended_similar_user_movies = most_similar_user_rated[recommended_movies_unwatch_picked_user]
    if show_text == True:
        print(f'STATUS: Recommended {len(recommended_similar_user_movies.columns)} elements {recommended_movies_unwatch_picked_user}')
        return recommended_similar_user_movies, similar_users
    else:
        return recommended_similar_user_movies, similar_users
    
# CHECKPOINT 2 - COMBINED
def collaborative_recommender(matrix_train_norm_treated_pearson, matrix_train_norm, col_Id, thereshold=None, \
                              n_rows=100, topN=10, show_text=False):
    import numpy as np
    from IPython.display import display
    df1, df2 = recommended_movies_(matrix_train_norm_treated_pearson, matrix_train_norm, \
                                   thereshold,col_Id,n_rows=n_rows,show_text=show_text)
    df1 = df1.sort_index(ascending=True)
    df2 = df2.sort_index(ascending=True)
    multiplied_result = df1.multiply(np.array(df2))
    # Obtain aggregated sum and divide by number of rated userid
    result = (multiplied_result.sum(axis = 0)/multiplied_result.astype(bool).sum(axis=0)).to_frame().reset_index()
    result.columns = ['conditional_column','weighted_score']
    result = result.sort_values(by='weighted_score', ascending=False)
    if show_text ==True:
        shape(df1, 'recommended mvoie') ; display(df1.head())
        shape(df2, 'similar users') ; display(df2.head())
        shape(multiplied_result, 'multiplied_result') ; display(multiplied_result.head())
        shape(result, 'topNresult') ; display(result.head(topN))
    return result.head(topN), col_Id



##################################






# CHECKPOINT 3 - CODING BLOCKS
# C3 : Make Prediction
def make_prediction(target_users_len, n_rows, topN, SIZE, \
                    matrix_train_norm, \
                    matrix_train_norm_treated_pearson):
    
    import pandas as pd
    from IPython.display import display

    if target_users_len == None:
        target_users_len = matrix_train_norm.shape[0]
    
    if SIZE == None:
        SIZE = matrix_train_norm.shape[0]
        
    print("----------------------------------")
    print(F"STATUS: Starting TopN = {topN}")
    
    predicted_list_nested = [] ; userId_nested = []; count=0; len_predict_nested=[]
    random_sampled_user_df = matrix_train_norm.sample(n=SIZE)
    print("STATUS: Random shuffled and sample dataset done")
    # thereshold = get_thereshold(matrix_train_norm_treated_pearson, thereshold_N=90)
    random_sampled_user_list = random_sampled_user_df.index.tolist()
    target_users_len = target_users_len

    for user in random_sampled_user_list:
        topn_result, col_Id = collaborative_recommender(matrix_train_norm_treated_pearson=matrix_train_norm_treated_pearson, \
                                                matrix_train_norm = matrix_train_norm, \
                                                col_Id = user, \
                                                thereshold = None, 
                                                n_rows = n_rows, \
                                                topN = topN, \
                                                show_text = False)
        if len(topn_result) ==topN:
            predicted_list = topn_result.conditional_column.values.tolist()
            predicted_list_nested.append(predicted_list)
            len_predict_nested.append(len(predicted_list))
            userId_nested.append(user)  
            count+=1    
            if count % (target_users_len/10) <= 1:
                print(f"STATUS: Complete predictions {count}/{target_users_len}...{'{:.2%}'.format(count/target_users_len)}")     
            if count >=target_users_len:
                break
                
    print(f"STATUS: Complete predictions {target_users_len}/{target_users_len}...{'{:.2%}'.format(target_users_len/target_users_len)}") 
    d = {'target_id':userId_nested , 'predicted': predicted_list_nested, 'len_predicted':len_predict_nested}
    predict_df = pd.DataFrame(data=d)
    shape(predict_df,'predict_df')
    print('STATUS: First 5 rows...')
    display(predict_df.head())
    return predict_df, userId_nested

# C3 : Get Predict and Actual Values
def get_predicted_n_actual(predict_df, matrix_test, topN, userId_nested, \
                           limit_len_actual ='no'):
    
    import pandas as pd
    from IPython.display import display
    import random 

    # Filter similar users in the train set
    xtest_filter = matrix_test[matrix_test.index.isin(userId_nested)]
    matrix_test_filter = xtest_filter.dropna(axis=1, how='all')
    print("STATUS: Filter user id in Test Set as shown in Train set")
    shape(matrix_test_filter,'matrix_test_filter')

    print("STATUS: Starting to append test set movies in list for each user...")
    actual_movie_list= [] ; userid_list=[] ; len_movie_list = []
    for userid in matrix_test_filter.index.tolist():
        actual_movie = matrix_test_filter[matrix_test_filter.index ==userid].dropna(axis=1, how='all').columns.tolist()
        if limit_len_actual == 'yes': 
            if len(actual_movie) > topN:
                actual_movie = random.sample(actual_movie, k=topN)
        actual_movie_list.append(actual_movie)
        len_movie_list.append(len(actual_movie))
        userid_list.append(userid)

    print("STATUS: Appended finish.")
    d = {'target_id':userid_list , 'actual': actual_movie_list, 'len_actual': len_movie_list}
    test_actual = pd.DataFrame(data=d)
    shape(test_actual,'test_actual')
    null(test_actual,'test_actual')
    # merge
    train_test_result =predict_df.merge(test_actual, how='left', on='target_id')
    shape(train_test_result,'train_test_result')
    print('STATUS: First 5 rows...')
    display(train_test_result.head())
    return train_test_result, topN

# C3 : Get Predict and Actual Metrics
def get_predicted_n_actual_result(train_test_result):

    import pandas as pd
    from IPython.display import display

    TP_list= [] ; userid_list=[] ; df3 =train_test_result
    for userid in df3.target_id.tolist():
        tp_hit_count=0
        try:
            predicted_temp = df3[df3.target_id ==userid]['predicted'].values[0] # get list of movie for a user
            actual_temp = df3[df3.target_id ==userid]['actual'].values[0]
            for movie in predicted_temp:
                if movie in actual_temp:
                    tp_hit_count+=1
            userid_list.append(userid)
            TP_list.append(tp_hit_count)
        except:
            pass
    print("STATUS: Hitcount for loop done.")
    d = {'target_id':userid_list , 'true_positive': TP_list}
    df4 = pd.DataFrame(data=d)
    df5 = df3.merge(df4, how='left', on='target_id')
    print("STATUS: Newly formed result df merged with train_test_result done")
    shape(df5,'df5')
    df5['len_actual']=df5['len_actual'].fillna(0)
    df5['true_positive']=df5['true_positive'].fillna(0)
    df5['true_negative']=0; df5['false_negative']=0
    df5['false_positive']=0; df5.loc[(df5.actual.isna()), 'false_positive'] =1
    df5['precision@N'] = df5['true_positive']/(df5['len_predicted'])
    df5['recalln@N'] = df5['true_positive']/(df5['len_actual'])
    global_precision = df5['true_positive'].sum()/(df5['len_predicted']).sum()
    global_recall = df5['true_positive'].sum()/(df5['len_actual']).sum()
    f_measure = 2*((global_precision*global_recall)/(global_precision+global_recall))
    print("STATUS: Binary values for evaluation done.")
    shape(df5,'df5')
    print(f"global precision @N = {global_precision}")
    print(f"global_recall @N = {global_recall}")
    print(f"f_measure @N = {f_measure}")
    display(df5.head())
    return df5, global_precision, global_recall,f_measure

# C3 : Concat Metric
def get_evaluation(df5,recommender_name, precision, recall,f1, topN):
    import pandas as pd
    print(f"Precision@N={topN}: {precision:.4f}")
    print(f"Recall@N={topN}: {recall:.4f}")
    print(f"F-Measure@N={topN}: {f1:.4f}")
    
    d = {
        'Recommender': [recommender_name],
         f'Precision@N={topN}': [round(precision,4)], 
         f'Recall@N={topN}': [round(recall,4)], 
         f'F-Measure@N={topN}': [round(f1,4)], 
        }
    
    result_metric = pd.DataFrame(data=d)
    return result_metric

# C3 : Concat Function
def get_evaluation_concat(topN, matrix_train_norm, \
                          matrix_train_norm_treated_pearson, matrix_test,\
                          target_users_len =None, n_rows=100, 
                          SIZE=None, limit_len_actual='no',recommender_name='User-Based'):
    predict_df, userId_nested = make_prediction(target_users_len = target_users_len, \
                                                n_rows=n_rows, topN=topN, SIZE = SIZE, \
                                                matrix_train_norm = matrix_train_norm, \
                                                matrix_train_norm_treated_pearson = matrix_train_norm_treated_pearson)

    train_test_result, topN = get_predicted_n_actual(predict_df=predict_df, matrix_test=matrix_test, topN=topN, \
                                                     userId_nested=userId_nested, \
                                                     limit_len_actual =limit_len_actual)
    
    df5, global_precision, global_recall,f_measure = get_predicted_n_actual_result(train_test_result=train_test_result)
    
    result_metric = get_evaluation(df5, recommender_name =recommender_name, \
                                   precision = global_precision, \
                                   recall = global_recall, \
                                   f1 = f_measure, topN = topN)
    
    return result_metric

def get_df():
    import pandas as pd
    d = {"userId": {"32170": 605.0, "83001": 38.0, "78180": 574.0, "17477": 190.0, "31043": 57.0, "24883": 164.0, "74774": 655.0, "4576": 536.0, "34060": 268.0, "16897": 461.0, "55488": 73.0, "67956": 205.0, "24109": 57.0, "67159": 324.0, "45226": 646.0, "50607": 232.0, "60747": 587.0, "42091": 292.0, "81495": 380.0, "45056": 294.0, "44858": 644.0, "38485": 30.0, "25663": 433.0, "8738": 242.0, "30414": 41.0, "66415": 452.0, "53811": 430.0, "42380": 534.0, "998": 659.0, "26024": 245.0, "19695": 493.0, "55332": 220.0, "42789": 150.0, "59950": 336.0, "37752": 463.0, "35342": 341.0, "15687": 233.0, "72017": 165.0, "653": 375.0, "54693": 417.0, "57434": 73.0, "23677": 391.0, "16371": 154.0, "43148": 358.0, "10773": 15.0, "82992": 48.0, "21431": 56.0, "66851": 134.0, "31425": 223.0, "52069": 212.0, "45342": 405.0, "14113": 483.0, "73504": 23.0, "55633": 575.0, "75781": 146.0, "7065": 529.0, "72121": 584.0, "65608": 77.0, "56232": 189.0, "32757": 120.0, "76701": 505.0, "42264": 311.0, "3363": 77.0, "39574": 95.0, "37050": 405.0, "74316": 379.0, "73658": 431.0, "17406": 452.0, "70764": 56.0, "40701": 30.0, "35251": 407.0, "22235": 160.0, "46359": 171.0, "29799": 420.0, "6624": 496.0, "84107": 15.0, "18230": 278.0, "26958": 73.0, "50072": 547.0, "4827": 460.0, "74767": 580.0, "2119": 242.0, "17503": 541.0, "24147": 218.0, "73837": 133.0, "14283": 294.0, "35783": 608.0, "45721": 201.0, "29068": 33.0, "24636": 510.0, "66432": 527.0, "20346": 128.0, "77573": 468.0, "83206": 48.0, "77980": 480.0, "6945": 594.0, "69735": 426.0, "67252": 388.0, "74421": 547.0, "72403": 186.0, "44926": 294.0, "3310": 550.0, "65998": 382.0, "31404": 95.0, "15640": 96.0, "21496": 342.0, "70601": 204.0, "46144": 189.0, "64944": 353.0, "12284": 218.0, "55136": 48.0, "35493": 213.0, "78391": 406.0, "33729": 388.0, "21152": 585.0, "47117": 293.0, "59716": 664.0, "42798": 212.0, "46262": 30.0, "13514": 282.0, "6273": 580.0, "72897": 212.0, "39121": 580.0, "36055": 247.0, "34370": 105.0, "58321": 621.0, "30092": 554.0, "41522": 585.0, "9381": 241.0, "70078": 235.0, "26777": 428.0, "9680": 75.0, "24455": 594.0, "53331": 23.0, "38715": 195.0, "46059": 239.0, "70608": 547.0, "6116": 447.0, "73331": 15.0, "2034": 80.0, "21675": 383.0, "12873": 468.0, "26189": 461.0, "71296": 176.0, "79797": 501.0, "62267": 345.0, "59938": 311.0, "79329": 73.0, "42554": 398.0, "25125": 428.0, "9082": 530.0, "74709": 125.0, "42781": 95.0, "81729": 73.0, "68345": 532.0, "1052": 212.0, "57321": 367.0, "58736": 378.0, "64653": 216.0, "30347": 19.0, "64534": 547.0, "11035": 19.0, "6380": 607.0, "68569": 480.0, "53347": 452.0, "69667": 235.0, "77110": 199.0, "71127": 505.0, "79156": 149.0, "26419": 21.0, "36966": 577.0, "18040": 519.0, "35527": 461.0, "84044": 380.0, "71193": 353.0, "42210": 311.0, "10435": 434.0, "76686": 547.0, "79748": 73.0, "37441": 607.0, "16718": 134.0, "10046": 394.0, "12757": 434.0, "81478": 615.0, "44969": 441.0, "12522": 423.0, "34843": 564.0, "190": 509.0, "14499": 288.0, "11338": 452.0, "12263": 85.0, "79299": 664.0, "59660": 345.0, "70133": 402.0, "41321": 232.0, "60845": 81.0, "24661": 654.0, "22794": 595.0, "64835": 481.0, "40978": 529.0, "28029": 4.0, "67142": 23.0, "68971": 89.0, "35071": 312.0, "8792": 562.0, "25181": 628.0, "82029": 620.0, "76884": 200.0, "43282": 614.0, "9677": 50.0, "37257": 118.0, "17848": 469.0, "16094": 292.0, "81646": 73.0, "63730": 547.0, "34837": 457.0, "32192": 232.0, "10450": 306.0, "52709": 431.0, "25532": 463.0, "35597": 550.0, "26283": 7.0, "19325": 83.0, "35178": 355.0, "22375": 265.0, "56023": 169.0, "1338": 385.0, "17610": 306.0, "31987": 306.0, "6840": 380.0, "38848": 287.0, "45598": 466.0, "15827": 649.0, "72794": 316.0, "40086": 439.0, "21162": 86.0, "75568": 624.0, "48764": 328.0, "5623": 110.0, "47457": 433.0, "66885": 547.0, "31026": 553.0, "80535": 56.0, "62388": 287.0, "41251": 17.0, "69889": 125.0, "59990": 452.0, "15220": 114.0, "14745": 428.0, "22670": 99.0, "83108": 48.0, "69037": 509.0, "19231": 417.0, "69483": 236.0, "23264": 537.0, "36704": 195.0, "3559": 77.0, "83303": 352.0, "39189": 73.0, "69550": 268.0, "11617": 172.0, "5659": 215.0, "9894": 18.0, "25749": 403.0, "34157": 457.0, "5184": 468.0, "20871": 119.0, "58928": 362.0, "29008": 646.0, "57183": 441.0, "41574": 268.0, "390": 496.0, "77798": 250.0, "29305": 30.0, "32135": 559.0, "54053": 575.0, "44394": 176.0, "80892": 624.0, "16330": 564.0, "42254": 213.0, "72369": 480.0, "2476": 562.0, "12338": 666.0, "8889": 145.0, "1677": 588.0, "25724": 119.0, "73263": 624.0, "36828": 291.0, "7399": 213.0, "69250": 472.0, "67458": 52.0, "17757": 261.0, "984": 555.0, "51466": 626.0, "3801": 240.0, "40982": 545.0, "66059": 105.0, "3626": 561.0, "24274": 56.0, "23149": 605.0, "79654": 73.0, "66140": 382.0, "53265": 242.0, "83066": 251.0, "42096": 359.0, "81812": 664.0, "2899": 537.0, "39146": 268.0, "74570": 481.0, "15460": 128.0, "10309": 633.0, "56520": 153.0, "29073": 134.0, "66042": 596.0, "7728": 602.0, "21943": 597.0, "44564": 615.0, "23148": 603.0, "5150": 201.0, "50858": 201.0, "26637": 509.0, "72077": 133.0, "58242": 294.0, "5806": 529.0, "15530": 458.0, "5625": 116.0, "25389": 626.0, "25585": 665.0, "67889": 17.0, "22847": 540.0, "63142": 509.0, "55249": 222.0, "52630": 195.0, "12193": 607.0, "22675": 195.0, "47175": 232.0, "67026": 452.0, "40855": 671.0, "60300": 388.0, "47008": 623.0, "57103": 624.0, "50009": 150.0, "18839": 420.0, "47809": 613.0, "9094": 559.0, "81123": 448.0, "41070": 232.0, "15214": 93.0, "62494": 575.0, "55914": 520.0, "73183": 547.0, "14056": 287.0, "40339": 500.0, "11747": 517.0, "61891": 655.0, "47287": 88.0, "70863": 72.0, "9484": 598.0, "37189": 57.0, "47156": 134.0, "79010": 324.0, "17903": 20.0, "76667": 475.0, "4501": 388.0, "1680": 596.0, "70755": 607.0, "11715": 445.0, "77670": 660.0, "61675": 509.0, "66848": 580.0, "82976": 664.0, "20306": 518.0, "29157": 229.0, "82583": 624.0, "22344": 407.0, "30552": 292.0, "80342": 73.0, "40218": 294.0, "37233": 585.0, "3335": 627.0, "34887": 74.0, "41518": 547.0, "48026": 380.0, "51374": 190.0, "17448": 592.0, "20343": 646.0, "35618": 654.0, "37056": 509.0, "53176": 472.0, "81669": 664.0, "5332": 121.0, "5995": 647.0, "55685": 134.0, "11537": 388.0, "57214": 183.0, "55204": 452.0, "53209": 97.0, "45681": 580.0, "17003": 406.0, "10317": 665.0, "59173": 220.0, "66626": 587.0, "83168": 570.0, "17556": 311.0, "50358": 134.0, "79281": 620.0, "33714": 564.0, "82525": 475.0, "49091": 427.0, "76258": 91.0, "27172": 287.0, "71912": 15.0, "49082": 299.0, "18802": 214.0, "187": 503.0, "419": 391.0, "62315": 607.0, "52114": 130.0, "22748": 383.0, "57716": 418.0, "31603": 311.0, "23675": 587.0, "58916": 253.0, "48429": 439.0, "4929": 533.0, "25493": 231.0, "14875": 142.0, "32605": 128.0, "30557": 348.0, "66756": 481.0, "911": 664.0, "56044": 12.0, "55123": 105.0, "83748": 475.0, "21565": 640.0, "75136": 427.0, "41594": 419.0, "39507": 88.0, "31412": 149.0, "71177": 273.0, "77498": 547.0, "70141": 572.0, "55513": 509.0, "44598": 150.0, "51087": 458.0, "15990": 113.0, "74698": 442.0, "46299": 472.0, "68135": 68.0, "41728": 230.0, "38504": 28.0, "51158": 15.0, "18831": 376.0, "71707": 353.0, "54000": 268.0, "16677": 564.0, "2913": 452.0, "30869": 196.0, "39738": 30.0, "79376": 428.0, "57740": 353.0, "36641": 494.0, "22673": 135.0, "63089": 346.0, "61495": 243.0, "24722": 105.0, "19631": 111.0, "21324": 154.0, "35124": 83.0, "69158": 478.0, "32438": 439.0, "8547": 64.0, "79120": 48.0, "75448": 544.0, "54574": 15.0, "65016": 365.0, "40238": 665.0, "61312": 93.0, "18421": 28.0, "60694": 103.0, "74844": 88.0, "42301": 5.0, "26257": 638.0, "73002": 388.0, "71083": 73.0, "50558": 30.0, "27668": 88.0, "12315": 508.0, "33718": 342.0, "70985": 457.0, "8283": 82.0, "1858": 192.0, "37548": 580.0, "55133": 580.0, "18351": 17.0, "24416": 497.0, "81844": 615.0, "51436": 401.0, "5679": 254.0, "17980": 350.0, "55489": 452.0, "42855": 527.0, "83708": 457.0, "36607": 558.0, "34170": 587.0, "40744": 98.0, "79123": 625.0, "13475": 516.0, "68614": 262.0, "69551": 394.0, "79087": 81.0, "26923": 509.0, "4586": 492.0, "36950": 311.0, "46384": 265.0, "82617": 287.0, "29403": 483.0, "54026": 463.0, "22347": 441.0, "46613": 262.0, "59916": 54.0, "4284": 240.0, "15049": 533.0, "23648": 577.0, "82401": 380.0, "19190": 21.0, "14799": 607.0, "19849": 537.0, "56300": 585.0, "15710": 304.0, "71210": 427.0, "53812": 431.0, "51216": 539.0, "18903": 125.0, "80502": 378.0, "66217": 405.0, "25881": 596.0, "45728": 427.0, "57045": 43.0, "47906": 311.0, "73742": 23.0, "17857": 575.0, "31353": 439.0, "47150": 91.0, "49536": 306.0, "39854": 520.0, "206": 548.0, "10639": 624.0, "62028": 547.0, "524": 647.0, "71336": 226.0, "4343": 536.0, "2746": 34.0, "70044": 294.0, "43170": 131.0, "45095": 466.0, "23219": 388.0, "46742": 294.0, "28653": 514.0, "67297": 8.0, "7771": 306.0, "29705": 311.0, "66671": 384.0, "65505": 547.0, "27484": 236.0, "20302": 388.0, "16674": 103.0, "3205": 242.0, "80418": 251.0, "2377": 242.0, "57053": 412.0, "50519": 134.0, "68541": 353.0, "82971": 583.0, "37423": 505.0, "16463": 437.0, "64551": 30.0, "55312": 547.0, "61591": 245.0, "40762": 405.0, "35233": 278.0, "77143": 402.0, "33953": 26.0, "17234": 136.0, "75524": 553.0, "42562": 564.0, "58894": 61.0, "73214": 494.0, "63556": 529.0, "74343": 15.0, "1705": 86.0, "7047": 407.0, "80363": 481.0, "63452": 664.0, "13023": 105.0, "9525": 26.0, "64915": 152.0, "51795": 22.0, "60816": 346.0, "58235": 345.0, "66316": 17.0, "4085": 508.0, "65835": 426.0, "70580": 623.0, "16938": 564.0, "31076": 564.0, "63963": 654.0, "83467": 62.0, "33719": 452.0, "82492": 200.0, "53364": 119.0, "60814": 320.0, "79395": 584.0, "26399": 102.0, "45230": 38.0, "44767": 148.0, "65669": 138.0, "53578": 558.0, "1570": 212.0, "20157": 558.0, "21373": 212.0, "9776": 220.0, "53075": 419.0, "62145": 212.0, "50154": 23.0, "72636": 157.0, "79026": 486.0, "46280": 294.0, "55536": 263.0, "19794": 597.0, "70707": 610.0, "38469": 468.0, "54791": 451.0, "43090": 505.0, "65523": 468.0, "71655": 580.0, "80452": 382.0, "49824": 353.0, "39076": 587.0, "60774": 243.0, "40255": 119.0, "22585": 472.0, "2605": 361.0, "14211": 104.0, "71007": 544.0, "73424": 547.0, "49103": 608.0, "83013": 553.0, "6135": 39.0, "5352": 388.0, "32730": 518.0, "68339": 509.0, "36546": 387.0, "49656": 294.0, "39530": 342.0, "387": 459.0, "1865": 247.0, "41762": 119.0, "74771": 620.0, "17876": 422.0, "27317": 203.0, "67541": 452.0, "83610": 547.0, "10983": 400.0, "42161": 518.0, "10405": 531.0, "59847": 200.0, "60061": 15.0, "11514": 564.0, "60050": 157.0, "80166": 270.0, "37780": 242.0, "41273": 379.0, "18833": 388.0, "42133": 311.0, "1542": 111.0, "74688": 380.0, "67377": 72.0, "64055": 452.0, "55602": 606.0, "52031": 509.0, "84112": 611.0, "68396": 468.0, "28544": 544.0, "4294": 290.0, "1895": 416.0, "32224": 562.0, "72284": 176.0, "58717": 253.0, "46455": 595.0, "77215": 62.0, "69218": 384.0, "15718": 327.0, "16869": 102.0, "68585": 15.0, "11626": 192.0, "18845": 452.0, "34303": 642.0, "56212": 558.0, "52359": 77.0, "73489": 371.0, "67143": 26.0, "81253": 547.0, "78012": 212.0, "10431": 311.0, "80683": 553.0, "23533": 492.0, "67728": 41.0, "35483": 125.0, "82079": 402.0, "66451": 607.0, "26728": 177.0, "33250": 105.0, "44018": 300.0, "34292": 554.0, "25146": 529.0, "72635": 481.0, "71094": 313.0, "3273": 440.0, "29438": 654.0, "61421": 654.0, "12289": 282.0, "50576": 291.0, "40857": 239.0, "42107": 491.0, "16531": 452.0, "40256": 213.0, "72174": 48.0, "60730": 143.0, "51495": 242.0, "4088": 534.0, "45477": 648.0, "46683": 626.0, "55203": 306.0, "24599": 345.0, "16543": 30.0, "49735": 119.0, "45282": 423.0, "19850": 547.0, "66401": 380.0, "14511": 317.0, "16034": 73.0, "78513": 26.0, "70564": 456.0, "12987": 30.0, "72971": 157.0, "7736": 632.0, "43547": 587.0, "26690": 452.0, "53796": 292.0, "70763": 48.0, "20188": 102.0, "70979": 313.0, "23124": 514.0, "43291": 608.0, "62898": 243.0, "30298": 95.0, "15486": 247.0, "80241": 475.0, "47919": 73.0, "9219": 396.0, "8712": 590.0, "72637": 299.0, "2717": 95.0, "14592": 590.0, "3162": 111.0, "12957": 564.0, "66721": 230.0, "30920": 101.0, "72038": 468.0, "11245": 4.0, "30786": 19.0, "28144": 460.0, "74046": 157.0, "65209": 584.0, "46939": 394.0, "73970": 452.0, "8232": 357.0, "58453": 84.0, "10906": 564.0, "5719": 329.0, "7362": 602.0, "46992": 574.0, "49620": 406.0, "11796": 627.0, "79594": 163.0, "38054": 202.0, "67676": 624.0, "29875": 212.0, "67312": 169.0, "80260": 268.0, "74228": 178.0, "56965": 558.0, "71428": 473.0, "18311": 212.0, "62897": 240.0, "36768": 232.0, "48756": 150.0, "44100": 303.0, "7507": 130.0, "70152": 405.0, "72835": 212.0, "20760": 311.0, "9507": 19.0, "72143": 68.0, "56147": 533.0, "67426": 547.0, "11273": 217.0, "50671": 577.0, "81344": 380.0, "40382": 564.0, "59036": 609.0, "43276": 534.0, "67753": 648.0, "25092": 232.0, "56707": 480.0, "27486": 245.0, "29898": 372.0, "38095": 480.0, "77626": 287.0, "2453": 501.0, "43816": 285.0, "70205": 547.0, "43347": 617.0, "15626": 57.0, "29394": 457.0, "31184": 405.0, "29183": 577.0, "59903": 245.0, "78066": 574.0, "33907": 355.0, "10880": 659.0, "67304": 452.0, "54803": 575.0, "75492": 384.0, "11792": 615.0, "2388": 279.0, "31830": 232.0, "42586": 580.0, "52291": 15.0, "33103": 607.0, "81830": 73.0, "77569": 664.0, "54099": 509.0, "72192": 377.0, "10917": 15.0, "73289": 297.0, "77072": 257.0, "73086": 486.0, "18705": 306.0, "61276": 202.0, "17172": 580.0, "80967": 213.0, "40021": 99.0, "22878": 202.0, "41327": 463.0, "18540": 472.0, "37878": 75.0, "59913": 452.0, "75467": 169.0, "44147": 163.0, "77120": 450.0, "34471": 574.0, "43848": 500.0, "28887": 575.0, "27347": 330.0, "20092": 95.0, "10404": 518.0, "1314": 232.0, "70090": 418.0, "36703": 99.0, "17179": 607.0, "10184": 214.0, "19881": 585.0, "57715": 412.0, "55792": 476.0, "56113": 380.0, "67101": 481.0, "3941": 57.0, "44581": 665.0, "69465": 505.0, "11477": 594.0, "72344": 353.0, "44076": 525.0, "35850": 3.0, "6350": 452.0, "34178": 4.0, "31990": 388.0, "46620": 547.0, "3090": 666.0, "49537": 312.0, "16027": 42.0, "20063": 614.0, "68812": 255.0, "28886": 569.0, "17979": 347.0, "34466": 553.0, "23718": 93.0, "14320": 396.0, "61051": 457.0, "63426": 472.0, "11140": 338.0, "70967": 601.0, "19202": 125.0, "11279": 285.0, "67040": 388.0, "24626": 463.0, "69292": 236.0, "52864": 23.0, "65730": 613.0, "68528": 157.0, "34525": 185.0, "50514": 564.0, "9906": 233.0, "70086": 333.0, "29204": 125.0, "17227": 119.0, "74241": 472.0, "50683": 414.0, "76934": 133.0, "48860": 388.0, "46322": 598.0, "20271": 509.0, "9231": 466.0, "76059": 475.0, "57628": 481.0, "3997": 265.0, "66550": 648.0, "55576": 265.0, "16066": 168.0, "31003": 344.0, "39049": 248.0, "37279": 594.0, "11398": 537.0, "79937": 200.0, "32346": 119.0, "54912": 15.0, "56899": 299.0, "36907": 214.0, "30985": 119.0, "58072": 509.0, "11366": 92.0, "11952": 452.0, "76961": 270.0, "51199": 43.0, "32584": 625.0, "53767": 73.0, "39665": 95.0, "77430": 270.0, "74648": 472.0, "3254": 385.0, "49479": 43.0, "6124": 555.0, "40": 119.0, "27543": 355.0, "28872": 482.0, "17695": 641.0, "81751": 205.0, "47566": 294.0, "46321": 408.0, "14979": 385.0, "47759": 457.0, "40601": 268.0, "51938": 102.0, "5040": 442.0, "78464": 475.0, "3860": 440.0, "32561": 390.0, "21548": 575.0, "9333": 97.0, "71925": 304.0, "14802": 624.0, "5681": 258.0, "60573": 587.0, "16454": 608.0, "21295": 461.0, "62208": 311.0, "13848": 77.0, "35045": 452.0, "46921": 320.0, "61443": 472.0, "29006": 603.0, "13102": 514.0, "5559": 590.0, "45950": 262.0, "67916": 624.0, "34022": 580.0, "55223": 587.0, "68839": 431.0, "79889": 56.0, "54347": 232.0, "64249": 23.0, "33372": 422.0, "43194": 560.0, "80694": 547.0, "68619": 380.0, "22979": 57.0, "36319": 608.0, "47002": 597.0, "2275": 363.0}, "movieId": {"32170": 1498, "83001": 110102, "78180": 64614, "17477": 785, "31043": 1378, "24883": 1206, "74774": 46578, "4576": 198, "34060": 1663, "16897": 745, "55488": 3728, "67956": 7090, "24109": 1197, "67159": 6870, "45226": 2640, "50607": 3100, "60747": 4855, "42091": 2336, "81495": 92694, "45056": 2628, "44858": 2606, "38485": 2025, "25663": 1214, "8738": 352, "30414": 1356, "66415": 6539, "53811": 3481, "42380": 2355, "998": 17, "26024": 1221, "19695": 934, "55332": 3702, "42789": 2396, "59950": 4486, "37752": 2001, "35342": 1748, "15687": 608, "72017": 27838, "653": 10, "54693": 3578, "57434": 4006, "23677": 1190, "16371": 673, "43148": 2416, "10773": 442, "82992": 109850, "21431": 1073, "66851": 6755, "31425": 1393, "52069": 3255, "45342": 2657, "14113": 588, "73504": 37741, "55633": 3742, "75781": 51662, "7065": 300, "72121": 30707, "65608": 6305, "56232": 3809, "32757": 1573, "76701": 55814, "42264": 2353, "3363": 111, "39574": 2105, "37050": 1960, "74316": 44555, "73658": 39292, "17406": 781, "70764": 8807, "40701": 2184, "35251": 1735, "22235": 1092, "46359": 2716, "29799": 1304, "6624": 293, "84107": 149406, "18230": 899, "26958": 1241, "50072": 3045, "4827": 223, "74767": 46578, "2119": 47, "17503": 785, "24147": 1197, "73837": 40819, "14283": 589, "35783": 1846, "45721": 2690, "29068": 1285, "24636": 1200, "66432": 6539, "20346": 1015, "77573": 59832, "83206": 112515, "77980": 62956, "6945": 296, "69735": 8361, "67252": 6874, "74421": 45179, "72403": 31658, "44926": 2617, "3310": 110, "65998": 6377, "31404": 1393, "15640": 608, "21496": 1073, "70601": 8751, "46144": 2707, "64944": 5989, "12284": 508, "55136": 3677, "35493": 1784, "78391": 66371, "33729": 1635, "21152": 1042, "47117": 2788, "59716": 4378, "42798": 2396, "46262": 2712, "13514": 553, "6273": 282, "72897": 33679, "39121": 2078, "36055": 1912, "34370": 1682, "58321": 4085, "30092": 1333, "41522": 2300, "9381": 364, "70078": 8529, "26777": 1237, "9680": 368, "24455": 1198, "53331": 3435, "38715": 2043, "46059": 2706, "70608": 8761, "6116": 272, "73331": 36517, "2034": 46, "21675": 1079, "12873": 529, "26189": 1222, "71296": 8970, "79797": 78088, "62267": 5060, "59938": 4478, "79329": 72733, "42554": 2375, "25125": 1208, "9082": 356, "74709": 46578, "42781": 2396, "81729": 95782, "68345": 7153, "1052": 19, "57321": 3996, "58736": 4226, "64653": 5952, "30347": 1350, "64534": 5940, "11035": 457, "6380": 288, "68569": 7256, "53347": 3435, "69667": 8360, "77110": 57669, "71127": 8958, "79156": 71535, "26419": 1228, "36966": 1957, "18040": 858, "35527": 1784, "84044": 140928, "71193": 8961, "42210": 2352, "10435": 412, "76686": 55765, "79748": 77561, "37441": 1968, "16718": 736, "10046": 377, "12757": 527, "81478": 92420, "44969": 2618, "12522": 520, "34843": 1717, "190": 1, "14499": 590, "11338": 468, "12263": 508, "79299": 72489, "59660": 4370, "70133": 8533, "41321": 2288, "60845": 4878, "24661": 1200, "22794": 1120, "64835": 5956, "40978": 2236, "28029": 1265, "67142": 6870, "68971": 7438, "35071": 1729, "8792": 353, "25181": 1209, "82029": 98491, "76884": 56367, "43282": 2424, "9677": 368, "37257": 1965, "17848": 838, "16094": 648, "81646": 95088, "63730": 5544, "34837": 1717, "32192": 1500, "10450": 417, "52709": 3359, "25532": 1213, "35597": 1792, "26283": 1225, "19325": 923, "35178": 1732, "22375": 1095, "56023": 3791, "1338": 25, "17610": 802, "31987": 1464, "6840": 296, "38848": 2058, "45598": 2683, "15827": 608, "72794": 33493, "40086": 2134, "21162": 1046, "75568": 50005, "48764": 2948, "5623": 260, "47457": 2804, "66885": 6773, "31026": 1377, "80535": 84116, "62388": 5108, "41251": 2278, "69889": 8376, "59990": 4499, "15220": 595, "14745": 592, "22670": 1103, "83108": 111659, "69037": 7438, "19231": 920, "69483": 8012, "23264": 1150, "36704": 1951, "3559": 141, "83303": 112852, "39189": 2081, "69550": 8167, "11617": 480, "5659": 260, "9894": 376, "25749": 1215, "34157": 1673, "5184": 235, "20871": 1035, "58928": 4246, "29008": 1282, "57183": 3992, "41574": 2302, "390": 3, "77798": 60950, "29305": 1291, "32135": 1485, "54053": 3507, "44394": 2571, "80892": 87520, "16330": 670, "42254": 2353, "72369": 31410, "2476": 50, "12338": 508, "8889": 356, "1677": 32, "25724": 1215, "73263": 34542, "36828": 1954, "7399": 317, "69250": 7587, "67458": 6942, "17757": 832, "984": 17, "51466": 3175, "3801": 150, "40982": 2239, "66059": 6378, "3626": 141, "24274": 1198, "23149": 1136, "79654": 76093, "66140": 6385, "53265": 3422, "83066": 111362, "42096": 2336, "81812": 96610, "2899": 89, "39146": 2080, "74570": 45720, "15460": 597, "10309": 380, "56520": 3897, "29073": 1285, "66042": 6377, "7728": 318, "21943": 1086, "44564": 2571, "23148": 1136, "5150": 235, "50858": 3114, "26637": 1233, "72077": 30707, "58242": 4061, "5806": 260, "15530": 597, "5625": 260, "25389": 1210, "25585": 1213, "67889": 7068, "22847": 1125, "63142": 5380, "55249": 3688, "52630": 3341, "12193": 500, "22675": 1103, "47175": 2791, "67026": 6810, "40855": 2194, "60300": 4688, "47008": 2762, "57103": 3980, "50009": 3039, "18839": 912, "47809": 2858, "9094": 356, "81123": 89745, "41070": 2248, "15214": 595, "62494": 5168, "55914": 3755, "73183": 34359, "14056": 588, "40339": 2145, "11747": 480, "61891": 4993, "47287": 2797, "70863": 8874, "9484": 364, "37189": 1962, "47156": 2791, "79010": 70286, "17903": 858, "76667": 55721, "4501": 188, "1680": 32, "70755": 8798, "11715": 480, "77670": 60069, "61675": 4979, "66848": 6754, "82976": 109487, "20306": 1012, "29157": 1287, "82583": 105504, "22344": 1094, "30552": 1358, "80342": 81834, "40218": 2141, "37233": 1963, "3335": 110, "34887": 1721, "41518": 2300, "48026": 2882, "51374": 3174, "17448": 783, "20343": 1014, "35618": 1797, "37056": 1960, "53176": 3418, "81669": 95167, "5332": 246, "5995": 265, "55685": 3751, "11537": 479, "57214": 3994, "55204": 3684, "53209": 3421, "45681": 2687, "17003": 750, "10317": 380, "59173": 4306, "66626": 6662, "83168": 112171, "17556": 800, "50358": 3081, "79281": 72294, "33714": 1629, "82525": 104841, "49091": 2966, "76258": 54272, "27172": 1246, "71912": 27773, "49082": 2964, "18802": 912, "187": 1, "419": 4, "62315": 5064, "52114": 3256, "22748": 1111, "57716": 4018, "31603": 1396, "23675": 1189, "58916": 4246, "48429": 2918, "4929": 230, "25493": 1213, "14875": 593, "32605": 1552, "30557": 1358, "66756": 6711, "911": 16, "56044": 3793, "55123": 3676, "83748": 122900, "21565": 1073, "75136": 48394, "41594": 2302, "39507": 2100, "31412": 1393, "71177": 8961, "77498": 59369, "70141": 8533, "55513": 3730, "44598": 2572, "51087": 3147, "15990": 647, "74698": 46347, "46299": 2712, "68135": 7147, "41728": 2318, "38504": 2028, "51158": 3152, "18831": 912, "71707": 26614, "54000": 3504, "16677": 735, "2913": 94, "30869": 1375, "39738": 2112, "79376": 72998, "57740": 4019, "36641": 1947, "22673": 1103, "63089": 5378, "61495": 4973, "24722": 1202, "19631": 932, "21324": 1060, "35124": 1732, "69158": 7458, "32438": 1527, "8547": 349, "79120": 71462, "75448": 49272, "54574": 3566, "65016": 5991, "40238": 2141, "61312": 4963, "18421": 904, "60694": 4848, "74844": 46976, "42301": 2355, "26257": 1223, "73002": 33794, "71083": 8957, "50558": 3098, "27668": 1258, "12315": 508, "33718": 1633, "70985": 8917, "8283": 344, "1858": 39, "37548": 1994, "55133": 3676, "18351": 903, "24416": 1198, "81844": 96821, "51436": 3175, "5679": 260, "17980": 858, "55489": 3728, "42855": 2396, "83708": 122886, "36607": 1946, "34170": 1673, "40744": 2193, "79123": 71462, "13475": 552, "68614": 7293, "69551": 8167, "79087": 71108, "26923": 1240, "4586": 199, "36950": 1957, "46384": 2716, "82617": 106072, "29403": 1291, "54026": 3505, "22347": 1094, "46613": 2732, "59916": 4467, "4284": 165, "15049": 593, "23648": 1188, "82401": 103253, "19190": 920, "14799": 592, "19849": 948, "56300": 3819, "15710": 608, "71210": 8961, "53812": 3481, "51216": 3158, "18903": 913, "80502": 82931, "66217": 6448, "25881": 1219, "45728": 2690, "57045": 3969, "47906": 2870, "73742": 40629, "17857": 838, "31353": 1391, "47150": 2791, "49536": 2997, "39854": 2115, "206": 1, "10639": 434, "62028": 5004, "524": 6, "71336": 8972, "4343": 165, "2746": 70, "70044": 8528, "43170": 2420, "45095": 2628, "23219": 1148, "46742": 2747, "28653": 1272, "67297": 6879, "7771": 319, "29705": 1302, "66671": 6708, "65505": 6273, "27484": 1252, "20302": 1012, "16674": 735, "3205": 110, "80418": 81847, "2377": 50, "57053": 3969, "50519": 3095, "68541": 7254, "82971": 109487, "37423": 1968, "16463": 709, "64551": 5945, "55312": 3700, "61591": 4975, "40762": 2193, "35233": 1734, "77143": 58047, "33953": 1653, "17234": 780, "75524": 49530, "42562": 2375, "58894": 4246, "73214": 34405, "63556": 5470, "74343": 44665, "1705": 35, "7047": 300, "80363": 81834, "63452": 5445, "13023": 539, "9525": 367, "64915": 5989, "51795": 3213, "60816": 4874, "58235": 4056, "66316": 6538, "4085": 161, "65835": 6365, "70580": 8665, "16938": 748, "31076": 1379, "63963": 5650, "83467": 115713, "33719": 1633, "82492": 104374, "53364": 3438, "60814": 4874, "79395": 72998, "26399": 1227, "45230": 2641, "44767": 2599, "65669": 6333, "53578": 3467, "1570": 32, "20157": 969, "21373": 1061, "9776": 370, "53075": 3408, "62145": 5015, "50154": 3053, "72636": 32840, "79026": 70286, "46280": 2712, "55536": 3734, "19794": 943, "70707": 8784, "38469": 2023, "54791": 3594, "43090": 2410, "65523": 6281, "71655": 26413, "80452": 82169, "49824": 3020, "39076": 2076, "60774": 4865, "40255": 2143, "22585": 1099, "2605": 58, "14211": 589, "71007": 8937, "73424": 37211, "49103": 2966, "83013": 110102, "6135": 273, "5352": 246, "32730": 1569, "68339": 7153, "36546": 1943, "49656": 3005, "39530": 2100, "387": 3, "1865": 39, "41762": 2321, "74771": 46578, "17876": 848, "27317": 1248, "67541": 6947, "83610": 118898, "10983": 454, "42161": 2346, "10405": 410, "59847": 4447, "60061": 4546, "11514": 475, "60050": 4545, "80166": 80549, "37780": 2002, "41273": 2278, "18833": 912, "42133": 2340, "1542": 32, "74688": 46322, "67377": 6934, "64055": 5673, "55602": 3740, "52031": 3253, "84112": 149606, "68396": 7156, "28544": 1270, "4294": 165, "1895": 39, "32224": 1500, "72284": 30816, "58717": 4226, "46455": 2716, "77215": 58559, "69218": 7569, "15718": 608, "16869": 745, "68585": 7265, "11626": 480, "18845": 912, "34303": 1676, "56212": 3801, "52359": 3275, "73489": 37733, "67143": 6870, "81253": 90866, "78012": 63082, "10431": 412, "80683": 85774, "23533": 1183, "67728": 7001, "35483": 1784, "82079": 99007, "66451": 6539, "26728": 1235, "33250": 1608, "44018": 2529, "34292": 1676, "25146": 1208, "72635": 32825, "71094": 8957, "3273": 110, "29438": 1291, "61421": 4963, "12289": 508, "50576": 3098, "40857": 2195, "42107": 2336, "16531": 728, "40256": 2143, "72174": 30793, "60730": 4855, "51495": 3176, "4088": 161, "45477": 2671, "46683": 2739, "55203": 3684, "24599": 1200, "16543": 733, "49735": 3011, "45282": 2648, "19850": 948, "66401": 6539, "14511": 590, "16034": 648, "78513": 68157, "70564": 8665, "12987": 538, "72971": 33794, "7736": 318, "43547": 2467, "26690": 1234, "53796": 3481, "70763": 8807, "20188": 973, "70979": 8917, "23124": 1136, "43291": 2425, "62898": 5349, "30298": 1347, "15486": 597, "80241": 81229, "47919": 2871, "9219": 357, "8712": 350, "72637": 32840, "2717": 63, "14592": 590, "3162": 110, "12957": 534, "66721": 6711, "30920": 1376, "72038": 27873, "11245": 464, "30786": 1374, "28144": 1265, "74046": 42632, "65209": 6016, "46939": 2762, "73970": 41569, "8232": 342, "58453": 4148, "10906": 450, "5719": 260, "7362": 316, "46992": 2762, "49620": 3000, "11796": 480, "79594": 74688, "38054": 2011, "67676": 6979, "29875": 1307, "67312": 6881, "80260": 81562, "74228": 44195, "56965": 3952, "71428": 8984, "18311": 902, "62897": 5349, "36768": 1953, "48756": 2948, "44100": 2539, "7507": 318, "70152": 8542, "72835": 33615, "20760": 1031, "9507": 366, "72143": 30749, "56147": 3793, "67426": 6935, "11273": 466, "50671": 3101, "81344": 91529, "40382": 2150, "59036": 4278, "43276": 2424, "67753": 7011, "25092": 1208, "56707": 3916, "27486": 1252, "29898": 1307, "38095": 2011, "77626": 60069, "2453": 50, "43816": 2502, "70205": 8618, "43347": 2428, "15626": 608, "29394": 1291, "31184": 1385, "29183": 1287, "59903": 4452, "78066": 63113, "33907": 1645, "10880": 446, "67304": 6879, "54803": 3604, "75492": 49314, "11792": 480, "2388": 50, "31830": 1411, "42586": 2378, "52291": 3265, "33103": 1584, "81830": 96811, "77569": 59784, "54099": 3510, "72192": 30793, "10917": 454, "73289": 35836, "77072": 57504, "73086": 34048, "18705": 910, "61276": 4945, "17172": 778, "80967": 88140, "40021": 2132, "22878": 1127, "41327": 2288, "18540": 906, "37878": 2005, "59913": 4465, "75467": 49278, "44147": 2541, "77120": 57669, "34471": 1682, "43848": 2502, "28887": 1278, "27347": 1249, "20092": 968, "10404": 410, "1314": 25, "70090": 8529, "36703": 1951, "17179": 778, "10184": 380, "19881": 950, "57715": 4018, "55792": 3752, "56113": 3793, "67101": 6863, "3941": 151, "44581": 2571, "69465": 7983, "11477": 474, "72344": 31162, "44076": 2533, "35850": 1884, "6350": 288, "34178": 1674, "31990": 1464, "46620": 2732, "3090": 105, "49537": 2997, "16027": 648, "20063": 955, "68812": 7361, "28886": 1278, "17979": 858, "34466": 1682, "23718": 1193, "14320": 589, "61051": 4886, "63426": 5445, "11140": 457, "70967": 8914, "19202": 920, "11279": 466, "67040": 6832, "24626": 1200, "69292": 7713, "52864": 3365, "65730": 6333, "68528": 7254, "34525": 1688, "50514": 3094, "9906": 376, "70086": 8529, "29204": 1288, "17227": 780, "74241": 44195, "50683": 3102, "76934": 56587, "48860": 2953, "46322": 2714, "20271": 1007, "9231": 357, "76059": 53322, "57628": 4014, "3997": 154, "66550": 6618, "55576": 3738, "16066": 648, "31003": 1377, "39049": 2076, "37279": 1965, "11398": 471, "79937": 79132, "32346": 1518, "54912": 3626, "56899": 3949, "36907": 1956, "30985": 1377, "58072": 4033, "11366": 471, "11952": 492, "76961": 56757, "51199": 3156, "32584": 1544, "53767": 3481, "39665": 2109, "77430": 59315, "74648": 45728, "3254": 110, "49479": 2997, "6124": 272, "40": 1, "27543": 1253, "28872": 1278, "17695": 805, "81751": 96079, "47566": 2846, "46321": 2714, "14979": 593, "47759": 2858, "40601": 2174, "51938": 3251, "5040": 231, "78464": 67734, "3860": 150, "32561": 1544, "21548": 1073, "9333": 364, "71925": 27773, "14802": 592, "5681": 260, "60573": 4809, "16454": 707, "21295": 1059, "62208": 5049, "13848": 587, "35045": 1727, "46921": 2762, "61443": 4970, "29006": 1282, "13102": 539, "5559": 253, "45950": 2700, "67916": 7076, "34022": 1653, "55223": 3685, "68839": 7361, "79889": 79091, "54347": 3545, "64249": 5810, "33372": 1610, "43194": 2420, "80694": 85881, "68619": 7293, "22979": 1130, "36319": 1921, "47002": 2762, "2275": 48}, "rating": {"32170": 2.0, "83001": 4.0, "78180": 4.0, "17477": 5.0, "31043": 4.0, "24883": 5.0, "74774": 1.0, "4576": 5.0, "34060": 1.5, "16897": 4.0, "55488": 4.0, "67956": 4.0, "24109": 5.0, "67159": 3.5, "45226": 3.0, "50607": 4.0, "60747": 4.0, "42091": 4.0, "81495": 3.5, "45056": 2.5, "44858": 3.0, "38485": 4.0, "25663": 4.5, "8738": 5.0, "30414": 4.0, "66415": 4.0, "53811": 5.0, "42380": 4.0, "998": 4.0, "26024": 5.0, "19695": 3.0, "55332": 3.0, "42789": 1.5, "59950": 1.0, "37752": 4.0, "35342": 0.5, "15687": 5.0, "72017": 3.0, "653": 4.0, "54693": 4.0, "57434": 4.0, "23677": 1.0, "16371": 4.0, "43148": 3.0, "10773": 1.0, "82992": 2.5, "21431": 4.0, "66851": 4.5, "31425": 5.0, "52069": 3.5, "45342": 3.5, "14113": 2.5, "73504": 4.0, "55633": 3.0, "75781": 3.0, "7065": 4.5, "72121": 5.0, "65608": 3.0, "56232": 3.0, "32757": 3.5, "76701": 3.5, "42264": 4.0, "3363": 4.0, "39574": 3.0, "37050": 4.5, "74316": 4.5, "73658": 4.0, "17406": 3.0, "70764": 4.0, "40701": 4.0, "35251": 4.0, "22235": 4.0, "46359": 3.0, "29799": 5.0, "6624": 4.0, "84107": 4.0, "18230": 3.0, "26958": 4.0, "50072": 2.0, "4827": 4.0, "74767": 4.0, "2119": 4.0, "17503": 3.0, "24147": 4.0, "73837": 1.5, "14283": 3.0, "35783": 5.0, "45721": 3.0, "29068": 4.0, "24636": 2.0, "66432": 3.0, "20346": 5.0, "77573": 3.0, "83206": 2.5, "77980": 4.5, "6945": 5.0, "69735": 4.5, "67252": 4.0, "74421": 3.5, "72403": 4.5, "44926": 4.5, "3310": 3.0, "65998": 4.5, "31404": 5.0, "15640": 4.0, "21496": 4.0, "70601": 5.0, "46144": 3.0, "64944": 3.5, "12284": 3.0, "55136": 4.5, "35493": 2.0, "78391": 4.0, "33729": 4.0, "21152": 4.0, "47117": 4.0, "59716": 4.0, "42798": 3.5, "46262": 4.0, "13514": 3.5, "6273": 2.5, "72897": 2.5, "39121": 3.5, "36055": 4.0, "34370": 3.5, "58321": 4.5, "30092": 4.0, "41522": 5.0, "9381": 3.0, "70078": 4.0, "26777": 4.5, "9680": 2.0, "24455": 5.0, "53331": 4.5, "38715": 5.0, "46059": 4.0, "70608": 3.5, "6116": 3.0, "73331": 1.5, "2034": 3.0, "21675": 3.0, "12873": 2.5, "26189": 3.5, "71296": 3.5, "79797": 3.5, "62267": 5.0, "59938": 3.0, "79329": 4.5, "42554": 4.0, "25125": 5.0, "9082": 5.0, "74709": 5.0, "42781": 4.0, "81729": 3.5, "68345": 5.0, "1052": 1.5, "57321": 5.0, "58736": 4.5, "64653": 5.0, "30347": 3.0, "64534": 2.5, "11035": 4.0, "6380": 4.0, "68569": 4.0, "53347": 4.0, "69667": 4.5, "77110": 4.0, "71127": 3.5, "79156": 2.0, "26419": 4.0, "36966": 5.0, "18040": 4.5, "35527": 3.5, "84044": 2.0, "71193": 3.0, "42210": 3.0, "10435": 4.0, "76686": 3.0, "79748": 2.5, "37441": 3.5, "16718": 4.5, "10046": 3.0, "12757": 4.0, "81478": 4.0, "44969": 4.5, "12522": 3.5, "34843": 4.0, "190": 3.0, "14499": 4.0, "11338": 3.0, "12263": 2.0, "79299": 3.0, "59660": 3.0, "70133": 5.0, "41321": 5.0, "60845": 2.0, "24661": 5.0, "22794": 4.0, "64835": 3.5, "40978": 2.0, "28029": 5.0, "67142": 3.5, "68971": 5.0, "35071": 2.0, "8792": 4.5, "25181": 2.5, "82029": 4.5, "76884": 4.0, "43282": 3.0, "9677": 4.0, "37257": 4.0, "17848": 3.5, "16094": 4.0, "81646": 4.0, "63730": 2.0, "34837": 1.5, "32192": 5.0, "10450": 3.0, "52709": 4.5, "25532": 3.0, "35597": 3.0, "26283": 5.0, "19325": 4.5, "35178": 4.0, "22375": 4.0, "56023": 2.5, "1338": 3.0, "17610": 2.0, "31987": 2.0, "6840": 5.0, "38848": 4.5, "45598": 4.0, "15827": 5.0, "72794": 4.0, "40086": 3.0, "21162": 4.0, "75568": 2.5, "48764": 3.5, "5623": 4.0, "47457": 4.0, "66885": 4.5, "31026": 3.0, "80535": 4.0, "62388": 5.0, "41251": 3.5, "69889": 4.0, "59990": 2.5, "15220": 5.0, "14745": 4.0, "22670": 4.0, "83108": 2.5, "69037": 4.0, "19231": 3.0, "69483": 4.5, "23264": 5.0, "36704": 4.0, "3559": 3.0, "83303": 4.5, "39189": 3.5, "69550": 3.5, "11617": 3.0, "5659": 3.0, "9894": 3.0, "25749": 4.0, "34157": 4.5, "5184": 3.5, "20871": 5.0, "58928": 3.5, "29008": 4.0, "57183": 4.0, "41574": 3.0, "390": 3.0, "77798": 3.5, "29305": 4.0, "32135": 4.0, "54053": 4.0, "44394": 4.5, "80892": 0.5, "16330": 1.0, "42254": 3.0, "72369": 3.5, "2476": 5.0, "12338": 4.0, "8889": 5.0, "1677": 4.0, "25724": 4.0, "73263": 3.5, "36828": 4.0, "7399": 2.0, "69250": 4.0, "67458": 4.0, "17757": 3.0, "984": 3.0, "51466": 5.0, "3801": 4.0, "40982": 4.0, "66059": 2.0, "3626": 4.0, "24274": 4.0, "23149": 3.0, "79654": 4.0, "66140": 3.0, "53265": 4.0, "83066": 4.5, "42096": 4.5, "81812": 3.5, "2899": 3.0, "39146": 3.5, "74570": 3.0, "15460": 5.0, "10309": 2.0, "56520": 5.0, "29073": 5.0, "66042": 3.5, "7728": 5.0, "21943": 4.0, "44564": 4.5, "23148": 5.0, "5150": 1.0, "50858": 4.0, "26637": 4.0, "72077": 3.5, "58242": 3.0, "5806": 4.0, "15530": 4.0, "5625": 5.0, "25389": 4.0, "25585": 4.0, "67889": 4.5, "22847": 4.0, "63142": 3.0, "55249": 3.0, "52630": 4.0, "12193": 2.5, "22675": 3.0, "47175": 5.0, "67026": 3.0, "40855": 3.5, "60300": 5.0, "47008": 4.5, "57103": 2.0, "50009": 3.5, "18839": 3.0, "47809": 4.0, "9094": 5.0, "81123": 5.0, "41070": 4.0, "15214": 4.0, "62494": 4.0, "55914": 2.5, "73183": 3.5, "14056": 5.0, "40339": 4.5, "11747": 4.0, "61891": 5.0, "47287": 4.0, "70863": 3.0, "9484": 4.0, "37189": 5.0, "47156": 4.5, "79010": 3.5, "17903": 2.0, "76667": 4.0, "4501": 2.0, "1680": 5.0, "70755": 4.0, "11715": 3.5, "77670": 5.0, "61675": 4.0, "66848": 3.0, "82976": 4.5, "20306": 4.0, "29157": 5.0, "82583": 4.5, "22344": 5.0, "30552": 3.0, "80342": 4.0, "40218": 3.0, "37233": 5.0, "3335": 4.0, "34887": 2.0, "41518": 5.0, "48026": 2.0, "51374": 5.0, "17448": 1.0, "20343": 5.0, "35618": 5.0, "37056": 4.0, "53176": 4.0, "81669": 3.5, "5332": 5.0, "5995": 4.0, "55685": 3.5, "11537": 4.0, "57214": 3.0, "55204": 3.0, "53209": 1.5, "45681": 2.0, "17003": 5.0, "10317": 3.0, "59173": 4.0, "66626": 4.0, "83168": 2.0, "17556": 4.5, "50358": 4.5, "79281": 4.0, "33714": 5.0, "82525": 4.5, "49091": 3.0, "76258": 4.5, "27172": 4.5, "71912": 1.0, "49082": 3.5, "18802": 3.0, "187": 4.0, "419": 2.0, "62315": 4.0, "52114": 2.5, "22748": 2.0, "57716": 3.5, "31603": 4.0, "23675": 3.5, "58916": 1.5, "48429": 4.0, "4929": 4.0, "25493": 5.0, "14875": 5.0, "32605": 5.0, "30557": 5.0, "66756": 4.5, "911": 4.0, "56044": 5.0, "55123": 2.0, "83748": 4.0, "21565": 3.0, "75136": 4.5, "41594": 4.5, "39507": 3.5, "31412": 4.0, "71177": 4.5, "77498": 1.0, "70141": 3.0, "55513": 4.0, "44598": 2.5, "51087": 4.0, "15990": 5.0, "74698": 4.5, "46299": 2.0, "68135": 3.5, "41728": 5.0, "38504": 3.0, "51158": 3.0, "18831": 4.0, "71707": 4.0, "54000": 4.5, "16677": 4.0, "2913": 4.0, "30869": 4.0, "39738": 3.0, "79376": 2.5, "57740": 3.5, "36641": 2.0, "22673": 3.0, "63089": 1.0, "61495": 5.0, "24722": 4.0, "19631": 5.0, "21324": 5.0, "35124": 5.0, "69158": 4.5, "32438": 3.0, "8547": 4.0, "79120": 4.0, "75448": 4.0, "54574": 3.0, "65016": 5.0, "40238": 5.0, "61312": 4.0, "18421": 4.0, "60694": 5.0, "74844": 4.5, "42301": 3.5, "26257": 4.5, "73002": 4.5, "71083": 4.0, "50558": 4.0, "27668": 3.0, "12315": 5.0, "33718": 4.0, "70985": 2.5, "8283": 3.0, "1858": 3.0, "37548": 2.5, "55133": 3.5, "18351": 5.0, "24416": 5.0, "81844": 4.0, "51436": 5.0, "5679": 4.0, "17980": 3.0, "55489": 3.0, "42855": 3.5, "83708": 0.5, "36607": 5.0, "34170": 4.0, "40744": 2.5, "79123": 4.5, "13475": 3.0, "68614": 0.5, "69551": 1.0, "79087": 4.0, "26923": 3.0, "4586": 3.0, "36950": 4.5, "46384": 4.0, "82617": 5.0, "29403": 4.0, "54026": 4.0, "22347": 4.0, "46613": 2.5, "59916": 0.5, "4284": 3.5, "15049": 5.0, "23648": 5.0, "82401": 2.5, "19190": 4.0, "14799": 3.5, "19849": 4.0, "56300": 4.0, "15710": 5.0, "71210": 3.5, "53812": 5.0, "51216": 4.0, "18903": 4.0, "80502": 3.5, "66217": 3.5, "25881": 4.5, "45728": 4.0, "57045": 4.0, "47906": 3.5, "73742": 4.0, "17857": 5.0, "31353": 4.0, "47150": 5.0, "49536": 3.0, "39854": 3.5, "206": 4.0, "10639": 3.0, "62028": 3.0, "524": 4.0, "71336": 4.0, "4343": 5.0, "2746": 4.0, "70044": 3.5, "43170": 3.0, "45095": 3.0, "23219": 5.0, "46742": 2.0, "28653": 5.0, "67297": 3.0, "7771": 4.0, "29705": 4.5, "66671": 3.5, "65505": 4.5, "27484": 4.5, "20302": 3.0, "16674": 4.0, "3205": 5.0, "80418": 4.5, "2377": 5.0, "57053": 5.0, "50519": 3.0, "68541": 3.0, "82971": 4.5, "37423": 3.5, "16463": 3.0, "64551": 4.0, "55312": 4.0, "61591": 5.0, "40762": 4.0, "35233": 2.0, "77143": 5.0, "33953": 3.5, "17234": 4.0, "75524": 4.0, "42562": 4.0, "58894": 3.5, "73214": 4.0, "63556": 5.0, "74343": 1.0, "1705": 4.0, "7047": 5.0, "80363": 3.0, "63452": 4.5, "13023": 3.0, "9525": 2.0, "64915": 3.0, "51795": 4.0, "60816": 2.0, "58235": 3.0, "66316": 4.0, "4085": 4.0, "65835": 4.5, "70580": 4.0, "16938": 4.0, "31076": 1.0, "63963": 4.0, "83467": 4.0, "33719": 4.0, "82492": 3.5, "53364": 2.0, "60814": 3.5, "79395": 5.0, "26399": 5.0, "45230": 4.0, "44767": 5.0, "65669": 0.5, "53578": 4.0, "1570": 3.5, "20157": 5.0, "21373": 4.0, "9776": 3.0, "53075": 3.5, "62145": 3.5, "50154": 2.0, "72636": 4.0, "79026": 4.0, "46280": 3.0, "55536": 2.5, "19794": 4.0, "70707": 3.5, "38469": 3.5, "54791": 2.0, "43090": 3.0, "65523": 2.5, "71655": 4.0, "80452": 4.5, "49824": 3.5, "39076": 4.0, "60774": 3.5, "40255": 3.0, "22585": 4.0, "2605": 3.0, "14211": 5.0, "71007": 5.0, "73424": 2.5, "49103": 4.0, "83013": 4.5, "6135": 3.0, "5352": 5.0, "32730": 2.0, "68339": 4.5, "36546": 4.0, "49656": 4.0, "39530": 4.0, "387": 4.0, "1865": 3.0, "41762": 4.0, "74771": 4.0, "17876": 3.0, "27317": 3.5, "67541": 3.5, "83610": 4.0, "10983": 3.0, "42161": 3.0, "10405": 3.5, "59847": 0.5, "60061": 3.0, "11514": 2.0, "60050": 3.0, "80166": 3.5, "37780": 4.0, "41273": 3.0, "18833": 4.0, "42133": 3.0, "1542": 3.5, "74688": 4.0, "67377": 2.0, "64055": 2.5, "55602": 2.5, "52031": 3.0, "84112": 4.5, "68396": 4.0, "28544": 4.5, "4294": 4.5, "1895": 3.0, "32224": 4.0, "72284": 3.5, "58717": 3.5, "46455": 3.0, "77215": 5.0, "69218": 3.0, "15718": 5.0, "16869": 4.0, "68585": 3.5, "11626": 4.0, "18845": 5.0, "34303": 4.0, "56212": 5.0, "52359": 4.5, "73489": 5.0, "67143": 3.0, "81253": 4.5, "78012": 3.0, "10431": 3.0, "80683": 3.0, "23533": 2.0, "67728": 4.0, "35483": 4.5, "82079": 4.5, "66451": 5.0, "26728": 5.0, "33250": 3.0, "44018": 5.0, "34292": 3.0, "25146": 4.0, "72635": 4.5, "71094": 3.5, "3273": 5.0, "29438": 4.5, "61421": 4.0, "12289": 4.0, "50576": 4.0, "40857": 3.0, "42107": 4.0, "16531": 4.0, "40256": 1.5, "72174": 3.5, "60730": 4.5, "51495": 5.0, "4088": 5.0, "45477": 3.5, "46683": 5.0, "55203": 3.0, "24599": 1.5, "16543": 4.0, "49735": 4.0, "45282": 4.0, "19850": 3.5, "66401": 3.5, "14511": 3.0, "16034": 3.0, "78513": 3.5, "70564": 3.5, "12987": 4.0, "72971": 4.0, "7736": 4.5, "43547": 4.0, "26690": 5.0, "53796": 4.5, "70763": 4.0, "20188": 5.0, "70979": 2.0, "23124": 4.0, "43291": 4.0, "62898": 3.0, "30298": 5.0, "15486": 3.0, "80241": 3.0, "47919": 4.5, "9219": 3.0, "8712": 3.0, "72637": 5.0, "2717": 4.0, "14592": 3.0, "3162": 4.0, "12957": 4.0, "66721": 4.0, "30920": 4.5, "72038": 2.5, "11245": 4.0, "30786": 3.0, "28144": 4.0, "74046": 4.0, "65209": 4.5, "46939": 4.5, "73970": 4.0, "8232": 5.0, "58453": 4.0, "10906": 3.0, "5719": 5.0, "7362": 1.0, "46992": 2.5, "49620": 5.0, "11796": 2.5, "79594": 2.5, "38054": 4.0, "67676": 3.0, "29875": 2.5, "67312": 1.0, "80260": 5.0, "74228": 4.0, "56965": 5.0, "71428": 2.5, "18311": 3.5, "62897": 3.5, "36768": 5.0, "48756": 2.5, "44100": 3.5, "7507": 3.5, "70152": 3.5, "72835": 2.5, "20760": 2.0, "9507": 3.0, "72143": 3.0, "56147": 5.0, "67426": 3.5, "11273": 3.5, "50671": 4.0, "81344": 4.0, "40382": 3.0, "59036": 1.0, "43276": 3.0, "67753": 3.5, "25092": 5.0, "56707": 4.0, "27486": 5.0, "29898": 4.0, "38095": 4.0, "77626": 4.0, "2453": 3.5, "43816": 4.0, "70205": 4.0, "43347": 3.0, "15626": 5.0, "29394": 2.0, "31184": 2.5, "29183": 5.0, "59903": 2.0, "78066": 3.0, "33907": 4.0, "10880": 3.0, "67304": 2.5, "54803": 3.0, "75492": 3.5, "11792": 4.0, "2388": 5.0, "31830": 5.0, "42586": 2.5, "52291": 4.0, "33103": 2.5, "81830": 4.0, "77569": 3.5, "54099": 3.0, "72192": 5.0, "10917": 3.0, "73289": 4.0, "77072": 3.5, "73086": 2.5, "18705": 4.0, "61276": 5.0, "17172": 4.5, "80967": 4.0, "40021": 2.0, "22878": 5.0, "41327": 3.0, "18540": 4.0, "37878": 3.5, "59913": 4.0, "75467": 3.5, "44147": 4.0, "77120": 5.0, "34471": 3.5, "43848": 3.5, "28887": 4.0, "27347": 5.0, "20092": 5.0, "10404": 3.0, "1314": 1.0, "70090": 5.0, "36703": 2.0, "17179": 4.0, "10184": 4.0, "19881": 5.0, "57715": 3.0, "55792": 1.0, "56113": 4.0, "67101": 4.0, "3941": 5.0, "44581": 5.0, "69465": 3.5, "11477": 3.0, "72344": 2.0, "44076": 4.0, "35850": 4.0, "6350": 4.0, "34178": 5.0, "31990": 1.0, "46620": 5.0, "3090": 3.0, "49537": 4.0, "16027": 4.0, "20063": 5.0, "68812": 5.0, "28886": 1.0, "17979": 4.0, "34466": 1.5, "23718": 4.0, "14320": 4.0, "61051": 1.0, "63426": 3.0, "11140": 3.0, "70967": 4.0, "19202": 2.0, "11279": 2.0, "67040": 3.0, "24626": 4.0, "69292": 4.5, "52864": 2.5, "65730": 4.0, "68528": 4.0, "34525": 3.0, "50514": 3.0, "9906": 3.0, "70086": 5.0, "29204": 4.5, "17227": 3.0, "74241": 3.0, "50683": 3.0, "76934": 2.0, "48860": 1.0, "46322": 3.0, "20271": 2.0, "9231": 5.0, "76059": 3.5, "57628": 4.0, "3997": 4.0, "66550": 4.5, "55576": 3.0, "16066": 3.0, "31003": 2.0, "39049": 5.0, "37279": 5.0, "11398": 5.0, "79937": 3.5, "32346": 3.0, "54912": 3.0, "56899": 4.5, "36907": 5.0, "30985": 1.0, "58072": 3.0, "11366": 4.0, "11952": 2.0, "76961": 4.5, "51199": 2.0, "32584": 4.0, "53767": 4.0, "39665": 5.0, "77430": 4.0, "74648": 4.0, "3254": 3.0, "49479": 4.0, "6124": 4.0, "40": 2.0, "27543": 4.5, "28872": 5.0, "17695": 5.0, "81751": 3.0, "47566": 4.0, "46321": 2.0, "14979": 5.0, "47759": 3.5, "40601": 3.5, "51938": 3.0, "5040": 4.5, "78464": 3.0, "3860": 5.0, "32561": 5.0, "21548": 4.0, "9333": 1.5, "71925": 4.5, "14802": 3.0, "5681": 4.0, "60573": 4.0, "16454": 3.0, "21295": 2.5, "62208": 3.5, "13848": 2.5, "35045": 4.0, "46921": 3.5, "61443": 4.0, "29006": 5.0, "13102": 3.0, "5559": 3.0, "45950": 2.5, "67916": 4.0, "34022": 3.0, "55223": 3.5, "68839": 4.0, "79889": 4.0, "54347": 4.0, "64249": 4.0, "33372": 4.0, "43194": 3.5, "80694": 3.5, "68619": 3.0, "22979": 4.0, "36319": 3.0, "47002": 4.0, "2275": 4.0}, "title": {"32170": "Inventing the Abbotts", "83001": "Captain America: The Winter Soldier", "78180": "Gran Torino", "17477": "Kingpin", "31043": "Young Guns", "24883": "A Clockwork Orange", "74774": "Little Miss Sunshine", "4576": "Strange Days", "34060": "Stripes", "16897": "A Close Shave", "55488": "One False Move", "67956": "Hero", "24109": "The Princess Bride", "67159": "Mystic River", "45226": "Superman", "50607": "A River Runs Through It", "60747": "Dirty Harry", "42091": "Elizabeth", "81495": "Perfect Sense", "45056": "Star Wars: Episode I - The Phantom Menace", "44858": "Idle Hands", "38485": "Lolita", "25663": "Alien", "8738": "Crooklyn", "30414": "Star Trek: First Contact", "66415": "Pirates of the Caribbean: The Curse of the Black Pearl", "53811": "High Fidelity", "42380": "A Bug's Life", "998": "Sense and Sensibility", "26024": "The Godfather: Part II", "19695": "Father of the Bride", "55332": "Mad Max", "42789": "Shakespeare in Love", "59950": "Clean and Sober", "37752": "Lethal Weapon 2", "35342": "Dark City", "15687": "Fargo", "72017": "Mean Creek", "653": "GoldenEye", "54693": "Gladiator", "57434": "The Transformers: The Movie", "23677": "Tie Me Up! Tie Me Down!", "16371": "Space Jam", "43148": "Back to School", "10773": "Demolition Man", "82992": "Need for Speed", "21431": "Willy Wonka & the Chocolate Factory", "66851": "Bubba Ho-tep", "31425": "Jerry Maguire", "52069": "A League of Their Own", "45342": "The Rocky Horror Picture Show", "14113": "Aladdin", "73504": "Capote", "55633": "Battleship Potemkin", "75781": "300", "7065": "Quiz Show", "72121": "Million Dollar Baby", "65608": "Fahrenheit 451", "56232": "What About Bob?", "32757": "Face/Off", "76701": "The Diving Bell and the Butterfly", "42264": "Enemy of the State", "3363": "Taxi Driver", "39574": "Tron", "37050": "The Last Emperor", "74316": "The Lives of Others", "73658": "Good Night, and Good Luck.", "17406": "Stealing Beauty", "70764": "Harold & Kumar Go to White Castle", "40701": "The Trouble with Harry", "35251": "Great Expectations", "22235": "Basic Instinct", "46359": "Ghostbusters", "29799": "Butch Cassidy and the Sundance Kid", "6624": "Leon: The Professional", "84107": "Kung Fu Panda 3", "18230": "Singin' in the Rain", "26958": "Braindead", "50072": "Peter's Friends", "4827": "Clerks", "74767": "Little Miss Sunshine", "2119": "Se7en", "17503": "Kingpin", "24147": "The Princess Bride", "73837": "Walk the Line", "14283": "Terminator 2: Judgment Day", "35783": "Nil by Mouth", "45721": "An Ideal Husband", "29068": "Heathers", "24636": "Aliens", "66432": "Pirates of the Caribbean: The Curse of the Black Pearl", "20346": "Homeward Bound: The Incredible Journey", "77573": "Where the Sidewalk Ends", "83206": "The Babadook", "77980": "Futurama: Bender's Game", "6945": "Pulp Fiction", "69735": "The Day After Tomorrow", "67252": "Kill Bill: Vol. 1", "74421": "The Glass Key", "72403": "Howl's Moving Castle", "44926": "The Mummy", "3310": "Braveheart", "65998": "Finding Nemo", "31404": "Jerry Maguire", "15640": "Fargo", "21496": "Willy Wonka & the Chocolate Factory", "70601": "Gun Crazy", "46144": "Arlington Road", "64944": "Catch Me If You Can", "12284": "Philadelphia", "55136": "Baraka", "35493": "As Good as It Gets", "78391": "Departures", "33729": "The Ice Storm", "21152": "That Thing You Do!", "47117": "And Now for Something Completely Different", "59716": "Sexy Beast", "42798": "Shakespeare in Love", "46262": "Eyes Wide Shut", "13514": "Tombstone", "6273": "Nell", "72897": "Mr. & Mrs. Smith", "39121": "The Jungle Book", "36055": "Out of Sight", "34370": "The Truman Show", "58321": "Beverly Hills Cop", "30092": "The Birds", "41522": "The Producers", "9381": "The Lion King", "70078": "The Terminal", "26777": "The Seventh Seal", "9680": "Maverick", "24455": "Raiders of the Lost Ark", "53331": "Double Indemnity", "38715": "Darby O'Gill and the Little People", "46059": "American Pie", "70608": "The Three Lives of Thomasina", "6116": "The Madness of King George", "73331": "The Constant Gardener", "2034": "How To Make An American Quilt", "21675": "A Fish Called Wanda", "12873": "Searching for Bobby Fischer", "26189": "Full Metal Jacket", "71296": "Finding Neverland", "79797": "Buried", "62267": "M*A*S*H", "59938": "Biloxi Blues", "79329": "Invictus", "42554": "The Money Pit", "25125": "Apocalypse Now", "9082": "Forrest Gump", "74709": "Little Miss Sunshine", "42781": "Shakespeare in Love", "81729": "Dragon Ball Z: Fusion Reborn", "68345": "The Lord of the Rings: The Return of the King", "1052": "Ace Ventura: When Nature Calls", "57321": "Crouching Tiger, Hidden Dragon", "58736": "Memento", "64653": "The Lord of the Rings: The Two Towers", "30347": "The Omen", "64534": "Eating Raoul", "11035": "The Fugitive", "6380": "Natural Born Killers", "68569": "Touching the Void", "53347": "Double Indemnity", "69667": "Shrek 2", "77110": "In Bruges", "71127": "Ray", "79156": "Zombieland", "26419": "Raging Bull", "36966": "Chariots of Fire", "18040": "The Godfather", "35527": "As Good as It Gets", "84044": "Joy", "71193": "The Incredibles", "42210": "The Big Chill", "10435": "The Age of Innocence", "76686": "American Gangster", "79748": "Iron Man 2", "37441": "The Breakfast Club", "16718": "Twister", "10046": "Speed", "12757": "Schindler's List", "81478": "Chronicle", "44969": "The Castle", "12522": "Robin Hood: Men in Tights", "34843": "Scream 2", "190": "Toy Story", "14499": "Dances with Wolves", "11338": "The Englishman Who Went Up a Hill But Came Down a Mountain", "12263": "Philadelphia", "79299": "Ninja Assassin", "59660": "A.I. Artificial Intelligence", "70133": "The Notebook", "41321": "The Thing", "60845": "Donnie Darko", "24661": "Aliens", "22794": "The People vs. Larry Flynt", "64835": "Gangs of New York", "40978": "Simon Birch", "28029": "Groundhog Day", "67142": "Mystic River", "68971": "Kill Bill: Vol. 2", "35071": "Jackie Brown", "8792": "The Crow", "25181": "Once Upon a Time in the West", "82029": "Paperman", "76884": "Juno", "43282": "You've Got Mail", "9677": "Maverick", "37257": "Repo Man", "17848": "Emma", "16094": "Mission: Impossible", "81646": "Safety Not Guaranteed", "63730": "Time After Time", "34837": "Scream 2", "32192": "Grosse Pointe Blank", "10450": "Barcelona", "52709": "Breaking Away", "25532": "GoodFellas", "35597": "U.S. Marshals", "26283": "Amadeus", "19325": "Citizen Kane", "35178": "The Big Lebowski", "22375": "Glengarry Glen Ross", "56023": "Footloose", "1338": "Leaving Las Vegas", "17610": "Phenomenon", "31987": "Lost Highway", "6840": "Pulp Fiction", "38848": "The Negotiator", "45598": "Austin Powers: The Spy Who Shagged Me", "15827": "Fargo", "72794": "Star Wars: Episode III - Revenge of the Sith", "40086": "Weird Science", "21162": "Beautiful Thing", "75568": "Curse of the Golden Flower", "48764": "From Russia with Love", "5623": "Star Wars", "47457": "A Christmas Story", "66885": "The Triplets of Belleville", "31026": "Batman Returns", "80535": "Poetry", "62388": "John Q", "41251": "Ronin", "69889": "Napoleon Dynamite", "59990": "Dirty Rotten Scoundrels", "15220": "Beauty and the Beast", "14745": "Batman", "22670": "Rebel Without a Cause", "83108": "Maleficent", "69037": "Kill Bill: Vol. 2", "19231": "Gone with the Wind", "69483": "Kikujiro", "23264": "The Return of Martin Guerre", "36704": "Oliver!", "3559": "The Birdcage", "83303": "Guardians of the Galaxy", "39189": "The Little Mermaid", "69550": "Captain Blood", "11617": "Jurassic Park", "5659": "Star Wars", "9894": "The River Wild", "25749": "Army of Darkness", "34157": "Boogie Nights", "5184": "Ed Wood", "20871": "The Sound of Music", "58928": "Bridget Jones's Diary", "29008": "Fantasia", "57183": "Malena", "41574": "My Cousin Vinny", "390": "Grumpier Old Men", "77798": "Vicky Cristina Barcelona", "29305": "Indiana Jones and the Last Crusade", "32135": "Liar Liar", "54053": "The Odd Couple", "44394": "The Matrix", "80892": "Transformers: Dark of the Moon", "16330": "The World of Apu", "42254": "Enemy of the State", "72369": "Downfall", "2476": "The Usual Suspects", "12338": "Philadelphia", "8889": "Forrest Gump", "1677": "Twelve Monkeys", "25724": "Army of Darkness", "73263": "Grizzly Man", "36828": "Rocky", "7399": "The Santa Clause", "69250": "Le Samoura\u00ef", "67458": "Love Actually", "17757": "Ransom", "984": "Sense and Sensibility", "51466": "Galaxy Quest", "3801": "Apollo 13", "40982": "Swept Away", "66059": "The Italian Job", "3626": "The Birdcage", "24274": "Raiders of the Lost Ark", "23149": "Monty Python and the Holy Grail", "79654": "How to Train Your Dragon", "66140": "Whale Rider", "53265": "She's Gotta Have It", "83066": "X-Men: Days of Future Past", "42096": "Elizabeth", "81812": "Looper", "2899": "Nick of Time", "39146": "Lady and the Tramp", "74570": "The Devil Wears Prada", "15460": "Pretty Woman", "10309": "True Lies", "56520": "Almost Famous", "29073": "Heathers", "66042": "Finding Nemo", "7728": "The Shawshank Redemption", "21943": "Dial M for Murder", "44564": "The Matrix", "23148": "Monty Python and the Holy Grail", "5150": "Ed Wood", "50858": "Toy Story 2", "26637": "Das Boot", "72077": "Million Dollar Baby", "58242": "The Man in the Moon", "5806": "Star Wars", "15530": "Pretty Woman", "5625": "Star Wars", "25389": "Return of the Jedi", "25585": "GoodFellas", "67889": "Last Year at Marienbad", "22847": "The Return of the Pink Panther", "63142": "The Importance of Being Earnest", "55249": "Porky's", "52630": "Born Yesterday", "12193": "Mrs. Doubtfire", "22675": "Rebel Without a Cause", "47175": "Airplane!", "67026": "Sleeping with the Enemy", "40855": "The Untouchables", "60300": "Black Robe", "47008": "The Sixth Sense", "57103": "Men of Honor", "50009": "Trading Places", "18839": "Casablanca", "47809": "American Beauty", "9094": "Forrest Gump", "81123": "The Avengers", "41070": "Say Anything...", "15214": "Beauty and the Beast", "62494": "Royal Wedding", "55914": "The Perfect Storm", "73183": "Georgy Girl", "14056": "Aladdin", "40339": "Pretty in Pink", "11747": "Jurassic Park", "61891": "The Lord of the Rings: The Fellowship of the Ring", "47287": "Big", "70863": "Shaun of the Dead", "9484": "The Lion King", "37189": "Driving Miss Daisy", "47156": "Airplane!", "79010": "District 9", "17903": "The Godfather", "76667": "Elite Squad", "4501": "The Prophecy", "1680": "Twelve Monkeys", "70755": "Collateral", "11715": "Jurassic Park", "77670": "WALL\u00b7E", "61675": "The Royal Tenenbaums", "66848": "Underworld", "82976": "Interstellar", "20306": "Old Yeller", "29157": "Ben-Hur", "82583": "Captain Phillips", "22344": "The Crying Game", "30552": "Sling Blade", "80342": "Harry Potter and the Deathly Hallows: Part 1", "40218": "An American Tail", "37233": "Take the Money and Run", "3335": "Braveheart", "34887": "Titanic", "41518": "The Producers", "48026": "Jakob the Liar", "51374": "Man on the Moon", "17448": "The Hunchback of Notre Dame", "20343": "Pollyanna", "35618": "Everest", "37056": "The Last Emperor", "53176": "Thelma & Louise", "81669": "Brave", "5332": "Hoop Dreams", "5995": "Like Water for Chocolate", "55685": "Chicken Run", "11537": "Judgment Night", "57214": "Unbreakable", "55204": "The Fabulous Baker Boys", "53209": "Animal House", "45681": "Tarzan", "17003": "Dr. Strangelove or: How I Learned to Stop Worrying and Love the Bomb", "10317": "True Lies", "59173": "Shrek", "66626": "The Pink Panther", "83168": "The Equalizer", "17556": "Lone Star", "50358": "Sleepy Hollow", "79281": "A Christmas Carol", "33714": "The Matchmaker", "82525": "Gravity", "49091": "The Straight Story", "76258": "The Simpsons Movie", "27172": "Dead Poets Society", "71912": "Oldboy", "49082": "Julien Donkey-Boy", "18802": "Casablanca", "187": "Toy Story", "419": "Waiting to Exhale", "62315": "The Count of Monte Cristo", "52114": "Patriot Games", "22748": "Microcosmos", "57716": "What Women Want", "31603": "Sneakers", "23675": "The Thin Blue Line", "58916": "Bridget Jones's Diary", "48429": "Ferris Bueller's Day Off", "4929": "Dolores Claiborne", "25493": "GoodFellas", "14875": "The Silence of the Lambs", "32605": "Con Air", "30557": "Sling Blade", "66756": "Lost in Translation", "911": "Casino", "56044": "X-Men", "55123": "Eraserhead", "83748": "Ant-Man", "21565": "Willy Wonka & the Chocolate Factory", "75136": "Pan's Labyrinth", "41594": "My Cousin Vinny", "39507": "Splash", "31412": "Jerry Maguire", "71177": "The Incredibles", "77498": "Taken", "70141": "The Notebook", "55513": "The Conversation", "44598": "10 Things I Hate About You", "51087": "The Green Mile", "15990": "Courage Under Fire", "74698": "Metal: A Headbanger's Journey", "46299": "Eyes Wide Shut", "68135": "Big Fish", "41728": "Happiness", "38504": "Saving Private Ryan", "51158": "The Last Picture Show", "18831": "Casablanca", "71707": "The Bourne Identity", "54000": "Network", "16677": "Cemetery Man", "2913": "Beautiful Girls", "30869": "Star Trek III: The Search for Spock", "39738": "Grand Canyon", "79376": "Avatar", "57740": "Finding Forrester", "36641": "West Side Story", "22673": "Rebel Without a Cause", "63089": "Star Wars: Episode II - Attack of the Clones", "61495": "Am\u00e9lie", "24722": "Withnail & I", "19631": "An Affair to Remember", "21324": "Swingers", "35124": "The Big Lebowski", "69158": "Troy", "32438": "The Fifth Element", "8547": "Clear and Present Danger", "79120": "The Cove", "75448": "Casino Royale", "54574": "The Big Kahuna", "65016": "Chicago", "40238": "An American Tail", "61312": "Ocean's Eleven", "18421": "Rear Window", "60694": "Mulholland Drive", "74844": "Stranger Than Fiction", "42301": "A Bug's Life", "26257": "A Grand Day Out", "73002": "Batman Begins", "71083": "Saw", "50558": "The Natural", "27668": "The Shining", "12315": "Philadelphia", "33718": "Ulee's Gold", "70985": "Team America: World Police", "8283": "Ace Ventura: Pet Detective", "1858": "Clueless", "37548": "Poltergeist", "55133": "Eraserhead", "18351": "Vertigo", "24416": "Raiders of the Lost Ark", "81844": "The Perks of Being a Wallflower", "51436": "Galaxy Quest", "5679": "Star Wars", "17980": "The Godfather", "55489": "One False Move", "42855": "Shakespeare in Love", "83708": "Star Wars: The Force Awakens", "36607": "Marty", "34170": "Boogie Nights", "40744": "Willow", "79123": "The Cove", "13475": "The Three Musketeers", "68614": "50 First Dates", "69551": "Captain Blood", "79087": "The White Ribbon", "26923": "The Terminator", "4586": "The Umbrellas of Cherbourg", "36950": "Chariots of Fire", "46384": "Ghostbusters", "82617": "Thor: The Dark World", "29403": "Indiana Jones and the Last Crusade", "54026": "No Way Out", "22347": "The Crying Game", "46613": "Jules and Jim", "59916": "The Adventures of Baron Munchausen", "4284": "Die Hard: With a Vengeance", "15049": "The Silence of the Lambs", "23648": "Strictly Ballroom", "82401": "Elysium", "19190": "Gone with the Wind", "14799": "Batman", "19849": "Giant", "56300": "Tampopo", "15710": "Fargo", "71210": "The Incredibles", "53812": "High Fidelity", "51216": "The Emperor and the Assassin", "18903": "The Maltese Falcon", "80502": "The Last Circus", "66217": "The Flight of the Phoenix", "25881": "Psycho", "45728": "An Ideal Husband", "57045": "Pay It Forward", "47906": "Barefoot in the Park", "73742": "Pride & Prejudice", "17857": "Emma", "31353": "Mars Attacks!", "47150": "Airplane!", "49536": "Being John Malkovich", "39854": "Indiana Jones and the Temple of Doom", "206": "Toy Story", "10639": "Cliffhanger", "62028": "The Party", "524": "Heat", "71336": "National Treasure", "4343": "Die Hard: With a Vengeance", "2746": "From Dusk Till Dawn", "70044": "DodgeBall: A True Underdog Story", "43170": "The Karate Kid", "45095": "Star Wars: Episode I - The Phantom Menace", "23219": "The Wrong Trousers", "46742": "The Little Shop of Horrors", "28653": "Patton", "67297": "Runaway Jury", "7771": "Shallow Grave", "29705": "Field of Dreams", "66671": "Matchstick Men", "65505": "In a Lonely Place", "27484": "Chinatown", "20302": "Old Yeller", "16674": "Cemetery Man", "3205": "Braveheart", "80418": "Tangled", "2377": "The Usual Suspects", "57053": "Pay It Forward", "50519": "The Grapes of Wrath", "68541": "The Butterfly Effect", "82971": "Interstellar", "37423": "The Breakfast Club", "16463": "Oliver & Company", "64551": "About Schmidt", "55312": "The Brother from Another Planet", "61591": "Vanilla Sky", "40762": "Willow", "35233": "My Life in Pink", "77143": "Definitely, Maybe", "33953": "Gattaca", "17234": "Independence Day", "75524": "Blood Diamond", "42562": "The Money Pit", "58894": "Bridget Jones's Diary", "73214": "Serenity", "63556": "The Importance of Being Earnest", "74343": "Lucky Number Slevin", "1705": "Carrington", "7047": "Quiz Show", "80363": "Harry Potter and the Deathly Hallows: Part 1", "63452": "Minority Report", "13023": "Sleepless in Seattle", "9525": "The Mask", "64915": "Catch Me If You Can", "51795": "Batman: Mask of the Phantasm", "60816": "K-PAX", "58235": "The Pledge", "66316": "Swimming Pool", "4085": "Crimson Tide", "65835": "The Matrix Reloaded", "70580": "The Bourne Supremacy", "16938": "The Arrival", "31076": "Young Guns II", "63963": "Strange Brew", "83467": "Ex Machina", "33719": "Ulee's Gold", "82492": "About Time", "53364": "Teenage Mutant Ninja Turtles", "60814": "K-PAX", "79395": "Avatar", "26399": "Once Upon a Time in America", "45230": "Superman II", "44767": "Election", "65669": "X2", "53578": "Hud", "1570": "Twelve Monkeys", "20157": "The African Queen", "21373": "Sleepers", "9776": "The Naked Gun 33\u2153: The Final Insult", "53075": "Erin Brockovich", "62145": "Monster's Ball", "50154": "The Messenger: The Story of Joan of Arc", "72636": "Vincent", "79026": "District 9", "46280": "Eyes Wide Shut", "55536": "Prince of the City", "19794": "The Ghost and Mrs. Muir", "70707": "Garden State", "38469": "The Godfather: Part III", "54791": "Center Stage", "43090": "Rocky III", "65523": "Phone Booth", "71655": "Snake in the Eagle's Shadow", "80452": "The Chronicles of Narnia: The Voyage of the Dawn Treader", "49824": "Falling Down", "39076": "Blue Velvet", "60774": "From Hell", "40255": "Legend", "22585": "A Christmas Carol", "2605": "The Postman", "14211": "Terminator 2: Judgment Day", "71007": "Friday Night Lights", "73424": "Go West", "49103": "The Straight Story", "83013": "Captain America: The Winter Soldier", "6135": "Mary Shelley's Frankenstein", "5352": "Hoop Dreams", "32730": "My Best Friend's Wedding", "68339": "The Lord of the Rings: The Return of the King", "36546": "The Greatest Show on Earth", "49656": "The Bone Collector", "39530": "Splash", "387": "Grumpier Old Men", "1865": "Clueless", "41762": "Pleasantville", "74771": "Little Miss Sunshine", "17876": "The Spitfire Grill", "27317": "Touch of Evil", "67541": "Master and Commander: The Far Side of the World", "83610": "A Most Violent Year", "10983": "The Firm", "42161": "The Stepford Wives", "10405": "Addams Family Values", "59847": "Legally Blonde", "60061": "The Vanishing", "11514": "In the Name of the Father", "60050": "Short Circuit", "80166": "Easy A", "37780": "Lethal Weapon 3", "41273": "Ronin", "18833": "Casablanca", "42133": "Meet Joe Black", "1542": "Twelve Monkeys", "74688": "Fearless", "67377": "The Matrix Revolutions", "64055": "Punch-Drunk Love", "55602": "Big Trouble in Little China", "52031": "Wayne's World", "84112": "Bajirao Mastani", "68396": "The Fog of War", "28544": "Back to the Future", "4294": "Die Hard: With a Vengeance", "1895": "Clueless", "32224": "Grosse Pointe Blank", "72284": "The Phantom of the Opera", "58717": "Memento", "46455": "Ghostbusters", "77215": "The Dark Knight", "69218": "You Only Live Twice", "15718": "Fargo", "16869": "A Close Shave", "68585": "The Dreamers", "11626": "Jurassic Park", "18845": "Casablanca", "34303": "Starship Troopers", "56212": "Anatomy of a Murder", "52359": "The Boondock Saints", "73489": "A History of Violence", "67143": "Mystic River", "81253": "Hugo", "78012": "Slumdog Millionaire", "10431": "The Age of Innocence", "80683": "Senna", "23533": "The English Patient", "67728": "Invasion of the Body Snatchers", "35483": "As Good as It Gets", "82079": "Warm Bodies", "66451": "Pirates of the Caribbean: The Curse of the Black Pearl", "26728": "Harold and Maude", "33250": "Air Force One", "44018": "Planet of the Apes", "34292": "Starship Troopers", "25146": "Apocalypse Now", "72635": "Sexmission", "71094": "Saw", "3273": "Braveheart", "29438": "Indiana Jones and the Last Crusade", "61421": "Ocean's Eleven", "12289": "Philadelphia", "50576": "The Natural", "40857": "Dirty Work", "42107": "Elizabeth", "16531": "Cold Comfort Farm", "40256": "Legend", "72174": "Charlie and the Chocolate Factory", "60730": "Dirty Harry", "51495": "The Talented Mr. Ripley", "4088": "Crimson Tide", "45477": "Notting Hill", "46683": "The Color Purple", "55203": "The Fabulous Baker Boys", "24599": "Aliens", "16543": "The Rock", "49735": "They Shoot Horses, Don't They?", "45282": "Frankenstein", "19850": "Giant", "66401": "Pirates of the Caribbean: The Curse of the Black Pearl", "14511": "Dances with Wolves", "16034": "Mission: Impossible", "78513": "Inglourious Basterds", "70564": "The Bourne Supremacy", "12987": "Six Degrees of Separation", "72971": "Batman Begins", "7736": "The Shawshank Redemption", "43547": "The Name of the Rose", "26690": "The Sting", "53796": "High Fidelity", "70763": "Harold & Kumar Go to White Castle", "20188": "Meet John Doe", "70979": "Team America: World Police", "23124": "Monty Python and the Holy Grail", "43291": "The General", "62898": "Spider-Man", "30298": "A Nightmare on Elm Street", "15486": "Pretty Woman", "80241": "RED", "47919": "Deliverance", "9219": "Four Weddings and a Funeral", "8712": "The Client", "72637": "Vincent", "2717": "Don't Be a Menace to South Central While Drinking Your Juice in the Hood", "14592": "Dances with Wolves", "3162": "Braveheart", "12957": "Shadowlands", "66721": "Lost in Translation", "30920": "Star Trek IV: The Voyage Home", "72038": "Metallica: Some Kind of Monster", "11245": "Hard Target", "30786": "Star Trek II: The Wrath of Khan", "28144": "Groundhog Day", "74046": "Sympathy for Lady Vengeance", "65209": "City of God", "46939": "The Sixth Sense", "73970": "King Kong", "8232": "Muriel's Wedding", "58453": "Hannibal", "10906": "With Honors", "5719": "Star Wars", "7362": "Stargate", "46992": "The Sixth Sense", "49620": "Princess Mononoke", "11796": "Jurassic Park", "79594": "Dear John", "38054": "Back to the Future Part II", "67676": "WarGames", "29875": "When Harry Met Sally...", "67312": "Pieces of April", "80260": "127 Hours", "74228": "Thank You for Smoking", "56965": "The Contender", "71428": "Ocean's Twelve", "18311": "Breakfast at Tiffany's", "62897": "Spider-Man", "36768": "The French Connection", "48756": "From Russia with Love", "44100": "Analyze This", "7507": "The Shawshank Redemption", "70152": "A Day at the Races", "72835": "Madagascar", "20760": "Bedknobs and Broomsticks", "9507": "New Nightmare", "72143": "Hotel Rwanda", "56147": "X-Men", "67426": "The Revolution Will Not Be Televised", "11273": "Hot Shots! Part Deux", "50671": "Fatal Attraction", "81344": "The Dark Knight Rises", "40382": "The Gods Must Be Crazy", "59036": "Triumph of the Will", "43276": "You've Got Mail", "67753": "Matador", "25092": "Apocalypse Now", "56707": "Remember the Titans", "27486": "Chinatown", "29898": "When Harry Met Sally...", "38095": "Back to the Future Part II", "77626": "WALL\u00b7E", "2453": "The Usual Suspects", "43816": "Office Space", "70205": "Johnny Guitar", "43347": "The Faculty", "15626": "Fargo", "29394": "Indiana Jones and the Last Crusade", "31184": "Under Siege", "29183": "Ben-Hur", "59903": "Made", "78066": "Quantum of Solace", "33907": "The Devil's Advocate", "10880": "Farewell My Concubine", "67304": "Runaway Jury", "54803": "Gypsy", "75492": "Harsh Times", "11792": "Jurassic Park", "2388": "The Usual Suspects", "31830": "Hamlet", "42586": "Police Academy", "52291": "Hard Boiled", "33103": "Contact", "81830": "End of Watch", "77569": "Kung Fu Panda", "54099": "Frequency", "72192": "Charlie and the Chocolate Factory", "10917": "The Firm", "73289": "The 40 Year Old Virgin", "77072": "The Girl Who Leapt Through Time", "73086": "War of the Worlds", "18705": "Some Like It Hot", "61276": "The Enforcer", "17172": "Trainspotting", "80967": "Captain America: The First Avenger", "40021": "Who's Afraid of Virginia Woolf?", "22878": "The Abyss", "41327": "The Thing", "18540": "Gaslight", "37878": "The Goonies", "59913": "The Accused", "75467": "D\u00e9j\u00e0 Vu", "44147": "Cruel Intentions", "77120": "In Bruges", "34471": "The Truman Show", "43848": "Office Space", "28887": "Young Frankenstein", "27347": "La Femme Nikita", "20092": "Night of the Living Dead", "10404": "Addams Family Values", "1314": "Leaving Las Vegas", "70090": "The Terminal", "36703": "Oliver!", "17179": "Trainspotting", "10184": "True Lies", "19881": "The Thin Man", "57715": "What Women Want", "55792": "Me, Myself & Irene", "56113": "X-Men", "67101": "School of Rock", "3941": "Rob Roy", "44581": "The Matrix", "69465": "Broadway Danny Rose", "11477": "In the Line of Fire", "72344": "The Life and Death of Peter Sellers", "44076": "Escape from the Planet of the Apes", "35850": "Fear and Loathing in Las Vegas", "6350": "Natural Born Killers", "34178": "Witness", "31990": "Lost Highway", "46620": "Jules and Jim", "3090": "The Bridges of Madison County", "49537": "Being John Malkovich", "16027": "Mission: Impossible", "20063": "Bringing Up Baby", "68812": "Eternal Sunshine of the Spotless Mind", "28886": "Young Frankenstein", "17979": "The Godfather", "34466": "The Truman Show", "23718": "One Flew Over the Cuckoo's Nest", "14320": "Terminator 2: Judgment Day", "61051": "Monsters, Inc.", "63426": "Minority Report", "11140": "The Fugitive", "70967": "Primer", "19202": "Gone with the Wind", "11279": "Hot Shots! Part Deux", "67040": "Regarding Henry", "24626": "Aliens", "69292": "Cat People", "52864": "The Searchers", "65730": "X2", "68528": "The Butterfly Effect", "34525": "Anastasia", "50514": "Maurice", "9906": "The River Wild", "70086": "The Terminal", "29204": "This Is Spinal Tap", "17227": "Independence Day", "74241": "Thank You for Smoking", "50683": "Jagged Edge", "76934": "The Bucket List", "48860": "Home Alone 2: Lost in New York", "46322": "The Wood", "20271": "The Apple Dumpling Gang", "9231": "Four Weddings and a Funeral", "76059": "Ocean's Thirteen", "57628": "Chocolat", "3997": "Belle de Jour", "66550": "Shaolin Soccer", "55576": "The Sugarland Express", "16066": "Mission: Impossible", "31003": "Batman Returns", "39049": "Blue Velvet", "37279": "Repo Man", "11398": "The Hudsucker Proxy", "79937": "Inception", "32346": "Breakdown", "54912": "8 \u00bd Women", "56899": "Requiem for a Dream", "36907": "Ordinary People", "30985": "Batman Returns", "58072": "Thirteen Days", "11366": "The Hudsucker Proxy", "11952": "Manhattan Murder Mystery", "76961": "Sweeney Todd: The Demon Barber of Fleet Street", "51199": "Bicentennial Man", "32584": "The Lost World: Jurassic Park", "53767": "High Fidelity", "39665": "The Jerk", "77430": "Iron Man", "74648": "Clerks II", "3254": "Braveheart", "49479": "Being John Malkovich", "6124": "The Madness of King George", "40": "Toy Story", "27543": "The Day the Earth Stood Still", "28872": "Young Frankenstein", "17695": "A Time to Kill", "81751": "Skyfall", "47566": "The Adventures of Milo and Otis", "46321": "The Wood", "14979": "The Silence of the Lambs", "47759": "American Beauty", "40601": "Beetlejuice", "51938": "Agnes of God", "5040": "Dumb and Dumber", "78464": "Adventureland", "3860": "Apollo 13", "32561": "The Lost World: Jurassic Park", "21548": "Willy Wonka & the Chocolate Factory", "9333": "The Lion King", "71925": "Oldboy", "14802": "Batman", "5681": "Star Wars", "60573": "Silkwood", "16454": "Mulholland Falls", "21295": "Romeo + Juliet", "62208": "48 Hrs.", "13848": "Ghost", "35045": "The Horse Whisperer", "46921": "The Sixth Sense", "61443": "The Blue Angel", "29006": "Fantasia", "13102": "Sleepless in Seattle", "5559": "Interview with the Vampire", "45950": "South Park: Bigger, Longer & Uncut", "67916": "Bullitt", "34022": "Gattaca", "55223": "Prizzi's Honor", "68839": "Eternal Sunshine of the Spotless Mind", "79889": "Despicable Me", "54347": "Cabaret", "64249": "8 Mile", "33372": "The Hunt for Red October", "43194": "The Karate Kid", "80694": "Win Win", "68619": "50 First Dates", "22979": "The Howling", "36319": "Pi", "47002": "The Sixth Sense", "2275": "Pocahontas"}}
    df3 = pd.DataFrame(data=d)
    print("Sample data is obtained from MovieLens by GroupLens Research")
    return df3