"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.filter");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.object.create");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.get-prototype-of");

require("core-js/modules/es.object.set-prototype-of");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.promise");

require("core-js/modules/es.reflect.construct");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewScheduledJobs = void 0;

require("regenerator-runtime/runtime");

var _apputils = require("@jupyterlab/apputils");

var _api = require("./api");

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Jobs = /*#__PURE__*/function (_React$Component) {
  _inherits(Jobs, _React$Component);

  var _super = _createSuper(Jobs);

  function Jobs() {
    var _this;

    _classCallCheck(this, Jobs);

    _this = _super.call(this);
    _this.state = {
      jobs: []
    };
    return _this;
  }

  _createClass(Jobs, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.getScheduledJobs();
    }
  }, {
    key: "getScheduledJobs",
    value: function () {
      var _getScheduledJobs = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var data;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return (0, _api.requestAPI)('list');

              case 3:
                data = _context.sent;

                if ("data" in data) {
                  this.setState({
                    jobs: data.data
                  });
                }

                console.log("data", data);
                _context.next = 11;
                break;

              case 8:
                _context.prev = 8;
                _context.t0 = _context["catch"](0);
                console.error("Error fetching jobs: ".concat(_context.t0));

              case 11:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 8]]);
      }));

      function getScheduledJobs() {
        return _getScheduledJobs.apply(this, arguments);
      }

      return getScheduledJobs;
    }()
  }, {
    key: "deleteJob",
    value: function () {
      var _deleteJob = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(schedule, script) {
        var dataToSend, reply, updatedJobs;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                dataToSend = {
                  script: script,
                  schedule: schedule
                };
                _context2.prev = 1;
                _context2.next = 4;
                return (0, _api.requestAPI)('delete', {
                  body: JSON.stringify(dataToSend),
                  method: 'POST'
                });

              case 4:
                reply = _context2.sent;
                console.log(reply); // delete it from the state object

                updatedJobs = this.state.jobs.filter(function (job) {
                  return job.script == (script && job.schedule == schedule);
                });
                this.setState({
                  jobs: updatedJobs
                });
                _context2.next = 13;
                break;

              case 10:
                _context2.prev = 10;
                _context2.t0 = _context2["catch"](1);
                console.error("Error sending delete: ".concat(_context2.t0));

              case 13:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[1, 10]]);
      }));

      function deleteJob(_x, _x2) {
        return _deleteJob.apply(this, arguments);
      }

      return deleteJob;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      return /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement("table", {
        style: {
          "border": "1px solid black",
          "borderCollapse": "collapse"
        }
      }, /*#__PURE__*/_react["default"].createElement("thead", null, /*#__PURE__*/_react["default"].createElement("tr", {
        style: {
          "border": "1px solid black"
        }
      }, /*#__PURE__*/_react["default"].createElement("th", {
        style: {
          "border": "1px solid black"
        }
      }, "Schedule"), /*#__PURE__*/_react["default"].createElement("th", {
        style: {
          "border": "1px solid black"
        }
      }, "Script"), /*#__PURE__*/_react["default"].createElement("th", {
        style: {
          "border": "1px solid black"
        }
      }, "Command"), /*#__PURE__*/_react["default"].createElement("th", {
        style: {
          "border": "1px solid black"
        }
      }, "Log Location"), /*#__PURE__*/_react["default"].createElement("th", {
        style: {
          "border": "1px solid black"
        }
      }, "Delete"))), /*#__PURE__*/_react["default"].createElement("tbody", null, this.state.jobs.map(function (job, i) {
        return /*#__PURE__*/_react["default"].createElement("tr", {
          key: i,
          style: {
            "border": "1px solid black"
          }
        }, /*#__PURE__*/_react["default"].createElement("td", {
          style: {
            "border": "1px solid black"
          }
        }, job.schedule), /*#__PURE__*/_react["default"].createElement("td", {
          style: {
            "border": "1px solid black"
          }
        }, job.script), /*#__PURE__*/_react["default"].createElement("td", {
          style: {
            "border": "1px solid black"
          }
        }, job.command), /*#__PURE__*/_react["default"].createElement("td", {
          style: {
            "border": "1px solid black"
          }
        }, job.log_file), /*#__PURE__*/_react["default"].createElement("td", {
          style: {
            "border": "1px solid black"
          }
        }, /*#__PURE__*/_react["default"].createElement("button", {
          onClick: function onClick() {
            _this2.deleteJob(job.schedule, job.script);
          }
        }, "X")));
      }))));
    }
  }]);

  return Jobs;
}(_react["default"].Component);
/*
table {
  border-collapse: collapse;
}

table, th, td {
  border: 1px solid black;
}
*/

/**
 * A Counter Lumino Widget that wraps a CounterComponent.
 */


var ViewScheduledJobs = /*#__PURE__*/function (_ReactWidget) {
  _inherits(ViewScheduledJobs, _ReactWidget);

  var _super2 = _createSuper(ViewScheduledJobs);

  function ViewScheduledJobs() {
    var _this3;

    _classCallCheck(this, ViewScheduledJobs);

    _this3 = _super2.call(this);

    _this3.addClass('ReactWidget');

    return _this3;
  }

  _createClass(ViewScheduledJobs, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react["default"].createElement(Jobs, null);
    }
  }]);

  return ViewScheduledJobs;
}(_apputils.ReactWidget);

exports.ViewScheduledJobs = ViewScheduledJobs;