"use strict";

require("core-js/modules/es.array.concat");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.promise");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

require("regenerator-runtime/runtime");

var _application = require("@jupyterlab/application");

var _mainmenu = require("@jupyterlab/mainmenu");

var _widgets = require("@lumino/widgets");

var _apputils = require("@jupyterlab/apputils");

var _ShowJobs = require("./ShowJobs.js");

var _AddJob = require("./AddJob.js");

var _filebrowser = require("@jupyterlab/filebrowser");

var _uiComponents = require("@jupyterlab/ui-components");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

require('../style/plugin.css');

/**
 * Initialization data for the main menu example.
 */
var extension = {
  id: 'jupyterlab_scheduler',
  autoStart: true,
  requires: [_apputils.ICommandPalette, _mainmenu.IMainMenu, _filebrowser.IFileBrowserFactory],
  activate: function () {
    var _activate = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(app, palette, mainMenu, factory) {
      var shell, commands, schedulerMenu, command;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              shell = app.shell, commands = app.commands;
              console.log('JupyterLab extension jupyterlab_scheduler is activated!');
              /**
               * Create a menu 
               */

              schedulerMenu = new _widgets.Menu({
                commands: commands
              });
              schedulerMenu.title.label = 'Cron Scheduler';
              mainMenu.addMenu(schedulerMenu, {
                rank: 80
              });
              /**
               * View for seeing Scheduled Jobs & Canceling them
               */
              // Add a command

              command = 'show-cron';
              commands.addCommand(command, {
                label: 'Show cronjobs',
                caption: 'Show cronjobs',
                execute: function execute(args) {
                  // Create widget for displaying jobs & attach
                  var content = new _ShowJobs.ViewScheduledJobs(shell);
                  var widget = new _apputils.MainAreaWidget({
                    content: content
                  });
                  widget.title.label = 'Scheduled Jobs';
                  widget.title.closable = true;
                  widget.id = 'scheduled-jobs';
                  shell.add(widget, 'main');
                }
              }); // Add the command to the menu

              schedulerMenu.addItem({
                command: command,
                args: {
                  origin: 'from the menu'
                }
              });
              /**
               * View for Scheduling jobs
               */
              // Add command for scheduling a job

              app.commands.addCommand('jupyterlab_scheduler/add-job:open', {
                label: 'Schedule',
                caption: "Schedule Recurring Exectuion of File",
                icon: _uiComponents.runIcon,
                execute: function execute() {
                  // Create dialog for scheduling job
                  var file = factory.tracker.currentWidget.selectedItems().next();

                  var fullPath = app._paths.directories.serverRoot.concat("/", file.path);

                  var addJob = new _AddJob.AddJob(file.name, fullPath);
                  (0, _apputils.showDialog)({
                    title: "Schedule Recurring Execution for: ".concat(file.name),
                    body: addJob,
                    buttons: [_apputils.Dialog.okButton()]
                  })["catch"](function (e) {
                    return console.log(e);
                  });
                }
              }); // Add command to the context menu

              app.contextMenu.addItem({
                command: 'jupyterlab_scheduler/add-job:open',
                selector: '.jp-DirListing-item',
                rank: 0
              });

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function activate(_x, _x2, _x3, _x4) {
      return _activate.apply(this, arguments);
    }

    return activate;
  }()
};
var _default = extension;
exports["default"] = _default;