"use strict";

require("core-js/modules/es.array.join");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.promise");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestAPI = requestAPI;

require("regenerator-runtime/runtime");

var _coreutils = require("@jupyterlab/coreutils");

var _services = require("@jupyterlab/services");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
function requestAPI() {
  return _requestAPI.apply(this, arguments);
}

function _requestAPI() {
  _requestAPI = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    var endPoint,
        init,
        settings,
        requestUrl,
        response,
        data,
        _args = arguments;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            endPoint = _args.length > 0 && _args[0] !== undefined ? _args[0] : '';
            init = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
            // Make request to Jupyter API
            settings = _services.ServerConnection.makeSettings();
            requestUrl = _coreutils.URLExt.join(settings.baseUrl, 'jupyterlab_scheduler', endPoint);
            _context.prev = 4;
            _context.next = 7;
            return _services.ServerConnection.makeRequest(requestUrl, init, settings);

          case 7:
            response = _context.sent;
            _context.next = 13;
            break;

          case 10:
            _context.prev = 10;
            _context.t0 = _context["catch"](4);
            throw new _services.ServerConnection.NetworkError(_context.t0);

          case 13:
            _context.next = 15;
            return response.json();

          case 15:
            data = _context.sent;

            if (response.ok) {
              _context.next = 18;
              break;
            }

            throw new _services.ServerConnection.ResponseError(response, data.message);

          case 18:
            return _context.abrupt("return", data);

          case 19:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[4, 10]]);
  }));
  return _requestAPI.apply(this, arguments);
}