<div align="center">
<img src="https://github.com/anzhi0708/yeongnok/blob/main/logo.png" />
</div>

<div align="center">
데이터를 갖고 노는 것이 아닙니다 교수님
<br>
아닌가...? ? 아니.겠.쥬....?
</div>

# yeongnok 影錄

Korean National Assembly VOD (**영**상회의**록**) crawler, and more

## Install

```bash
pip install yeongnok
```

## Usage

### List

```python
>>> from yeongnok import *
>>> 
>>> List(20)
<20th Congressman List (male: 267; female: 53; total: 320)>
>>> 
>>> List(19)
<19th Congressman List (male: 278; female: 54; total: 332)>
>>> 
>>> "문재인" in List(19)
True
>>> 
>>> List(7)[0]
Congressman(generation=7, name='고재필', party='민주공화당', group=[], region='전남 담양,장성군', gender='남', n=4, how='지역구')
>>> for person in List(20):
...     if person.is_female:
...             print(person)
...
Congressman(generation=20, name='권미혁', party='더불어민주당', group=[], region='비례대표', gender='여', n=1, how='지역구')
Congressman(generation=20, name='권은희', party='국민의당', group=[], region='광주 광산구을', gender='여', n=3, how='지역구')
Congressman(generation=20, name='김삼화', party='국민의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='김상희', party='더불어민주당', group=[], region='경기 부천시소사구', gender='여', n=4, how='지역구')
Congressman(generation=20, name='김수민', party='국민의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='김순례', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='김승희', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='김영주', party='더불어민주당', group=[], region='서울 영등포구갑', gender='여', n=4, how='지역구')
Congressman(generation=20, name='김정재', party='새누리당', group=[], region='경북 포항시북구', gender='여', n=2, how='지역구')
Congressman(generation=20, name='김현미', party='더불어민주당', group=[], region='경기 고양시정', gender='여', n=3, how='지역구')
Congressman(generation=20, name='김현아', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='나경원', party='새누리당', group=[], region='서울 동작구을', gender='여', n=4, how='지역구')
Congressman(generation=20, name='남인순', party='더불어민주당', group=[], region='서울 송파구병', gender='여', n=3, how='지역구')
Congressman(generation=20, name='문미옥', party='더불어민주당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='박경미', party='더불어민주당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='박선숙', party='국민의당', group=[], region='비례대표', gender='여', n=2, how='비례대표')
Congressman(generation=20, name='박순자', party='새누리당', group=[], region='경기 안산시단원구을', gender='여', n=3, how='지역구')
Congressman(generation=20, name='박영선', party='더불어민주당', group=[], region='서울 구로구을', gender='여', n=4, how='지역구')
Congressman(generation=20, name='박인숙', party='새누리당', group=[], region='서울 송파구갑', gender='여', n=2, how='지역구')
Congressman(generation=20, name='박주현', party='국민의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='백혜련', party='더불어민주당', group=[], region='경기 수원시을', gender='여', n=2, how='지역구')
Congressman(generation=20, name='서영교', party='더불어민주당', group=[], region='서울 중랑구갑', gender='여', n=3, how='지역구')
Congressman(generation=20, name='손혜원', party='더불어민주당', group=[], region='서울 마포구을', gender='여', n=1, how='지역구')
Congressman(generation=20, name='송옥주', party='더불어민주당', group=[], region='비례대표', gender='여', n=2, how='비례대표')
Congressman(generation=20, name='송희경', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='신보라', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='신용현', party='국민의당', group=[], region='비례대표', gender='여', n=1, how='지역구')
Congressman(generation=20, name='심상정', party='정의당', group=[], region='경기 고양시갑', gender='여', n=4, how='지역구')
Congressman(generation=20, name='유승희', party='더불어민주당', group=[], region='서울 성북구갑', gender='여', n=3, how='지역구')
Congressman(generation=20, name='유은혜', party='더불어민주당', group=[], region='경기 고양시병', gender='여', n=2, how='지역구')
Congressman(generation=20, name='윤종필', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='이언주', party='더불어민주당', group=[], region='경기 광명시을', gender='여', n=2, how='지역구')
Congressman(generation=20, name='이은재', party='새누리당', group=[], region='서울 강남구병', gender='여', n=2, how='지역구')
Congressman(generation=20, name='이재정', party='더불어민주당', group=[], region='비례대표', gender='여', n=2, how='비례대표')
Congressman(generation=20, name='이정미', party='정의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='이혜훈', party='새누리당', group=[], region='서울 서초구갑', gender='여', n=3, how='지역구')
Congressman(generation=20, name='인재근', party='더불어민주당', group=[], region='서울 도봉구갑', gender='여', n=3, how='지역구')
Congressman(generation=20, name='임이자', party='새누리당', group=[], region='비례대표', gender='여', n=2, how='비례대표')
Congressman(generation=20, name='장정숙', party='국민의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='전현희', party='더불어민주당', group=[], region='서울 강남구을', gender='여', n=2, how='지역구')
Congressman(generation=20, name='전혜숙', party='새누리당', group=[], region='서울 광진구갑', gender='여', n=3, how='지역구')
Congressman(generation=20, name='전희경', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='정은혜', party='더불어민주당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='정춘숙', party='더불어민주당', group=[], region='비례대표', gender='여', n=2, how='비례대표')
Congressman(generation=20, name='제윤경', party='더불어민주당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='조배숙', party='국민의당', group=[], region='전북 익산시을 ', gender='여', n=4, how='지역구')
Congressman(generation=20, name='진선미', party='더불어민주당', group=[], region='서울 강동구갑', gender='여', n=3, how='지역구')
Congressman(generation=20, name='최도자', party='국민의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='최연혜', party='새누리당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='추미애', party='더불어민주당', group=[], region='서울 광진구을', gender='여', n=5, how='지역구')
Congressman(generation=20, name='추혜선', party='정의당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
Congressman(generation=20, name='한정애', party='더불어민주당', group=[], region='서울 강서구병', gender='여', n=3, how='지역구')
Congressman(generation=20, name='허윤정', party='더불어민주당', group=[], region='비례대표', gender='여', n=1, how='비례대표')
>>>
>>> 
>>>
```

### analyzer

```python
>>> from yeongnok import *
>>> for person in List(20):
...     if person.is_female:
...             get_activities_of(person, at=19)
...
[ANALYZER] 19th_20220706-234320.csv
[SCANNING] ./19th_20220706-234320.csv
           Searching 권미혁's activities at 19th assembly...

[ANALYZER] 19th_20220706-234320.csv
[SCANNING] ./19th_20220706-234320.csv
           Searching 권은희's activities at 19th assembly...

['11:53:28 권은희 질의, 2015-12-01 10:12 미방위, 제337회 국회(정기회) 제09차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 고대영 사장(한국방송공사)  답변 / 우종범 사장(한국교육방송공사)  답변', '16:38:55 권은희 질의, 2015-11-25 15:25 국방위, 제337회 국회(정기회) 제08차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '16:35:23 권은희 발언, 2015-11-18 14:07 국방위, 제337회 국회(정기회) 제07차 국방위원회, 권은희 위원(새정치민주연합)  발언', '11:48:17 권은희 질의, 2015-11-16 10:06 미방위, 제337회 국회(정기회) 제06차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 고대영 사장후보자(한국방송공사)  답변', '11:14:53 권은희 질의, 2015-11-09 10:19 예결위, 제337회 국회(정기회) 제12차 예산결산특별위원회, 권은희 위원(새정치민주연합)  질의 / 박승춘 처장(국가보훈처)  답변 / 장명진 청장(방위사업청)  답변 / 박춘섭 실장(기획재정부)  답변 / 한민구 장관(국방부)  답변', '11:56:58 권은희 질의, 2015-10-30 10:12 국방위, 제337회 국회(정기회) 제05차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 장명진 청장(방위사업청)  답변 / 정두언 위원장(새누리당)  발언 / 한민구 장관(국방부)  답변', '12:15:14 권은희 질의, 2015-10-29 10:07 예결위, 제337회 국회(정기회) 제05차 예산결산특별위원회, 권은희 위원(새정치민주연합)  질의 / 최경환 장관(기획재정부)  답변 / 황우여 장관(교육부)  답변 / 황교안 국무총리  답변', '11:11:50 권은희 발언, 2015-10-28 10:07 예결위, 제337회 국회(정기회) 제04차 예산결산특별위원회, 권은희 위원(새정치민주연합)  발언 / 최경환 장관(기획재정부)  발언', '16:59:42 권은희 질의, 2015-10-27 15:07 예결위, 제337회 국회(정기회) 제03차 예산결산특별위원회, 권은희 위원(새정치민주연합)  질의 / 최천근 행정학과 교수(한성대학교)  답변 / 정도진 회계학과 교수(중앙대학교)  답변', '11:01:33 권은희 질의, 2015-10-23 10:05 운영위, 2015년도 국정감사(대통령비서실 등), 권은희 위원(새정치민주연합)  질의 / 김관진 실장(국가안보실)  답변 / 원유철 위원장(새누리당)  발언', '16:59:05 권은희 질의, 2015-10-22 16:03 운영위, 2015년도 국정감사(국회사무처 등), 권은희 위원(새정치민주연합)  질의 / 박형준 사무총장(국회사무처)  답변 / 임성호 처장(국회입법조사처)  답변', '10:10:24 권은희 인사, 2015-10-22 10:10 운영위, 2015년도 국정감사(국가인권위원회), 권은희 위원(새정치민주연합)  인사', '11:11:06 권은희 질의, 2015-10-22 10:10 운영위, 2015년도 국정감사(국가인권위원회), 권은희 위원(새정치민주연합)  질의 / 이성호 위원장(국가인권위원회)  답변', '11:30:33 권은희 질의, 2015-10-22 10:10 운영위, 2015년도 국정감사(국가인권위원회), 권은희 위원(새누리당)  질의 / 이성호 위원장(국가인권위원회)  답변', '15:18:29 권은희 질의, 2015-10-19 14:13 국방위, 제337회 국회(정기회) 제04차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변 / 장명진 청장(방위사업청)  답변', '11:11:26 권은희 질의, 2015-10-08 10:36 미방위, 2015년도 국정감사(미래창조과학부), 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변', '10:35:33 권은희 질의, 2015-10-08 10:05 국방위, 2015년도 국정감사(국방부 등), 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변 / 정두언 위원장(새누리당)  발언', '15:08:09 권은희 질의, 2015-10-06 14:46 미방위, 2015년도 국정감사(방송통신위원회), 권은희 위원(새누리당)  질의 / 최성준 위원장(방송통신위원회)  답변 / 박효종 위원장(방송통신심의위원회)  답변', '10:46:41 권은희 질의, 2015-10-06 10:19 미방위, 2015년도 국정감사(원자력안전위원회), 권은희 위원(새누리당)  질의 / 조병옥 품질안전본부장(한국수력원자력)  답변 / 이은철 위원장(원자력안전위원회)  답변', '11:24:35 권은희 질의, 2015-10-05 10:00 미방위, 2015년도 국정감사(한국방송공사), 권은희 위원(새누리당)  질의 / 조대현 사장(한국방송공사)  답변 / 허원제 부위원장(방송통신위원회)  답변', '11:19:45 권은희 질의, 2015-10-02 10:07 국방위, 2015년도 국정감사(군인공제회), 권은희 위원(새정치민주연합)  질의 / 이상돈 이사장(군인공제회)  답변', '12:57:02 권은희 질의, 2015-10-02 10:07 국방위, 2015년도 국정감사(군인공제회), 권은희 위원(새정치민주연합)  질의 / 이상돈 이사장(군인공제회)  답변', '11:31:57 권은희 질의, 2015-09-21 10:08 미방위, 2015년도 국정감사(정보통신산업진흥원 등), 권은희 위원(새누리당)  질의 / 서병조 원장(한국정보화진흥원)  답변 / 백기승 원장(한국인터넷진흥원)  답변 / 윤종록 원장(정보통신산업진흥원)  답변', '11:45:24 권은희 질의, 2015-09-17 10:00 미방위, 2015년도 국정감사(국가과학기술연구회 등), 권은희 위원(새누리당)  질의 / 이상천 이사장(국가과학기술연구회)  답변 / 오태광 원장(한국생명공학연구원)  답변 / 김광호 소장(국가보안기술연구소)  답변', '15:43:40 권은희 질의, 2015-09-14 14:05 국방위, 2015년도 국정감사(병무청), 권은희 위원(새정치민주연합)  질의 / 박창명 청장(병무청)  답변', '         권은희 질의, 2015-09-14 10:00 미방위, 2015년도 국정감사(미래창조과학부 등), 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변', '         권은희 질의, 2015-09-10 10:00 국방위, 2015년도 국정감사(국방부 등), 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변 / 이학기 유해발굴감식단장(국방부)  답변', '10:53:10 권은희 질의, 2015-08-12 10:06 국방위, 제336회 국회(임시회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변 / 엄기학 작전본부장(합동참모본부)  답변', '10:42:50 권은희 질의, 2015-08-11 10:11 운영위, 제336회 국회(임시회) 제01차 국회운영위원회, 권은희 위원(새누리당) 질의 / 이성호 공직후보자 답변', '15:00:25 권은희 질의, 2015-07-27 14:09 미방위, 제335회 국회(임시회) 제01차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변', '17:16:12 권은희 질의, 2015-07-27 14:09 미방위, 제335회 국회(임시회) 제01차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변', '15:11:45 권은희 질의, 2015-07-14 14:13 국방위, 제335회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 유명상 검찰단장(국방부)  답변 / 한민구 장관(국방부)  답변', '15:07:16 권은희 질의, 2015-07-13 14:06 국방위, 제335회 국회(임시회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '16:03:52 권은희 질의, 2015-07-01 14:13 국방위, 제334회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '15:24:14 권은희 질의, 2015-06-16 14:07 국방위, 제334회 국회(임시회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '11:56:41 권은희 질의, 2015-06-16 10:11 미방위, 제334회 국회(임시회) 제01차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최성준 위원장(방송통신위원회)  답변', '02:02:33 권은희 인사, 2015-05-29 02:01 운영위, 제333회 국회(임시회) 제01차 국회운영위원회, 권은희 위원(새정치민주연합)  인사', '16:01:16 권은희 질의, 2015-05-11 15:06 국방위, 제333회 국회(임시회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '16:06:54 권은희 질의, 2015-04-27 15:09 미방위, 제332회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변 / 최성준 위원장(방송통신위원회)  답변', '15:13:07 권은희 질의, 2015-04-20 14:12 국방위, 제332회 국회(임시회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부) 답변 / 박신규 사업관리본부장(방위사업청) 답변 / 장명진 청장(방위사업청) 답변 / 이재익 계약관리본부장(방위사업청) 답변', '11:42:08 권은희 질의, 2015-04-10 10:41 미방위, 제332회 국회(임시회) 제01차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변 / 최성준 위원장(방송통신위원회)  답변', '11:08:16 권은희 질의, 2015-03-17 10:12 특별위, 제331회 국회(임시회) 폐회중 제09차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 최현락 기획조정관(경찰청)  답변 / 홍익태 해양경비안전본부장(국민안전처)  답변 / 이성호 차관(국민안전처)  답변', '11:30:52 권은희 질의, 2015-03-03 10:09 특별위, 제331회 국회(임시회) 제08차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 조송래 중앙소방본부장(국민안전처)  답변', '12:35:54 권은희 질의, 2015-03-03 10:09 특별위, 제331회 국회(임시회) 제08차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 김재춘 차관(교육부)  답변 / 이성호 차관(국민안전처)  답변', '11:49:03 권은희 질의, 2015-02-26 10:10 본회의, 제331회 국회(임시회) 제06차 본회의, 권은희 의원(새누리당)  질의 / 최경환 장관(기획재정부)  답변 / 최양희 장관(미래창조과학부)  답변 / 이완구 국무총리  답변', '11:09:09 권은희 질의, 2015-02-24 10:05 국방위, 제331회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '12:19:54 권은희 질의, 2015-02-24 10:05 국방위, 제331회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '12:42:43 권은희 질의, 2015-02-24 10:05 국방위, 제331회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변 /   실무자  답변', '11:20:31 권은희 질의, 2015-02-13 10:12 미방위, 제331회 국회(임시회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 김보라미 변호사(법무법인 나눔)  답변 / 이경호 정보보호대학원 교수(고려대학교)  답변 / 이은우 변호사(법무법인 지향)  답변 / 심종헌 회장(지식정보보안산업협회)  답변 / 강성주 정보화전략국장(미래창조과학부)  답변', '10:32:05 권은희 질의, 2015-02-11 10:06 미방위, 제331회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 조석 사장(한국수력원자력)  답변', '11:20:49 권은희 질의, 2015-01-27 10:06 특별위, 제330회 국회(임시회) 폐회중 제06차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 이기권 장관(고용노동부)  답변 / 윤성규 장관(환경부)  답변', '12:20:43 권은희 질의, 2015-01-27 10:06 특별위, 제330회 국회(임시회) 폐회중 제06차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 윤성규 장관(환경부)  답변', '11:15:39 권은희 질의, 2015-01-13 10:05 특별위, 제330회 국회(임시회) 제05차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 윤상직 장관(산업통상자원부)  답변 / 조석 사장(한국수력원자력)  답변', '12:30:03 권은희 질의, 2015-01-13 10:05 특별위, 제330회 국회(임시회) 제05차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 조석 사장(한국수력원자력)  답변', '15:17:53 권은희 설명, 2014-12-29 14:13 본회의, 제330회 국회(임시회) 제03차 본회의, 권은희 의원(새누리당)  설명', '09:16:49 권은희 질의, 2014-12-29 08:07 국방위, 제330회 국회(임시회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변 / 임천영 법무관리관(국방부)  답변 / 황진하 위원장(새누리당)  발언 / 백승주 차관(국방부)  답변', '11:51:17 권은희 질의, 2014-12-23 10:03 특별위, 제330회 국회(임시회) 제04차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 박인용 장관(국민안전처)  답변 / 이건기 부시장(서울특별시)  답변', '10:49:12 권은희 질의, 2014-12-09 10:04 특별위, 제329회 국회(정기회) 제03차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 서승환 장관(국토교통부) 답변', '10:51:39 권은희 질의, 2014-12-09 10:04 특별위, 제329회 국회(정기회) 제03차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  질의 / 서승환 장관(국토교통부)  답변', '11:04:01 권은희 질의, 2014-12-04 10:12 미방위, 제329회 국회(정기회) 제09차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 민영기 사무국장(클라우드산업협회)  답변 / 오길영 교수(신경대학교)  답변 / 장여경 정책활동가(진보네트워크센터)  답변', '11:42:19 권은희 질의, 2014-11-20 10:35 국방위, 제329회 국회(정기회) 제07차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 성석호 수석전문위원(국방위원회)  답변 / 한민구 장관(국방부)  답변', '10:55:22 권은희 질의, 2014-11-18 10:06 국방위, 제329회 국회(정기회) 제06차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 김상봉 공공행정학부교수(고려대학교)  답변 / 정주성 책임연구원(한국국방연구원)  답변 / 원승재 기획조정부장(대한체육회)  답변 / 이남경 법무팀장(한국연예제작협회)  답변', '14:24:23 권은희 인사, 2014-11-17 14:09 특별위, 제329회 국회(정기회) 제01차 국민안전혁신특별위원회, 권은희 위원(새정치민주연합)  인사', '16:01:25 권은희 질의, 2014-11-11 15:00 미방위, 제329회 국회(정기회) 제05차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 조규조 전파정책국장(미래창조과학부)  답변 / 홍인기 전자전파공학과교수(경희대학교)  답변', '15:41:52 권은희 질의, 2014-10-30 14:18 미방위, 제329회 국회(정기회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변', '15:08:36 권은희 질의, 2014-10-29 14:04 국방위, 제329회 국회(정기회) 제04차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 임천영 법무관리관(국방부)  답변 / 한민구 장관(국방부)  답변', '11:47:57 권은희 질의, 2014-10-27 10:24 미방위, 2014년도 국정감사(미래창조과학부), 권은희 위원(새누리당)  질의 / 최양희 장관(미래창조과학부)  답변', '11:32:33 권은희 질의, 2014-10-27 10:05 국방위, 2014년도 국정감사(국방부 등), 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '15:22:00 권은희 질의, 2014-10-24 14:36 미방위, 2014년도 국정감사(방송통신위원회), 권은희 위원(새누리당)  질의 / 최성준 위원장(방송통신위원회)  답변', '11:31:32 권은희 질의, 2014-10-24 10:06 미방위, 2014년도 국정감사(원자력안전위원회 등), 권은희 위원(새누리당)  질의 / 조석 사장(한국수력원자력)  답변', '10:59:54 권은희 질의, 2014-10-23 10:00 미방위, 2014년도 국정감사(정보통신산업진흥원 등), 권은희 위원(새누리당)  질의 / 박수용 원장(정보통신산업진흥원)  답변 / 김용수 정보통신방송정책실장(미래창조과학부)  답변', '22:08:10 권은희 질의, 2014-10-22 20:35 미방위, 2014년도 국정감사(한국교육방송공사), 권은희 위원(새누리당)  질의 / 신용섭 사장(한국교육방송공사)  답변 / 한송희 위원(EBS)  답변', '10:20:06 권은희 발언, 2014-10-20 10:03 국방위, 2014년도 국정감사(방위사업청 등), 권은희 위원(새정치민주연합)  발언 / 이용걸 청장(방위사업청)  발언', '17:24:49 권은희 질의, 2014-10-10 17:04 국방위, 제329회 국회(정기회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 박찬웅 인사기획관(국방부)  답변', '11:41:21 권은희 질의, 2014-10-10 10:04 국방위, 2014년도 국정감사(병무청), 권은희 위원(새정치민주연합)  질의 / 박창명 청장(병무청)  답변 /   실무자  답변', '11:15:45 권은희 질의, 2014-10-07 10:06 국방위, 2014년도 국정감사(국방부 등), 권은희 위원(새정치민주연합)  질의 / 한민구 장관(국방부)  답변', '16:20:30 권은희 발언, 2014-10-01 16:08 국방위, 제329회 국회(정기회) 제01차 국방위원회, 권은희 위원(새정치민주연합)  발언', '14:52:18 권은희 인사, 2014-09-01 14:26 본회의, 제329회 국회(정기회) 제01차 본회의, 권은희 의원(새정치민주연합) 인사', '11:49:43 권은희 질의, 2014-08-21 10:11 국방위, 제327회 국회(임시회) 폐회중 제03차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 임태훈 소장(군인권센터)  답변 / 신인균 대표(자주국방네트워크)  답변', '10:13:04 권은희 인사, 2014-08-19 10:09 국방위, 제327회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  인사', '11:06:15 권은희 발언, 2014-08-19 10:09 국방위, 제327회 국회(임시회) 제02차 국방위원회, 황진하 위원장(새누리당)  발언 / 권은희 위원(새정치민주연합)  발언', '11:25:05 권은희 질의, 2014-08-19 10:09 국방위, 제327회 국회(임시회) 제02차 국방위원회, 권은희 위원(새정치민주연합)  질의 / 백승주 차관(국방부)  답변', '11:39:37 권은희 질의, 2014-07-18 10:09 예결위, 제326회 국회(임시회) 폐회중 제06차 예산결산특별위원회, 권은희 위원(새누리당)  질의 / 최경환 장관(기획재정부)  답변', '11:00:23 권은희 질의, 2014-07-10 10:13 미방위, 제326회 국회(임시회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최성준 위원장(방송통신위원회)  답변 /   실무자  답변 / 이상목 제1차관(미래창조과학부)  답변', '10:05:05 권은희 인사, 2014-07-07 10:04 미방위, 제326회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  인사', '10:33:38 권은희 질의, 2014-07-07 10:04 미방위, 제326회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최양희 공직후보자  답변', '14:23:44 권은희 인사, 2014-07-02 14:11 예결위, 제326회 국회(임시회) 제01차 예산결산특별위원회, 권은희 위원(새누리당)  인사', '14:55:51 권은희 질의, 2014-06-16 14:02 특별위, 제325회 국회(임시회) 제11차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  질의 / 조명우 행정부시장(인천광역시)  답변 / 김영수 위원장(2014인천아시아경기대회조직위원회)  답변', '11:14:08 권은희 질의, 2014-04-16 10:07 특별위, 제323회 국회(임시회) 제09차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  질의 / 유진룡 장관(문화체육관광부)  답변', '12:30:00 권은희 질의, 2014-04-01 11:25 미방위, 제323회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최성준 공직후보자  답변', '11:07:23 권은희 질의, 2014-02-21 10:03 미방위, 제322회 국회(임시회) 제04차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최문기 장관(미래창조과학부)  답변', '10:44:23 권은희 발언, 2014-02-19 10:16 미방위, 제322회 국회(임시회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  발언 / 한선교 위원장(새누리당)  발언', '11:57:12 권은희 발언, 2014-02-19 10:16 미방위, 제322회 국회(임시회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  발언', '11:15:36 권은희 질의, 2014-02-17 10:06 특별위, 제322회 국회(임시회) 제07차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  질의 / 유진룡 장관(문화체육관광부)  답변', '10:26:34 권은희 발언, 2013-12-26 10:06 특별위, 제321회 국회(임시회) 제05차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  발언', '10:54:53 권은희 발언, 2013-12-26 10:06 특별위, 제321회 국회(임시회) 제05차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  발언', '11:12:28 권은희 질의, 2013-12-26 10:06 특별위, 제321회 국회(임시회) 제05차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  질의 / 설문식 경제부지사(충청북도)  답변 / 박위진 체육국장(문화체육관광부)  답변', '11:33:16 권은희 질의, 2013-11-26 10:31 미방위, 제320회 국회(정기회) 제07차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 이은철 위원장(원자력안전위원회)  답변', '11:39:00 권은희 질의, 2013-11-07 10:14 미방위, 제320회 국회(정기회) 제05차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 이은철 위원장(원자력안전위원회)  답변', '11:52:06 권은희 발언, 2013-11-07 10:14 미방위, 제320회 국회(정기회) 제05차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  발언', '10:33:52 권은희 질의, 2013-11-05 10:30 미방위, 제320회 국회(정기회) 제04차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 길환영 사장(한국방송공사)  답변 / 이경재 위원장(방송통신위원회)  답변', '15:22:23 권은희 질의, 2013-11-01 14:40 미방위, 2013년도 국정감사(방송통신위원회 등), 권은희 위원(새누리당)  질의 / 이경재 위원장(방송통신위원회)  답변 / 박만 위원장(방송통신심의위원회)  답변', '10:34:12 권은희 질의, 2013-11-01 10:14 미방위, 2013년도 국정감사(원자력안전위원회), 권은희 위원(새누리당)  질의 / 전용갑 부사장(한국수력원자력)  답변', '12:06:43 권은희 질의, 2013-11-01 10:14 미방위, 2013년도 국정감사(원자력안전위원회), 권은희 위원(새누리당)  질의 / 전용갑 부사장(한국수력원자력)  답변', '10:42:06 권은희 발언, 2013-10-31 10:18 미방위, 2013년도 국정감사(미래창조과학부), 권은희 위원(새누리당)  발언', '11:48:02 권은희 질의, 2013-10-31 10:18 미방위, 2013년도 국정감사(미래창조과학부), 권은희 위원(새누리당)  질의 / 최문기 장관(미래창조과학부)  답변', '11:51:14 권은희 질의, 2013-10-29 10:09 미방위, 2013년도 국정감사(방송문화진흥회 등), 권은희 위원(새누리당)  질의 / 김문환 이사장(방송문화진흥회)  답변 / 이원창 사장(한국방송광고진흥공사)  답변', '10:42:07 권은희 질의, 2013-10-22 10:06 미방위, 2013년도 국정감사(한국연구재단 등), 권은희 위원(새누리당)  질의 / 강성모 총장(한국과학기술원)  답변 / 이걸우 사무총장(한국연구재단)  답변', '14:54:52 권은희 질의, 2013-10-21 14:07 미방위, 2013년도 국정감사(산업기술연구회 등), 권은희 위원(새누리당)  질의 / 김흥남 원장(한국전자통신연구원)  답변 / 이상목 차관(미래창조과학부)  답변', '10:54:39 권은희 질의, 2013-10-21 10:10 미방위, 2013년도 국정감사(기초기술연구회 등), 권은희 위원(새누리당)  질의 / 김건 이사장(기초기술연구회)  답변', '10:42:26 권은희 발언, 2013-10-17 10:21 미방위, 2013년도 국정감사(원자력안전위원회 등), 권은희 위원(새누리당)  발언', '11:55:58 권은희 질의, 2013-06-19 10:07 미방위, 제316회 국회(임시회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 이종관 연구위원(미디어미래연구소)  답변 / 박종수 교수(고려대법학전문대학원)  답변', '11:06:14 권은희 질의, 2013-06-18 10:11 미방위, 제316회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최문기 장관(미래창조과학부)  답변', '11:12:49 권은희 발언, 2013-06-18 10:11 미방위, 제316회 국회(임시회) 제02차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  발언', '11:04:28 권은희 질의, 2013-06-17 10:05 미방위, 제316회 국회(임시회) 제01차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 이은철 위원장(원자력안전위원회)  답변', '10:37:49 권은희 질의, 2013-05-03 10:14 미방위, 제315회 국회(임시회) 제06차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최문기 장관(미래창조과학부)  답변', '10:37:26 권은희 질의, 2013-04-29 10:15 미방위, 제315회 국회(임시회) 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최문기 장관(미래창조과학부)  답변', '14:10:30 권은희 인사, 2013-04-19 14:10 특별위, 제315회 국회(임시회) 제02차 평창동계올림픽및국제경기대회지원특별위원회, 권은희 위원(새누리당)  인사', '10:47:43 권은희 질의, 2013-04-10 10:04 미방위, 제315회 국회(임시회) 제01차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 이경재 공직후보자  답변', '10:05:56 권은희 인사, 2013-04-08 10:05 산자위, 제315회 국회(임시회) 제01차 산업통상자원위원회, 권은희 위원(새누리당)  인사', '10:02:59 권은희 인사, 2013-04-01 10:02 미방위, 제314회 국회(임시회) 폐회중 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  발언, 인사', '10:40:31 권은희 질의, 2013-04-01 10:02 미방위, 제314회 국회(임시회) 폐회중 제03차 미래창조과학방송통신위원회, 권은희 위원(새누리당)  질의 / 최문기 공직후보자  답변', '12:06:04 권은희 질의, 2013-03-07 10:04 지경위, 제313회 국회(임시회) 폐회중 제04차 지식경제위원회, 권은희 위원(새누리당) 질의 / 윤상직 공직후보자 답변', '16:41:42 권은희 질의, 2013-02-15 15:02 지경위, 제313회 국회(임시회) 제02차 지식경제위원회, 권은희 위원(새누리당) 질의 / 홍석우 장관(지식경제부) 답변', '10:00:47 권은희 발언, 2012-11-22 09:06 특별위, 제311회 국회(정기회) 제05차 국회쇄신특별위원회, 권은희 위원(새누리당) 발언', '10:41:47 권은희 발언, 2012-11-22 09:06 특별위, 제311회 국회(정기회) 제05차 국회쇄신특별위원회, 정희수 위원장(새누리당) 발언 / 원혜영 위원(민주통합당) 발언 / 김성곤 위원(민주통합당) 발언 / 함진규 위원(새누리당) 발언 / 권은희 위원(새누리당) 발언', '12:11:19 권은희 질의, 2012-11-07 10:00 지경위, 제311회 국회(정기회) 제14차 지식경제위원회, 권은희 위원(새누리당) 질의 / 홍석우 장관(지식경제부) 답변', '14:02:53 권은희 발언, 2012-10-24 13:40 특별위, 제311회 국회(정기회) 제04차 국회쇄신특별위원회, 권은희 위원(새누리당) 발언', '10:04:23 권은희 발언, 2012-10-24 10:02 지경위, 2012년도 국정감사(지식경제부 등), 권은희 위원(새누리당) 발언', '10:10:13 권은희 발언, 2012-10-24 10:02 지경위, 2012년도 국정감사(지식경제부 등), 권은희 위원(새누리당) 발언 / 홍석우 장관(지식경제부) 답변', '10:38:11 권은희 질의, 2012-10-22 10:01 지경위, 2012년도 국정감사(한국수력원자력 등), 권은희 위원(새누리당) 질의 / 김균섭 사장(한국수력원자력) 답변', '10:46:25 권은희 질의, 2012-10-19 10:04 지경위, 2012년도 국정감사(대한무역투자진흥공사 등), 권은희 위원(새누리당) 질의 / 오영호 사장(대한무역투자진흥공사) 답변', '11:24:07 권은희 질의, 2012-10-18 10:04 지경위, 2012년도 국정감사(산업기술연구회 등), 권은희 위원(새누리당) 질의 / 장호남 이사장(산업기술연구회) 답변 / 박수용 원장(정보통신산업진흥원) 답변 / 김흥남 원장(한국전자통신연구원) 답변', '12:17:01 권은희 질의, 2012-10-12 10:07 지경위, 2012년도 국정감사(한국가스공사 등), 권은희 위원(새누리당) 질의 / 전대천 사장(한국가스공사) 답변 / 서문규 사장(한국석유공사) 답변 / 강창일 위원장(민주통합당) 발언', '15:15:37 권은희 토론, 2012-09-27 14:12 본회의, 제311회 국회(정기회) 제09차 본회의, 권은희 의원(새누리당) 토론', '10:56:36 권은희 질의, 2012-09-21 10:13 지경위, 제311회 국회(정기회) 제04차 지식경제위원회, 권은희 위원(새누리당) 질의 / 홍석우 장관(지식경제부) 답변', '15:17:29 권은희 질의, 2012-09-18 14:06 특별위, 제311회 국회(정기회) 제03차 국회쇄신특별위원회, 권은희 위원(새누리당) 질의 / 김형준 인문교양학부 교수(명지대학교) 답변', '14:17:27 권은희 발언, 2012-09-05 14:09 특별위, 제311회 국회(정기회) 제02차 국회쇄신특별위원회, 권은희 위원(새누리당) 발언', '09:44:35 권은희 인사, 2012-08-22 09:37 특별위, 제310회 국회(임시회) 제01차 국회쇄신특별위원회, 권은희 위원(새누리당) 인사', '16:45:02 권은희 질의, 2012-07-26 14:35 지경위, 제309회 국회(임시회) 제04차 지식경제위원회, 권은희 위원(새누리당) 질의 / 김균섭 사장(한국수력원자력) 답변', '11:19:24 권은희 질의, 2012-07-24 10:00 지경위, 제309회 국회(임시회) 제02차 지식경제위원회, 권은희 위원(새누리당) 질의 / 홍석우 장관(지식경제부) 답변', '10:19:00 권은희 인사, 2012-07-12 10:13 지경위, 제309회 국회(임시회) 제01차 지식경제위원회, 권은희 위원(새누리당) 인사']

[ANALYZER] 19th_20220706-234320.csv
[SCANNING] ./19th_20220706-234320.csv
           Searching 김삼화's activities at 19th assembly...

[ANALYZER] 19th_20220706-234320.csv
[SCANNING] ./19th_20220706-234320.csv
           Searching 김상희's activities at 19th assembly...

^CTraceback (most recent call last):
  File "<stdin>", line 3, in <module>
  File "/Users/aj/Projects/yeongnok/tools/analyzer.py", line 48, in get_activities_of
    for index, line in enumerate(reader):
KeyboardInterrupt
>>>
```

### page

It's a range, and it works like python's built-in `range`.

For example, ```page(1, 10, nth=21)``` means "page 1 to 10 of the 21st national assembly". As what you can see [HERE](https://w3.assembly.go.kr/vod/main/sub.do?menu=1&ct1=21&curPages=1), usually, each page contains 10 records.

Use `for each_page in page(...)` to get VOD info of each meeting.

```python
from yeongnok import page

for each_page in page(7, -1, nth=21):  # '-1' means 'the last page'.
                          # Just write a random number...
                          # You'll get the maximum page number anyway.

  print(each_page)        # Prints every meeting's 
                          # 'date', 'open time', 'title',
                          # 'video link', 'video record' and so on (JSON format).

  each_page.to_csv()      # Save all the data to
                          # "{nth}_{date}_{open-time}_{time-now}.csv".
                          # e.g. "20th_20220704-143708.csv".
                          # By specifying the file path & name, for example:
                          # each_page.to_csv("path/to_my/folder/my_data.csv")
                          # you can save it anywhere.
```

You can run 'site.py' directly from the command line like this

```bash
python3 site.py --nth 21 --start 1 --end 50 --delta 5 --csv "output/my_csv.csv"
```

The video meta data of the 21st Assembly will be saved to 'output' folder. Since ```--delta``` (or, ```-d```) is '5', the crawler will pause for 5 seconds after getting a whole page.

The time interval of getting each single record is **1.5 seconds**. You can change this value in ```site.py``` :: class ```Page``` :: method ```refresh```, its default argument ```delta_time```.

Each csv output will be like this:

```csv
2020-06-05,10:00,본회의,제379회 국회(임시회) 제01차 본회의,,https://w3.assembly.go.kr/vod/main/player.do?menu=1&mc=10&ct1=21&ct2=379&ct3=01&wv=1&,21,379,01,"[{'realTime': '10:00:00', 'playTime': '01:17:10', 'speakType': '전체보기', 'no': 488837, 'subList': [{'realTime': '10:00:00', 'playTime': '00:01:50', 'speakType': '보고', 'no': 488838, 'movieTitle': '유인태 사무총장(국회사무처)  보고', 'wv': 0}, {'realTime': '10:01:50', 'playTime': '00:02:59', 'speakType': '개의', 'no': 488839, 'movieTitle': '김진표 국회의장직무대행(더불어민주당)  개의, 발언', 'wv': 0}, {'realTime': '10:04:50', 'playTime': '00:06:39', 'speakType': '발언', 'no': 488840, 'movieTitle': '주호영 의원(미래통합당)  발언', 'wv': 0}, {'realTime': '10:11:29', 'playTime': '00:04:58', 'speakType': '발언', 'no': 488841, 'movieTitle': '김영진 의원(더불어민주당)  발언', 'wv': 0}, {'realTime': '10:16:28', 'playTime': '00:01:43', 'speakType': '법안', 'no': 488842, 'movieTitle': '김진표 국회의장직무대행(더불어민주당)  발언, 의사일정 제1항 상정', 'wv': 0}, {'realTime': '10:18:11', 'playTime': '00:13:42', 'speakType': '설명', 'no': 488843, 'movieTitle': '박태형 의사국장  설명, 투표', 'wv': 0}, {'realTime': '10:31:54', 'playTime': '00:10:08', 'speakType': '발언', 'no': 488844, 'movieTitle': '김진표 국회의장직무대행(더불어민주당)  발언', 'wv': 0}, {'realTime': '10:42:02', 'playTime': '00:29:28', 'speakType': '인사', 'no': 488845, 'movieTitle': '박병석 국회의장  인사, 발언, 투표', 'wv': 0}, {'realTime': '11:11:31', 'playTime': '00:04:52', 'speakType': '인사', 'no': 488846, 'movieTitle': '김상희 국회부의장(더불어민주당)  인사', 'wv': 0}, {'realTime': '11:16:23', 'playTime': '00:00:45', 'speakType': '산회', 'no': 488847, 'movieTitle': '박병석 국회의장  발언, 산회', 'wv': 0}], 'movieTitle': '전체보기(10시 00분 개의~11시 17분 산회)', 'qvod': '0', 'wv': 1}]"
```

After saving to CSV file, run command ```wc``` (Linux, macOS) to check the number of records:

```bash
wc -l 20th_20220704-143708.csv
```

Output:

```
    2377 20th_20220704-143708.csv
```

20th National Assembly of Korea had 2377 meetings, interesting.

### send

If you have an **API key** from the official site of KR Assembly, you can use ```send``` to get JSON data like this

```python
from yeongnok import send

my_data: dict = send(
              KEY=YOUR_API_KEY,
              ct1=21,
              ct2=10,
              ct3=1
).received
# For more details, check the official page of the Korean National Assembly.
```

# License

Copyright Anji Wong, 2022.

Distributed under the terms of the Apache 2.0 license.
