/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TextUtils {
    public static final Pattern kuuPohineFormaat = Pattern.compile("\\d\\d\\d\\d-\\d\\d?-\\d\\d?T\\d\\d:\\d\\d");
    public static final Pattern timeMLDocumentCreationTime = Pattern.compile("<[^>]*(([0-9X]{4}-[0-9X]{2}-[0-9X]{2}(T[0-9X]{2}:[0-9X]{2})?)[^>]*functionInDocument=\"CREATION_TIME\")[^>]*>");
    public static final Pattern customRuleFile = Pattern.compile("<rules file=\"([^\"]+)\"\\s*/>", 2);
    private static final Pattern removePunctationFromBeginning = Pattern.compile("^(\\p{Punct}|\u00ab)+");
    private static final Pattern removePunctationFromEnding = Pattern.compile("(\\p{Punct}|\u00bb)+$");
    private static final Pattern endsWithNumbersAndSpecificPunctation = Pattern.compile(".*[0-9]+(\\.|:|/|%|-|'|\\))+$");
    public static final Pattern beginningOfQuote = Pattern.compile("^(\u00ab|\")+");
    public static final Pattern endOfQuote = Pattern.compile("(\u00bb|\")+$");
    public static final Pattern musterMurdArv = Pattern.compile("^[0-9]+\\.[0-9]+$");
    public static final Pattern validTimeMLtid = Pattern.compile("^t[0-9]+$");

    public static String trim(String string) {
        return TextUtils.ltrim(string).replaceAll("\\s+$", "");
    }

    public static String ltrim(String string) {
        return string.replaceAll("^\\s+", "");
    }

    public static String trimSurroundingPunctation(String string) {
        if (endsWithNumbersAndSpecificPunctation.matcher(string).matches()) {
            return removePunctationFromBeginning.matcher(string).replaceAll("");
        }
        return removePunctationFromEnding.matcher(removePunctationFromBeginning.matcher(string).replaceAll("")).replaceAll("");
    }

    public static String normalizeSpecialSymbols(String string) {
        string = string.replaceAll("-{2,}", "-");
        string = string.replaceAll("(\u2212|\uff0d|\u02d7|\ufe63|-)", "-");
        string = string.replaceAll("(\u2010|\u2011|\u2012|\u2013|\u2014|\u2015)", "-");
        string = string.replaceAll("&(quot|#34);", "\"");
        string = string.replaceAll("&(apos|#39);", "'");
        string = string.replaceAll("&(amp|#38);", "&");
        string = string.replaceAll("&(lt|#60);", "<");
        string = string.replaceAll("&(gt|#62);", ">");
        return string;
    }

    public static String resizeString(String string, int n, boolean bl) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            if (bl) {
                return string.substring(0, n);
            }
            return string.substring(string.length() - n, string.length());
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = n - string.length(); i > 0; --i) {
            if (bl) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.insert(0, " ");
        }
        return stringBuilder.toString();
    }

    public static boolean containsLetters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if (!string2.matches("[A-Za-z]")) continue;
            return true;
        }
        return false;
    }

    public static String looMustriTahisteVoti(List<String> list, boolean bl) {
        if (bl) {
            Collections.sort(list);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append("+");
        }
        return stringBuilder.toString();
    }
}

