/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.AjaTuvastaja;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.MustriTahis;
import ee.ut.soras.ajavtV2.mudel.TuvastamisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaKlass;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.util.SemDefValjadeParsija;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FraasiMusterFSM
implements FraasiMuster {
    private String mustriID;
    private List<SonaMall> sonaMallid;
    private List<Boolean> onArajaetav;
    private TuvastamisReegel tuvastamisReegel = null;
    private List<Transition> transitions = null;
    private List<Transition> emptyTransitions = null;
    private List<StateAndPath> currentStates = null;
    private List<Integer> startStates = null;
    private int endState = -1;

    public FraasiMusterFSM(List<SonaMall> list, List<Boolean> list2, List<Boolean> list3, String string) {
        this.mustriID = string;
        this.sonaMallid = list;
        this.onArajaetav = list3;
        this.buildAutomaton(list, list2);
    }

    private void buildAutomaton(List<SonaMall> list, List<Boolean> list2) {
        Object object;
        this.endState = list.size();
        this.startStates = new ArrayList<Integer>();
        this.startStates.add(0);
        this.transitions = new ArrayList<Transition>();
        this.emptyTransitions = new ArrayList<Transition>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            Object object2 = new Transition(i, i + 1, (SonaMall)object);
            this.transitions.add((Transition)object2);
            boolean bl = list2.get(i);
            if (!bl) continue;
            object2 = new Transition(i, i + 1, null);
            this.emptyTransitions.add((Transition)object2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.startStates);
        while (!arrayList.isEmpty()) {
            object = (Integer)arrayList.remove(0);
            for (Transition transition : this.emptyTransitions) {
                int n = transition.attemptTransition((Integer)object, null, null);
                if (n <= -1 || n == (Integer)object) continue;
                this.startStates.add(n);
                arrayList.add(n);
            }
        }
    }

    @Override
    public void kontrolliMustrileVastavust(AjavtSona ajavtSona, HashMap<String, MallileVastavus> hashMap) throws Exception {
        ArrayList<StateAndPath> arrayList = new ArrayList<StateAndPath>();
        boolean bl = false;
        if (this.currentStates == null) {
            this.currentStates = new ArrayList<StateAndPath>();
        }
        for (Integer iterator2 : this.startStates) {
            StateAndPath stateAndPath = new StateAndPath(iterator2);
            this.currentStates.add(stateAndPath);
        }
        LinkedList linkedList = new LinkedList();
        for (StateAndPath stateAndPath : this.currentStates) {
            int n = stateAndPath.getState();
            for (Transition transition : this.transitions) {
                int n2 = transition.attemptTransition(n, ajavtSona, hashMap);
                if (n2 <= -1) continue;
                if (n2 == this.endState) {
                    bl = true;
                }
                StateAndPath stateAndPath2 = new StateAndPath(n2, stateAndPath, n, ajavtSona);
                arrayList.add(stateAndPath2);
                linkedList.add(stateAndPath2);
            }
        }
        while (!linkedList.isEmpty()) {
            StateAndPath stateAndPath = (StateAndPath)linkedList.remove(0);
            Integer n = stateAndPath.getState();
            for (Transition transition : this.emptyTransitions) {
                int n3 = transition.attemptTransition(n, ajavtSona, hashMap);
                if (n3 <= -1 || n3 == n) continue;
                StateAndPath stateAndPath3 = new StateAndPath(n3, stateAndPath, -1, null);
                arrayList.add(stateAndPath3);
                linkedList.add(stateAndPath3);
                if (n3 != this.endState) continue;
                bl = true;
            }
        }
        if (bl) {
            this.konstrueeriJaKinnitaEraldatudAjavaljendiKandidaadid(arrayList);
            Iterator<StateAndPath> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                StateAndPath stateAndPath = iterator.next();
                if (stateAndPath.getState() != this.endState) continue;
                iterator.remove();
            }
        }
        this.currentStates = arrayList;
    }

    private AjavaljendiKandidaat konstrueeriJaKinnitaEraldatudAjavaljendiKandidaadid(ArrayList<StateAndPath> arrayList) {
        for (StateAndPath stateAndPath : arrayList) {
            if (stateAndPath.getState() != this.endState) continue;
            AjavaljendiKandidaat ajavaljendiKandidaat = null;
            HashMap<String, List<AjavtSona>> hashMap = stateAndPath.getPath();
            ArrayList<AjavtSona> arrayList2 = new ArrayList<AjavtSona>();
            for (int i = 0; i < this.endState; ++i) {
                String string = String.valueOf(i);
                if (!hashMap.containsKey(string) || this.onArajaetav.get(i).booleanValue()) continue;
                arrayList2.addAll((Collection<AjavtSona>)hashMap.get(string));
            }
            if (arrayList2.isEmpty()) continue;
            ajavaljendiKandidaat = new AjavaljendiKandidaat();
            if (this.lisaKandidaadileSemantikaDefinitsioonid(ajavaljendiKandidaat, hashMap)) {
                AjaTuvastaja.seoSonadKandidaadiKylge(ajavaljendiKandidaat, arrayList2);
                ajavaljendiKandidaat.lisaTuvastamisReegel(this.tuvastamisReegel);
            }
            ajavaljendiKandidaat.setMustriID(this.mustriID);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean lisaKandidaadileSemantikaDefinitsioonid(AjavaljendiKandidaat ajavaljendiKandidaat, HashMap<String, List<AjavtSona>> hashMap) {
        void var8_16;
        List<SemantikaDefinitsioon> list;
        Object object;
        boolean bl = false;
        ArrayList<SemantikaDefinitsioon> arrayList = new ArrayList<SemantikaDefinitsioon>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            String object22 = String.valueOf(i);
            if (!hashMap.containsKey(object22)) continue;
            object = hashMap.get(object22);
            list = object.get(object.size() - 1);
            List<SemantikaDefinitsioon> list2 = this.sonaMallid.get(i).tagastaMalliSemantilineOsa((AjavtSona)((Object)list));
            if (list2 == null || list2.isEmpty()) continue;
            if (((SemantikaDefinitsioon)list2.get(0)).getSonaKlass() != null) {
                hashMap3.put(((SemantikaDefinitsioon)list2.get(0)).getSonaKlass(), "1");
                hashMap3.put(((SemantikaDefinitsioon)list2.get(0)).getSonaKlass() + "_" + object22, "1");
                for (int j = 0; j < list2.size(); ++j) {
                    hashMap2.put(arrayList.size() + j, object22);
                }
            }
            arrayList.addAll(list2);
        }
        if (this.tuvastamisReegel != null) {
            List<SemantikaDefinitsioon> list3 = this.tuvastamisReegel.taiendaSonaMallidestSaadudSemDeffe(hashMap, hashMap3, arrayList, hashMap2, this.sonaMallid);
            arrayList.addAll(list3);
        }
        for (SemantikaDefinitsioon list4 : arrayList) {
            object = SemDefValjadeParsija.detectFormatOfValue(list4.getSemValue());
            if (object == SemDefValjadeParsija.FORMAT_OF_VALUE.REF_TO_VAL) {
                list = list4.getSemValue().split(":")[1];
                for (SemantikaDefinitsioon semantikaDefinitsioon : arrayList) {
                    if (semantikaDefinitsioon.getSonaKlass() == null || !semantikaDefinitsioon.getSonaKlass().equals(list) || semantikaDefinitsioon.getSemValue() == null) continue;
                    list4.setSemValue(semantikaDefinitsioon.getSemValue());
                }
            }
            if (object != SemDefValjadeParsija.FORMAT_OF_VALUE.REF_TO_LAB) continue;
            list = list4.getSemValue().split(":")[1];
            for (SemantikaDefinitsioon semantikaDefinitsioon : arrayList) {
                if (semantikaDefinitsioon.getSonaKlass() == null || !semantikaDefinitsioon.getSonaKlass().equals(list) || semantikaDefinitsioon.getSemLabel() == null) continue;
                list4.setSemValue(semantikaDefinitsioon.getSemLabel());
            }
        }
        Iterator<SemantikaDefinitsioon> iterator = arrayList.listIterator();
        while (iterator.hasNext()) {
            SemantikaDefinitsioon semantikaDefinitsioon = (SemantikaDefinitsioon)iterator.next();
            object = SemDefValjadeParsija.detectFormatOfValue(semantikaDefinitsioon.getSemValue());
            if (semantikaDefinitsioon.getGranulaarsus() != Granulaarsus.HOUR_OF_DAY && (semantikaDefinitsioon.getSemLabel() != null || object == SemDefValjadeParsija.FORMAT_OF_VALUE.UNSET || object == SemDefValjadeParsija.FORMAT_OF_VALUE.FRACTION || object == SemDefValjadeParsija.FORMAT_OF_VALUE.INTEGER || object == SemDefValjadeParsija.FORMAT_OF_VALUE.CONSTANT)) continue;
            list = SemDefValjadeParsija.kirjutaLahtiSemantikadefinitsioon(semantikaDefinitsioon, object);
            iterator.remove();
            for (SemantikaDefinitsioon semantikaDefinitsioon2 : list) {
                iterator.add(semantikaDefinitsioon2);
            }
        }
        Collections.sort(arrayList);
        boolean bl2 = false;
        while (var8_16 < arrayList.size()) {
            object = (SemantikaDefinitsioon)arrayList.get((int)var8_16);
            ajavaljendiKandidaat.lisaSemantikaEhitusklots((SemantikaDefinitsioon)object);
            bl = true;
            ++var8_16;
        }
        if (bl && this.tuvastamisReegel != null && this.tuvastamisReegel.kasLeidubMustriTahiseid()) {
            List<MustriTahis> list3 = this.tuvastamisReegel.parsiRahuldatudMustriosaleVastavadMustriTahised(hashMap, hashMap3);
            ajavaljendiKandidaat.lisaMustriTahised(list3);
        }
        return bl;
    }

    @Override
    public String getMustriID() {
        return this.mustriID;
    }

    @Override
    public void setMustriID(String string) {
        this.mustriID = string;
    }

    @Override
    public List<SonaMall> getSonaMallid() {
        return this.sonaMallid;
    }

    @Override
    public void setTuvastamisReegel(TuvastamisReegel tuvastamisReegel) {
        this.tuvastamisReegel = tuvastamisReegel;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mustriID != null) {
            stringBuilder.append(this.mustriID);
            stringBuilder.append(" ");
        }
        stringBuilder.append("< ");
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            SonaMall sonaMall = this.sonaMallid.get(i);
            stringBuilder.append(sonaMall);
            stringBuilder.append(" ");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    private class StateAndPath {
        private int state = -1;
        private HashMap<String, List<AjavtSona>> pathOfMatches = null;

        public StateAndPath(int n) {
            this.state = n;
        }

        public StateAndPath(int n, StateAndPath stateAndPath, int n2, AjavtSona ajavtSona) {
            this.state = n;
            if (stateAndPath.pathOfMatches != null) {
                this.pathOfMatches = new HashMap<String, List<AjavtSona>>(stateAndPath.pathOfMatches);
            }
            if (n2 != -1) {
                this.addToPath(n2, ajavtSona);
            }
        }

        public int getState() {
            return this.state;
        }

        public void addToPath(Integer n, AjavtSona ajavtSona) {
            String string;
            if (this.pathOfMatches == null) {
                this.pathOfMatches = new HashMap();
            }
            if (this.pathOfMatches.containsKey(string = n.toString())) {
                if (ajavtSona != null) {
                    this.pathOfMatches.get(string).add(ajavtSona);
                }
            } else {
                ArrayList<AjavtSona> arrayList = new ArrayList<AjavtSona>();
                if (ajavtSona != null) {
                    arrayList.add(ajavtSona);
                }
                this.pathOfMatches.put(string, arrayList);
            }
        }

        public HashMap<String, List<AjavtSona>> getPath() {
            return this.pathOfMatches;
        }
    }

    private class Transition {
        private int sourceState = -1;
        private SonaMall requiredMatch = null;
        private int targetState = -1;

        public Transition(int n, int n2, SonaMall sonaMall) {
            this.sourceState = n;
            this.targetState = n2;
            this.requiredMatch = sonaMall;
        }

        public int attemptTransition(int n, AjavtSona ajavtSona, HashMap<String, MallileVastavus> hashMap) {
            if (n == this.sourceState) {
                SonaMall sonaMall = this.requiredMatch;
                if (sonaMall == null) {
                    return this.targetState;
                }
                MallileVastavus mallileVastavus = MallileVastavus.EI_VASTA;
                if (sonaMall.getTyyp() == SonaMall.TYYP.SONAKLASS) {
                    String string = ((SonaKlass)sonaMall).getNimi();
                    if (hashMap.containsKey(string)) {
                        mallileVastavus = hashMap.get(string);
                    } else {
                        mallileVastavus = sonaMall.vastabMallile(ajavtSona);
                        hashMap.put(string, mallileVastavus);
                    }
                } else {
                    mallileVastavus = sonaMall.vastabMallile(ajavtSona);
                }
                if (mallileVastavus == MallileVastavus.VASTAB_LOPLIKULT) {
                    return this.targetState;
                }
                if (mallileVastavus == MallileVastavus.EI_VASTA) {
                    return -1;
                }
                return this.sourceState;
            }
            return -1;
        }
    }
}

