/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.util.List;

public class ArvuEriKujudSonaMall
extends SonaMalliSemOsa
implements SonaMall {
    private String[] arvuTyybid = null;
    private int arvuVaartuseAlampiir = -1;
    private int arvuVaartuseYlempiir = -1;
    public static final Object[][] romanToArabic = new Object[][]{{"I", 1}, {"V", 5}, {"X", 10}, {"L", 50}, {"C", 100}, {"D", 500}, {"M", 1000}};

    public void setArvuVaartusePiirid(int n, int n2) {
        this.arvuVaartuseAlampiir = n;
        this.arvuVaartuseYlempiir = n2;
    }

    public ArvuEriKujudSonaMall() {
        this.setArvuTyyp("_N_|_O_|_F_");
    }

    public void setArvuTyyp(String string) {
        String[] stringArray;
        if (string != null && (stringArray = string.split("\\|")) != null && stringArray.length > 0) {
            this.arvuTyybid = stringArray;
        }
    }

    private boolean arvMahubEtteantudPiiridesse(int n) {
        if (this.arvuVaartuseAlampiir != -1 && this.arvuVaartuseAlampiir > n) {
            return false;
        }
        return this.arvuVaartuseYlempiir == -1 || this.arvuVaartuseYlempiir >= n;
    }

    @Override
    public SonaMall.TYYP getTyyp() {
        return SonaMall.TYYP.ERIARV;
    }

    @Override
    public MallileVastavus vastabMallile(AjavtSona ajavtSona) {
        if (this.arvuTyybid != null) {
            for (String string : this.arvuTyybid) {
                boolean bl = true;
                if (!this.vastabArvuTyybile(string, ajavtSona)) {
                    bl = false;
                }
                if (string.equals("_R_") && bl) {
                    int n = ArvuEriKujudSonaMall.parsiRoomaNumber(ajavtSona.getAlgSonaYmbritsevateMarkideta());
                    if (!this.arvMahubEtteantudPiiridesse(n)) {
                        bl = false;
                    }
                } else if (ajavtSona.getArvSonaFraasis() != FraasisPaiknemiseKoht.PUUDUB) {
                    Integer n = ajavtSona.getArvSonaTaisArvVaartus();
                    Double d = ajavtSona.getArvSonaMurdArvVaartus();
                    if (n != null && !this.arvMahubEtteantudPiiridesse(n) || d != null && !this.arvMahubEtteantudPiiridesse(d.intValue()) || n == null && d == null) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                if (!bl) continue;
                if (string.matches("_[NOF]_")) {
                    if (ajavtSona.getArvSonaFraasis() == FraasisPaiknemiseKoht.AINUSSONA || ajavtSona.getArvSonaFraasis() == FraasisPaiknemiseKoht.LOPUS) {
                        return MallileVastavus.VASTAB_LOPLIKULT;
                    }
                    if (ajavtSona.getArvSonaFraasis() == FraasisPaiknemiseKoht.ALGUSES) {
                        return MallileVastavus.VASTAB_ALGUS;
                    }
                    if (ajavtSona.getArvSonaFraasis() != FraasisPaiknemiseKoht.KESKEL) continue;
                    return MallileVastavus.VASTAB_KESKOSA;
                }
                return MallileVastavus.VASTAB_LOPLIKULT;
            }
        }
        return MallileVastavus.EI_VASTA;
    }

    private boolean vastabArvuTyybile(String string, AjavtSona ajavtSona) {
        if (ajavtSona.getArvSonaTaisArvVaartus() != null && ajavtSona.getArvSonaMurdArvVaartus() == null) {
            for (MorfAnRida morfAnRida : ajavtSona.getAnalyysiTulemused()) {
                if (morfAnRida.getSonaliik() == null || !morfAnRida.getSonaliik().startsWith(string)) continue;
                return true;
            }
        } else {
            int n;
            if (ajavtSona.getArvSonaTaisArvVaartus() == null && ajavtSona.getArvSonaMurdArvVaartus() != null && string.matches("_F_")) {
                return true;
            }
            if (string.equals("_R_") && (n = ArvuEriKujudSonaMall.parsiRoomaNumber(ajavtSona.getAlgSonaYmbritsevateMarkideta())) != -1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<SemantikaDefinitsioon> tagastaMalliSemantilineOsa(AjavtSona ajavtSona) {
        int[] nArray = super.getSemValueReferences();
        List<SemantikaDefinitsioon> list = super.tagastaMalliSemantilineOsa(ajavtSona);
        if (nArray != null && list != null && nArray.length == list.size() && this.arvuTyybid != null) {
            for (int i = 0; i < nArray.length; ++i) {
                SemantikaDefinitsioon semantikaDefinitsioon = list.get(i);
                int n = nArray[i];
                if (n <= -1 || semantikaDefinitsioon == null) continue;
                for (String string : this.arvuTyybid) {
                    if (!this.vastabArvuTyybile(string, ajavtSona)) continue;
                    if (string.equals("_R_")) {
                        int n2 = ArvuEriKujudSonaMall.parsiRoomaNumber(ajavtSona.getAlgSonaYmbritsevateMarkideta());
                        if (n2 == -1 || !this.arvMahubEtteantudPiiridesse(n2)) continue;
                        semantikaDefinitsioon.setSemValue(String.valueOf(n2));
                        continue;
                    }
                    if (!ajavtSona.getArvSonaFraasis().onFraasiLopp()) continue;
                    Integer n3 = ajavtSona.getArvSonaTaisArvVaartus();
                    Double d = ajavtSona.getArvSonaMurdArvVaartus();
                    if (d != null) {
                        if (!this.arvMahubEtteantudPiiridesse(d.intValue())) continue;
                        semantikaDefinitsioon.setSemValue(d.toString().replace(".", ","));
                        continue;
                    }
                    if (n3 == null || semantikaDefinitsioon.getSemValue() != null && (semantikaDefinitsioon.getSemValue() == null || TextUtils.musterMurdArv.matcher(semantikaDefinitsioon.getSemValue()).matches()) || !this.arvMahubEtteantudPiiridesse(n3)) continue;
                    semantikaDefinitsioon.setSemValue(n3.toString());
                }
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("arvu_erikujud{");
        for (String string : this.arvuTyybid) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int parsiYksikRoomaNumber(String string) {
        for (Object[] objectArray : romanToArabic) {
            String string2 = (String)objectArray[0];
            if (!string2.equalsIgnoreCase(string)) continue;
            return (Integer)objectArray[1];
        }
        return -1;
    }

    public static int parsiRoomaNumber(String string) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            int n2 = ArvuEriKujudSonaMall.parsiYksikRoomaNumber(string2);
            if (n2 > -1) {
                if (i == string.length() - 1) {
                    n += n2;
                } else {
                    int n3 = ArvuEriKujudSonaMall.parsiYksikRoomaNumber(string.substring(i + 1, i + 2));
                    if (n3 > -1) {
                        if (n2 >= n3) {
                            n += n2;
                        } else {
                            n += n3 - n2;
                            ++i;
                        }
                    } else {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            n = -1;
            break;
        }
        return n > 0 ? n : -1;
    }
}

