/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel;

import ee.ut.soras.ajavtV2.NumberTokenizer;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AjavtSona
extends MorfAnSona {
    private int startPosition = -1;
    private int endPosition = -1;
    private int innerTokenPosition = -1;
    private boolean atTokenBreakPosition = false;
    private String algSonaErisymbolidNormaliseeritud = null;
    private String algSonaYmbritsevateMarkideta = null;
    private FraasisPaiknemiseKoht arvSonaFraasis = FraasisPaiknemiseKoht.PUUDUB;
    private Integer arvSonaTaisArvVaartus = null;
    private Double arvSonaMurdArvVaartus = null;
    private List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = null;
    private List<AjavaljendiKandidaat> ajavaljendiKandidaadid = null;
    private boolean onPotentsiaalneVahemikuAlgus = false;
    private boolean onPotentsiaalneVahemikuLopp = false;
    private GRAMMATILINE_AEG grammatilineAeg = GRAMMATILINE_AEG.MAARAMATA;

    public AjavtSona(String string) {
        super(string);
        if (string.length() <= 50) {
            this.algSonaErisymbolidNormaliseeritud = TextUtils.normalizeSpecialSymbols(string);
            this.algSonaYmbritsevateMarkideta = TextUtils.trimSurroundingPunctation(this.algSonaErisymbolidNormaliseeritud);
            if (string.equals(this.algSonaYmbritsevateMarkideta) || this.algSonaYmbritsevateMarkideta.length() == 0) {
                this.algSonaYmbritsevateMarkideta = this.algSonaErisymbolidNormaliseeritud;
            }
        }
    }

    public AjavtSona(MorfAnSona morfAnSona, String string) {
        super(string != null ? string : morfAnSona.getAlgSona());
        for (int i = 0; i < morfAnSona.getAnalyysiTulemused().size(); ++i) {
            super.lisaAnalyysiRida(morfAnSona.getAnalyysiTulemused().get(i));
        }
        super.setTokenPosition(morfAnSona.getTokenPosition());
        String string2 = this.getAlgSona();
        if (string2.length() <= 50) {
            this.algSonaErisymbolidNormaliseeritud = TextUtils.normalizeSpecialSymbols(string2);
            this.algSonaYmbritsevateMarkideta = TextUtils.trimSurroundingPunctation(this.algSonaErisymbolidNormaliseeritud);
            if (string2.equals(this.algSonaYmbritsevateMarkideta) || this.algSonaYmbritsevateMarkideta.length() == 0) {
                this.algSonaYmbritsevateMarkideta = this.algSonaErisymbolidNormaliseeritud;
            }
        }
    }

    public void eemaldaYlekattuvadAjavaljendiKandidaadid() {
        ArrayList<AjavaljendiKandidaat> arrayList = new ArrayList<AjavaljendiKandidaat>();
        for (int i = 0; i < this.ajavaljendiKandidaadid.size(); ++i) {
            AjavaljendiKandidaat ajavaljendiKandidaat = this.ajavaljendiKandidaadid.get(i);
            if (!ajavaljendiKandidaat.onYlekaetudTeisteAjavaljendifraasidePoolt()) continue;
            arrayList.add(ajavaljendiKandidaat);
        }
        for (AjavaljendiKandidaat ajavaljendiKandidaat : arrayList) {
            ajavaljendiKandidaat.eemaldaEnnastSonadeKyljest();
        }
    }

    public void eemaldaAjavaljendiKandidaat(AjavaljendiKandidaat ajavaljendiKandidaat) {
        Iterator<AjavaljendiKandidaat> iterator = this.ajavaljendiKandidaadid.iterator();
        Iterator<FraasisPaiknemiseKoht> iterator2 = this.ajavaljendiKandidaatides.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            AjavaljendiKandidaat ajavaljendiKandidaat2 = iterator.next();
            iterator2.next();
            if (!ajavaljendiKandidaat2.equals(ajavaljendiKandidaat)) continue;
            iterator.remove();
            iterator2.remove();
            break;
        }
    }

    public List<Integer> parsiPotentsVahemikugaSeotudArvud() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        if (this.onSeotudMoneAjavaljendiKandidaadiga()) {
            for (AjavaljendiKandidaat ajavaljendiKandidaat : this.ajavaljendiKandidaadid) {
                if (ajavaljendiKandidaat.getAste() != AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA && ajavaljendiKandidaat.getAste() != AjavaljendiKandidaat.ASTE.MUSTRI_POOLT_ERALDATUD) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            if (this.getArvSonaFraasis().onFraasiAlgus() && this.getArvSonaTaisArvVaartus() != null) {
                arrayList.add(this.getArvSonaTaisArvVaartus());
            } else if (this.getArvSonaFraasis() == FraasisPaiknemiseKoht.PUUDUB) {
                List<String> list = NumberTokenizer.extractNumbersWithTrailingPunctation(this.getAlgSona(), false);
                for (int i = 0; i < list.size(); ++i) {
                    if (((String)list.get(i)).length() <= 0) continue;
                    try {
                        Integer n = Integer.valueOf((String)list.get(i));
                        if (n == null) continue;
                        arrayList.add(n);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    public boolean arvudeEsitusKujuOnYhilduv(AjavtSona ajavtSona) {
        return this.arvSonaFraasis == ajavtSona.arvSonaFraasis || this.arvSonaFraasis != FraasisPaiknemiseKoht.PUUDUB && ajavtSona.arvSonaFraasis != FraasisPaiknemiseKoht.PUUDUB;
    }

    public void margendaAjavaljendiKandidaadiga(AjavaljendiKandidaat ajavaljendiKandidaat, FraasisPaiknemiseKoht fraasisPaiknemiseKoht) {
        if (this.ajavaljendiKandidaadid == null) {
            this.ajavaljendiKandidaatides = new ArrayList<FraasisPaiknemiseKoht>();
            this.ajavaljendiKandidaadid = new ArrayList<AjavaljendiKandidaat>();
        }
        this.ajavaljendiKandidaadid.add(ajavaljendiKandidaat);
        this.ajavaljendiKandidaatides.add(fraasisPaiknemiseKoht);
    }

    public boolean onSeotudMoneAjavaljendiKandidaadiga() {
        return this.ajavaljendiKandidaadid != null && this.ajavaljendiKandidaadid.size() > 0;
    }

    public boolean onVoimalikTsiteeringuLoppVoiAlgus() {
        String string = this.getAlgSonaErisymbolidNormaliseeritud();
        if (string != null) {
            boolean bl = TextUtils.beginningOfQuote.matcher(string).matches();
            boolean bl2 = TextUtils.endOfQuote.matcher(string).matches();
            return bl && !bl2 || !bl && bl2 || bl && bl2 && string.length() == 1;
        }
        return false;
    }

    public List<FraasisPaiknemiseKoht> getAjavaljendiKandidaatides() {
        return this.ajavaljendiKandidaatides;
    }

    public List<AjavaljendiKandidaat> getAjavaljendiKandidaadid() {
        return this.ajavaljendiKandidaadid;
    }

    public FraasisPaiknemiseKoht getArvSonaFraasis() {
        return this.arvSonaFraasis;
    }

    public void setArvSonaFraasis(FraasisPaiknemiseKoht fraasisPaiknemiseKoht) {
        this.arvSonaFraasis = fraasisPaiknemiseKoht;
    }

    public Integer getArvSonaTaisArvVaartus() {
        return this.arvSonaTaisArvVaartus;
    }

    public void setArvSonaTaisArvVaartus(Integer n) {
        this.arvSonaTaisArvVaartus = n;
    }

    public Double getArvSonaMurdArvVaartus() {
        return this.arvSonaMurdArvVaartus;
    }

    public void setArvSonaMurdArvVaartus(Double d) {
        this.arvSonaMurdArvVaartus = d;
    }

    public boolean isOnPotentsiaalneVahemikuAlgus() {
        return this.onPotentsiaalneVahemikuAlgus;
    }

    public void setOnPotentsiaalneVahemikuAlgus(boolean bl) {
        this.onPotentsiaalneVahemikuAlgus = bl;
    }

    public boolean isOnPotentsiaalneVahemikuLopp() {
        return this.onPotentsiaalneVahemikuLopp;
    }

    public void setOnPotentsiaalneVahemikuLopp(boolean bl) {
        this.onPotentsiaalneVahemikuLopp = bl;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int n) {
        this.startPosition = n;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int n) {
        this.endPosition = n;
    }

    public int getInnerTokenPosition() {
        return this.innerTokenPosition;
    }

    public void setInnerTokenPosition(int n) {
        this.innerTokenPosition = n;
    }

    public boolean isAtTokenBreakPosition() {
        return this.atTokenBreakPosition;
    }

    public void setAtTokenBreakPosition(boolean bl) {
        this.atTokenBreakPosition = bl;
    }

    public String getAlgSonaYmbritsevateMarkideta() {
        if (this.algSonaYmbritsevateMarkideta != null) {
            return this.algSonaYmbritsevateMarkideta;
        }
        return this.getAlgSona();
    }

    public String getAlgSonaErisymbolidNormaliseeritud() {
        if (this.algSonaErisymbolidNormaliseeritud != null) {
            return this.algSonaErisymbolidNormaliseeritud;
        }
        return this.getAlgSona();
    }

    public GRAMMATILINE_AEG getGrammatilineAeg() {
        return this.grammatilineAeg;
    }

    public void setGrammatilineAeg(GRAMMATILINE_AEG gRAMMATILINE_AEG) {
        this.grammatilineAeg = gRAMMATILINE_AEG;
    }

    public static enum GRAMMATILINE_AEG {
        MAARAMATA,
        OLEVIK,
        TAISMINEVIK,
        LIHTMINEVIK,
        ENNEMINEVIK,
        YLDMINEVIK,
        KS_MINEVIK,
        KS_OLEVIK;

    }
}

