/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberTokenizer {
    private static final Pattern musterSisaldabArvuJaMitteArvu = Pattern.compile("(\\d\\D|\\D\\d)");
    private static final Pattern hypenPattern1 = Pattern.compile("(\\d+([.:]\\d+)?-\\d+([.:]\\d+)?)(\\\\|/)(\\d+([.:]\\d+)?-\\d+([.:]\\d+)?)");
    private static final Pattern hypenPattern2 = Pattern.compile("\\d+-\\d+-([a-z]|\u00f6).*");
    private static final Pattern hypenPattern3 = Pattern.compile("\\d+-\\d+-");
    private static final Pattern hypenPattern4 = Pattern.compile("\\d\\d\\d\\d-\\d+-\\d+");
    private static final Pattern pointPattern1 = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+.*");
    private static final Pattern acronymPattern1 = Pattern.compile("[A-Z][a-zA-Z]*-?\\d+.*");
    private static final Pattern htmlEntityPattern1 = Pattern.compile(".*&#[0-9]+;.*");

    public static boolean isNumberTokenizationNeeded(String string) {
        Matcher matcher = musterSisaldabArvuJaMitteArvu.matcher(string);
        if (matcher.find()) {
            if (!NumberTokenizer.passesHypenGuard(string)) {
                return false;
            }
            if (!NumberTokenizer.passesPointGuard(string)) {
                return false;
            }
            if (!NumberTokenizer.passesAcronymGuard(string)) {
                return false;
            }
            return NumberTokenizer.passesHTMLEntityGuard(string);
        }
        return false;
    }

    public static boolean passesHypenGuard(String string) {
        String string2 = TextUtils.normalizeSpecialSymbols(string);
        int n = NumberTokenizer.countNumberOfOccurrences(string2, "-");
        if (n > 1) {
            if (hypenPattern1.matcher(string2).matches()) {
                return true;
            }
            if (hypenPattern2.matcher(string2).matches()) {
                return true;
            }
            if (hypenPattern3.matcher(string2).matches()) {
                return true;
            }
            return hypenPattern4.matcher(string2).matches();
        }
        return true;
    }

    public static boolean passesPointGuard(String string) {
        return !pointPattern1.matcher(string).matches();
    }

    public static boolean passesAcronymGuard(String string) {
        return !acronymPattern1.matcher(string).matches();
    }

    public static boolean passesHTMLEntityGuard(String string) {
        return !htmlEntityPattern1.matcher(string).matches();
    }

    public static int countNumberOfOccurrences(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            if ((n2 = string.indexOf(string2, n2)) == -1) continue;
            ++n;
            ++n2;
        }
        return n;
    }

    public static List<String> extractNumbersWithTrailingPunctation(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl3;
            String string2 = string.substring(i, i + 1);
            boolean bl4 = string2.compareTo("0") >= 0 && string2.compareTo("9") <= 0;
            boolean bl5 = string2.equals(",");
            boolean bl6 = bl3 = bl4 || bl5;
            if (i > 0 && bl3 && !bl2) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            }
            if (bl || !bl && bl3) {
                stringBuilder.append(string2);
            }
            bl2 = bl3;
            if (i != string.length() - 1 || stringBuilder.length() <= 0) continue;
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

