# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['work_components']

package_data = \
{'': ['*']}

modules = \
['work']
entry_points = \
{'console_scripts': ['work = work:main']}

setup_kwargs = {
    'name': 'work-time-log',
    'version': '0.99.0.post1',
    'description': 'Manual time tracking via a CLI that works similarly to git.',
    'long_description': '# Work time log\n\n`work` allows manual time tracking via a CLI that works similarly to `git`:\n\n1. Text files are used for storage. This makes it easy to track the log with `git`.\n2. The `work status` is global, meaning any terminal can be used to check or update it.\n3. Hashes are used to verify that the log was not modified by another tool.\n\n# Release history\n\n## 0.99 (WIP): Getting a better view\n\nThis is a work-in-progress release. Currently released version: `0.99.0` (2022-02-22)\n\n### New mode `view`\n\n- Until now, the only way to view entries was grouped by date (with `list`).\n- The new mode `view` allows other views on entries.\n- This version adds the `by-category` and `balance` view.\n\n#### `view by-category`\n\n- View entries grouped by their category.\n- Use cases:\n  + Quickly view categories used in the past in a compact form.\n  + Check how much work was done for a specific project (category), e.g. in the current week.\n\nFor example:\n\n```bash\n$ work view by-category --since 1.2.\ncategory            hours        %      records\n-----------------------------------------------\nproject-A/coding    16 h 30 m    40%    17\nmeetings            9 h          21%    5\n∅                   7 h          17%    19\nproject-B/coding    4 h 30 m     10%    7\nproject-B/slides    3 h 30 m     8%     4\nhelp                30 m         1%     1\n-----------------------------------------------\nTotal               41 h                76\n```\n\nAbove, `∅` is used to represent entries without a category.\n\nWe could combine this with a filter (more on the new filters below) to check how much we worked for `project-B`:\n\n```bash\n$ work view by-category --since 1.2. --Fc "project-B*"\ncategory            hours        %      records\n-----------------------------------------------\nproject-B/coding    4 h 30 m     56%    7\nproject-B/slides    3 h 30 m     44%    4\n-----------------------------------------------\nTotal               8 h                 11\n```\n\n#### `view balance`\n\n- View the balance, and how it developed, over multiple weeks or longer periods.\n- Until now, the balance was only tracked over the current week. This view allows arbitrary periods for balance calculation.\n- Use case: Check for accumulated overtime over a longer period of time, e.g. the past year or even since you started tracking your work.\n\nFor example, assuming it is Tuesday, 2022-02-22:\n\n```bash\n$ work view balance --week\nDay      Date      Days    Expected    Worked       Balance graph\n-----------------------------------------------------------------------\nMon      21.02.    1       8 h         8 h          |        |        |\nTue      22.02.    1       8 h         5 h 45 m     |      ==|        |\nWed      23.02.    1       8 h         0 m          |========|        |\nThu      24.02.    1       8 h         0 m          |========|        |\nFri      25.02.    1       8 h         0 m          |========|        |\nSat      26.02.    1       0 m         0 m          |        |        |\nSun      27.02.    1       0 m         0 m          |        |        |\n-----------------------------------------------------------------------\nTotal              7       40 h        13 h 45 m    26 h 15 m remaining\n```\n\nAlternatively, we can take a look back to previous weeks, e.g.:\n\n```bash\n$ work view balance --period 3.1. 20.2.\nWeek     Date range         Days    Expected    Worked       Balance graph\n--------------------------------------------------------------------------------\nw. 01    03.01. – 09.01.    7       32 h        32 h         |        |        |\nw. 02    10.01. – 16.01.    7       40 h        40 h         |        |        |\nw. 03    17.01. – 23.01.    7       40 h        40 h         |        |        |\nw. 04    24.01. – 30.01.    7       40 h        40 h         |        |        |\nw. 05    31.01. – 06.02.    7       40 h        37 h 30 m    |       =|        |\nw. 06    07.02. – 13.02.    7       40 h        42 h 30 m    |        |=       |\nw. 07    14.02. – 20.02.    7       40 h        45 h         |        |=       |\n--------------------------------------------------------------------------------\nTotal                       49      272 h       277 h        5 h overtime\n```\n\nLonger periods are grouped by month:\n\n```bash\n$ work view balance --period 1.9.21 31.12.2021\nMonth    Date range             Days    Expected    Worked       Balance graph\n-------------------------------------------------------------------------------------\nSep      01.09.21 – 30.09.21    30      176 h       177 h        |        |        |\nOct      01.10.21 – 31.10.21    31      168 h       168 h        |        |        |\nNov      01.11.21 – 30.11.21    30      176 h       180 h        |        |        |\nDec      01.12.21 – 31.12.21    31      144 h       100 h        |      ==|        |\n-------------------------------------------------------------------------------------\nTotal                           122     664 h       625 h        39 h remaining\n```\n\n### Filtering for `list` (and `view`)\n\n- Beyond selecting the date (range), records can now optionally be filtered based on both category or message.\n- New flags: `--filter-category` / `--Fc` and `--filter-message` / `--Fm`\n- By default, the complete category or message must match, but glob patterns (with `*`) are supported.\n\nFor example:\n\n```bash\n$ work ls\nTue, 22.02.: 3 records\n10:00 – 12:00 | 2 h   (project-B/slides)   "Slides for customer meeting on 2022-03-01"\n12:00 – 12:30 | 3 h   (project-A/coding)\n14:00 – 15:00 | 45 m                       "Cleaned office"\n              = 5 h 45 m\n\n$ work ls --Fc "project*"\nTue, 22.02.: 2 records\n10:00 – 12:00 | 2 h   (project-B/slides)   "Slides for customer meeting on 2022-03-01"\n12:00 – 12:30 | 3 h   (project-A/coding)\n              = 5 h\n\n$ work ls --Fc "project*" --Fm "*customer*"\nTue, 22.02.: 1 record\n10:00 – 12:00 | 2 h   (project-B/slides)   "Slides for customer meeting on 2022-03-01"\n              = 2 h\n```\n\n### Expanded date selection\n\n- `add`, `edit`, and `remove` now also support `--yesterday` / `-1` and `--day`\n- For `list`, `view`, and `export`:\n  + New `--since` selector equivalent to `--period X today`\n  + The `--month` selector now allows (optionally) passing a DATE, to select a month by one of its dates. E.g., `--month 1.1.` selects January of the current year.\n\n### More robust `edit`ing\n\n- The improved handling for multi-record editing introduced in v0.97 has been finalized.\n- Most noticeable will be that now multiple entries can be edited in such a way that each individual edit would be invalid, but the final state is valid again. E.g., two records (`10–12` and `12–13`) can be shifted at once (to `10–12:30` and `12:30–13`).\n- Also, if an individual edit operation encounters an error, the complete edit will be rolled back safely.\n\n### Changes\n\n- If an invalid state is detected but fixed by the user, the originally requested command is now retried automatically.\n- Output:\n  + `hours`: Both `--until` and `--target` / `-8` now print the projected balance at the assumed end time.\n  + When stopping or switching, the recorded run length will be printed out, e.g.: `"Stopped work at 17:30 today (30 m recorded)"`\n  + When an invalid state is detected, the user will no longer be offered to "abort", instead use Ctrl-C.\n- CLI:\n  + `switch`: The command alias `pause` will be deprecated in an upcoming version; a warning is printed if it is used.\n  + `recess`: The primary name has been changed to `free-days` for clarity. The alias `recess` will remain as an option for now.\n  + The short flag for `--version` is now `-V`.\n- This version removes the migration code for the info file.\n\n### Fixed bugs\n\n- `edit`: Invalid changes no longer lead to deletion of the last edited record.\n\n\n## 0.98: Improved selection interface and fine-grained `hours` calculation\n\nFinal release version: `0.98.1` (2021-12-18)\n\n### New `edit` and `remove` selection interface\n\n- A new selection interface to improve readability (inspired by `fish`\'s `history` tool).\n- Now allows selection of multiple indices at once.\n- By entering nothing, the selection can be immediately cancelled.\n\nFor example:\n\n```bash\n$ work add 10 14 -c supre\n$ work add 15 17:5 -m "ji"\n$ work edit\nEdit mode – today\n\n[0] 10:00 – 14:00 (supre) ""\n[1] 15:00 – 17:05 () "ji"\n\nEnter nothing to cancel, or\nEnter one or more indices [0..1] separated by a space, or\nEnter "all" to edit all entries.\n\nWhich entries? > \n```\n\n### New flags for `hours` calculation\n\n- New flag `--start` to override the assumed start time.\n- New flag `--pause` to include planned breaks in the calculation.\n- Assumptions for the calculations are only printed once if multiple modes are selected.\n- Flag `--balance` removed – the balance is now always printed.\n\nFor example (assume it is 14:17):\n\n```bash\n$ work start 12\nStarted work at 12:00 today\n\n$ work hours --until 17\n0 m on record, 2 h 17 m active run | Balance: 5 h 43 m remaining (8 h to work today)\n> You will have worked 5 h at target time 17:00.\n\n$ work cancel\nRun cancelled\n\n$ work hours --until 17\n0 m on record, 0 m active run | Balance: 8 h remaining (8 h to work today)\n\nAssuming you start now (14:15):\n> You will have worked 2 h 45 m at target time 17:00.\n\n$ work add 10 12\nAdded a record from 10:00 to 12:00 today\n\n$ work hours --until 17 --target 6 --start 14 --pause 0:30\n2 h on record, 0 m active run | Balance: 6 h remaining (8 h to work today)\n\nAssuming you start at 14:00 and take 30 m of breaks:\n> You will have worked 4 h 30 m at target time 17:00.\n> Work until 18:30 for a 6:00 hour day.\n```\n\n### Changes\n\n- Corrupted files will now be detected more robustly while parsing. Specifically this covers the case that a file is formatted validly, but the contents violate assumed invariants.\n\n### Fixed bugs\n\n- `recess`: If a vacation was added over multiple years, the days were added to both years.\n- `hours`: If a day started with overtime, an exception was raised.\n\n\n## 0.97: Force actions and edit better\n\nFinal release version: `0.97.4` (released 2021-08-17)\n\n### Force `start`, `resume`, `add`\n\nA new `--force` flag allows intentionally overriding some warnings:\n\n- `start --force`: Start even if a run is already active.\n- `resume --force`: Resume even if a new run was already started (undo `switch`).\n- `add --force`: Insert entries forcefully.\n  - If an entry is *subsumed*, remove and replace it.\n  - If an entry is *overlapped*, shorten it to make space.\n  - If an entry *contains* the forced entry, split it up and shorten the splits to make space in-between.\n\nFor example:\n\n```\n$ work ls\nFri, 28.05.: 1 records\n10:00 – 18:00 | 8 h  (original)\n              = 8 h\n\n$ work add 14 15 -c split --force\nExisting record split up: 10:00 – 18:00 (original) ""\n  ➜  10:00 – 14:00  &  15:00 – 18:00\nAdded a record from 14:00 to 15:00 today\n\n$ work ls\nFri, 28.05.: 3 records\n10:00 – 14:00 | 4 h  (original)\n14:00 – 15:00 | 1 h  (split)\n15:00 – 18:00 | 3 h  (original)\n              = 8 h\n```\n\n### New `edit` handling\n\n- When editing `"all"`, edits are only applied after all entries were iterated to allow cancelling any time and prevent some merge conflicts.\n- Category and message can now be removed when editing an entry by entering `"-"` as their new value.\n- Entering nothing and just pressing Enter now accepts a change, as is suggested by `[Y/n]` in the message.\n\n### `list` output improvements\n\n- `--include-active` now counts active run in total\n- `--only-time` now merges touching entries for output\n- `--with-breaks`:\n    + now shows breaks in separate lines\n    + now omits 0 minute breaks from the output.\n\n### Changes\n\n- `switch` now only allows one positional argument. To add a break before restarting, use the optional argument `--start H:M`.\n- The `--week` selector now allows an optional argument for the week number. If none is given, the current week is assumed.\n- `hours --target` now expects a string formatted as "H:M" instead of a float.\n- Entries with empty category and message are now printed as `<start> – <end> () ""`.\n- `recess`: Clearer error message when removing nonexistent day\n- completions: Global flags no longer suggested after sub-commands\n- packaging: Test modules now omitted from package\n\n### Known bugs\n\n- When editing `"all"` and changing an entry so that it would be merged with its *next* neighbor, an exception occurs.\n\n\n## 0.96: Expected hour management\n\nFinal release version: `0.96.3`\n\n### Expected hour management\n\n- New module `recess`\n  - Configure holidays, vacations, and days with reduced expected hours.\n  - The expected hours for the week and day will update accordingly.\n\nFor example:\n\n```shell\n$ work recess --add-vacation 1.2. 3.2.\n$ work recess --add-reduced-day 4.2. 2.0\n$ work recess --list\nVacation:\n  01.02.2021\n  02.02.2021\n  03.02.2021\nReduced hour days:\n  04.02.2021 (2.0 hours)\n```\n\n- Expected hours per weekday can now be configured in the RC file.\n\nFor example:\n\n```json\n{\n  "expected_hours": {\n    "Monday":    8.0,\n    "Tuesday":   8.0,\n    "Wednesday": 4.0,\n    "Thursday":  8.0,\n    "Friday":    8.0,\n    "Saturday":  2.0,\n    "Sunday":    0.0\n  }\n}\n```\n\nCheck your configuration with `work config --see "expected hours"`.\n\n### Calculation of presumed work time with `hours`\n\n- `--until` now handles differently depending on if a run is active.\n- Fixes hour calculation for runs starting in the future (`--target` and `--workday`).\n- Fixes presumed start time in `--until` if no run is active.\n\n### Changes\n\n- Output messages for `switch` are now more abstract and intuitive.\n-  `work config --expected` now prints the default configuration that is used by `work config --create`.\n- **Breaking**\n    + Old configuration files are now invalid, due to added (see above) and removed (see below) keys. Create a valid configuration file with `work config --create`.\n    + Autopause functionality removed, including the configuration option\n\n\n## 0.95: export and CLI convenience\n\n- New mode `export` that enables exporting entries of any date or date range as CSV.\n- `start` now understands the keyword `again`, enabling easy back-to-back entries after a run was stopped.\n- Time parsing now understands military time, e.g. `1400` = 14:00.\n- If a corrupted record file is detected on disk, its path is now printed out.\n\n### Fixes\n\n- Handles Ctrl-C more cleanly.\n- Fixes bug where entering nothing in `rehash` lead to a rehash.\n- Fixes bug where `list --include-active` would crash if an active run starts in the future.\n\n\n## 0.94: New verification algorithm\n\n- Verification algorithm changed: Replaced MD5 hash with a much faster Adler-32 checksum.\n  - As the hash was only meant to protect against accidental edits, priorities were shifted to increase the speed.\n  - Relative speed improvement: About 20–50 % faster, more with growing size.\n  - Absolute improvement: About 1 ms for large sets of records (5 years * 200 days * 10 records).\n- Empty folders for years and months in the records directory will be removed now.\n- This version removes the migration code introduced in v0.93. Make sure to migrate your records before updating.\n\nWith this update, your info file needs to be updated once. Please run `work rehash` to do that.\n\n\n## 0.93: Performance improvements\n\n- Alias "pause" for `switch`\n- Internal structural changes that make listing a huge number of days quicker.\n- Start-up checks slimmed down to reduce start-up time.\n- Adds verification functionality for traversed record directories; if an unexpected file name or type is encountered, an error is raised.\n\nDue to a bug in previous versions, not all entries were migrated from protocol v2 to protocol v3. It is recommended to run `work ls --period 1.1.1900 31.12.2100` once (this traverses all entries in the protocol). This will fix any leftover entries automatically.\n\n\n## 0.92: switch\n\nNew `switch` function\n- The `pause` function was deprecated in favor of the new `switch` function.\n- The old functionality "stop at time A, restart at time B" has been preserved.\n- New: only one time argument can be passed.\n  - This enables a "switch in place" functionality.\n  - When a new task is started, this command suffices to save the completed work and immediately start a new task.\n\n\n## 0.9: Category and message\n\nFinal release version: `0.91`\n\n- Entries can now have an optional category and message.\n- Both can be added when stopping a run or adding an entry.\n- When listing entries, these fields can be displayed.\n',
    'author': 'Valentin',
    'author_email': 'noemail@example.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
