#!/usr/bin/python
# -*- coding: utf-8 -*-

#
# Address field
#
ADDRESS_BROADCAST_REPLY = 0xFE
ADDRESS_BROADCAST_NOREPLY = 0xFF
ADDRESS_NETWORK_LAYER = 0xFD

#
# Control field
#
CONTROL_FIELD_DIRECTION = 0x07
CONTROL_FIELD_FCB = 0x06
CONTROL_FIELD_ACD = 0x06
CONTROL_FIELD_FCV = 0x05
CONTROL_FIELD_DFC = 0x05
CONTROL_FIELD_F3 = 0x04
CONTROL_FIELD_F2 = 0x03
CONTROL_FIELD_F1 = 0x02
CONTROL_FIELD_F0 = 0x01

CONTROL_MASK_SND_NKE = 0x40
CONTROL_MASK_SND_UD = 0x53
CONTROL_MASK_REQ_UD2 = 0x5B
CONTROL_MASK_REQ_UD1 = 0x5A
CONTROL_MASK_RSP_UD = 0x08

CONTROL_MASK_FCB = 0x20
CONTROL_MASK_FCV = 0x10

CONTROL_MASK_ACD = 0x20
CONTROL_MASK_DFC = 0x10

CONTROL_MASK_DIR = 0x40
CONTROL_MASK_DIR_M2S = 0x40
CONTROL_MASK_DIR_S2M = 0x00

#
# Control field
#
CONTROL_INFO_DATA_SEND = 0x51
CONTROL_INFO_DATA_SEND_MSB = 0x55
CONTROL_INFO_SELECT_SLAVE = 0x52
CONTROL_INFO_SELECT_SLAVE_MSB = 0x56
CONTROL_INFO_APPLICATION_RESET = 0x50
CONTROL_INFO_SYNC_ACTION = 0x54
CONTROL_INFO_SET_BAUDRATE_300 = 0xB8
CONTROL_INFO_SET_BAUDRATE_600 = 0xB9
CONTROL_INFO_SET_BAUDRATE_1200 = 0xBA
CONTROL_INFO_SET_BAUDRATE_2400 = 0xBB
CONTROL_INFO_SET_BAUDRATE_4800 = 0xBC
CONTROL_INFO_SET_BAUDRATE_9600 = 0xBD
CONTROL_INFO_SET_BAUDRATE_19200 = 0xBE
CONTROL_INFO_SET_BAUDRATE_38400 = 0xBF
CONTROL_INFO_REQUEST_RAM_READ = 0xB1
CONTROL_INFO_SEND_USER_DATA = 0xB2
CONTROL_INFO_INIT_TEST_CALIB = 0xB3
CONTROL_INFO_EEPROM_READ = 0xB4
CONTROL_INFO_SW_TEST_START = 0xB6

CONTROL_INFO_ERROR_GENERAL = 0x70
CONTROL_INFO_STATUS_ALARM = 0x71

CONTROL_INFO_RESP_FIXED = 0x73
CONTROL_INFO_RESP_FIXED_MSB = 0x77

CONTROL_INFO_RESP_VARIABLE = 0x72
CONTROL_INFO_RESP_VARIABLE_MSB = 0x76

# Control Mask
CONTROL_MASK_FCB = 0x20
CONTROL_MASK_FCV = 0x10


FRAME_DATA_LENGTH = 252

FRAME_ACK_START = 0xE5
FRAME_SHORT_START = 0x10
FRAME_CONTROL_START = 0x68
FRAME_LONG_START = 0x68
FRAME_STOP = 0x16

MAX_PRIMARY_SLAVES = 250

