"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToStepFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_stepfunctions_1 = require("@aws-solutions-constructs/aws-s3-stepfunctions");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class S3ToStepFunction extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the S3ToStepFunction class.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new S3ToStepfunctions instead of S3ToStepFunction)
        const wrappedConstruct = new aws_s3_stepfunctions_1.S3ToStepfunctions(this, `${id}W`, convertedProps);
        this.stateMachine = wrappedConstruct.stateMachine;
        this.stateMachineLogGroup = wrappedConstruct.stateMachineLogGroup;
        this.s3Bucket = wrappedConstruct.s3Bucket;
        this.s3LoggingBucket = wrappedConstruct.s3LoggingBucket;
        this.cloudwatchAlarms = wrappedConstruct.cloudwatchAlarms;
        this.cloudtrail = wrappedConstruct.cloudtrail;
        this.cloudtrailBucket = wrappedConstruct.cloudtrailBucket;
        this.cloudtrailLoggingBucket = wrappedConstruct.cloudtrailLoggingBucket;
    }
}
exports.S3ToStepFunction = S3ToStepFunction;
_a = JSII_RTTI_SYMBOL_1;
S3ToStepFunction[_a] = { fqn: "@aws-solutions-constructs/aws-s3-step-function.S3ToStepFunction", version: "1.126.0" };
//# sourceMappingURL=data:application/json;base64,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