# Copyright 2021 IRT Saint Exupéry, https://www.irt-saintexupery.com
#
# This work is licensed under a BSD 0-Clause License.
#
# Permission to use, copy, modify, and/or distribute this software
# for any purpose with or without fee is hereby granted.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT,
# OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

import sys

from gemseo.api import create_discipline, create_scenario

num = int(sys.argv[1])

disciplines = create_discipline(
    [
        "SobieskiPropulsion",
        "SobieskiAerodynamics",
        "SobieskiMission",
        "SobieskiStructure",
    ]
)

scenario = create_scenario(
    disciplines,
    formulation="MDF",
    objective_name="y_4",
    maximize_objective=True,
    scenario_type="DOE",
    design_space="design_space.txt",
)

scenario.set_differentiation_method("user")

algo_options = {"n_samples": num, "algo": "lhs"}

for constraint in ["g_1", "g_2", "g_3"]:
    scenario.add_constraint(constraint, "ineq")

scenario.execute(algo_options)

scenario.post_process(
    "SOM",
    n_x=2,
    n_y=2,
    save=True,
    show=False,
    file_path="mdf2_" + str(num),
    extension="png",
)
scenario.post_process(
    "SOM",
    n_x=4,
    n_y=4,
    save=True,
    show=False,
    file_path="mdf4_" + str(num),
    extension="png",
)
scenario.post_process(
    "SOM",
    n_x=16,
    n_y=16,
    save=True,
    show=False,
    file_path="mdf16_" + str(num),
    extension="png",
)
