# Generated by Django 3.0.3 on 2020-03-03 18:45

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True)),
                ('balance', models.FloatField(default=0, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='AccountType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True)),
                ('bal_type', models.CharField(choices=[('C', 'Credit'), ('D', 'Debit')], help_text='Indicate whether the account type is a credi or debit', max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('amount', models.FloatField()),
                ('note', models.TextField(blank=True, max_length=256, null=True)),
                ('from_acc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='from_account', to='dbaccounting.Account')),
                ('to_acc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='to_account', to='dbaccounting.Account')),
            ],
        ),
        migrations.AddField(
            model_name='account',
            name='acc_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dbaccounting.AccountType'),
        ),
    ]
