# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 allow_insecure_https: Optional[pulumi.Input[bool]] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 skip_version_check: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[bool] allow_insecure_https: Flag to set whether to allow https with invalid certificates
        :param pulumi.Input[str] api_token: Netbox API authentication token
        :param pulumi.Input[Mapping[str, Any]] headers: Set these header on all requests to Netbox
        :param pulumi.Input[str] server_url: Location of Netbox server including scheme and optional port
        :param pulumi.Input[bool] skip_version_check: If true, do not try to determine the running Netbox version at provider startup. Disables warnings about possibly
               unsupported Netbox version. Also useful for local testing on terraform plans.
        """
        if allow_insecure_https is not None:
            pulumi.set(__self__, "allow_insecure_https", allow_insecure_https)
        if api_token is None:
            api_token = _utilities.get_env('NETBOX_API_TOKEN')
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if server_url is None:
            server_url = _utilities.get_env('NETBOX_SERVER_URL')
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if skip_version_check is not None:
            pulumi.set(__self__, "skip_version_check", skip_version_check)

    @property
    @pulumi.getter(name="allowInsecureHttps")
    def allow_insecure_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to set whether to allow https with invalid certificates
        """
        return pulumi.get(self, "allow_insecure_https")

    @allow_insecure_https.setter
    def allow_insecure_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure_https", value)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[str]]:
        """
        Netbox API authentication token
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Set these header on all requests to Netbox
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[str]]:
        """
        Location of Netbox server including scheme and optional port
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="skipVersionCheck")
    def skip_version_check(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, do not try to determine the running Netbox version at provider startup. Disables warnings about possibly
        unsupported Netbox version. Also useful for local testing on terraform plans.
        """
        return pulumi.get(self, "skip_version_check")

    @skip_version_check.setter
    def skip_version_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_version_check", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure_https: Optional[pulumi.Input[bool]] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 skip_version_check: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The provider type for the netbox package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_insecure_https: Flag to set whether to allow https with invalid certificates
        :param pulumi.Input[str] api_token: Netbox API authentication token
        :param pulumi.Input[Mapping[str, Any]] headers: Set these header on all requests to Netbox
        :param pulumi.Input[str] server_url: Location of Netbox server including scheme and optional port
        :param pulumi.Input[bool] skip_version_check: If true, do not try to determine the running Netbox version at provider startup. Disables warnings about possibly
               unsupported Netbox version. Also useful for local testing on terraform plans.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the netbox package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure_https: Optional[pulumi.Input[bool]] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 skip_version_check: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["allow_insecure_https"] = pulumi.Output.from_input(allow_insecure_https).apply(pulumi.runtime.to_json) if allow_insecure_https is not None else None
            if api_token is None:
                api_token = _utilities.get_env('NETBOX_API_TOKEN')
            __props__.__dict__["api_token"] = api_token
            __props__.__dict__["headers"] = pulumi.Output.from_input(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            if server_url is None:
                server_url = _utilities.get_env('NETBOX_SERVER_URL')
            __props__.__dict__["server_url"] = server_url
            __props__.__dict__["skip_version_check"] = pulumi.Output.from_input(skip_version_check).apply(pulumi.runtime.to_json) if skip_version_check is not None else None
        super(Provider, __self__).__init__(
            'netbox',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[str]]:
        """
        Netbox API authentication token
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[Optional[str]]:
        """
        Location of Netbox server including scheme and optional port
        """
        return pulumi.get(self, "server_url")

