# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_type_id: pulumi.Input[int],
                 cluster_group_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        """
        pulumi.set(__self__, "cluster_type_id", cluster_type_id)
        if cluster_group_id is not None:
            pulumi.set(__self__, "cluster_group_id", cluster_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterTypeId")
    def cluster_type_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "cluster_type_id")

    @cluster_type_id.setter
    def cluster_type_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "cluster_type_id", value)

    @property
    @pulumi.getter(name="clusterGroupId")
    def cluster_group_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cluster_group_id")

    @cluster_group_id.setter
    def cluster_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 cluster_group_id: Optional[pulumi.Input[int]] = None,
                 cluster_type_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        """
        if cluster_group_id is not None:
            pulumi.set(__self__, "cluster_group_id", cluster_group_id)
        if cluster_type_id is not None:
            pulumi.set(__self__, "cluster_type_id", cluster_type_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterGroupId")
    def cluster_group_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cluster_group_id")

    @cluster_group_id.setter
    def cluster_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_group_id", value)

    @property
    @pulumi.getter(name="clusterTypeId")
    def cluster_type_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cluster_type_id")

    @cluster_type_id.setter
    def cluster_type_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_type_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_group_id: Optional[pulumi.Input[int]] = None,
                 cluster_type_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        From the [official documentation](https://docs.netbox.dev/en/stable/core-functionality/virtualization/#clusters):

        > A cluster is a logical grouping of physical resources within which virtual machines run. A cluster must be assigned a type (technological classification), and may optionally be assigned to a cluster group, site, and/or tenant. Each cluster must have a unique name within its assigned group and/or site, if any.
        > 
        > Physical devices may be associated with clusters as hosts. This allows users to track on which host(s) a particular virtual machine may reside. However, NetBox does not support pinning a specific VM within a cluster to a particular host device.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_netbox as netbox

        dc_west = netbox.get_cluster_group(name="dc-west")
        vmw_vsphere = netbox.ClusterType("vmwVsphere")
        vmw_cluster01 = netbox.Cluster("vmwCluster01",
            cluster_type_id=vmw_vsphere.id,
            cluster_group_id=dc_west.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        From the [official documentation](https://docs.netbox.dev/en/stable/core-functionality/virtualization/#clusters):

        > A cluster is a logical grouping of physical resources within which virtual machines run. A cluster must be assigned a type (technological classification), and may optionally be assigned to a cluster group, site, and/or tenant. Each cluster must have a unique name within its assigned group and/or site, if any.
        > 
        > Physical devices may be associated with clusters as hosts. This allows users to track on which host(s) a particular virtual machine may reside. However, NetBox does not support pinning a specific VM within a cluster to a particular host device.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_netbox as netbox

        dc_west = netbox.get_cluster_group(name="dc-west")
        vmw_vsphere = netbox.ClusterType("vmwVsphere")
        vmw_cluster01 = netbox.Cluster("vmwCluster01",
            cluster_type_id=vmw_vsphere.id,
            cluster_group_id=dc_west.id)
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_group_id: Optional[pulumi.Input[int]] = None,
                 cluster_type_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["cluster_group_id"] = cluster_group_id
            if cluster_type_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type_id'")
            __props__.__dict__["cluster_type_id"] = cluster_type_id
            __props__.__dict__["name"] = name
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["tags"] = tags
        super(Cluster, __self__).__init__(
            'netbox:index/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_group_id: Optional[pulumi.Input[int]] = None,
            cluster_type_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["cluster_group_id"] = cluster_group_id
        __props__.__dict__["cluster_type_id"] = cluster_type_id
        __props__.__dict__["name"] = name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["tags"] = tags
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterGroupId")
    def cluster_group_id(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "cluster_group_id")

    @property
    @pulumi.getter(name="clusterTypeId")
    def cluster_type_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "cluster_type_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "tags")

