# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CircuitTerminationArgs', 'CircuitTermination']

@pulumi.input_type
class CircuitTerminationArgs:
    def __init__(__self__, *,
                 circuit_id: pulumi.Input[int],
                 site_id: pulumi.Input[int],
                 term_side: pulumi.Input[str],
                 port_speed: Optional[pulumi.Input[int]] = None,
                 upstream_speed: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a CircuitTermination resource.
        """
        pulumi.set(__self__, "circuit_id", circuit_id)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "term_side", term_side)
        if port_speed is not None:
            pulumi.set(__self__, "port_speed", port_speed)
        if upstream_speed is not None:
            pulumi.set(__self__, "upstream_speed", upstream_speed)

    @property
    @pulumi.getter(name="circuitId")
    def circuit_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "circuit_id")

    @circuit_id.setter
    def circuit_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "circuit_id", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="termSide")
    def term_side(self) -> pulumi.Input[str]:
        return pulumi.get(self, "term_side")

    @term_side.setter
    def term_side(self, value: pulumi.Input[str]):
        pulumi.set(self, "term_side", value)

    @property
    @pulumi.getter(name="portSpeed")
    def port_speed(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port_speed")

    @port_speed.setter
    def port_speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_speed", value)

    @property
    @pulumi.getter(name="upstreamSpeed")
    def upstream_speed(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "upstream_speed")

    @upstream_speed.setter
    def upstream_speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "upstream_speed", value)


@pulumi.input_type
class _CircuitTerminationState:
    def __init__(__self__, *,
                 circuit_id: Optional[pulumi.Input[int]] = None,
                 port_speed: Optional[pulumi.Input[int]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 term_side: Optional[pulumi.Input[str]] = None,
                 upstream_speed: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CircuitTermination resources.
        """
        if circuit_id is not None:
            pulumi.set(__self__, "circuit_id", circuit_id)
        if port_speed is not None:
            pulumi.set(__self__, "port_speed", port_speed)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if term_side is not None:
            pulumi.set(__self__, "term_side", term_side)
        if upstream_speed is not None:
            pulumi.set(__self__, "upstream_speed", upstream_speed)

    @property
    @pulumi.getter(name="circuitId")
    def circuit_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "circuit_id")

    @circuit_id.setter
    def circuit_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "circuit_id", value)

    @property
    @pulumi.getter(name="portSpeed")
    def port_speed(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port_speed")

    @port_speed.setter
    def port_speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_speed", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="termSide")
    def term_side(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "term_side")

    @term_side.setter
    def term_side(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "term_side", value)

    @property
    @pulumi.getter(name="upstreamSpeed")
    def upstream_speed(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "upstream_speed")

    @upstream_speed.setter
    def upstream_speed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "upstream_speed", value)


class CircuitTermination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 circuit_id: Optional[pulumi.Input[int]] = None,
                 port_speed: Optional[pulumi.Input[int]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 term_side: Optional[pulumi.Input[str]] = None,
                 upstream_speed: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        From the [official documentation](https://docs.netbox.dev/en/stable/core-functionality/circuits/#circuit-terminations):

        > The association of a circuit with a particular site and/or device is modeled separately as a circuit termination. A circuit may have up to two terminations, labeled A and Z. A single-termination circuit can be used when you don't know (or care) about the far end of a circuit (for example, an Internet access circuit which connects to a transit provider). A dual-termination circuit is useful for tracking circuits which connect two sites.
        > 
        > Each circuit termination is attached to either a site or to a provider network. Site terminations may optionally be connected via a cable to a specific device interface or port within that site. Each termination must be assigned a port speed, and can optionally be assigned an upstream speed if it differs from the downstream speed (a common scenario with e.g. DOCSIS cable modems). Fields are also available to track cross-connect and patch panel details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CircuitTerminationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        From the [official documentation](https://docs.netbox.dev/en/stable/core-functionality/circuits/#circuit-terminations):

        > The association of a circuit with a particular site and/or device is modeled separately as a circuit termination. A circuit may have up to two terminations, labeled A and Z. A single-termination circuit can be used when you don't know (or care) about the far end of a circuit (for example, an Internet access circuit which connects to a transit provider). A dual-termination circuit is useful for tracking circuits which connect two sites.
        > 
        > Each circuit termination is attached to either a site or to a provider network. Site terminations may optionally be connected via a cable to a specific device interface or port within that site. Each termination must be assigned a port speed, and can optionally be assigned an upstream speed if it differs from the downstream speed (a common scenario with e.g. DOCSIS cable modems). Fields are also available to track cross-connect and patch panel details.

        :param str resource_name: The name of the resource.
        :param CircuitTerminationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CircuitTerminationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 circuit_id: Optional[pulumi.Input[int]] = None,
                 port_speed: Optional[pulumi.Input[int]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 term_side: Optional[pulumi.Input[str]] = None,
                 upstream_speed: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CircuitTerminationArgs.__new__(CircuitTerminationArgs)

            if circuit_id is None and not opts.urn:
                raise TypeError("Missing required property 'circuit_id'")
            __props__.__dict__["circuit_id"] = circuit_id
            __props__.__dict__["port_speed"] = port_speed
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if term_side is None and not opts.urn:
                raise TypeError("Missing required property 'term_side'")
            __props__.__dict__["term_side"] = term_side
            __props__.__dict__["upstream_speed"] = upstream_speed
        super(CircuitTermination, __self__).__init__(
            'netbox:index/circuitTermination:CircuitTermination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            circuit_id: Optional[pulumi.Input[int]] = None,
            port_speed: Optional[pulumi.Input[int]] = None,
            site_id: Optional[pulumi.Input[int]] = None,
            term_side: Optional[pulumi.Input[str]] = None,
            upstream_speed: Optional[pulumi.Input[int]] = None) -> 'CircuitTermination':
        """
        Get an existing CircuitTermination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CircuitTerminationState.__new__(_CircuitTerminationState)

        __props__.__dict__["circuit_id"] = circuit_id
        __props__.__dict__["port_speed"] = port_speed
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["term_side"] = term_side
        __props__.__dict__["upstream_speed"] = upstream_speed
        return CircuitTermination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="circuitId")
    def circuit_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "circuit_id")

    @property
    @pulumi.getter(name="portSpeed")
    def port_speed(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "port_speed")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="termSide")
    def term_side(self) -> pulumi.Output[str]:
        return pulumi.get(self, "term_side")

    @property
    @pulumi.getter(name="upstreamSpeed")
    def upstream_speed(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "upstream_speed")

