# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CircuitArgs', 'Circuit']

@pulumi.input_type
class CircuitArgs:
    def __init__(__self__, *,
                 cid: pulumi.Input[str],
                 provider_id: pulumi.Input[int],
                 status: pulumi.Input[str],
                 type_id: pulumi.Input[int],
                 tenant_id: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Circuit resource.
        """
        pulumi.set(__self__, "cid", cid)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type_id", type_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def cid(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cid")

    @cid.setter
    def cid(self, value: pulumi.Input[str]):
        pulumi.set(self, "cid", value)

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "provider_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "type_id")

    @type_id.setter
    def type_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "type_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _CircuitState:
    def __init__(__self__, *,
                 cid: Optional[pulumi.Input[str]] = None,
                 provider_id: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[int]] = None,
                 type_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Circuit resources.
        """
        if cid is not None:
            pulumi.set(__self__, "cid", cid)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type_id is not None:
            pulumi.set(__self__, "type_id", type_id)

    @property
    @pulumi.getter
    def cid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cid")

    @cid.setter
    def cid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cid", value)

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provider_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "type_id")

    @type_id.setter
    def type_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "type_id", value)


class Circuit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cid: Optional[pulumi.Input[str]] = None,
                 provider_id: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[int]] = None,
                 type_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        From the [official documentation](https://docs.netbox.dev/en/stable/core-functionality/circuits/#circuits_1):

        > A communications circuit represents a single physical link connecting exactly two endpoints, commonly referred to as its A and Z terminations. A circuit in NetBox may have zero, one, or two terminations defined. It is common to have only one termination defined when you don't necessarily care about the details of the provider side of the circuit, e.g. for Internet access circuits. Both terminations would likely be modeled for circuits which connect one customer site to another.
        > 
        > Each circuit is associated with a provider and a user-defined type. For example, you might have Internet access circuits delivered to each site by one provider, and private MPLS circuits delivered by another. Each circuit must be assigned a circuit ID, each of which must be unique per provider.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CircuitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        From the [official documentation](https://docs.netbox.dev/en/stable/core-functionality/circuits/#circuits_1):

        > A communications circuit represents a single physical link connecting exactly two endpoints, commonly referred to as its A and Z terminations. A circuit in NetBox may have zero, one, or two terminations defined. It is common to have only one termination defined when you don't necessarily care about the details of the provider side of the circuit, e.g. for Internet access circuits. Both terminations would likely be modeled for circuits which connect one customer site to another.
        > 
        > Each circuit is associated with a provider and a user-defined type. For example, you might have Internet access circuits delivered to each site by one provider, and private MPLS circuits delivered by another. Each circuit must be assigned a circuit ID, each of which must be unique per provider.

        :param str resource_name: The name of the resource.
        :param CircuitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CircuitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cid: Optional[pulumi.Input[str]] = None,
                 provider_id: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[int]] = None,
                 type_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CircuitArgs.__new__(CircuitArgs)

            if cid is None and not opts.urn:
                raise TypeError("Missing required property 'cid'")
            __props__.__dict__["cid"] = cid
            if provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'provider_id'")
            __props__.__dict__["provider_id"] = provider_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tenant_id"] = tenant_id
            if type_id is None and not opts.urn:
                raise TypeError("Missing required property 'type_id'")
            __props__.__dict__["type_id"] = type_id
        super(Circuit, __self__).__init__(
            'netbox:index/circuit:Circuit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cid: Optional[pulumi.Input[str]] = None,
            provider_id: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[int]] = None,
            type_id: Optional[pulumi.Input[int]] = None) -> 'Circuit':
        """
        Get an existing Circuit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CircuitState.__new__(_CircuitState)

        __props__.__dict__["cid"] = cid
        __props__.__dict__["provider_id"] = provider_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type_id"] = type_id
        return Circuit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cid(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cid")

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "provider_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "type_id")

