# Payload Generator

This is a package for generating different sized payloads of voice data that can be sent to the Ingestion Gateway to be enriched.

Each payload is populated with pseudo-data produced by the Faker library in Python. Verbatims created in each payload are capable of being enriched by the models in a given project by leveraging the given word bank.

## Usage

Make sure you have python installed on your machine (v2 or higher): https://www.python.org/downloads/

or using the following Homebrew command (only installs v3 or higher):

```
brew install python
```

### Installing the package

Either Python installation method above should automatically have `pip` installed. Confirm this by running

```
python3 -m pip --version
```

If this doesn't work, review the following guide on getting it installed: https://packaging.python.org/en/latest/tutorials/installing-packages/#ensure-you-can-run-pip-from-the-command-line

Now you can install the package:

```
pip install payload-generator
```

### Command

This package requires three arguments:

1. the count of payloads/documents to be generated by the tool
2. the project ID the created payloads are intended to be uploaded to (in any CMP instance)
3. the path where the payloads will be kept (make sure any folder specified exists)

```
payload-generator [count] [project_id] [directory]
```

### Additional Arguments

To make the tool more versatile, a few different optional arguments may be passed in depending on the use case. These arguments are all explained below

| Argument                              | Description                                                                 | Accepted Values  |
| ------------------------------------- | --------------------------------------------------------------------------- | ---------------- |
| `-h`, `--help`                        | displays the help message                                                   |                  |
| `-m`, `--multi`                       | includes project id in output file name to support multi-project generation |                  |
| `-b <BRAND>`, `--brand <BRAND>`       | generates payloads based on brand passed in                                 | humana, centene  |
| `-p <PAYLOAD>`, `--payload <PAYLOAD>` | generates verbatims based on the payload type passed in                     | chat, call, text |
| `--no_ids`                            | creates payloads with no natural_id (replaced by `%s`)                      |                  |
| `-v`, `--version`                     | displays program version number                                             |                  |

If none of these arguments are passed in, a payload is created using the generic brand and `call` payload type.

### Example

1. Create 5 payloads for the project `1010101` in the current directory

```
payload-generator 5 1010101 .
```

2. Create a single payload for the project `1111111` in the `test` directory using the `humana` brand and `text` payload type

```
payload-generator 1 1111111 ./test -b humana -p text
```

3. Create 3 payloads for the project `0000001` in the `test/first_project` directory using the `multi` and `no_ids` flag

```
payload-generator 3 0000001 ./test/first-project -m --no_ids
```

## Contributing

Feel free to iterate and introduce your own updates to this tool by creating a new feature branch and merging when ready!

Please reach out to @zkhatri if so for review and updating the package version to reflect your changes. Also feel free to suggest improvements!
