local sounds = {}

sounds.plant =
{
  {
    filename = "__base__/sound/walking/plant/plant-01.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/walking/plant/plant-02.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/walking/plant/plant-03.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/walking/plant/plant-04.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/walking/plant/plant-05.ogg",
    volume = 0.4
  }
}

sounds.big_bush =
{
  {
    filename = "__base__/sound/walking/plant/bush-big-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/plant/bush-big-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/plant/bush-big-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/plant/bush-big-04.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/plant/bush-big-05.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/plant/bush-big-06.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/plant/bush-big-07.ogg",
    volume = 0.3
  }
}

sounds.small_bush =
{
  {
    filename = "__base__/sound/walking/plant/bush-small-01.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/plant/bush-small-02.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/plant/bush-small-03.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/plant/bush-small-04.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/plant/bush-small-05.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/plant/bush-small-06.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/plant/bush-small-07.ogg",
    volume = 0.6
  }
}
sounds.pebble =
{
  {
    filename = "__base__/sound/walking/pebble/stones_01.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_02.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_03.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_04.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_05.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_06.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_07.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_08.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/pebble/stones_09.ogg",
    volume = 0.6
  }
}
sounds.hairy_grass =
{
  {
    filename = "__base__/sound/walking/decorative-grass-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-04.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-05.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-06.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-07.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-08.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-09.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-grass-10.ogg",
    volume = 0.3
  }
}
sounds.carpet_grass =
{
  {
    filename = "__base__/sound/walking/decorative-grass-01.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-02.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-03.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-04.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-05.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-06.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-07.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-08.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-09.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/walking/decorative-grass-10.ogg",
    volume = 0.2
  }
}
sounds.mud =
{
  {
    filename = "__base__/sound/walking/decorative-mud-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-04.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-05.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-06.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-07.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-08.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-09.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/walking/decorative-mud-10.ogg",
    volume = 0.3
  }
}
sounds.ore =
{
  {
    filename = "__base__/sound/walking/resources/ore-01.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-02.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-03.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-04.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-05.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-06.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-07.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-08.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-09.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/ore-10.ogg",
    volume = 0.7
  }
}

sounds.oil =
{
  {
    filename = "__base__/sound/walking/resources/oil-01.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/oil-02.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/oil-03.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/oil-04.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/oil-05.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/oil-06.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/walking/resources/oil-07.ogg",
    volume = 0.7
  }
}

sounds.rails =
{
  {
    filename = "__base__/sound/walking/rails/rails-01.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-02.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-03.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-04.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-05.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-06.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-07.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-08.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-09.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-10.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-11.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/walking/rails/rails-12.ogg",
    volume = 0.6
  }
}

sounds.tree_leaves =
{
  {
    filename = "__base__/sound/particles/tree-leaves-1.ogg",
    volume = 0.35
  },
  {
    filename = "__base__/sound/particles/tree-leaves-2.ogg",
    volume = 0.35
  },
  {
    filename = "__base__/sound/particles/tree-leaves-3.ogg",
    volume = 0.35
  },
  {
    filename = "__base__/sound/particles/tree-leaves-4.ogg",
    volume = 0.35
  }
}

sounds.mine_fish =
{
  {
    filename = "__core__/sound/mine-fish.ogg",volume = 0.8
  },
  {
    filename = "__core__/sound/mine-fish-1.ogg",volume = 0.8
  },
  {
    filename = "__core__/sound/mine-fish-2.ogg",volume = 0.8
  },
  {
    filename = "__core__/sound/mine-fish-3.ogg",volume = 0.8
  },
  {
    filename = "__core__/sound/mine-fish-4.ogg",volume = 0.8
  }
}

sounds.eat_fish =
{
  {
    filename = "__base__/sound/eat.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/eat-1.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/eat-2.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/eat-3.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/eat-4.ogg",
    volume = 0.6
  }
}

sounds.inserter_basic =
{
  match_progress_to_activity = true,
  sound =
  {
    {
      filename = "__base__/sound/inserter-basic-1.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-basic-2.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-basic-3.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-basic-4.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-basic-5.ogg",
      volume = 0.5
    }
  },
  audible_distance_modifier = 0.3
}

sounds.inserter_fast =
{
  match_progress_to_activity = true,
  sound =
  {
    {
      filename = "__base__/sound/inserter-fast-1.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-fast-2.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-fast-3.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-fast-4.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-fast-5.ogg",
      volume = 0.5
    }
  },
  audible_distance_modifier = 0.3
}

sounds.inserter_long_handed =
{
  match_progress_to_activity = true,
  sound =
  {
    {
      filename = "__base__/sound/inserter-long-handed-1.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-long-handed-2.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-long-handed-3.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-long-handed-4.ogg",
      volume = 0.5
    },
    {
      filename = "__base__/sound/inserter-long-handed-5.ogg",
      volume = 0.5
    }
  },
  audible_distance_modifier = 0.5
}

sounds.splitter =
{
  sound =
  {
    {
      filename = "__base__/sound/splitters/splitter.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/splitter-2.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/splitter-3.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/splitter-4.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/splitter-5.ogg",
      volume = 0.2
    }
  },
  max_sounds_per_type = 3,
  audible_distance_modifier = 0.45
}

sounds.fast_splitter =
{
  sound =
  {
    {
      filename = "__base__/sound/splitters/fast-splitter.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/fast-splitter-2.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/fast-splitter-3.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/fast-splitter-4.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/fast-splitter-5.ogg",
      volume = 0.2
    }
  },
  max_sounds_per_type = 3,
  audible_distance_modifier = 0.45
}

sounds.express_splitter =
{
  sound =
  {
    {
      filename = "__base__/sound/splitters/express-splitter.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/express-splitter-2.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/express-splitter-3.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/express-splitter-4.ogg",
      volume = 0.2
    },
    {
      filename = "__base__/sound/splitters/express-splitter-5.ogg",
      volume = 0.2
    }
  },
  max_sounds_per_type = 3,
  audible_distance_modifier = 0.45
}

sounds.loader =
{
  sound =
  {
    {
      filename = "__base__/sound/transport-belt.ogg",
    volume = 0.3
    }
  },
  max_sounds_per_type = 3,
  audible_distance_modifier = 0.45
}

sounds.fast_loader =
{
  sound =
  {
    {
      filename = "__base__/sound/fast-transport-belt.ogg",
    volume = 0.3
    }
  },
  max_sounds_per_type = 3,
  audible_distance_modifier = 0.45
}

sounds.express_loader =
{
  sound =
  {
    {
      filename = "__base__/sound/express-transport-belt.ogg",
    volume = 0.3
    }
  },
  max_sounds_per_type = 3,
  audible_distance_modifier = 0.45
}

sounds.spidertron_leg =
{
  {
    filename = "__base__/sound/spidertron/spidertron-leg-1.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/spidertron/spidertron-leg-2.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/spidertron/spidertron-leg-3.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/spidertron/spidertron-leg-4.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/spidertron/spidertron-leg-5.ogg",
    volume = 0.2
  }
}

sounds.pipe =
{
  {
    filename = "__base__/sound/pipe.ogg",
    volume = 0.45
  }
}

sounds.train_brakes =
{
  {
    filename = "__base__/sound/train-breaks.ogg",
    volume = 0.3
  }
}

sounds.train_brake_screech =
{
  {
    filename = "__base__/sound/train-brake-screech.ogg", volume = 0.3
  },
  {
    filename = "__base__/sound/train-brake-screech-1.ogg", volume = 0.3
  }
}

sounds.car_stone_impact =
{
  {
    filename = "__base__/sound/car-stone-impact.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-stone-impact-2.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-stone-impact-3.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-stone-impact-4.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-stone-impact-5.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-stone-impact-6.ogg", volume = 0.5
  }
}

sounds.car_wood_impact = function(volume)
  return
  {
    {
      filename = "__base__/sound/car-wood-impact.ogg", volume = volume
    },
    {
      filename = "__base__/sound/car-wood-impact-02.ogg", volume = volume
    },
    {
      filename = "__base__/sound/car-wood-impact-03.ogg", volume = volume
    },
    {
      filename = "__base__/sound/car-wood-impact-04.ogg", volume = volume
    },
    {
      filename = "__base__/sound/car-wood-impact-05.ogg", volume = volume
    }
  }
end

sounds.generic_impact =
{
  {
    filename = "__base__/sound/car-metal-impact-2.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-metal-impact-3.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-metal-impact-4.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-metal-impact-5.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/car-metal-impact-6.ogg", volume = 0.5
  }
}

sounds.artillery_open =
{
  {
    filename = "__base__/sound/artillery-open.ogg", volume = 0.57
  }
}

sounds.artillery_close =
{
  {
    filename = "__base__/sound/artillery-close.ogg", volume = 0.6
  }
}

sounds.cargo_wagon_open =
{
  {
    filename = "__base__/sound/cargo-wagon-open.ogg", volume = 0.55
  }
}

sounds.cargo_wagon_close =
{
  {
    filename = "__base__/sound/cargo-wagon-close.ogg", volume = 0.54
  }
}

sounds.machine_open =
{
  {
    filename = "__base__/sound/machine-open.ogg", volume = 0.5
  }
}

sounds.machine_close =
{
  {
    filename = "__base__/sound/machine-close.ogg", volume = 0.5
  }
}

sounds.electric_network_open =
{
  {
    filename = "__base__/sound/electric-network-open.ogg", volume = 0.6
  }
}

sounds.electric_network_close =
{
  {
    filename = "__base__/sound/electric-network-close.ogg", volume = 0.6
  }
}

sounds.roboport_door_open =
{
  {
    type = "play-sound",
    sound =
    {
      filename = "__base__/sound/roboport-door.ogg",
      volume = 0.3,
      min_speed = 1,
      max_speed = 1.5
    }
  }
}

sounds.roboport_door_close =
{
  {
    type = "play-sound",
    sound =
    {
      filename = "__base__/sound/roboport-door-close.ogg",
    volume = 0.2,
    min_speed = 1,
    max_speed = 1.5
    }
  }
}

sounds.flying_robot = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/construction-robot-11.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-12.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-13.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-14.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-15.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-16.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-17.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-18.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-19.ogg", volume = volume
      },
      {
        filename = "__base__/sound/flying-robot-1.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-2.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-3.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-4.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-5.ogg", volume = 0.43
      }
    },
    max_sounds_per_type = 20,
    audible_distance_modifier = 1,
    fade_in_ticks = 8,
    fade_out_ticks = 10,
    probability = 1 / (10 * 60) -- average pause between the sound is 10 seconds
  }
end

sounds.construction_robot = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/construction-robot-1.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-2.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-3.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-4.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-5.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-6.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-7.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-8.ogg", volume = volume
      },
      {
        filename = "__base__/sound/construction-robot-9.ogg", volume = volume
      },
      {
        filename = "__base__/sound/flying-robot-1.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-2.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-3.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-4.ogg", volume = 0.43
      },
      {
        filename = "__base__/sound/flying-robot-5.ogg", volume = 0.43
      }
    },
    max_sounds_per_type = 20,
    audible_distance_modifier = 1,
    fade_in_ticks = 8,
    fade_out_ticks = 8,
    probability = 1 / (10 * 60) -- average pause between the sound is 10 seconds
  }
end

sounds.robot_die_whoosh =
{
  {
    filename = "__base__/sound/fight/robot-die-whoosh-01.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-whoosh-02.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-whoosh-03.ogg", volume = 0.5
  }
}

sounds.robot_die_vox =
{
  {
    filename = "__base__/sound/fight/robot-die-vox-01.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-vox-02.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-vox-03.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-vox-04.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-vox-05.ogg", volume = 0.5
  },
  {
    filename = "__base__/sound/fight/robot-die-vox-06.ogg", volume = 0.5
  }
}

sounds.robot_selfdestruct =
{
  {
    filename = "__base__/sound/fight/robot-selfdestruct-01.ogg", volume = 0.4
  },
  {
    filename = "__base__/sound/fight/robot-selfdestruct-02.ogg", volume = 0.4
  },
  {
    filename = "__base__/sound/fight/robot-selfdestruct-03.ogg", volume = 0.4
  }
}

sounds.robot_die_impact =
{
  {
    filename = "__base__/sound/fight/robot-die-impact-01.ogg", volume = 0.7
  },
  {
    filename = "__base__/sound/fight/robot-die-impact-02.ogg", volume = 0.7
  },
  {
    filename = "__base__/sound/fight/robot-die-impact-03.ogg", volume = 0.7
  }
}

sounds.laser_turret_activate =
{
  {
    filename = "__base__/sound/fight/laser-turret-activate-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/laser-turret-activate-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/laser-turret-activate-03.ogg",
    volume = 0.3
  }

}

sounds.laser_turret_deactivate =
{
  {
    filename = "__base__/sound/fight/laser-turret-deactivate-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/laser-turret-deactivate-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/laser-turret-deactivate-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/laser-turret-deactivate-04.ogg",
    volume = 0.3
  }
}

sounds.gun_turret_activate =
{
  {
    filename = "__base__/sound/fight/gun-turret-activate-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/gun-turret-activate-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/gun-turret-activate-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/gun-turret-activate-04.ogg",
    volume = 0.3
  }
}

sounds.gun_turret_deactivate =
{
  {
    filename = "__base__/sound/fight/gun-turret-deactivate-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/gun-turret-deactivate-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/gun-turret-deactivate-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/gun-turret-deactivate-04.ogg",
    volume = 0.3
  }
}

sounds.flamethrower_turret_activate =
{
  {
    filename = "__base__/sound/fight/flamethrower-turret-activate-01.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/flamethrower-turret-activate-02.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/flamethrower-turret-activate-03.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/fight/flamethrower-turret-activate-04.ogg",
    volume = 0.3
  }
}

sounds.flamethrower_turret_deactivate =
{
  {
    filename = "__base__/sound/fight/flamethrower-turret-deactivate-01.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/fight/flamethrower-turret-deactivate-02.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/fight/flamethrower-turret-deactivate-03.ogg",
    volume = 0.2
  },
  {
    filename = "__base__/sound/fight/flamethrower-turret-deactivate-04.ogg",
    volume = 0.2
  }
}

sounds.heavy_gunshot =
{
  {
    filename = "__base__/sound/fight/heavy-gunshot-1.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/heavy-gunshot-2.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/heavy-gunshot-3.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/heavy-gunshot-4.ogg",
    volume = 0.4
  }
}

sounds.gun_turret_gunshot =
{
  {
    filename = "__base__/sound/fight/gun-turret-gunshot-01.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/gun-turret-gunshot-02.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/gun-turret-gunshot-03.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/gun-turret-gunshot-04.ogg",
    volume = 0.4
  }
}

sounds.light_gunshot =
{
  {
    filename = "__base__/sound/fight/light-gunshot-1.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/light-gunshot-2.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/light-gunshot-3.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/light-gunshot-4.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/light-gunshot-5.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/light-gunshot-6.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/light-gunshot-7.ogg",
    volume = 0.6
  }
}

sounds.defender_gunshot =
{
  {
    filename = "__base__/sound/fight/defender-gunshot-1.ogg",
    volume = 0.65
  },
  {
    filename = "__base__/sound/fight/defender-gunshot-2.ogg",
    volume = 0.65
  },
  {
    filename = "__base__/sound/fight/defender-gunshot-3.ogg",
    volume = 0.65
  }
}

sounds.submachine_gunshot =
{
  {
    filename = "__base__/sound/fight/submachine-gunshot-1.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/submachine-gunshot-2.ogg",
    volume = 0.6
  },
  {
    filename = "__base__/sound/fight/submachine-gunshot-3.ogg",
    volume = 0.6
  }
}

sounds.shotgun =
{
  {
    filename = "__base__/sound/fight/pump-shotgun-1.ogg",
    volume = 0.37
  },
  {
    filename = "__base__/sound/fight/pump-shotgun-2.ogg",
    volume = 0.37
  },
  {
    filename = "__base__/sound/fight/pump-shotgun-3.ogg",
    volume = 0.37
  },
  {
    filename = "__base__/sound/fight/pump-shotgun-4.ogg",
    volume = 0.37
  },
  {
    filename = "__base__/sound/fight/pump-shotgun-5.ogg",
    volume = 0.37
  }
}

sounds.tank_gunshot =
{
  {
    filename = "__base__/sound/fight/tank-cannon-1.ogg",
    volume = 0.57
  },
  {
    filename = "__base__/sound/fight/tank-cannon-2.ogg",
    volume = 0.57
  },
  {
    filename = "__base__/sound/fight/tank-cannon-3.ogg",
    volume = 0.57
  },
  {
    filename = "__base__/sound/fight/tank-cannon-4.ogg",
    volume = 0.57
  },
  {
    filename = "__base__/sound/fight/tank-cannon-5.ogg",
    volume = 0.57
  }

}

sounds.throw_projectile =
{
  {
    filename = "__base__/sound/fight/throw-projectile-1.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/throw-projectile-2.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/throw-projectile-3.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/throw-projectile-4.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/throw-projectile-5.ogg",
    volume = 0.4
  },
  {
    filename = "__base__/sound/fight/throw-projectile-6.ogg",
    volume = 0.4
  }

}

sounds.poison_cloud = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/fight/poison-cloud.ogg",
        volume = volume
      }
    }
  }
end

sounds.poison_capsule_explosion = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/fight/poison-capsule-explosion-1.ogg",
        volume = volume
      }
    }
  }
end

sounds.small_explosion = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/small-explosion-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/small-explosion-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/small-explosion-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/small-explosion-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/small-explosion-5.ogg",
        volume = volume
      }
    }
  }
end

sounds.medium_explosion = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    audible_distance_modifier = 0.7,
    variations =
    {
      {
        filename = "__base__/sound/fight/medium-explosion-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/medium-explosion-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/medium-explosion-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/medium-explosion-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/medium-explosion-5.ogg",
        volume = volume
      }
    }
  }
end

sounds.robot_explosion = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/fight/robot-explosion-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/robot-explosion-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/robot-explosion-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/robot-explosion-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/robot-explosion-5.ogg",
        volume = volume
      }
    }
  }
end

sounds.large_explosion = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    audible_distance_modifier = 1.95,
    variations =
    {
      {
        filename = "__base__/sound/fight/large-explosion-1.ogg",
        volume = 0.55
      },
      {
        filename = "__base__/sound/fight/large-explosion-2.ogg",
        volume = 0.55
      }
    }
  }
end

sounds.nuclear_explosion = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/fight/nuclear-explosion-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/nuclear-explosion-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/fight/nuclear-explosion-3.ogg",
        volume = volume
      }
    }
  }
end

sounds.nuclear_explosion_aftershock = function(volume)
  return
  {
    aggregation =
    {
      max_count = 1,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/fight/nuclear-explosion-aftershock.ogg",
        volume = volume
      }
    }
  }
end

sounds.small_splash =
{
  {
    filename = "__base__/sound/particles/small-splash-1.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/particles/small-splash-2.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/particles/small-splash-3.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/particles/small-splash-4.ogg",
    volume = 0.7
  },
  {
    filename = "__base__/sound/particles/small-splash-5.ogg",
    volume = 0.7
  }
}

sounds.manual_repair =
{
  {
    filename = "__base__/sound/manual-repair-simple-1.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/manual-repair-simple-2.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/manual-repair-simple-3.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/manual-repair-simple-4.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/manual-repair-simple-5.ogg",
    volume = 0.4
  }
}

sounds.logistics_chest_open =
{
  {
    filename = "__base__/sound/passive-provider-chest-open-1.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/passive-provider-chest-open-2.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/passive-provider-chest-open-3.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/passive-provider-chest-open-4.ogg",
    volume = 0.3
  },
  {
    filename = "__base__/sound/passive-provider-chest-open-5.ogg",
    volume = 0.3
  }
}

sounds.gate_open =
{
  {
    filename = "__base__/sound/gate-open-1.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-open-2.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-open-3.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-open-4.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-open-5.ogg", volume = 0.55
  }
}

sounds.gate_close =
{
  {
    filename = "__base__/sound/gate-close-1.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-close-2.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-close-3.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-close-4.ogg", volume = 0.55
  },
  {
    filename = "__base__/sound/gate-close-5.ogg", volume = 0.55
  }
}

sounds.biter_roars = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/biter-roar-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-5.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-6.ogg",
      volume = volume
    }
  }
end

sounds.biter_roars_mid = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/biter-roar-mid-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-mid-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-mid-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-mid-4.ogg",
      volume = volume
    },
    --{
    --  filename = "__base__/sound/creatures/biter-roar-mid-5.ogg",
    --  volume = volume
    --},
    {
      filename = "__base__/sound/creatures/biter-roar-mid-6.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-mid-7.ogg",
      volume = volume
    },
    --{
    --  filename = "__base__/sound/creatures/biter-roar-mid-8.ogg",
    --  volume = volume
    --},
    {
      filename = "__base__/sound/creatures/biter-roar-mid-9.ogg",
      volume = volume
    }
  }
end

sounds.biter_roars_big = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/biter-roar-big-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-big-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-big-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-big-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-big-5.ogg",
      volume = volume
    }
  }
end

sounds.biter_roars_behemoth = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-5.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-6.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-7.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-8.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-roar-behemoth-9.ogg",
      volume = volume
    }
  }
end

sounds.biter_dying = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/biter-death-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-5.ogg",
      volume = volume
    }
  }
end

sounds.biter_dying_big = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/biter-death-big-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-big-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-big-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-big-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/biter-death-big-5.ogg",
      volume = volume
    }
  }
end

sounds.biter_calls = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/creatures/biter-call-1.ogg",
        volume = 0.58
      },
      {
        filename = "__base__/sound/creatures/biter-call-2.ogg",
        volume = 0.58
      },
      {
        filename = "__base__/sound/creatures/biter-call-3.ogg",
        volume = 0.58
      },
      {
        filename = "__base__/sound/creatures/biter-call-4.ogg",
        volume = 0.58
      },
      {
        filename = "__base__/sound/creatures/biter-call-5.ogg",
        volume = 0.58
      }
    },
    probability = 1 / (12 * 60), -- average pause between the sound is 12 seconds
    max_sounds_per_type = 2
  }
end

sounds.biter_calls_big = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/creatures/biter-call-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-big-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-big-6.ogg",
        volume = volume
      }
    },
    probability = 1 / (4 * 60), -- average pause between the sound is 4 seconds
    max_sounds_per_type = 2
  }
end

sounds.biter_calls_behemoth = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/creatures/biter-call-behemoth-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-behemoth-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-behemoth-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-behemoth-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-behemoth-7.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-call-behemoth-8.ogg",
        volume = volume
      },

    },
    probability = 1 / (4 * 60), -- average pause between the sound is 4 seconds
    max_sounds_per_type = 2
  }
end

sounds.biter_walk = function(volume)
  return
  {
    aggregation =
    {
      max_count = 2,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/creatures/biter-walk-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-7.ogg",
        volume = volume
      }
    }
  }
end

sounds.biter_walk_big = function(volume)
  return
  {
    aggregation =
    {
      max_count = 2,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/creatures/biter-walk-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-7.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-8.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-9.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/biter-walk-big-10.ogg",
        volume = volume
      }
    }
  }
end

sounds.spitter_walk = function(volume)
  return
  {
    aggregation =
    {
      max_count = 2,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/creatures/spitter-walk-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-7.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-8.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-9.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-10.ogg",
        volume = volume
      }
    }
  }
end

sounds.spitter_walk_big = function(volume)
  return
  {
    aggregation =
    {
      max_count = 2,
      remove = true
    },
    variations =
    {
      {
        filename = "__base__/sound/creatures/spitter-walk-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-7.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-8.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-9.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-walk-big-10.ogg",
        volume = volume
      }
    }
  }
end

sounds.spitter_calls = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/creatures/spitter-call-small-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-7.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-8.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-small-9.ogg",
        volume = volume
      }
    },
    probability = 1 / (4 * 60), -- average pause between the sound is 4 seconds
    --audible_distance_modifier = 0.9
  }
end

sounds.spitter_calls_med = function(volume)
  return
  {
    --aggregation =
    --{
    -- max_count = 1,
    --remove = true
    --},
    --variations =
    sound =
    {
      {
        filename = "__base__/sound/creatures/spitter-call-med-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-7.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-8.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-9.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-med-10.ogg",
        volume = volume
      }
    },
    probability = 1 / (8 * 60) -- average pause between the sound is 8 seconds
  }
end

sounds.spitter_calls_big = function(volume)
  return
  {
    sound =
    {
      {
        filename = "__base__/sound/creatures/spitter-call-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/spitter-call-big-5.ogg",
        volume = volume
      }
    },
    probability = 1 / (4 * 60), -- average pause between the sound is 4 seconds
    --audible_distance_modifier = 0.9
  }
end

sounds.spitter_roars = function(volume)
  return
  {
    layers =
    {
      [0] =
      {
        {
          filename = "__base__/sound/creatures/Spiters_1_1.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_2_1.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_3_1.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_4_1.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_5_1.ogg",
          volume = volume
        }
      },
      [1] =
      {
        {
          filename = "__base__/sound/creatures/Spiters_1_2.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_2_2.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_3_2.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_4_2.ogg",
          volume = volume
        },
        {
          filename = "__base__/sound/creatures/Spiters_5_2.ogg",
          volume = volume
        }
      }
    }
  }
end

sounds.spitter_dying = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/spitter-death-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-5.ogg",
      volume = volume
    }
  }
end

sounds.spitter_dying_mid = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/spitter-death-mid-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-mid-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-mid-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-mid-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-mid-5.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-mid-6.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-mid-7.ogg",
      volume = volume
    }
  }
end

sounds.spitter_dying_big = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/spitter-death-big-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-big-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-big-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-big-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-big-5.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-big-6.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-big-7.ogg",
      volume = volume
    }
  }
end

sounds.spitter_dying_behemoth = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-5.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-6.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/spitter-death-behemoth-7.ogg",
      volume = volume
    }
  }
end

sounds.worm_roars = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-roar-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-4.ogg",
        volume = volume
      }
    },
    audible_distance_modifier = 1.5
  }
end

sounds.worm_roars_big = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-roar-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-big-5.ogg",
        volume = volume
      }
    },
    audible_distance_modifier = 1.3
  }
end

sounds.worm_roar_alternative = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-roar-alt-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-5.ogg",
        volume = volume
      }
    },
    audible_distance_modifier = 2.0
  }
end

sounds.worm_roar_alternative_big = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-roar-alt-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-roar-alt-big-5.ogg",
        volume = volume
      }
    },
   audible_distance_modifier = 1.8
  }
end

sounds.worm_breath = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-breathe-01.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-02.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-03.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-04.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-05.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-06.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-07.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-08.ogg",
        volume = volume
      }
    },
   audible_distance_modifier = 1.2
  }
end

sounds.worm_breath_big = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-breathe-big-01.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-02.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-03.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-04.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-05.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-06.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-07.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-breathe-big-08.ogg",
        volume = volume
      }
    },
    audible_distance_modifier = 1.5
  }
end

sounds.worm_dying = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-death-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-7.ogg",
        volume = volume
      }
    },
    -- audible_distance_modifier = 1.2
  }
end

sounds.worm_dying_small = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/worm-death-small-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-death-small-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-death-small-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-death-small-4.ogg",
      volume = volume
    }
  }
end

sounds.worm_dying_big = function(volume)
  return
  {
    variations =
    {
      {
        filename = "__base__/sound/creatures/worm-death-big-1.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-big-2.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-big-3.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-big-4.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-big-5.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-big-6.ogg",
        volume = volume
      },
      {
        filename = "__base__/sound/creatures/worm-death-big-7.ogg",
        volume = volume
      }
    },
    audible_distance_modifier = 1.2
  }
end

sounds.worm_fold = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/worm-folding-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-folding-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-folding-3.ogg",
      volume = volume
    }
  }
end

sounds.worm_standup = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/worm-standup-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-standup-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-standup-3.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-standup-4.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-standup-5.ogg",
      volume = volume
    }
  }
end

sounds.worm_standup_small = function(volume)
  return
  {
    {
      filename = "__base__/sound/creatures/worm-standup-small-1.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-standup-small-2.ogg",
      volume = volume
    },
    {
      filename = "__base__/sound/creatures/worm-standup-small-3.ogg",
      volume = volume
    }
  }
end

sounds.tree_impact =
{
  {
    filename = "__base__/sound/car-tree-wood-impact-01.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/car-tree-wood-impact-02.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/car-tree-wood-impact-03.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/car-tree-wood-impact-04.ogg",
    volume = 0.5
  }
}

return sounds
