/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.AggregationKernel;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.PoolingKernel;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.Server;
import java.util.HashSet;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ManualConnectionFactoryConfiguration
extends ConnectionFactoryConfiguration {
    private Cluster[] _clusterArr;
    private Puddle[] _puddleArr;

    public ManualConnectionFactoryConfiguration(Server server) {
        this(server, false);
    }

    @SASScope
    public ManualConnectionFactoryConfiguration(Server server, boolean noRedirect) {
        this(new Cluster[]{new FailoverCluster(server)}, noRedirect);
    }

    public ManualConnectionFactoryConfiguration(Cluster cluster) {
        this(new Cluster[]{cluster});
    }

    public ManualConnectionFactoryConfiguration(Cluster[] clusters) {
        this(clusters, false);
    }

    private ManualConnectionFactoryConfiguration(Cluster[] clusters, boolean noRedirect) {
        super(noRedirect);
        if (clusters == null || clusters.length == 0) {
            throw new IllegalArgumentException("\"clusters\" cannot be null or empty.");
        }
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[i] != null) continue;
            throw new IllegalArgumentException("Element " + i + " of \"clusters\" cannot be null.");
        }
        this._clusterArr = ConnectionFactoryUtil.copyClusterArray(clusters);
    }

    public ManualConnectionFactoryConfiguration(Puddle puddle) {
        this(new Puddle[]{puddle});
    }

    public ManualConnectionFactoryConfiguration(Puddle[] puddles) {
        if (puddles == null || puddles.length == 0) {
            throw new IllegalArgumentException("\"puddles\" cannot be null or empty.");
        }
        for (int i = 0; i < puddles.length; ++i) {
            if (puddles[i] != null) continue;
            throw new IllegalArgumentException("Element " + i + " of \"puddles\" cannot be null.");
        }
        this._puddleArr = ConnectionFactoryUtil.copyPuddleArray(puddles);
    }

    public Cluster[] getClusterArray() {
        return ConnectionFactoryUtil.copyClusterArray(this._clusterArr);
    }

    public Puddle[] getPuddleArray() {
        return ConnectionFactoryUtil.copyPuddleArray(this._puddleArr);
    }

    @Override
    public boolean equals(Object that) {
        Puddle[] thosePuddles;
        if (!super.equals(that)) {
            return false;
        }
        ManualConnectionFactoryConfiguration thatConfig = (ManualConnectionFactoryConfiguration)that;
        Cluster[] thoseClusters = thatConfig.getClustersNoCopy();
        if (this._clusterArr != thoseClusters) {
            if (this._clusterArr == null || thoseClusters == null || this._clusterArr.length != thoseClusters.length) {
                return false;
            }
            for (int i = 0; i < this._clusterArr.length; ++i) {
                if (this._clusterArr[i].equals(thoseClusters[i])) continue;
                return false;
            }
        }
        if (this._puddleArr != (thosePuddles = thatConfig.getPuddlesNoCopy())) {
            if (this._puddleArr == null || thosePuddles == null || this._puddleArr.length != thosePuddles.length) {
                return false;
            }
            for (int i = 0; i < this._puddleArr.length; ++i) {
                if (this._puddleArr[i].equals(thosePuddles[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        if (this._clusterArr != null) {
            for (int i = 0; i < this._clusterArr.length; ++i) {
                hc ^= this._clusterArr[i].hashCode();
            }
        } else {
            for (int i = 0; i < this._puddleArr.length; ++i) {
                hc ^= this._puddleArr[i].hashCode();
            }
        }
        return hc;
    }

    public String toString() {
        String str = null;
        if (this._clusterArr != null) {
            str = ConnectionFactoryUtil.clusterArrayToString(this._clusterArr);
        } else if (this._puddleArr != null) {
            str = ConnectionFactoryUtil.puddleArrayToString(this._puddleArr);
        } else {
            String[][] nvPairArr = new String[1][2];
            nvPairArr[0][0] = "clusters";
            nvPairArr[0][1] = "undefined";
            str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        }
        return str;
    }

    @Override
    @SASScope
    protected ConnectionFactoryKernel doGetKernel(ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        ConnectionFactoryKernel kernel = null;
        if (this._clusterArr != null) {
            kernel = new AggregationKernel(cxfReq, this._clusterArr);
        } else {
            PuddleEnvelope[] envs = new PuddleEnvelope[this._puddleArr.length];
            for (int i = 0; i < this._puddleArr.length; ++i) {
                envs[i] = new PuddleEnvelope(this._puddleArr[i]);
            }
            AuthServer authServer = new AuthServer(envs, true);
            kernel = new PoolingKernel(cxfReq, envs, authServer);
        }
        return kernel;
    }

    @Override
    @SASScope
    protected String doGetLogicalServerName() {
        HashSet entryPointSet = new HashSet(8);
        if (this._clusterArr != null) {
            ManualConnectionFactoryConfiguration.addEntryPointsToSet(entryPointSet, this._clusterArr);
        } else {
            for (int i = 0; i < this._puddleArr.length; ++i) {
                Puddle puddle = this._puddleArr[i];
                Cluster[] clusterArr = puddle.getClusterArray();
                ManualConnectionFactoryConfiguration.addEntryPointsToSet(entryPointSet, clusterArr);
            }
        }
        if (entryPointSet.size() == 1) {
            String entryPoint = (String)entryPointSet.iterator().next();
            return entryPoint;
        }
        String serverName = ((Object)entryPointSet).toString();
        return serverName;
    }

    protected Cluster[] getClustersNoCopy() {
        return this._clusterArr;
    }

    protected Puddle[] getPuddlesNoCopy() {
        return this._puddleArr;
    }

    private static void addEntryPointsToSet(Set entryPointSet, Cluster[] clusterArr) {
        for (int i = 0; i < clusterArr.length; ++i) {
            Cluster cluster = clusterArr[i];
            Server[] serverArr = cluster.getServerArray();
            for (int j = 0; j < serverArr.length; ++j) {
                Server server = serverArr[j];
                String serverName = server.getEntryPoint();
                entryPointSet.add(serverName);
            }
        }
    }
}

