/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.Conversion;
import com.sas.text.D;
import com.sas.text.FormatDescription;
import com.sas.text.NLD;
import com.sas.text.Pattern;
import com.sas.text.Roman;
import com.sas.text.SASFormat;
import com.sas.text.SASFormatInfo;
import com.sas.text.exp;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class SASNumericFormat
extends SASFormat {
    protected SASFormatInfo info;
    private static Object[] numericFormats;
    private static FormatDescription[] descriptions;

    protected SASNumericFormat() {
    }

    @Override
    protected void init() {
        this.info = (SASFormatInfo)this.formatInfo;
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        if (source.length() == 1) {
            status.setIndex(source.length());
        } else {
            status.setIndex(source.length() - 1);
        }
        return new Double(this.informat(source));
    }

    public abstract double informat(String var1);

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (super.format(obj, toAppendTo, pos) == null) {
            if (obj instanceof Number) {
                double value = ((Number)obj).doubleValue();
                if (Double.isNaN(value) || Double.isInfinite(value)) {
                    StringBuffer result = new StringBuffer(".");
                    this.insertLeadingBlanks(result);
                    toAppendTo.append(result);
                } else {
                    toAppendTo.append(this.format(value));
                }
            } else {
                throw new IllegalArgumentException("Cannot format given Object");
            }
        }
        return toAppendTo;
    }

    public abstract StringBuffer format(double var1);

    @Override
    public boolean isNumericFormat() {
        return true;
    }

    protected StringBuffer asteriskArray() {
        StringBuffer result = new StringBuffer(this.info.getWidth());
        for (int i = 0; i < this.info.getWidth(); ++i) {
            result.append('*');
        }
        return result;
    }

    static Object[] getSupportedFormats(Locale locale) {
        Object[] p = Pattern.getDefinedFormats(locale);
        Object[] e = exp.getDefinedFormats();
        Object[] c = Conversion.getDefinedFormats();
        Object[] d = D.getDefinedFormats();
        Object[] nld = NLD.getDefinedFormats(locale);
        Object[] roman = Roman.getDefinedFormats();
        numericFormats = new Object[p.length + e.length + c.length + d.length + nld.length + roman.length];
        System.arraycopy(p, 0, numericFormats, 0, p.length);
        System.arraycopy(e, 0, numericFormats, p.length, e.length);
        System.arraycopy(c, 0, numericFormats, e.length + p.length, c.length);
        System.arraycopy(d, 0, numericFormats, c.length + e.length + p.length, d.length);
        System.arraycopy(nld, 0, numericFormats, d.length + c.length + e.length + p.length, nld.length);
        System.arraycopy(roman, 0, numericFormats, d.length + c.length + e.length + p.length + nld.length, roman.length);
        descriptions = new FormatDescription[numericFormats.length];
        for (int i = 0; i < numericFormats.length; ++i) {
            SASNumericFormat.descriptions[i] = (FormatDescription)numericFormats[i];
        }
        return numericFormats;
    }

    public static FormatDescription[] getDescriptions() {
        return descriptions;
    }
}

