/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import com.sas.GlobalInfoTable;
import com.sas.PublicClonable;
import com.sas.beans.RB;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends java.beans.PropertyDescriptor
implements PublicClonable {
    protected String propertyEditorClassName;
    protected boolean linkable;
    protected String defaultValue;
    protected boolean compareValue;
    protected boolean persisted;
    protected String fieldName;
    protected String description;
    protected boolean masked;
    protected String category;
    Method readMethod;
    Method writeMethod;

    public PropertyDescriptor(java.beans.PropertyDescriptor property) throws IntrospectionException {
        super(property.getName(), property.getReadMethod(), property.getWriteMethod());
        this.commonInit();
        this.setReadMethod(property.getReadMethod());
        this.setWriteMethod(property.getWriteMethod());
        if (property instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)property;
            this.setDescription(pd.getDescription());
            this.setLinkable(pd.isLinkable());
            this.setDefaultValue(pd.getDefaultValue());
            this.setComparesValue(pd.comparesValue());
            this.setFieldName(pd.getFieldName());
            this.setPersisted(pd.isPersisted());
            this.setMasked(pd.isMasked());
            this.setCategory(pd.getCategory());
        }
    }

    public PropertyDescriptor(String propertyName, Method getter, Method setter) throws IntrospectionException {
        super(propertyName, getter, setter);
        this.commonInit();
        this.setReadMethod(super.getReadMethod());
        this.setWriteMethod(super.getWriteMethod());
    }

    public PropertyDescriptor(String propertyName, Class beanClass) throws IntrospectionException {
        super(propertyName, beanClass);
        this.commonInit();
        this.setReadMethod(super.getReadMethod());
        this.setWriteMethod(super.getWriteMethod());
    }

    public PropertyDescriptor(String propertyName, Class beanClass, String getterName, String setterName) throws IntrospectionException {
        super(propertyName, beanClass, getterName, setterName);
        this.commonInit();
        this.setReadMethod(super.getReadMethod());
        this.setWriteMethod(super.getWriteMethod());
    }

    protected void commonInit() {
        this.linkable = true;
        this.compareValue = true;
    }

    public Class getPropertyEditorClass() {
        if (this.propertyEditorClassName == null) {
            return super.getPropertyEditorClass();
        }
        Class propertyEditorClass = null;
        try {
            propertyEditorClass = GlobalInfoTable.loadClass(this.propertyEditorClassName);
        }
        catch (ClassNotFoundException cnfe) {
            String string = RB.getStringResource("Introspector.annotateProperties.invalidPropertyEditorClass.ex.txt");
        }
        return propertyEditorClass;
    }

    public void setPropertyEditorClass(String className) {
        this.propertyEditorClassName = className;
    }

    public void setPropertyEditorClass(Class propertyEditorClass) {
        this.propertyEditorClassName = null;
        super.setPropertyEditorClass(propertyEditorClass);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isLinkable() {
        return this.linkable;
    }

    public void setLinkable(boolean linkable) {
        this.linkable = linkable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean comparesValue() {
        return this.compareValue;
    }

    public void setComparesValue(boolean compareValue) {
        this.compareValue = compareValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isWritable() {
        return this.getWriteMethod() != null;
    }

    public boolean isMasked() {
        return this.masked;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public Object clone() {
        try {
            PropertyDescriptor clone = (PropertyDescriptor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            System.err.println("PropertyDescriptor.clone(): " + cnse.getMessage());
            return null;
        }
    }
}

