import random
import string
from datetime import datetime


def generate_random_token(length: int = 64, include_punctuation: bool = False) -> str:
    """
    Creates a random token of the given length.

    Args:
        length: The length of the rquired random string
        include_punctuation: True if punctuation should be included

    Returns:
        Random string of the given length
    """
    letters = string.ascii_lowercase + string.ascii_uppercase + string.digits
    if include_punctuation:
        letters += string.punctuation
    return ''.join(random.choice(letters) for _ in range(length))


def create_date(date_str: str) -> datetime:
    """
    Converts a date and time received from Monzo into a DateTime object

    Args:
        date_str: Date and time as a string

    Returns:
        Converted date and time
    """
    return datetime.strptime(date_str[:19], '%Y-%m-%dT%H:%M:%S')
