# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 application_scopes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 policies: pulumi.Input[Sequence[pulumi.Input[str]]],
                 scope_expression: pulumi.Input[str],
                 scope_variables: pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]],
                 target: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The service's policies; an array of container firewall policy names.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]] scope_variables: List of scope attributes.
        :param pulumi.Input[str] target: Type of the workload. container or host.
        :param pulumi.Input[str] description: A textual description of the service record; maximum 500 characters.
        :param pulumi.Input[bool] enforce: Enforcement status of the service.
        :param pulumi.Input[bool] monitoring: Indicates if monitoring is enabled or not
        :param pulumi.Input[str] name: The name of the service. It is recommended not to use whitespace characters in the name.
        :param pulumi.Input[int] priority: Rules priority, must be between 1-100.
        """
        pulumi.set(__self__, "application_scopes", application_scopes)
        pulumi.set(__self__, "policies", policies)
        pulumi.set(__self__, "scope_expression", scope_expression)
        pulumi.set(__self__, "scope_variables", scope_variables)
        pulumi.set(__self__, "target", target)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The service's policies; an array of container firewall policy names.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> pulumi.Input[str]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]]):
        pulumi.set(self, "scope_variables", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        Type of the workload. container or host.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A textual description of the service record; maximum 500 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Enforcement status of the service.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if monitoring is enabled or not
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service. It is recommended not to use whitespace characters in the name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Rules priority, must be between 1-100.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 containers_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 evaluated: Optional[pulumi.Input[bool]] = None,
                 is_registered: Optional[pulumi.Input[bool]] = None,
                 lastupdate: Optional[pulumi.Input[int]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 not_evaluated_count: Optional[pulumi.Input[int]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 unregistered_count: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_high: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_low: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_malware: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_medium: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_negligible: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_score_average: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_sensitive: Optional[pulumi.Input[int]] = None,
                 vulnerabilities_total: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[int] containers_count: The number of containers associated with the service.
        :param pulumi.Input[str] description: A textual description of the service record; maximum 500 characters.
        :param pulumi.Input[bool] enforce: Enforcement status of the service.
        :param pulumi.Input[bool] evaluated: Whether the service has been evaluated for security vulnerabilities.
        :param pulumi.Input[bool] is_registered: Indicates if registered or not.
        :param pulumi.Input[int] lastupdate: Timestamp of the last update in Unix time format.
        :param pulumi.Input[bool] monitoring: Indicates if monitoring is enabled or not
        :param pulumi.Input[str] name: The name of the service. It is recommended not to use whitespace characters in the name.
        :param pulumi.Input[int] not_evaluated_count: The number of container that are not evaluated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The service's policies; an array of container firewall policy names.
        :param pulumi.Input[int] priority: Rules priority, must be between 1-100.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]] scope_variables: List of scope attributes.
        :param pulumi.Input[str] target: Type of the workload. container or host.
        :param pulumi.Input[int] unregistered_count: The number of containers allocated to the service that are not registered.
        :param pulumi.Input[int] vulnerabilities_high: Number of high severity vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_low: Number of low severity vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_malware: Number of malware.
        :param pulumi.Input[int] vulnerabilities_medium: Number of medium severity vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_negligible: Number of negligible vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_score_average: The CVSS average vulnerabilities score.
        :param pulumi.Input[int] vulnerabilities_sensitive: Number of sensitive vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_total: Total number of vulnerabilities.
        """
        if application_scopes is not None:
            pulumi.set(__self__, "application_scopes", application_scopes)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if containers_count is not None:
            pulumi.set(__self__, "containers_count", containers_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if evaluated is not None:
            pulumi.set(__self__, "evaluated", evaluated)
        if is_registered is not None:
            pulumi.set(__self__, "is_registered", is_registered)
        if lastupdate is not None:
            pulumi.set(__self__, "lastupdate", lastupdate)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_evaluated_count is not None:
            pulumi.set(__self__, "not_evaluated_count", not_evaluated_count)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if scope_expression is not None:
            pulumi.set(__self__, "scope_expression", scope_expression)
        if scope_variables is not None:
            pulumi.set(__self__, "scope_variables", scope_variables)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if unregistered_count is not None:
            pulumi.set(__self__, "unregistered_count", unregistered_count)
        if vulnerabilities_high is not None:
            pulumi.set(__self__, "vulnerabilities_high", vulnerabilities_high)
        if vulnerabilities_low is not None:
            pulumi.set(__self__, "vulnerabilities_low", vulnerabilities_low)
        if vulnerabilities_malware is not None:
            pulumi.set(__self__, "vulnerabilities_malware", vulnerabilities_malware)
        if vulnerabilities_medium is not None:
            pulumi.set(__self__, "vulnerabilities_medium", vulnerabilities_medium)
        if vulnerabilities_negligible is not None:
            pulumi.set(__self__, "vulnerabilities_negligible", vulnerabilities_negligible)
        if vulnerabilities_score_average is not None:
            pulumi.set(__self__, "vulnerabilities_score_average", vulnerabilities_score_average)
        if vulnerabilities_sensitive is not None:
            pulumi.set(__self__, "vulnerabilities_sensitive", vulnerabilities_sensitive)
        if vulnerabilities_total is not None:
            pulumi.set(__self__, "vulnerabilities_total", vulnerabilities_total)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @application_scopes.setter
    def application_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_scopes", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="containersCount")
    def containers_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of containers associated with the service.
        """
        return pulumi.get(self, "containers_count")

    @containers_count.setter
    def containers_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "containers_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A textual description of the service record; maximum 500 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[bool]]:
        """
        Enforcement status of the service.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce", value)

    @property
    @pulumi.getter
    def evaluated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the service has been evaluated for security vulnerabilities.
        """
        return pulumi.get(self, "evaluated")

    @evaluated.setter
    def evaluated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "evaluated", value)

    @property
    @pulumi.getter(name="isRegistered")
    def is_registered(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if registered or not.
        """
        return pulumi.get(self, "is_registered")

    @is_registered.setter
    def is_registered(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_registered", value)

    @property
    @pulumi.getter
    def lastupdate(self) -> Optional[pulumi.Input[int]]:
        """
        Timestamp of the last update in Unix time format.
        """
        return pulumi.get(self, "lastupdate")

    @lastupdate.setter
    def lastupdate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lastupdate", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if monitoring is enabled or not
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service. It is recommended not to use whitespace characters in the name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notEvaluatedCount")
    def not_evaluated_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of container that are not evaluated.
        """
        return pulumi.get(self, "not_evaluated_count")

    @not_evaluated_count.setter
    def not_evaluated_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "not_evaluated_count", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The service's policies; an array of container firewall policy names.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Rules priority, must be between 1-100.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @scope_expression.setter
    def scope_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_expression", value)

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]]]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @scope_variables.setter
    def scope_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScopeVariableArgs']]]]):
        pulumi.set(self, "scope_variables", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the workload. container or host.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="unregisteredCount")
    def unregistered_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of containers allocated to the service that are not registered.
        """
        return pulumi.get(self, "unregistered_count")

    @unregistered_count.setter
    def unregistered_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unregistered_count", value)

    @property
    @pulumi.getter(name="vulnerabilitiesHigh")
    def vulnerabilities_high(self) -> Optional[pulumi.Input[int]]:
        """
        Number of high severity vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_high")

    @vulnerabilities_high.setter
    def vulnerabilities_high(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_high", value)

    @property
    @pulumi.getter(name="vulnerabilitiesLow")
    def vulnerabilities_low(self) -> Optional[pulumi.Input[int]]:
        """
        Number of low severity vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_low")

    @vulnerabilities_low.setter
    def vulnerabilities_low(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_low", value)

    @property
    @pulumi.getter(name="vulnerabilitiesMalware")
    def vulnerabilities_malware(self) -> Optional[pulumi.Input[int]]:
        """
        Number of malware.
        """
        return pulumi.get(self, "vulnerabilities_malware")

    @vulnerabilities_malware.setter
    def vulnerabilities_malware(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_malware", value)

    @property
    @pulumi.getter(name="vulnerabilitiesMedium")
    def vulnerabilities_medium(self) -> Optional[pulumi.Input[int]]:
        """
        Number of medium severity vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_medium")

    @vulnerabilities_medium.setter
    def vulnerabilities_medium(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_medium", value)

    @property
    @pulumi.getter(name="vulnerabilitiesNegligible")
    def vulnerabilities_negligible(self) -> Optional[pulumi.Input[int]]:
        """
        Number of negligible vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_negligible")

    @vulnerabilities_negligible.setter
    def vulnerabilities_negligible(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_negligible", value)

    @property
    @pulumi.getter(name="vulnerabilitiesScoreAverage")
    def vulnerabilities_score_average(self) -> Optional[pulumi.Input[int]]:
        """
        The CVSS average vulnerabilities score.
        """
        return pulumi.get(self, "vulnerabilities_score_average")

    @vulnerabilities_score_average.setter
    def vulnerabilities_score_average(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_score_average", value)

    @property
    @pulumi.getter(name="vulnerabilitiesSensitive")
    def vulnerabilities_sensitive(self) -> Optional[pulumi.Input[int]]:
        """
        Number of sensitive vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_sensitive")

    @vulnerabilities_sensitive.setter
    def vulnerabilities_sensitive(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_sensitive", value)

    @property
    @pulumi.getter(name="vulnerabilitiesTotal")
    def vulnerabilities_total(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_total")

    @vulnerabilities_total.setter
    def vulnerabilities_total(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vulnerabilities_total", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceScopeVariableArgs']]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Service resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[str] description: A textual description of the service record; maximum 500 characters.
        :param pulumi.Input[bool] enforce: Enforcement status of the service.
        :param pulumi.Input[bool] monitoring: Indicates if monitoring is enabled or not
        :param pulumi.Input[str] name: The name of the service. It is recommended not to use whitespace characters in the name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The service's policies; an array of container firewall policy names.
        :param pulumi.Input[int] priority: Rules priority, must be between 1-100.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceScopeVariableArgs']]]] scope_variables: List of scope attributes.
        :param pulumi.Input[str] target: Type of the workload. container or host.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Service resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enforce: Optional[pulumi.Input[bool]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scope_expression: Optional[pulumi.Input[str]] = None,
                 scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceScopeVariableArgs']]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            if application_scopes is None and not opts.urn:
                raise TypeError("Missing required property 'application_scopes'")
            __props__.__dict__["application_scopes"] = application_scopes
            __props__.__dict__["description"] = description
            __props__.__dict__["enforce"] = enforce
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["priority"] = priority
            if scope_expression is None and not opts.urn:
                raise TypeError("Missing required property 'scope_expression'")
            __props__.__dict__["scope_expression"] = scope_expression
            if scope_variables is None and not opts.urn:
                raise TypeError("Missing required property 'scope_variables'")
            __props__.__dict__["scope_variables"] = scope_variables
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["author"] = None
            __props__.__dict__["containers_count"] = None
            __props__.__dict__["evaluated"] = None
            __props__.__dict__["is_registered"] = None
            __props__.__dict__["lastupdate"] = None
            __props__.__dict__["not_evaluated_count"] = None
            __props__.__dict__["unregistered_count"] = None
            __props__.__dict__["vulnerabilities_high"] = None
            __props__.__dict__["vulnerabilities_low"] = None
            __props__.__dict__["vulnerabilities_malware"] = None
            __props__.__dict__["vulnerabilities_medium"] = None
            __props__.__dict__["vulnerabilities_negligible"] = None
            __props__.__dict__["vulnerabilities_score_average"] = None
            __props__.__dict__["vulnerabilities_sensitive"] = None
            __props__.__dict__["vulnerabilities_total"] = None
        super(Service, __self__).__init__(
            'aquasec:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            author: Optional[pulumi.Input[str]] = None,
            containers_count: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enforce: Optional[pulumi.Input[bool]] = None,
            evaluated: Optional[pulumi.Input[bool]] = None,
            is_registered: Optional[pulumi.Input[bool]] = None,
            lastupdate: Optional[pulumi.Input[int]] = None,
            monitoring: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            not_evaluated_count: Optional[pulumi.Input[int]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            scope_expression: Optional[pulumi.Input[str]] = None,
            scope_variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceScopeVariableArgs']]]]] = None,
            target: Optional[pulumi.Input[str]] = None,
            unregistered_count: Optional[pulumi.Input[int]] = None,
            vulnerabilities_high: Optional[pulumi.Input[int]] = None,
            vulnerabilities_low: Optional[pulumi.Input[int]] = None,
            vulnerabilities_malware: Optional[pulumi.Input[int]] = None,
            vulnerabilities_medium: Optional[pulumi.Input[int]] = None,
            vulnerabilities_negligible: Optional[pulumi.Input[int]] = None,
            vulnerabilities_score_average: Optional[pulumi.Input[int]] = None,
            vulnerabilities_sensitive: Optional[pulumi.Input[int]] = None,
            vulnerabilities_total: Optional[pulumi.Input[int]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_scopes: Indicates the application scope of the service.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[int] containers_count: The number of containers associated with the service.
        :param pulumi.Input[str] description: A textual description of the service record; maximum 500 characters.
        :param pulumi.Input[bool] enforce: Enforcement status of the service.
        :param pulumi.Input[bool] evaluated: Whether the service has been evaluated for security vulnerabilities.
        :param pulumi.Input[bool] is_registered: Indicates if registered or not.
        :param pulumi.Input[int] lastupdate: Timestamp of the last update in Unix time format.
        :param pulumi.Input[bool] monitoring: Indicates if monitoring is enabled or not
        :param pulumi.Input[str] name: The name of the service. It is recommended not to use whitespace characters in the name.
        :param pulumi.Input[int] not_evaluated_count: The number of container that are not evaluated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The service's policies; an array of container firewall policy names.
        :param pulumi.Input[int] priority: Rules priority, must be between 1-100.
        :param pulumi.Input[str] scope_expression: Logical expression of how to compute the dependency of the scope variables.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceScopeVariableArgs']]]] scope_variables: List of scope attributes.
        :param pulumi.Input[str] target: Type of the workload. container or host.
        :param pulumi.Input[int] unregistered_count: The number of containers allocated to the service that are not registered.
        :param pulumi.Input[int] vulnerabilities_high: Number of high severity vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_low: Number of low severity vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_malware: Number of malware.
        :param pulumi.Input[int] vulnerabilities_medium: Number of medium severity vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_negligible: Number of negligible vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_score_average: The CVSS average vulnerabilities score.
        :param pulumi.Input[int] vulnerabilities_sensitive: Number of sensitive vulnerabilities.
        :param pulumi.Input[int] vulnerabilities_total: Total number of vulnerabilities.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["application_scopes"] = application_scopes
        __props__.__dict__["author"] = author
        __props__.__dict__["containers_count"] = containers_count
        __props__.__dict__["description"] = description
        __props__.__dict__["enforce"] = enforce
        __props__.__dict__["evaluated"] = evaluated
        __props__.__dict__["is_registered"] = is_registered
        __props__.__dict__["lastupdate"] = lastupdate
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["not_evaluated_count"] = not_evaluated_count
        __props__.__dict__["policies"] = policies
        __props__.__dict__["priority"] = priority
        __props__.__dict__["scope_expression"] = scope_expression
        __props__.__dict__["scope_variables"] = scope_variables
        __props__.__dict__["target"] = target
        __props__.__dict__["unregistered_count"] = unregistered_count
        __props__.__dict__["vulnerabilities_high"] = vulnerabilities_high
        __props__.__dict__["vulnerabilities_low"] = vulnerabilities_low
        __props__.__dict__["vulnerabilities_malware"] = vulnerabilities_malware
        __props__.__dict__["vulnerabilities_medium"] = vulnerabilities_medium
        __props__.__dict__["vulnerabilities_negligible"] = vulnerabilities_negligible
        __props__.__dict__["vulnerabilities_score_average"] = vulnerabilities_score_average
        __props__.__dict__["vulnerabilities_sensitive"] = vulnerabilities_sensitive
        __props__.__dict__["vulnerabilities_total"] = vulnerabilities_total
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationScopes")
    def application_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the application scope of the service.
        """
        return pulumi.get(self, "application_scopes")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="containersCount")
    def containers_count(self) -> pulumi.Output[int]:
        """
        The number of containers associated with the service.
        """
        return pulumi.get(self, "containers_count")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A textual description of the service record; maximum 500 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enforce(self) -> pulumi.Output[Optional[bool]]:
        """
        Enforcement status of the service.
        """
        return pulumi.get(self, "enforce")

    @property
    @pulumi.getter
    def evaluated(self) -> pulumi.Output[bool]:
        """
        Whether the service has been evaluated for security vulnerabilities.
        """
        return pulumi.get(self, "evaluated")

    @property
    @pulumi.getter(name="isRegistered")
    def is_registered(self) -> pulumi.Output[bool]:
        """
        Indicates if registered or not.
        """
        return pulumi.get(self, "is_registered")

    @property
    @pulumi.getter
    def lastupdate(self) -> pulumi.Output[int]:
        """
        Timestamp of the last update in Unix time format.
        """
        return pulumi.get(self, "lastupdate")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if monitoring is enabled or not
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the service. It is recommended not to use whitespace characters in the name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notEvaluatedCount")
    def not_evaluated_count(self) -> pulumi.Output[int]:
        """
        The number of container that are not evaluated.
        """
        return pulumi.get(self, "not_evaluated_count")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence[str]]:
        """
        The service's policies; an array of container firewall policy names.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Rules priority, must be between 1-100.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="scopeExpression")
    def scope_expression(self) -> pulumi.Output[str]:
        """
        Logical expression of how to compute the dependency of the scope variables.
        """
        return pulumi.get(self, "scope_expression")

    @property
    @pulumi.getter(name="scopeVariables")
    def scope_variables(self) -> pulumi.Output[Sequence['outputs.ServiceScopeVariable']]:
        """
        List of scope attributes.
        """
        return pulumi.get(self, "scope_variables")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[str]:
        """
        Type of the workload. container or host.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="unregisteredCount")
    def unregistered_count(self) -> pulumi.Output[int]:
        """
        The number of containers allocated to the service that are not registered.
        """
        return pulumi.get(self, "unregistered_count")

    @property
    @pulumi.getter(name="vulnerabilitiesHigh")
    def vulnerabilities_high(self) -> pulumi.Output[int]:
        """
        Number of high severity vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_high")

    @property
    @pulumi.getter(name="vulnerabilitiesLow")
    def vulnerabilities_low(self) -> pulumi.Output[int]:
        """
        Number of low severity vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_low")

    @property
    @pulumi.getter(name="vulnerabilitiesMalware")
    def vulnerabilities_malware(self) -> pulumi.Output[int]:
        """
        Number of malware.
        """
        return pulumi.get(self, "vulnerabilities_malware")

    @property
    @pulumi.getter(name="vulnerabilitiesMedium")
    def vulnerabilities_medium(self) -> pulumi.Output[int]:
        """
        Number of medium severity vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_medium")

    @property
    @pulumi.getter(name="vulnerabilitiesNegligible")
    def vulnerabilities_negligible(self) -> pulumi.Output[int]:
        """
        Number of negligible vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_negligible")

    @property
    @pulumi.getter(name="vulnerabilitiesScoreAverage")
    def vulnerabilities_score_average(self) -> pulumi.Output[int]:
        """
        The CVSS average vulnerabilities score.
        """
        return pulumi.get(self, "vulnerabilities_score_average")

    @property
    @pulumi.getter(name="vulnerabilitiesSensitive")
    def vulnerabilities_sensitive(self) -> pulumi.Output[int]:
        """
        Number of sensitive vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_sensitive")

    @property
    @pulumi.getter(name="vulnerabilitiesTotal")
    def vulnerabilities_total(self) -> pulumi.Output[int]:
        """
        Total number of vulnerabilities.
        """
        return pulumi.get(self, "vulnerabilities_total")

