"""Instruction pattern definitions for ENG1448 8-bit processor
   (c) 2020-2023 Wouter Caarls, PUC-Rio
"""

defs = {'ldr':   [('00000',         '0000', 'RA'),
                  ('00000',             '', 'RA4'),
                  ('00001',             '', 'RB')],
        'str':   [('00010',         '0000', 'RA'),
                  ('00010',             '', 'RA4'),
                  ('00011',             '', 'RB')],
        'mov':   [('00100',         '0000', 'RR'),
                  ('00101',             '', 'R8')],
        'b':     [('001100000',     '0000', 'R'),
                  ('001100000',         '', 'R4'),
                  ('001110000',         '', '8')],
        'bz':    [('001100001',     '0000', 'R'),
                  ('001100001',         '', 'R4'),
                  ('001110001',         '', '8')],
        'beq':   [('001100001',     '0000', 'R'),
                  ('001100001',         '', 'R4'),
                  ('001110001',         '', '8')],
        'bnz':   [('001100010',     '0000', 'R'),
                  ('001100010',         '', 'R4'),
                  ('001110010',         '', '8')],
        'bne':   [('001100010',     '0000', 'R'),
                  ('001100010',         '', 'R4'),
                  ('001110010',         '', '8')],
        'bcs':   [('001100011',     '0000', 'R'),
                  ('001100011',         '', 'R4'),
                  ('001110011',         '', '8')],
        'bhs':   [('001100011',     '0000', 'R'),
                  ('001100011',         '', 'R4'),
                  ('001110011',         '', '8')],
        'bcc':   [('001100100',     '0000', 'R'),
                  ('001100100',         '', 'R4'),
                  ('001110100',         '', '8')],
        'blo':   [('001100100',     '0000', 'R'),
                  ('001100100',         '', 'R4'),
                  ('001110100',         '', '8')],
        'push':  [('01000',     '00000000', 'R')],
        'call':  [('010100000',     '0000', 'R'),
                  ('010110000',         '', '8')],
        'ret':   [('011001111', '00000000', '')],   # pop pc
        'pop':   [('01100',     '00000000', 'R')],

        'add':   [('10000',             '', 'RRR'),
                  ('10001',             '', 'RR4')],
        'sub':   [('10010',             '', 'RRR'),
                  ('10011',             '', 'RR4')],
        'shl':   [('10100',             '', 'RRR'),
                  ('10101',             '', 'RR4')],
        'shr':   [('10110',             '', 'RRR'),
                  ('10111',             '', 'RR4')],

        'and':   [('11000',             '', 'RRR'),
                  ('11001',             '', 'RR4')],
        'orr':   [('11010',             '', 'RRR'),
                  ('11011',             '', 'RR4')],
        'eor':   [('11100',             '', 'RRR'),
                  ('11101',             '', 'RR4')],

        '.org':  [('',                  '', '8')],
        '.db':   [('',                  '', '8')],
        '.section': [('',               '', 'X')],
        '.equ':  [('',                  '', 'X8')]
       }
