<div align="center"><a name="readme-top"></a>

<img height="160" src="https://raw.githubusercontent.com/sindresorhus/awesome/refs/heads/main/media/logo.svg" />

<h1>Awesome List Generator</h1>

Awesome List Generator is a powerful Python tool for creating and maintaining curated lists of awesome projects. It supports multiple formats, integrates with GitHub for project metadata, and provides customizable templates for generating professional-looking lists with rich project details.

[![PyPI - Version](https://img.shields.io/pypi/v/awesome-list-generator?logo=PyPI&logoColor=3775A9&label=PyPI)](https://pypi.org/project/awesome-list-generator/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/awesome-list-generator?logo=PyPI&logoColor=3775A9)](https://pypi.org/project/awesome-list-generator/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/awesome-list-generator?logo=Python&logoColor=3776AB&label=Python)](https://pypi.org/project/awesome-list-generator/) <br />
[![GitHub contributors](https://img.shields.io/github/contributors/liblaf/awesome-list-generator)](https://github.com/liblaf/awesome-list-generator/graphs/contributors)
[![GitHub forks](https://img.shields.io/github/forks/liblaf/awesome-list-generator)](https://github.com/liblaf/awesome-list-generator/forks)
[![GitHub Repo stars](https://img.shields.io/github/stars/liblaf/awesome-list-generator)](https://github.com/liblaf/awesome-list-generator/stargazers)
[![GitHub Issues](https://img.shields.io/github/issues/liblaf/awesome-list-generator)](https://github.com/liblaf/awesome-list-generator/issues)
[![GitHub License](https://img.shields.io/github/license/liblaf/awesome-list-generator)](https://github.com/liblaf/awesome-list-generator/blob/main/LICENSE)

[Changelog](https://github.com/liblaf/awesome-list-generator/blob/main/CHANGELOG.md) · [Report Bug](https://github.com/liblaf/awesome-list-generator/issues) · [Request Feature](https://github.com/liblaf/awesome-list-generator/issues)

![banner](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/rainbow.png)

</div>

## ✨ Features

- 📜 **Markdown Generation:** Automatically generates beautiful and structured Markdown files for awesome lists, complete with badges, descriptions, and project statistics;
- 🚀 **GitHub Integration:** Seamlessly fetches project information from GitHub, including stars, forks, issues, pull requests, and license details;
- 🧩 **Plugin Architecture:** Extensible plugin system allows for easy integration of additional data sources and formats beyond GitHub;
- 🎨 **Customizable Formatting:** Supports multiple output formats (currently Markdown) with customizable templates for different presentation styles;
- ⚡ **Async Performance:** Built with asyncio for efficient concurrent fetching of project data from multiple sources;
- 🔍 **Project Categorization:** Automatically organizes projects into categories with customizable titles and subtitles;
- 🛠️ **CLI Interface:** Easy-to-use command-line interface for generating lists with a single command;
- 🧪 **Type Safety:** Fully type-annotated codebase with Pydantic models for robust data validation and IDE support;
- 🧰 **Dependency Management:** Uses modern Python packaging tools (Hatch) for clean dependency management and reproducible builds;
- 🤖 **Automation Ready:** Includes GitHub Actions workflows for automated testing, linting, and releases.

<div align="right">

[![BACK TO TOP](https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square)](#readme-top)

</div>

## 📦 Installation

To install `awesome-list-generator`, run the following command:

```bash
uv tool install awesome-list-generator
```

<div align="right">

[![BACK TO TOP](https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square)](#readme-top)

</div>

## ⌨️ Local Development

You can use Github Codespaces for online development:

[![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/liblaf/awesome-list-generator)

Or clone it for local development:

```bash
git clone https://github.com/liblaf/awesome-list-generator.git
cd lime
uv sync
```

<div align="right">

[![BACK TO TOP](https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square)](#readme-top)

</div>

## 🤝 Contributing

Contributions of all types are more than welcome, if you are interested in contributing code, feel free to check out our GitHub [Issues](https://github.com/liblaf/awesome-list-generator/issues) to get stuck in to show us what you're made of.

[![🤯 PR WELCOME](https://img.shields.io/badge/%F0%9F%A4%AF%20PR%20WELCOME-%E2%86%92-ffcb47?labelColor=black&style=for-the-badge)](https://github.com/liblaf/awesome-list-generator/pulls)

[![Contributors](https://contrib.rocks/image?repo=liblaf%2Flime)](https://github.com/liblaf/awesome-list-generator/graphs/contributors)

<div align="right">

[![BACK TO TOP](https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square)](#readme-top)

</div>

---

#### 📝 License

Copyright © 2025 [liblaf](https://github.com/liblaf). <br />
This project is [MIT](https://github.com/liblaf/awesome-list-generator/blob/main/LICENSE) licensed.
