# -*- coding: utf-8 -*-

from yapconf.docs import build_markdown_table


# flake8: noqa
def test_build_markdown_table():
    headers = {'foo': 'Foo', 'bar': 'Bar'}
    rows = [
        {
            'bar': 'bar_value',
            'foo': 'x',
        },
        {
            'bar': 'bar_value2',
            'foo': 'y',
        },
    ]
    table = build_markdown_table(headers, rows, ['foo', 'bar'])
    assert table == ("| Foo | Bar        |\n"
                     "| --- | ---------- |\n"
                     "| x   | bar_value  |\n"
                     "| y   | bar_value2 |\n")


def test_generate_markdown_doc_simple(simple_spec):
    doc = simple_spec.generate_documentation('My App Name')
    assert doc == (
"""# My App Name Configuration

This document describes the configuration for My App Name. Each section will 
document a particular configuration value and its description. First, 
though, we start with the possible sources. 

This documentation was auto-generated by [yapconf.](https://github.com/loganasherjones/yapconf)


## Sources

My App Name configuration can be loaded from the below sources:

## Configuration

This section outlines the various configuration items My App Name supports.

| Name                      | Type    | Default | Description |
| ------------------------- | ------- | ------- | ----------- |
| [my_bool](#my_bool)       | bool    | None    | None        |
| [my_complex](#my_complex) | complex | None    | None        |
| [my_float](#my_float)     | float   | None    | None        |
| [my_int](#my_int)         | int     | None    | None        |
| [my_long](#my_long)       | long    | None    | None        |
| [my_string](#my_string)   | str     | None    | None        |

### my_bool

No description provided.

| Attribute     | Value       |
| ------------- | ----------- |
| **item_type** | `bool`      |
| **default**   | `None`      |
| **env_name**  | `MY_BOOL`   |
| **required**  | `True`      |
| **cli_name**  | `--my-bool` |
| **fallback**  | `None`      |
| **choices**   | `None`      |

You can set my_bool from the environment by setting the environment variable `MY_BOOL`

You can set `my_bool` from the command-line by specifying `--my-bool` at My App Name's entrypoint.



### my_complex

No description provided.

| Attribute     | Value          |
| ------------- | -------------- |
| **item_type** | `complex`      |
| **default**   | `None`         |
| **env_name**  | `MY_COMPLEX`   |
| **required**  | `True`         |
| **cli_name**  | `--my-complex` |
| **fallback**  | `None`         |
| **choices**   | `None`         |

You can set my_complex from the environment by setting the environment variable `MY_COMPLEX`

You can set `my_complex` from the command-line by specifying `--my-complex` at My App Name's entrypoint.



### my_float

No description provided.

| Attribute     | Value        |
| ------------- | ------------ |
| **item_type** | `float`      |
| **default**   | `None`       |
| **env_name**  | `MY_FLOAT`   |
| **required**  | `True`       |
| **cli_name**  | `--my-float` |
| **fallback**  | `None`       |
| **choices**   | `None`       |

You can set my_float from the environment by setting the environment variable `MY_FLOAT`

You can set `my_float` from the command-line by specifying `--my-float` at My App Name's entrypoint.



### my_int

No description provided.

| Attribute     | Value      |
| ------------- | ---------- |
| **item_type** | `int`      |
| **default**   | `None`     |
| **env_name**  | `MY_INT`   |
| **required**  | `True`     |
| **cli_name**  | `--my-int` |
| **fallback**  | `None`     |
| **choices**   | `None`     |

You can set my_int from the environment by setting the environment variable `MY_INT`

You can set `my_int` from the command-line by specifying `--my-int` at My App Name's entrypoint.



### my_long

No description provided.

| Attribute     | Value       |
| ------------- | ----------- |
| **item_type** | `long`      |
| **default**   | `None`      |
| **env_name**  | `MY_LONG`   |
| **required**  | `True`      |
| **cli_name**  | `--my-long` |
| **fallback**  | `None`      |
| **choices**   | `None`      |

You can set my_long from the environment by setting the environment variable `MY_LONG`

You can set `my_long` from the command-line by specifying `--my-long` at My App Name's entrypoint.



### my_string

No description provided.

| Attribute     | Value         |
| ------------- | ------------- |
| **item_type** | `str`         |
| **default**   | `None`        |
| **env_name**  | `MY_STRING`   |
| **required**  | `True`        |
| **cli_name**  | `--my-string` |
| **fallback**  | `None`        |
| **choices**   | `None`        |

You can set my_string from the environment by setting the environment variable `MY_STRING`

You can set `my_string` from the command-line by specifying `--my-string` at My App Name's entrypoint.


"""
    )
