/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.io.FileManager;
import de.jstacs.utils.Time;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import projects.dream2016.DataParser;

public class ExtractAndParseFeaturesMore {
    public static void main(String[] args) throws Exception {
        HashMap selList2 = new HashMap();
        BufferedReader sel = new BufferedReader(new FileReader(args[0]));
        String out = args[1];
        PrintWriter wr = new PrintWriter(out);
        PrintWriter weights = new PrintWriter(String.valueOf(out) + ".weights");
        PrintWriter files = new PrintWriter(String.valueOf(out) + ".args");
        int i = 0;
        while (i < args.length) {
            files.println(args[i]);
            ++i;
        }
        files.close();
        AlphabetContainer cont = null;
        String str = null;
        int a = 0;
        while ((str = sel.readLine()) != null) {
            Entry en = new Entry(str, args.length - 2);
            if (!selList2.containsKey(en.chrom)) {
                selList2.put(en.chrom, new LinkedList());
            }
            ((LinkedList)selList2.get(en.chrom)).add(en);
            ++a;
        }
        sel.close();
        System.out.println("selected: " + a + " regions in " + selList2.size() + " chromsomes");
        LinkedList keySet = new LinkedList(selList2.keySet());
        Collections.sort(keySet);
        Iterator keyIt = keySet.iterator();
        while (keyIt.hasNext()) {
            HashMap<String, LinkedList> selList = new HashMap<String, LinkedList>();
            int num = 0;
            while ((double)num < 10000.0 && keyIt.hasNext()) {
                String key = (String)keyIt.next();
                LinkedList el = (LinkedList)selList2.remove(key);
                selList.put(key, el);
                num += el.size();
            }
            System.out.println("Parsing " + selList.keySet());
            Time t = Time.getTimeInstance(null);
            Iterator it = null;
            Entry curr = null;
            LinkedList<String> conf = new LinkedList<String>();
            int col = 0;
            int f = 0;
            while (f < args.length - 2) {
                if (args[2 + f].endsWith("hg19.fa_other.txt.gz")) {
                    conf.add("Percent\t" + col + "," + (col + 1) + "\tEach\tMeanCenter3");
                    conf.add("Entropy\t" + ((col += 2) + 2) + "\tEach\tMaxCenter3");
                    col += 3;
                } else if (args[2 + f].endsWith("hg19.fa_tracts.txt.gz")) {
                    conf.add("Length\t" + col + "," + (col + 1) + "," + (col + 2) + "," + (col + 3) + "\tEach\tMaxCenter3");
                    col += 4;
                } else if (args[2 + f].endsWith("gencode.v19.types.txt.gz")) {
                    conf.add("Region\t" + col + "\tEach\tMin");
                    ++col;
                } else if (args[2 + f].endsWith(".bigwig-interval.txt.gz")) {
                    conf.add("Coverage\t" + col + "\tEach\tMinCenter3");
                    conf.add("Coverage\t" + (col + 2) + "," + (col + 3) + "\tEach\tMin");
                    conf.add("Coverage\t" + (col + 1) + "\tEach\tEach");
                    col += 4;
                } else if (args[2 + f].endsWith(".xml_winscores2.txt.gz")) {
                    conf.add("Score\t" + col + "\tEach\tMaxCenter3");
                    conf.add("Score\t" + (col + 1) + "\tEach\tCenter");
                    conf.add("Score\t" + col + "\tEach\tLogSum");
                    col += 2;
                    col += 2;
                    ++col;
                } else if (args[2 + f].endsWith("_winscores2.txt.gz")) {
                    conf.add("Score\t" + col + "\tEach\tMax");
                    col += 2;
                    col += 2;
                    ++col;
                } else if (args[2 + f].endsWith("hg19.genome.fa.seqs.gz")) {
                    conf.add("Seq\t" + col + "\tEach\tCenter");
                    ++col;
                } else {
                    throw new RuntimeException("Unknown file type");
                }
                t.reset();
                GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[f + 2]));
                BufferedReader read = new BufferedReader(new InputStreamReader(stream));
                int idx = 0;
                LinkedList<String> buffer = new LinkedList<String>();
                while ((str = read.readLine()) != null) {
                    if (str.charAt(0) == '[') {
                        String chr = str.substring(1, str.length() - 1);
                        if (selList.containsKey(chr)) {
                            it = ((LinkedList)selList.get(chr)).iterator();
                            curr = (Entry)it.next();
                        } else {
                            it = null;
                            curr = null;
                        }
                        idx = 0;
                        buffer.clear();
                        continue;
                    }
                    if (curr == null) continue;
                    buffer.addLast(str);
                    int startIdx = curr.start / 50;
                    int endIdx = curr.end / 50;
                    if (idx >= startIdx && idx < endIdx) {
                        curr.append(str, f);
                    }
                    if (idx == endIdx - 1) {
                        while (it.hasNext()) {
                            curr = (Entry)it.next();
                            int tempStart = curr.start / 50;
                            int tempEnd = curr.end / 50;
                            if (tempStart <= idx) {
                                int diff;
                                int j = diff = idx - tempStart;
                                while (j >= 0) {
                                    curr.append((String)buffer.get(buffer.size() - 1 - j), f);
                                    --j;
                                }
                            }
                            if (idx != tempEnd - 1) break;
                        }
                    }
                    if (buffer.size() > 1000) {
                        buffer.removeFirst();
                    }
                    ++idx;
                }
                read.close();
                System.out.println("Finished " + args[f + 2] + ": " + t.getElapsedTime());
                ++f;
            }
            System.out.println();
            conf.addFirst("5\t" + col);
            int c = 0;
            while (c < conf.size()) {
                System.out.println((String)conf.get(c));
                ++c;
            }
            PrintWriter confw = new PrintWriter(String.valueOf(out) + ".conf");
            confw.println("0\t" + col);
            int c2 = 1;
            while (c2 < conf.size()) {
                confw.println((String)conf.get(c2));
                ++c2;
            }
            confw.close();
            DataParser parser = new DataParser(conf.toArray(new String[0]));
            LinkedList keySet2 = new LinkedList(selList.keySet());
            Collections.sort(keySet2);
            for (String chrom : keySet2) {
                System.out.println("printing: " + chrom);
                LinkedList li = (LinkedList)selList.get(chrom);
                for (Entry en : li) {
                    String enstr = en.toString();
                    ArbitrarySequence seq = parser.parse(cont, enstr.split("\t"));
                    if (cont == null) {
                        cont = seq.getAlphabetContainer();
                    }
                    wr.println(seq.toString("\t", 0, seq.getLength()));
                    weights.println(en.value);
                    en.clear();
                }
            }
            selList.clear();
        }
        wr.close();
        weights.close();
        FileManager.writeFile(String.valueOf(out) + ".alpha", (CharSequence)cont.toXML());
    }

    private static class Entry {
        private String chrom;
        private int start;
        private int end;
        private String pos;
        private String value;
        private ArrayList[] list;
        private int[] rem;

        public Entry(String line, int nfiles) {
            String[] parts = line.split("\t");
            this.chrom = parts[0];
            this.start = (int)Math.round(Double.parseDouble(parts[1]));
            this.end = (int)Math.round(Double.parseDouble(parts[2]));
            this.pos = parts[3];
            this.value = parts[4];
            this.list = new ArrayList[nfiles];
            this.rem = new int[nfiles];
            int i = 0;
            while (i < this.list.length) {
                this.list[i] = new ArrayList();
                this.rem[i] = -1;
                ++i;
            }
        }

        public void clear() {
            this.list = null;
        }

        public void append(String s, int idx) {
            if (this.rem[idx] == -1) {
                this.rem[idx] = 0;
                if (s.startsWith(String.valueOf(this.chrom) + "\t")) {
                    int pos = s.indexOf(9) + 1;
                    s = s.substring(pos);
                    int n = idx;
                    this.rem[n] = this.rem[n] + 1;
                    if (s.startsWith(String.valueOf(this.start) + "\t")) {
                        pos = s.indexOf(9) + 1;
                        s = s.substring(pos);
                        int n2 = idx;
                        this.rem[n2] = this.rem[n2] + 1;
                    }
                }
            } else if (this.rem[idx] > 0) {
                int pos = 0;
                int j = 0;
                while (j < this.rem[idx]) {
                    pos = s.indexOf(9, pos) + 1;
                    ++j;
                }
                s = s.substring(pos);
            }
            this.list[idx].add(s);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.chrom) + "\t" + this.start + "\t" + this.end + "\t" + this.pos + "\t" + this.value);
            int j = 0;
            while (j < this.list[0].size()) {
                int i = 0;
                while (i < this.list.length) {
                    sb.append("\t" + this.list[i].get(j));
                    ++i;
                }
                ++j;
            }
            return sb.toString();
        }

        public String[] toStringArray() {
            ArrayList<String> al = new ArrayList<String>();
            al.add(this.chrom);
            al.add(String.valueOf(this.start));
            al.add(String.valueOf(this.end));
            al.add(String.valueOf(this.pos));
            al.add(String.valueOf(this.value));
            int j = 0;
            while (j < this.list[0].size()) {
                int i = 0;
                while (i < this.list.length) {
                    al.add("" + this.list[i].get(j));
                    ++i;
                }
                ++j;
            }
            return al.toArray(new String[0]);
        }
    }
}

