/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.io.RegExFilenameFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class DNaseStatistics {
    public static void main(String[] args) throws IOException {
        String line;
        RegExFilenameFilter filter = new RegExFilenameFilter("DNase", RegExFilenameFilter.Directory.FORBIDDEN, true, ".*\\.bigwig-interval2\\.txt\\.gz-s\\.gz-order\\.gz-r\\.gz");
        File[] ct = new File(args[0]).listFiles(filter);
        HashMap<String, ArrayList<int[]>> hash = new HashMap<String, ArrayList<int[]>>();
        BufferedReader r = new BufferedReader(new FileReader(args[1]));
        while ((line = r.readLine()) != null) {
            String[] split = line.split("\t");
            ArrayList<int[]> current = (ArrayList<int[]>)hash.get(split[0]);
            if (current == null) {
                current = new ArrayList<int[]>();
                hash.put(split[0], current);
            }
            current.add(new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])});
        }
        r.close();
        String labelFile = args[2];
        GZIPInputStream label = new GZIPInputStream(new FileInputStream(labelFile));
        r = new BufferedReader(new InputStreamReader(label));
        line = r.readLine();
        Object[] known = line.split("\t");
        System.out.println(Arrays.toString(known));
        r.close();
        int N = 100;
        int a = 8;
        int[][] stats = new int[a][5 * N];
        String[][][] examples = new String[a][5 * N][10];
        int[][] count = new int[a][5 * N];
        int threshold = 10000;
        int[][][] labeledStats = new int[a][2][5 * N];
        int i = 0;
        while (i < ct.length) {
            int j;
            int best = -1;
            int k = 3;
            while (k < known.length) {
                if (ct[i].getName().contains((CharSequence)known[k])) {
                    best = k;
                    int j2 = 0;
                    while (j2 < stats.length) {
                        Arrays.fill(labeledStats[j2][0], 0);
                        Arrays.fill(labeledStats[j2][1], 0);
                        ++j2;
                    }
                    break;
                }
                ++k;
            }
            System.out.println(ct[i] + "\t" + (String)(best > -1 ? known[best] : ""));
            int j3 = 0;
            while (j3 < stats.length) {
                Arrays.fill(stats[j3], 0);
                ++j3;
            }
            ArrayList intervals = null;
            int idx = -1;
            int[] inter = null;
            int lab = -1;
            if (best > -1) {
                label = new GZIPInputStream(new FileInputStream(labelFile));
                r = new BufferedReader(new InputStreamReader(label));
                line = r.readLine();
            }
            GZIPInputStream stream = new GZIPInputStream(new FileInputStream(ct[i]));
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            int start = 0;
            double[] min = new double[4];
            double[] max = new double[4];
            int hIdx = 0;
            int anz = 0;
            String chr = null;
            while ((line = reader.readLine()) != null) {
                if (line.charAt(0) == '[') {
                    chr = line.substring(1, line.length() - 1);
                    intervals = (ArrayList)hash.get(chr);
                    if (intervals != null) {
                        idx = 0;
                        inter = (int[])intervals.get(idx);
                    } else {
                        inter = null;
                        idx = -1;
                    }
                    Arrays.fill(min, Double.NaN);
                    Arrays.fill(max, Double.NaN);
                    anz = 0;
                    hIdx = 0;
                    start = 0;
                    continue;
                }
                if (intervals != null) {
                    int oldIdx = idx;
                    while (idx < intervals.size() && start >= (inter = (int[])intervals.get(idx))[1]) {
                        ++idx;
                    }
                    if (idx > oldIdx) {
                        Arrays.fill(min, Double.NaN);
                        Arrays.fill(max, Double.NaN);
                        anz = 0;
                        hIdx = 0;
                    }
                    if (start >= inter[0] && idx != intervals.size() && start >= inter[0] && start < inter[1]) {
                        String[] split = line.split("\t");
                        j = 0;
                        while (j < 4) {
                            DNaseStatistics.fill(Double.parseDouble(split[j]), 0.0, N, stats[j], count[j], examples[j], chr, start, lab > -1 ? labeledStats[j][lab] : null);
                            ++j;
                        }
                        min[hIdx] = Double.parseDouble(split[0]);
                        max[hIdx++] = Double.parseDouble(split[2]);
                        if (hIdx == 4) {
                            hIdx = 0;
                        }
                        ++anz;
                    }
                }
                start += 50;
            }
            reader.close();
            BufferedWriter w = new BufferedWriter(new FileWriter(ct[i] + ".stats6"));
            int k2 = 0;
            while (k2 < stats[0].length) {
                j = 0;
                while (j < stats.length) {
                    w.append(String.valueOf(j == 0 ? "" : "\t") + stats[j][k2]);
                    ++j;
                }
                w.newLine();
                ++k2;
            }
            w.close();
            ++i;
        }
    }

    private static void fill(double a, double b, int N, int[] stats, int[] count, String[][] examples, String chr, int start, int[] labeledStats) {
        int index;
        int n = index = (int)Math.floor((double)N * Math.log((1.0 + a) / (1.0 + b)));
        stats[n] = stats[n] + 1;
        if (count[index] < examples[index].length) {
            int n2 = index;
            int n3 = count[n2];
            count[n2] = n3 + 1;
            examples[index][n3] = String.valueOf(chr) + "\t" + start;
        }
        if (labeledStats != null) {
            int n4 = index;
            labeledStats[n4] = labeledStats[n4] + 1;
        }
    }
}

