/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import java.io.IOException;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;

public class BigWigAccessor {
    private BBFileReader reader;

    public BigWigAccessor(String bigWigFile) throws IOException {
        this.reader = new BBFileReader(bigWigFile);
        BBFileHeader header = this.reader.getBBFileHeader();
        if (!header.isHeaderOK()) {
            throw new RuntimeException("Header not OK");
        }
        if (!header.isBigWig()) {
            throw new RuntimeException("No Bigwig");
        }
    }

    public double[] getProfileInRegion(String chr, int start, int end) {
        double[] res = new double[end - start];
        BigWigIterator it = this.reader.getBigWigIterator(chr, start, chr, end, false);
        while (it.hasNext()) {
            WigItem item = it.next();
            int s = item.getStartBase();
            int e = item.getEndBase();
            double v = item.getWigValue();
            int i = Math.max(start, s);
            while (i < Math.min(e, end)) {
                res[i - start] = v;
                ++i;
            }
        }
        return res;
    }
}

